/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.logging.Level;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.EnhancedSyntaxSupport;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ReadAttributeHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-attribute", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, GlobalOperationAttributes.INCLUDE_DEFAULTS, GlobalOperationAttributes.INCLUDE_UNDEFINED_METRIC_VALUES).setReadOnly().setReplyType(ModelType.OBJECT).build();
    public static final OperationStepHandler INSTANCE = new ReadAttributeHandler();
    private static final SimpleAttributeDefinition RESOLVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("resolve-expressions", ModelType.BOOLEAN).setRequired(false)).setDefaultValue(ModelNode.FALSE)).build();
    public static final OperationDefinition RESOLVE_DEFINITION = new SimpleOperationDefinitionBuilder("read-attribute", ControllerResolver.getResolver("global")).setParameters(RESOLVE, GlobalOperationAttributes.NAME, GlobalOperationAttributes.INCLUDE_DEFAULTS).setReadOnly().setReplyType(ModelType.OBJECT).build();
    public static final OperationStepHandler RESOLVE_INSTANCE = new ReadAttributeHandler(true);
    private final ParametersValidator validator = new ParametersValidator(){

        @Override
        public void validate(ModelNode operation) throws OperationFailedException {
            super.validate(operation);
            if (operation.hasDefined("resolve-expressions") && operation.get("resolve-expressions").asBoolean(false) && !ReadAttributeHandler.this.resolvable) {
                throw ControllerLogger.ROOT_LOGGER.unableToResolveExpressions();
            }
        }
    };
    private final OperationStepHandler overrideHandler;
    private final boolean resolvable;

    public ReadAttributeHandler() {
        this(null, null, false);
    }

    public ReadAttributeHandler(boolean resolve) {
        this(null, null, resolve);
    }

    ReadAttributeHandler(FilteredData filteredData, OperationStepHandler overrideHandler, boolean resolvable) {
        super(filteredData);
        if (resolvable) {
            this.validator.registerValidator(RESOLVE.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        }
        this.validator.registerValidator(GlobalOperationAttributes.NAME.getName(), new StringLengthValidator(1));
        this.validator.registerValidator(GlobalOperationAttributes.INCLUDE_DEFAULTS.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        this.validator.registerValidator(GlobalOperationAttributes.INCLUDE_UNDEFINED_METRIC_VALUES.getName(), new ModelTypeValidator(ModelType.BOOLEAN, true));
        assert (overrideHandler == null || filteredData != null) : "overrideHandler only supported with filteredData";
        this.overrideHandler = overrideHandler;
        this.resolvable = resolvable;
    }

    @Override
    void doExecute(OperationContext context, ModelNode operation, FilteredData filteredData, boolean ignoreMissingResource) throws OperationFailedException {
        context.addStep(operation, new AuthorizeAttributeReadHandler(filteredData), OperationContext.Stage.MODEL, true);
        boolean resolve = RESOLVE.resolveModelAttribute(context, operation).asBoolean();
        if (resolve && this.resolvable) {
            context.addStep(operation, ResolveAttributeHandler.getInstance(), OperationContext.Stage.MODEL, true);
        }
        if (filteredData == null) {
            this.doExecuteInternal(context, operation);
        } else {
            try {
                if (this.overrideHandler == null) {
                    this.doExecuteInternal(context, operation);
                } else {
                    this.overrideHandler.execute(context, operation);
                }
            }
            catch (UnauthorizedException ue) {
                PathAddress pa = context.getCurrentAddress();
                filteredData.addReadRestrictedAttribute(pa, operation.get("name").asString());
                context.getResult().set(new ModelNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteInternal(OperationContext context, ModelNode operation) throws OperationFailedException {
        AttributeAccess attributeAccess;
        this.validator.validate(operation);
        String attributeName = GlobalOperationAttributes.NAME.resolveModelAttribute(context, operation).asString();
        boolean defaults = GlobalOperationAttributes.INCLUDE_DEFAULTS.resolveModelAttribute(context, operation).asBoolean();
        boolean includeUndefinedMetricValue = GlobalOperationAttributes.INCLUDE_UNDEFINED_METRIC_VALUES.resolveModelAttribute(context, operation).asBoolean();
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        boolean useEnhancedSyntax = EnhancedSyntaxSupport.containsEnhancedSyntax(attributeName, registry);
        String attributeExpression = attributeName;
        if (useEnhancedSyntax) {
            attributeName = EnhancedSyntaxSupport.extractAttributeName(attributeName);
        }
        if ((attributeAccess = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName)) == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.unknownAttribute(attributeName));
        }
        assert (attributeAccess.getAttributeDefinition() != null);
        if (attributeAccess.getReadHandler() == null) {
            ReadAttributeHandler.resolveAttribute(context, attributeAccess.getAttributeDefinition(), attributeExpression, defaults, useEnhancedSyntax);
        } else {
            ModelNode undefinedMetricValue;
            OperationStepHandler handler = attributeAccess.getReadHandler();
            ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(handler.getClass());
            try {
                handler.execute(context, operation);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
            if (attributeAccess.getAccessType() == AttributeAccess.AccessType.METRIC && !context.getResult().isDefined() && !includeUndefinedMetricValue && (undefinedMetricValue = attributeAccess.getAttributeDefinition().getUndefinedMetricValue()) != null) {
                context.getResult().set(undefinedMetricValue);
            }
            if (useEnhancedSyntax) {
                int prefixLength = attributeName.length();
                if (attributeExpression.charAt(prefixLength) == '.') {
                    ++prefixLength;
                }
                String remainingExpression = attributeExpression.substring(prefixLength);
                if (AttributeAccess.Storage.CONFIGURATION == attributeAccess.getStorageType()) {
                    ModelNode resolved = EnhancedSyntaxSupport.resolveEnhancedSyntax(remainingExpression, context.getResult(), attributeAccess.getAttributeDefinition());
                    context.getResult().set(resolved);
                } else {
                    assert (AttributeAccess.Storage.RUNTIME == attributeAccess.getStorageType());
                    context.addStep((context1, operation1) -> {
                        ModelNode resolved = EnhancedSyntaxSupport.resolveEnhancedSyntax(remainingExpression, context.getResult(), attributeAccess.getAttributeDefinition());
                        context.getResult().set(resolved);
                    }, OperationContext.Stage.RUNTIME);
                }
            }
        }
    }

    static void resolveAttribute(OperationContext context, AttributeDefinition attribute, String attributeSyntax, boolean defaults, boolean enhancedSyntax) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ModelNode subModel = resource.getModel();
        if (enhancedSyntax) {
            context.getResult().set(EnhancedSyntaxSupport.resolveEnhancedSyntax(attributeSyntax, subModel, attribute));
        } else if (subModel.hasDefined(attribute.getName())) {
            ModelNode result = subModel.get(attribute.getName());
            context.getResult().set(result);
        } else if (defaults && attribute.getDefaultValue() != null) {
            context.getResult().set(attribute.getDefaultValue());
        } else {
            context.getResult();
        }
    }

    private static class ResolveAttributeHandler
    implements OperationStepHandler {
        private ResolveAttributeHandler() {
        }

        public static ResolveAttributeHandler getInstance() {
            return ResolveAttributeHandlerHolder.INSTANCE;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode unresolvedResult = context.hasResult() ? context.getResult().clone() : new ModelNode();
            ModelNode simpleAnswer = ExpressionResolver.SIMPLE_LENIENT.resolveExpressions(unresolvedResult);
            if (!simpleAnswer.equals(unresolvedResult)) {
                boolean secureExpression;
                try {
                    ModelNode fullyResolved = context.resolveExpressions(unresolvedResult);
                    secureExpression = !simpleAnswer.equals(fullyResolved);
                }
                catch (ExpressionResolver.ExpressionResolutionServerException | ExpressionResolver.ExpressionResolutionUserException e) {
                    secureExpression = true;
                }
                if (secureExpression) {
                    context.addResponseWarning(Level.WARNING, ControllerLogger.MGMT_OP_LOGGER.attributeUnresolvableUsingSimpleResolution(operation.get("name").asString(), context.getCurrentAddress().toCLIStyleString(), unresolvedResult));
                } else {
                    context.getResult().set(simpleAnswer);
                }
            }
        }

        private static class ResolveAttributeHandlerHolder {
            private static final ResolveAttributeHandler INSTANCE = new ResolveAttributeHandler();

            private ResolveAttributeHandlerHolder() {
            }
        }
    }

    private static class AuthorizeAttributeReadHandler
    implements OperationStepHandler {
        private final FilteredData filteredData;

        private AuthorizeAttributeReadHandler(FilteredData filteredData) {
            this.filteredData = filteredData;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.filteredData == null) {
                this.doExecuteInternal(context, operation);
            } else {
                try {
                    this.doExecuteInternal(context, operation);
                }
                catch (UnauthorizedException ue) {
                    if (context.hasResult()) {
                        context.getResult().set(new ModelNode());
                    }
                    PathAddress pa = context.getCurrentAddress();
                    this.filteredData.addReadRestrictedAttribute(pa, operation.get("name").asString());
                    context.getResult().set(new ModelNode());
                }
            }
        }

        private void doExecuteInternal(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value = context.hasResult() ? context.getResult().clone() : new ModelNode();
            AuthorizationResult authorizationResult = context.authorize(operation, operation.require("name").asString(), value);
            if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
                context.getResult().clear();
                throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), context.getCurrentAddress(), authorizationResult.getExplanation());
            }
        }
    }
}

