/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.capability;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractCapability {
    private final String name;
    private final Set<String> requirements;
    private final Set<String> optionalRequirements;

    protected AbstractCapability(String name, Set<String> requirements, Set<String> optionalRequirements) {
        assert (name != null);
        this.name = name;
        this.requirements = requirements != null && !requirements.isEmpty() ? Collections.unmodifiableSet(new HashSet<String>(requirements)) : Collections.emptySet();
        this.optionalRequirements = optionalRequirements != null && !optionalRequirements.isEmpty() ? Collections.unmodifiableSet(new HashSet<String>(optionalRequirements)) : Collections.emptySet();
    }

    protected AbstractCapability(String name, String ... requirements) {
        assert (name != null);
        this.name = name;
        if (requirements != null && requirements.length > 0) {
            HashSet set = new HashSet(requirements.length);
            Collections.addAll(set, requirements);
            this.requirements = Collections.unmodifiableSet(set);
        } else {
            this.requirements = Collections.emptySet();
        }
        this.optionalRequirements = Collections.emptySet();
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getRequirements() {
        return this.requirements;
    }

    public Set<String> getOptionalRequirements() {
        return this.optionalRequirements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractCapability that = (AbstractCapability)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

