/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.logging;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.UnauthorizedException;
import org.jboss.as.controller._private.OperationCancellationException;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.interfaces.InterfaceCriteria;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYCTL", length=4)
public interface ControllerLogger
extends BasicLogger {
    public static final ControllerLogger ROOT_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.controller");
    public static final ControllerLogger MGMT_OP_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.controller.management-operation");
    public static final ControllerLogger SERVER_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.server");
    public static final ControllerLogger SERVER_MANAGEMENT_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.server.management");
    public static final ControllerLogger DEPRECATED_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.controller.management-deprecated");
    public static final ControllerLogger TRANSFORMER_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.controller.transformer");
    public static final ControllerLogger ACCESS_LOGGER = (ControllerLogger)Logger.getMessageLogger(ControllerLogger.class, (String)"org.jboss.as.controller.access-control");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Cannot resolve address %s, so cannot match it to any InetAddress")
    public void cannotResolveAddress(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="Error booting the container")
    public void errorBootingContainer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Error booting the container due to insufficient stack space for the thread used to execute boot operations. The thread was configured with a stack size of [%1$d]. Setting system property %2$s to a value higher than [%1$d] may resolve this problem.")
    public void errorBootingContainer(@Cause Throwable var1, long var2, String var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=4, value="%s caught exception attempting to revert operation %s at address %s")
    public void errorRevertingOperation(@Cause Throwable var1, String var2, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Failed executing operation %s at address %s")
    public void failedExecutingOperation(@Cause Throwable var1, ModelNode var2, PathAddress var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed executing subsystem %s boot operations")
    public void failedSubsystemBootOperations(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Failed to close resource %s")
    public void failedToCloseResource(@Cause Throwable var1, Closeable var2);

    @LogMessage(level=Logger.Level.ERROR)
    public void failedToCloseResource(@Cause Throwable var1, XMLStreamWriter var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=8, value="Failed to persist configuration change")
    public void failedToPersistConfigurationChange(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=9, value="Failed to store configuration to %s")
    public void failedToStoreConfiguration(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=10, value="Invalid value %s for system property %s -- using default value [%d]")
    public void invalidSystemPropertyValue(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="Address %1$s is a wildcard address, which will not match against any specific address. Do not use the '%2$s' configuration element to specify that an interface should use a wildcard address; use '%3$s'")
    public void invalidWildcardAddress(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=13, value="Operation (%s) failed - address: (%s)")
    public void operationFailed(@Cause Throwable var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=-1, value="Operation (%s) failed - address: (%s) - failure description: %s")
    public void operationFailed(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="Operation (%s) failed - address: (%s) -- due to insufficient stack space for the thread used to execute operations. If this error is occurring during server boot, setting system property %s to a value higher than [%d] may resolve this problem.")
    public void operationFailedInsufficientStackSpace(@Cause Throwable var1, ModelNode var2, ModelNode var3, String var4, int var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Wildcard address detected - will ignore other interface criteria.")
    public void wildcardAddressDetected();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=16, value="Received no final outcome response for operation %s with address %s from remote process at address %s. The result of this operation will only include the remote process' preliminary response to the request.")
    public void noFinalProxyOutcomeReceived(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=17, value="Operation (%s) failed - address: (%s) - failure description: %s")
    public void operationFailedOnClientError(ModelNode var1, ModelNode var2, ModelNode var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="A subsystem '%s' was registered without calling ExtensionContext.createTracker(). The subsystems are registered normally but won't be cleaned up when the extension is removed.")
    public void registerSubsystemNoWrapper(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Graceful shutdown of the handler used for native management requests did not complete within [%d] ms but shutdown of the underlying communication channel is proceeding")
    public void gracefulManagementChannelHandlerShutdownTimedOut(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="Graceful shutdown of the handler used for native management requests failed but shutdown of the underlying communication channel is proceeding")
    public void gracefulManagementChannelHandlerShutdownFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=21, value="Invalid value '%s' for system property '%s' -- value must be convertible into an int")
    public void invalidChannelCloseTimeout(@Cause NumberFormatException var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=22, value="Multiple addresses or network interfaces matched the selection criteria for interface '%s'. Matching addresses: %s.  Matching network interfaces: %s. The interface will use address %s and network interface %s.")
    public void multipleMatchingAddresses(String var1, Set<InetAddress> var2, Set<String> var3, InetAddress var4, String var5);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=23, value="Value '%s' for interface selection criteria 'inet-address' is ambiguous, as more than one address or network interface available on the machine matches it. Because of this ambiguity, no address will be selected as a match. Matching addresses: %s.  Matching network interfaces: %s.")
    public void multipleMatchingAddresses(String var1, Set<InetAddress> var2, Set<String> var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=24, value="Could not read target definition!")
    public void cannotReadTargetDefinition(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Could not transform")
    public void cannotTransform(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=26, value="We have no transformer for subsystem: %s-%d.%d model transfer can break!")
    public void transformerNotFound(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=27, value="Operation was interrupted before stability could be reached")
    public void interruptedWaitingStability();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=28, value="Attribute %s is deprecated, and it might be removed in future version!")
    public void attributeDeprecated(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=29, value="Cannot delete temp file %s, will be deleted on exit")
    public void cannotDeleteTempFile(String var1);

    @Message(id=30, value="No resource definition is registered for address %s")
    public String noSuchResourceType(PathAddress var1);

    @Message(id=31, value="No operation named '%s' exists at address %s")
    public String noHandlerForOperation(String var1, PathAddress var2);

    @Message(id=32, value="There were problems during the transformation process for target host: '%s' %nProblems found: %n%s")
    @LogMessage(level=Logger.Level.WARN)
    public void transformationWarnings(String var1, Set<String> var2);

    @Message(id=33, value="Extension '%s' is deprecated and may not be supported in future versions")
    @LogMessage(level=Logger.Level.WARN)
    public void extensionDeprecated(String var1);

    @Message(id=34, value="Subsystems %s provided by legacy extension '%s' are not supported on servers running this version. The extension is only supported for use by hosts running a previous release in a mixed-version managed domain. On this server the extension will not register any subsystems, and future attempts to create or address subsystem resources on this server will result in failure.")
    @LogMessage(level=Logger.Level.INFO)
    public void ignoringUnsupportedLegacyExtension(List<String> var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=35, value="Update of the management operation audit log failed")
    public void failedToUpdateAuditLog(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=36, value="[%d] consecutive management operation audit logging failures have occurred; disabling audit logging")
    public void disablingLoggingDueToFailures(short var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=37, value="Update of the management operation audit log failed in handler '%s'")
    public void logHandlerWriteFailed(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=38, value="[%d] consecutive management operation audit logging failures have occurred in handler '%s'; disabling this handler for audit logging")
    public void disablingLogHandlerDueToFailures(int var1, String var2);

    @Message(id=39, value="%s already defined")
    public XMLStreamException alreadyDefined(String var1, @Param Location var2);

    @Message(id=40, value="%s %s already declared")
    public XMLStreamException alreadyDeclared(String var1, String var2, @Param Location var3);

    @Message(id=41, value="A %s %s already declared has already been declared in %s %s")
    public XMLStreamException alreadyDeclared(String var1, String var2, String var3, String var4, @Param Location var5);

    @Message(id=42, value="A %s or a %s %s already declared has already been declared in %s %s")
    public XMLStreamException alreadyDeclared(String var1, String var2, String var3, String var4, String var5, @Param Location var6);

    @Message(id=43, value="An %s named '%s' is already registered at location '%s'")
    public IllegalArgumentException alreadyRegistered(String var1, String var2, String var3);

    @Message(id=44, value="Ambiguous configuration file name '%s' as there are multiple files in %s that end in %s")
    public IllegalStateException ambiguousConfigurationFiles(String var1, File var2, String var3);

    @Message(id=45, value="Ambiguous name '%s' in %s: %s")
    public IllegalArgumentException ambiguousName(String var1, String var2, Collection<String> var3);

    @Message(id=46, value="Thread was interrupted waiting for a response for asynch operation")
    public RequestProcessingException asynchOperationThreadInterrupted();

    @Message(id=47, value="No asynch request with batch id %d")
    public RequestProcessingException asynchRequestNotFound(int var1);

    @Message(id=48, value="Attribute %s is not writable")
    public String attributeNotWritable(String var1);

    @Message(id=49, value="'%s' is a registered child of resource (%s)")
    public String attributeRegisteredOnResource(String var1, ModelNode var2);

    @Message(id=50, value="Unable to determine a default name based on the local host name")
    public RuntimeException cannotDetermineDefaultName(@Cause Throwable var1);

    @Message(id=51, value="Could not create %s")
    public IllegalStateException cannotCreate(String var1);

    @Message(id=52, value="Could not delete %s")
    public IllegalStateException cannotDelete(File var1);

    @Message(id=53, value="Cannot register submodels with a null PathElement")
    public IllegalArgumentException cannotRegisterSubmodelWithNullPath();

    @Message(id=54, value="Cannot register non-runtime-only submodels with a runtime-only parent")
    public IllegalArgumentException cannotRegisterSubmodel();

    @Message(id=55, value="Cannot remove %s")
    public OperationFailedRuntimeException cannotRemove(String var1);

    @Message(id=56, value="Could not rename %s to %s")
    public IllegalStateException cannotRename(String var1, String var2);

    @Message(id=57, value="Cannot write to %s")
    public IllegalArgumentException cannotWriteTo(String var1);

    @Message(id=58, value="Child %s of element %s already declared")
    public XMLStreamException childAlreadyDeclared(String var1, String var2, @Param Location var3);

    @Message(id=59, value="Could not get canonical file for boot file: %s")
    public RuntimeException canonicalBootFileNotFound(@Cause Throwable var1, File var2);

    @Message(id=60, value="Could not get canonical file for main file: %s")
    public IllegalStateException canonicalMainFileNotFound(@Cause Throwable var1, File var2);

    @Message(id=61, value="Channel closed")
    public String channelClosed();

    @Message(id=62, value="Composite operation failed and was rolled back. Steps that failed:")
    public String compositeOperationFailed();

    @Message(id=63, value="Composite operation was rolled back")
    public String compositeOperationRolledBack();

    @Message(id=64, value="Configuration files whose complete name is %s are not allowed")
    public IllegalArgumentException configurationFileNameNotAllowed(String var1);

    @Message(id=65, value="No configuration file ending in %s found in %s")
    public IllegalStateException configurationFileNotFound(String var1, File var2);

    @Message(id=66, value="No directory %s was found")
    public IllegalArgumentException directoryNotFound(String var1);

    @Message(id=67, value="Either a %s or %s domain controller configuration must be declared.")
    public XMLStreamException domainControllerMustBeDeclared(String var1, String var2, @Param Location var3);

    @Message(id=68, value="An attribute named '%s' has already been declared")
    public XMLStreamException duplicateAttribute(String var1, @Param Location var2);

    @Message(id=69, value="Duplicate %s declaration")
    public XMLStreamException duplicateDeclaration(String var1, @Param Location var2);

    @Message(id=70, value="Duplicate %s declaration %s")
    public XMLStreamException duplicateDeclaration(String var1, String var2, @Param Location var3);

    @Message(id=71, value="Duplicate path element '%s' found")
    public OperationFailedRuntimeException duplicateElement(String var1);

    @Message(id=72, value="Duplicate interface declaration")
    public XMLStreamException duplicateInterfaceDeclaration(@Param Location var1);

    @Message(id=73, value="An element of this type named '%s' has already been declared")
    public XMLStreamException duplicateNamedElement(String var1, @Param Location var2);

    @Message(id=74, value="Duplicate profile included")
    public XMLStreamException duplicateProfile(@Param Location var1);

    @Message(id=75, value="Duplicate resource %s")
    public IllegalStateException duplicateResource(String var1);

    @Message(id=76, value="Duplicate resource type %s")
    public IllegalStateException duplicateResourceType(String var1);

    @Message(id=77, value="Element %s is not supported in a %s file")
    public String elementNotSupported(String var1, String var2);

    @Message(id=78, value="Error waiting for Tx commit/rollback")
    public String errorWaitingForTransaction();

    @Message(id=79, value="Failed initializing module %s")
    public RuntimeException failedInitializingModule(@Cause Throwable var1, String var2);

    @Message(id=80, value="Failed services")
    public String failedServices();

    @Message(id=81, value="Failed to back up %s")
    public ConfigurationPersistenceException failedToBackup(@Cause Throwable var1, File var2);

    @Message(id=82, value="Failed to create backup copies of configuration file %s")
    public ConfigurationPersistenceException failedToCreateConfigurationBackup(@Cause Throwable var1, File var2);

    @Message(id=83, value="Failed to load module")
    public XMLStreamException failedToLoadModule(@Cause Throwable var1);

    @Message(id=-1, value="Failed to load module %s")
    public XMLStreamException failedToLoadModule(@Cause Throwable var1, String var2);

    @Message(id=84, value="Failed to marshal configuration")
    public ConfigurationPersistenceException failedToMarshalConfiguration(@Cause Throwable var1);

    @Message(id=85, value="Failed to parse configuration")
    public ConfigurationPersistenceException failedToParseConfiguration(@Cause Throwable var1);

    @Message(id=86, value="Failed to persist configuration change: %s")
    public String failedToPersistConfigurationChange(String var1);

    @Message(id=87, value="Failed to store configuration")
    public ConfigurationPersistenceException failedToStoreConfiguration(@Cause Throwable var1);

    @Message(id=88, value="Failed to take a snapshot of %s to %s")
    public ConfigurationPersistenceException failedToTakeSnapshot(@Cause Throwable var1, File var2, File var3);

    @Message(id=89, value="Failed to write configuration")
    public ConfigurationPersistenceException failedToWriteConfiguration(@Cause Throwable var1);

    @Message(id=90, value="%s does not exist")
    public IllegalArgumentException fileNotFound(String var1);

    @Message(id=91, value="No files beginning with '%s' found in %s")
    public IllegalArgumentException fileNotFoundWithPrefix(String var1, String var2);

    @Message(id=92, value="%s cannot be used except in a full server boot")
    public IllegalStateException fullServerBootRequired(Class<?> var1);

    @Message(id=93, value="No included group with name %s found")
    public String groupNotFound(String var1);

    @Message(id=94, value="Illegal interface criteria type %s; must be %s")
    public String illegalInterfaceCriteria(ModelType var1, ModelType var2);

    @Message(id=95, value="Illegal value %s for interface criteria %s; must be %s")
    public String illegalValueForInterfaceCriteria(ModelType var1, String var2, ModelType var3);

    @Message(id=96, value="Resource is immutable")
    public UnsupportedOperationException immutableResource();

    @Message(id=97, value="Wrong type for %s. Expected %s but was %s")
    public OperationFailedException incorrectType(String var1, Collection<ModelType> var2, ModelType var3);

    @Message(id=98, value="Interrupted while waiting for request")
    public String interruptedWaitingForRequest();

    @Message(id=99, value="%s is invalid")
    public String invalid(String var1);

    @Message(id=100, value="%d is not a valid %s")
    public XMLStreamException invalid(@Cause Throwable var1, int var2, String var3, @Param Location var4);

    @Message(id=101, value="Invalid address %s (%s)")
    public String invalidAddress(String var1, String var2);

    @Message(id=102, value="Invalid 'value' %s -- must be of the form address/mask")
    public String invalidAddressMaskValue(String var1);

    @Message(id=103, value="Invalid mask %s (%s)")
    public String invalidAddressMask(String var1, String var2);

    @Message(id=104, value="Invalid address %s (%s)")
    public String invalidAddressValue(String var1, String var2);

    @Message(id=105, value="%s is invalid in combination with %s")
    public String invalidAttributeCombo(String var1, StringBuilder var2);

    @Message(id=106, value="Invalid value '%s' for attribute '%s'")
    public XMLStreamException invalidAttributeValue(String var1, QName var2, @Param Location var3);

    @Message(id=107, value="Illegal value %d for attribute '%s' must be between %d and %d (inclusive)")
    public XMLStreamException invalidAttributeValue(int var1, QName var2, int var3, int var4, @Param Location var5);

    @Message(id=108, value="Illegal value '%s' for attribute '%s' must be an integer")
    public XMLStreamException invalidAttributeValueInt(@Cause Throwable var1, String var2, QName var3, @Param Location var4);

    @Message(id=109, value="Invalid pattern %s for interface criteria %s")
    public String invalidInterfaceCriteriaPattern(String var1, String var2);

    @Message(id=110, value="Invalid resource address element '%s'. The key '%s' is not valid for an element in a resource address.")
    public String invalidPathElementKey(String var1, String var2);

    @Message(id=111, value="Load factor must be greater than 0 and less than or equal to 1")
    public IllegalArgumentException invalidLoadFactor();

    @Message(id=112, value="'%s' is an invalid value for parameter %s. Values must have a maximum length of %d characters")
    public String invalidMaxLength(String var1, String var2, int var3);

    @Message(id=113, value="'%s' is an invalid value for parameter %s. Values must have a minimum length of %d characters")
    public String invalidMinLength(String var1, String var2, int var3);

    @Message(id=114, value="[%d] is an invalid size for parameter %s. A maximum length of [%d] is required")
    public String invalidMaxSize(int var1, String var2, int var3);

    @Message(id=115, value="[%d] is an invalid size for parameter %s. A minimum length of [%d] is required")
    public String invalidMinSize(int var1, String var2, int var3);

    @Message(id=116, value="%d is an invalid value for parameter %s. A maximum value of %d is required")
    public String invalidMaxValue(int var1, String var2, int var3);

    public String invalidMaxValue(long var1, String var3, long var4);

    @Message(id=117, value="%d is an invalid value for parameter %s. A minimum value of %d is required")
    public String invalidMinValue(int var1, String var2, int var3);

    public String invalidMinValue(long var1, String var3, long var4);

    @Message(id=118, value="Invalid modification after completed step")
    public IllegalStateException invalidModificationAfterCompletedStep();

    @Message(id=119, value="Value %s for attribute %s is not a valid multicast address")
    public OperationFailedException invalidMulticastAddress(String var1, String var2);

    @Message(id=120, value="An outbound socket binding: %s cannot have both %s as well as a %s at the same time")
    public XMLStreamException invalidOutboundSocketBinding(String var1, String var2, String var3, @Param Location var4);

    @Message(id=121, value="%s is not a valid value for parameter %s -- must be one of %s")
    public IllegalArgumentException invalidParameterValue(OperationEntry.Flag var1, String var2, Collection<OperationEntry.Flag> var3);

    @Message(id=122, value="Value %s for attribute %s does not represent a properly hex-encoded SHA1 hash")
    public XMLStreamException invalidSha1Value(@Cause Throwable var1, String var2, String var3, @Param Location var4);

    @Message(id=123, value="Stage %s is not valid for context process type %s")
    public IllegalStateException invalidStage(OperationContext.Stage var1, ProcessType var2);

    @Message(id=124, value="Invalid step stage specified")
    public IllegalArgumentException invalidStepStage();

    @Message(id=125, value="Invalid step stage for this context type")
    public IllegalArgumentException invalidStepStageForContext();

    @Message(id=126, value="Can not have a negative size table!")
    public IllegalArgumentException invalidTableSize();

    @Message(id=127, value="Invalid type %s")
    public String invalidType(ModelType var1);

    @Message(id=128, value="Invalid resource address element '%s'. The value '%s' is not valid for an element in a resource address. Character '%s' is not allowed.")
    public String invalidPathElementValue(String var1, String var2, Character var3);

    @Message(id=129, value="Invalid value %s for %s; legal values are %s")
    public String invalidValue(String var1, String var2, Collection<?> var3);

    @Message(id=130, value="Illegal '%s' value %s -- must be greater than %s")
    public XMLStreamException invalidValueGreaterThan(String var1, int var2, int var3, @Param Location var4);

    @Message(id=131, value="Illegal '%s' value %s -- cannot be negative")
    public XMLStreamException invalidValueNegative(String var1, int var2, @Param Location var3);

    @Message(id=132, value="Must include one of the following elements: %s")
    public XMLStreamException missingOneOf(StringBuilder var1, @Param Location var2);

    @Message(id=133, value="Missing required attribute(s): %s")
    public XMLStreamException missingRequiredAttributes(StringBuilder var1, @Param Location var2);

    @Message(id=134, value="Missing required element(s): %s")
    public XMLStreamException missingRequiredElements(StringBuilder var1, @Param Location var2);

    @Message(id=135, value="Interrupted awaiting loading of module %s")
    public XMLStreamException moduleLoadingInterrupted(String var1);

    @Message(id=136, value="Interrupted awaiting initialization of module %s")
    public RuntimeException moduleInitializationInterrupted(String var1);

    @Message(id=137, value="Model contains multiple %s nodes")
    public IllegalStateException multipleModelNodes(String var1);

    @Message(id=138, value="Namespace with prefix %s already registered with schema URI %s")
    public String namespaceAlreadyRegistered(String var1, String var2);

    @Message(id=139, value="No namespace with URI %s found")
    public String namespaceNotFound(String var1);

    @Message(id=140, value="Nested %s not allowed")
    public String nestedElementNotAllowed(Element var1);

    @Message(id=141, value="No active request found for handling report %d")
    public RequestProcessingException noActiveRequestForHandlingReport(int var1);

    @Message(id=142, value="No active request found for proxy operation control %d")
    public RequestProcessingException noActiveRequestForProxyOperation(int var1);

    @Message(id=143, value="No active request found for reading inputstream report %d")
    public IOException noActiveRequestForReadingInputStreamReport(int var1);

    @Message(id=144, value="No active step")
    public IllegalStateException noActiveStep();

    @Message(id=145, value="No active tx found for id %d")
    public RuntimeException noActiveTransaction(int var1);

    @Message(id=146, value="No child registry for (%s, %s)")
    public String noChildRegistry(String var1, String var2);

    @Message(id=147, value="No child type %s")
    public OperationFailedRuntimeException noChildType(String var1);

    @Message(id=149, value="No interface criteria was provided")
    public String noInterfaceCriteria();

    @Message(id=150, value="No operation handler")
    public String noOperationHandler();

    @Message(id=151, value="A node is already registered at '%s%s)'")
    public IllegalArgumentException nodeAlreadyRegistered(String var1, String var2);

    @Message(id=152, value="%s is not a directory")
    public IllegalStateException notADirectory(String var1);

    @Message(id=153, value="No %s%s found for %s")
    public IllegalStateException notFound(String var1, String var2, ModuleIdentifier var3);

    @Message(id=154, value="Cannot execute asynchronous operation without an executor")
    public IllegalStateException nullAsynchronousExecutor();

    @Message(id=155, value="%s may not be null")
    public OperationFailedException nullNotAllowed(String var1);

    @Message(id=156, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=0, value="Operation %s")
    public String operation(String var1);

    @Message(id=157, value="Operation already complete")
    public IllegalStateException operationAlreadyComplete();

    @Message(id=158, value="Operation handler failed: %s")
    public String operationHandlerFailed(String var1);

    @Message(id=159, value="Operation handler failed to complete")
    public String operationHandlerFailedToComplete();

    @Message(id=160, value="Operation rolling back")
    public String operationRollingBack();

    @Message(id=161, value="Operation succeeded, committing")
    public String operationSucceeded();

    @Message(id=162, value="There is no operation %s registered at address %s")
    public String operationNotRegistered(String var1, PathAddress var2);

    @Message(id=163, value="An operation reply value type description is required but was not implemented for operation %s")
    public IllegalStateException operationReplyValueTypeRequired(String var1);

    @Message(id=164, value="Parsing problem at [row,col]:[%d ,%d]%nMessage: %s")
    public String parsingProblem(int var1, int var2, String var3);

    @Message(id=165, value="No configuration persister was injected")
    public StartException persisterNotInjected();

    @Message(id=166, value="Thread was interrupted waiting for the operation to prepare/fail")
    public RequestProcessingException prepareFailThreadInterrupted();

    @Message(id=168, value="No profile found for inclusion")
    public XMLStreamException profileNotFound(@Param Location var1);

    @Message(id=169, value="A proxy handler is already registered at location '%s'")
    public IllegalArgumentException proxyHandlerAlreadyRegistered(String var1);

    @Message(id=170, value="Thread was interrupted waiting to read attachment input stream from remote caller")
    public RuntimeException remoteCallerThreadInterrupted();

    @Message(id=171, value="Removing services has lead to unsatisfied dependencies:")
    public String removingServiceUnsatisfiedDependencies();

    @Message(id=0, value="%nService %s was depended upon by ")
    public String removingServiceUnsatisfiedDependencies(String var1);

    @Message(id=172, value="%s is required")
    public String required(String var1);

    @Message(id=173, value="%s is reserved")
    public XMLStreamException reserved(String var1, @Param Location var2);

    @Message(id=174, value="Resource does not exist: %s")
    public String resourceNotFound(ModelNode var1);

    @Message(id=175, value="Resource %s does not exist; a resource at address %s cannot be created until all ancestor resources have been added")
    public OperationFailedRuntimeException resourceNotFound(PathAddress var1, PathAddress var2);

    @Message(id=176, value="rollback() has already been invoked")
    public IllegalStateException rollbackAlreadyInvoked();

    @Message(id=177, value="Schema with URI %s already registered with location %s")
    public String schemaAlreadyRegistered(String var1, String var2);

    @Message(id=178, value="No schema location with URI %s found")
    public String schemaNotFound(String var1);

    @Message(id=179, value="Service install was cancelled")
    public CancellationException serviceInstallCancelled();

    @Message(id=0, value="is missing [%s]")
    public String servicesMissing(StringBuilder var1);

    @Message(id=180, value="Services with missing/unavailable dependencies")
    public String servicesMissingDependencies();

    @Message(id=181, value="Get service registry only supported in runtime operations")
    public IllegalStateException serviceRegistryRuntimeOperationsOnly();

    @Message(id=182, value="Service removal only supported in runtime operations")
    public IllegalStateException serviceRemovalRuntimeOperationsOnly();

    @Message(id=183, value="Service status report%n")
    public String serviceStatusReportHeader();

    @Message(id=184, value="   New missing/unsatisfied dependencies:%n")
    public String serviceStatusReportDependencies();

    @Message(id=0, value="      %s (missing) dependents: %s %n")
    public String serviceStatusReportMissing(ServiceName var1, String var2);

    @Message(id=0, value="      %s (unavailable) dependents: %s %n")
    public String serviceStatusReportUnavailable(ServiceName var1, String var2);

    @Message(id=185, value="   Newly corrected services:%n")
    public String serviceStatusReportCorrected();

    @Message(id=0, value="      %s (no longer required)%n")
    public String serviceStatusReportNoLongerRequired(ServiceName var1);

    @Message(id=0, value="      %s (new available)%n")
    public String serviceStatusReportAvailable(ServiceName var1);

    @Message(id=186, value="  Services which failed to start:")
    public String serviceStatusReportFailed();

    @Message(id=187, value="Get service target only supported in runtime operations")
    public IllegalStateException serviceTargetRuntimeOperationsOnly();

    @Message(id=188, value="Stage %s is already complete")
    public IllegalStateException stageAlreadyComplete(OperationContext.Stage var1);

    @Message(id=189, value="Step handler %s failed after completion")
    public String stepHandlerFailed(OperationStepHandler var1);

    @Message(id=190, value="Step handler %s for operation %s at address %s failed handling operation rollback -- %s")
    public String stepHandlerFailedRollback(OperationStepHandler var1, String var2, PathAddress var3, Throwable var4);

    @Message(id=191, value="Interrupted awaiting subsystem boot operation execution")
    public String subsystemBootInterrupted();

    @Message(id=192, value="Boot operations for subsystem %s failed without explanation")
    public String subsystemBootOperationFailed(String var1);

    @Message(id=193, value="Failed executing subsystem %s boot operations")
    public String subsystemBootOperationFailedExecuting(String var1);

    @Message(id=194, value="Table is full!")
    public IllegalStateException tableIsFull();

    @Message(id=195, value="Interrupted awaiting transaction commit or rollback")
    public RuntimeException transactionInterrupted();

    @Message(id=196, value="A timeout occurred waiting for the transaction to %s")
    public RuntimeException transactionTimeout(String var1);

    @Message(id=197, value="Unexpected attribute '%s' encountered")
    public XMLStreamException unexpectedAttribute(QName var1, @Param Location var2);

    @Message(id=198, value="Unexpected element '%s' encountered")
    public XMLStreamException unexpectedElement(QName var1, @Param Location var2);

    @Message(id=199, value="Unexpected end of element '%s' encountered")
    public XMLStreamException unexpectedEndElement(QName var1, @Param Location var2);

    @Message(id=200, value="Unexpected storage %s")
    public IllegalStateException unexpectedStorage(AttributeAccess.Storage var1);

    @Message(id=201, value="Unknown attribute %s")
    public String unknownAttribute(String var1);

    @Message(id=202, value="No known child type named %s")
    public String unknownChildType(String var1);

    @Message(id=203, value="Unknown property in interface criteria list: %s")
    public RuntimeException unknownCriteriaInterfaceProperty(String var1);

    @Message(id=204, value="Unknown interface criteria type %s")
    public String unknownCriteriaInterfaceType(String var1);

    @Message(id=205, value="Unknown interface %s %s must be declared in element %s")
    public XMLStreamException unknownInterface(String var1, String var2, String var3, @Param Location var4);

    @Message(id=206, value="Unknown %s %s %s must be declared in element %s")
    public XMLStreamException unknownValueForElement(String var1, String var2, String var3, String var4, @Param Location var5);

    @Message(id=207, value="Validation failed for %s")
    public String validationFailed(String var1);

    @Message(id=208, value="... and %s more")
    public String andNMore(int var1);

    @Message(id=209, value="Invalid value '%s' for attribute '%s' -- valid values are %s")
    public XMLStreamException invalidAttributeValue(String var1, QName var2, Set<String> var3, @Param Location var4);

    @Message(id=210, value="Caught SecurityException attempting to resolve expression '%s' -- %s")
    public String noPermissionToResolveExpression(ModelNode var1, SecurityException var2);

    @Message(id=211, value="Cannot resolve expression '%s'")
    public OperationFailedException cannotResolveExpression(String var1);

    @Message(id=212, value="Duplicate resource %s")
    public OperationFailedRuntimeException duplicateResourceAddress(PathAddress var1);

    @Message(id=213, value="Cannot remove resource before removing child resources %s")
    public OperationFailedException cannotRemoveResourceWithChildren(List<PathElement> var1);

    @Message(id=214, value="Could not get main file: %s. Specified files must be relative to the configuration dir: %s")
    public IllegalStateException mainFileNotFound(String var1, File var2);

    @Message(id=216, value="Management resource '%s' not found")
    public Resource.NoSuchResourceException managementResourceNotFound(PathAddress var1);

    @Message(id=217, value="Child resource '%s' not found")
    public String childResourceNotFound(PathElement var1);

    @Message(id=218, value="A node is already registered at '%s'")
    public IllegalArgumentException nodeAlreadyRegistered(String var1);

    @Message(id=219, value="An attempt was made to unregister extension %s which still has subsystem %s registered")
    public IllegalStateException removingExtensionWithRegisteredSubsystem(String var1, String var2);

    @Message(id=220, value="An override model registration is not allowed for the root model registration")
    public IllegalStateException cannotOverrideRootRegistration();

    @Message(id=221, value="An override model registration is not allowed for non-wildcard model registrations. This registration is for the non-wildcard name '%s'.")
    public IllegalStateException cannotOverrideNonWildCardRegistration(String var1);

    @Message(id=222, value="A registration named '*' is not an override model and cannot be unregistered via the unregisterOverrideModel API.")
    public IllegalArgumentException wildcardRegistrationIsNotAnOverride();

    @Message(id=223, value="The root resource registration does not support overrides, so no override can be removed.")
    public IllegalStateException rootRegistrationIsNotOverridable();

    @Message(id=224, value="There is no operation %s registered at address %s")
    public IllegalArgumentException operationNotRegisteredException(String var1, PathAddress var2);

    @Message(id=225, value="Failed to recover services during operation rollback")
    public RuntimeException failedToRecoverServices(@Param OperationFailedException var1);

    @Message(id=226, value="A subsystem named '%s' cannot be registered by extension '%s' -- a subsystem with that name has already been registered by extension '%s'.")
    public IllegalStateException duplicateSubsystem(String var1, String var2, String var3);

    @Message(id=227, value="Operation has no '%s' field. %s")
    public IllegalArgumentException validationFailedOperationHasNoField(String var1, String var2);

    @Message(id=228, value="Operation has a null or empty name. %s")
    public IllegalArgumentException validationFailedOperationHasANullOrEmptyName(String var1);

    @Message(id=229, value="No operation called '%s' at '%s'. %s")
    public IllegalArgumentException validationFailedNoOperationFound(String var1, PathAddress var2, String var3);

    @Message(id=230, value="Operation contains a parameter '%s' which is not one of the expected parameters %s. %s")
    public IllegalArgumentException validationFailedActualParameterNotDescribed(String var1, Set<String> var2, String var3);

    @Message(id=231, value="Required parameter %s is not present. %s")
    public IllegalArgumentException validationFailedRequiredParameterNotPresent(String var1, String var2);

    @Message(id=232, value="Alternative parameter '%s' for required parameter '%s' was used. Please use one or the other. %s")
    public IllegalArgumentException validationFailedRequiredParameterPresentAsWellAsAlternative(String var1, String var2, String var3);

    @Message(id=233, value="Could not convert the parameter '%s' to a %s. %s")
    public IllegalArgumentException validationFailedCouldNotConvertParamToType(String var1, ModelType var2, String var3);

    @Message(id=234, value="The value '%s' passed in for '%s' is smaller than the minimum value '%s'. %s")
    public IllegalArgumentException validationFailedValueIsSmallerThanMin(Number var1, String var2, Number var3, String var4);

    @Message(id=235, value="The value '%s' passed in for '%s' is bigger than the maximum value '%s'. %s")
    public IllegalArgumentException validationFailedValueIsGreaterThanMax(Number var1, String var2, Number var3, String var4);

    @Message(id=236, value="The value '%s' passed in for '%s' is shorter than the minimum length '%s'. %s")
    public IllegalArgumentException validationFailedValueIsShorterThanMinLength(Object var1, String var2, Object var3, String var4);

    @Message(id=237, value="The value '%s' passed in for '%s' is longer than the maximum length '%s'. %s")
    public IllegalArgumentException validationFailedValueIsLongerThanMaxLength(Object var1, String var2, Object var3, String var4);

    @Message(id=238, value="%s is expected to be a list of %s. %s")
    public IllegalArgumentException validationFailedInvalidElementType(String var1, ModelType var2, String var3);

    @Message(id=239, value="'required' parameter: '%s' must be a boolean in the description of the operation at %s: %s")
    public String invalidDescriptionRequiredFlagIsNotABoolean(String var1, PathAddress var2, ModelNode var3);

    @Message(id=240, value="Undefined request property '%s' in description of the operation at %s: %s")
    public String invalidDescriptionUndefinedRequestProperty(String var1, PathAddress var2, ModelNode var3);

    @Message(id=241, value="There is no type for parameter '%s' in the description of the operation at %s: %s")
    public String invalidDescriptionNoParamTypeInDescription(String var1, PathAddress var2, ModelNode var3);

    @Message(id=242, value="Could not determine the type of parameter '%s' in the description of the operation at %s: %s")
    public String invalidDescriptionInvalidParamTypeInDescription(String var1, PathAddress var2, ModelNode var3);

    @Message(id=243, value="The '%s' attribute of the '%s' parameter can not be converted to its type: %s in the description of the operation at %s: %s")
    public String invalidDescriptionMinMaxForParameterHasWrongType(String var1, String var2, ModelType var3, PathAddress var4, ModelNode var5);

    @Message(id=244, value="The '%s' attribute of the '%s' parameter can not be converted to an integer in the description of the operation at %s: %s")
    public String invalidDescriptionMinMaxLengthForParameterHasWrongType(String var1, String var2, PathAddress var3, ModelNode var4);

    @Message(id=245, value="Illegal '%s' value %s -- must be a valid port number")
    public XMLStreamException invalidPort(String var1, String var2, @Param Location var3);

    @Message(id=246, value="Cannot resolve the localhost address to create a UUID-based name for this process")
    public RuntimeException cannotResolveProcessUUID(@Cause UnknownHostException var1);

    @Message(id=247, value="Do not call ServiceController.setMode(REMOVE), use OperationContext.removeService() instead.")
    public IllegalStateException useOperationContextRemoveService();

    @Message(id=248, value="Invalid value %s for %s; legal values are %s")
    public OperationFailedException invalidEnumValue(String var1, String var2, Set<?> var3);

    @Message(id=249, value="Operation '%s' targeted at resource '%s' was directly invoked by a user. User operations are not permitted to directly update the persistent configuration of a server in a managed domain.")
    public OperationFailedRuntimeException modelUpdateNotAuthorized(String var1, PathAddress var2);

    @Message(id=250, value="An operation handler attempted to access the operation response server results object on a process type other than '%s'. The current process type is '%s'")
    public IllegalStateException serverResultsAccessNotAllowed(ProcessType var1, ProcessType var2);

    @Message(id=251, value="Can't have both loopback and inet-address criteria")
    public String cantHaveBothLoopbackAndInetAddressCriteria();

    @Message(id=252, value="Can't have both link-local and inet-address criteria")
    public String cantHaveBothLinkLocalAndInetAddressCriteria();

    @Message(id=253, value="Can't have same criteria for both not and inclusion %s")
    public String cantHaveSameCriteriaForBothNotAndInclusion(InterfaceCriteria var1);

    @Message(id=254, value="Invalid value '%s' for attribute '%s' -- no interface configuration with that name exists")
    public OperationFailedException nonexistentInterface(String var1, String var2);

    @Message(id=255, value="%s is empty")
    public IllegalArgumentException emptyVar(String var1);

    @Message(id=256, value="Could not find a path called '%s'")
    public IllegalArgumentException pathEntryNotFound(String var1);

    @Message(id=257, value="Path entry is read-only: '%s'")
    public IllegalArgumentException pathEntryIsReadOnly(String var1);

    @Message(id=258, value="There is already a path entry called: '%s'")
    public IllegalArgumentException pathEntryAlreadyExists(String var1);

    @Message(id=259, value="Could not find relativeTo path '%s' for relative path '%s'")
    public IllegalStateException pathEntryNotFoundForRelativePath(String var1, String var2);

    @Message(id=260, value="Invalid relativePath value '%s'")
    public IllegalArgumentException invalidRelativePathValue(String var1);

    @Message(id=261, value="'%s' is a Windows absolute path")
    public IllegalArgumentException pathIsAWindowsAbsolutePath(String var1);

    @Message(id=262, value="Path '%s' is read-only; it cannot be removed")
    public OperationFailedException cannotRemoveReadOnlyPath(String var1);

    @Message(id=263, value="Path '%s' is read-only; it cannot be modified")
    public OperationFailedException cannotModifyReadOnlyPath(String var1);

    @Message(id=264, value="%s may not be ModelType.EXPRESSION")
    public OperationFailedException expressionNotAllowed(String var1);

    @Message(id=265, value="PathManager not available on processes of type '%s'")
    public IllegalStateException pathManagerNotAvailable(ProcessType var1);

    @Message(id=266, value="Value %s for attribute %s is not a valid multicast address")
    public OperationFailedException unknownMulticastAddress(@Cause UnknownHostException var1, String var2, String var3);

    @Message(id=267, value="Path '%s' cannot be removed, since the following paths depend on it: %s")
    public OperationFailedException cannotRemovePathWithDependencies(String var1, Set<String> var2);

    @Message(id=268, value="Failed to rename temp file %s to %s")
    public ConfigurationPersistenceException failedToRenameTempFile(@Cause Throwable var1, File var2, File var3);

    @Message(id=269, value="Invalid locale format:  %s")
    public String invalidLocaleString(String var1);

    @Message(id=270, value="<one or more transitive dependencies>")
    public String transitiveDependencies();

    @Message(id=271, value="Operation cancelled")
    public String operationCancelled();

    @Message(id=272, value="Operation cancelled asynchronously")
    public OperationCancellationException operationCancelledAsynchronously();

    @Message(id=273, value="Stream was killed")
    public IOException streamWasKilled();

    @Message(id=274, value="Stream was closed")
    public IOException streamWasClosed();

    @Message(id=275, value="Cannot define both '%s' and '%s'")
    public OperationFailedException cannotHaveBothParameters(String var1, String var2);

    @Message(id=276, value="Failed to delete file %s")
    public IllegalStateException couldNotDeleteFile(File var1);

    @Message(id=277, value="An alias is already registered at location '%s'")
    public IllegalArgumentException aliasAlreadyRegistered(String var1);

    @Message(id=278, value="Expected an address under '%s', was '%s'")
    public IllegalArgumentException badAliasConvertAddress(PathAddress var1, PathAddress var2);

    @Message(id=279, value="Alias target address not found: %s")
    public IllegalArgumentException aliasTargetResourceRegistrationNotFound(PathAddress var1);

    @Message(id=280, value="No operation called '%s' found for alias address '%s' which maps to '%s'")
    public IllegalArgumentException aliasStepHandlerOperationNotFound(String var1, PathAddress var2, PathAddress var3);

    @Message(id=281, value="Resource registration is not an alias")
    public IllegalStateException resourceRegistrationIsNotAnAlias();

    @Message(id=282, value="Model contains fields that are not known in definition, fields: %s, path: %s")
    public RuntimeException modelFieldsNotKnown(Set<String> var1, PathAddress var2);

    @Message(id=283, value="Could not marshal attribute as element: %s")
    public UnsupportedOperationException couldNotMarshalAttributeAsElement(String var1);

    @Message(id=284, value="Could not marshal attribute as attribute: %s")
    public UnsupportedOperationException couldNotMarshalAttributeAsAttribute(String var1);

    @Message(id=285, value="Operation %s invoked against multiple target addresses failed at address %s with failure description %s")
    public String wildcardOperationFailedAtSingleAddress(String var1, PathAddress var2, String var3);

    @Message(id=286, value="Operation %s invoked against multiple target addresses failed at address %s. See the operation result for details.")
    public String wildcardOperationFailedAtSingleAddressWithComplexFailure(String var1, PathAddress var2);

    @Message(id=287, value="Operation %s invoked against multiple target addresses failed at addresses %s. See the operation result for details.")
    public String wildcardOperationFailedAtMultipleAddresses(String var1, Set<PathAddress> var2);

    @Message(id=288, value="One or more services were unable to start due to one or more indirect dependencies not being available.")
    public String missingTransitiveDependencyProblem();

    @Message(id=0, value="Services that were unable to start:")
    public String missingTransitiveDependents();

    @Message(id=0, value="Services that may be the cause:")
    public String missingTransitiveDependencies();

    @Message(id=289, value="No operation entry called '%s' registered at '%s'")
    public String noOperationEntry(String var1, PathAddress var2);

    @Message(id=290, value="No operation handler called '%s' registered at '%s'")
    public String noOperationHandler(String var1, PathAddress var2);

    @Message(id=291, value="There is no registered path to resolve with path attribute '%s' and/or relative-to attribute '%s on: %s")
    public IllegalStateException noPathToResolve(String var1, String var2, ModelNode var3);

    @Message(id=292, value="Attributes do not support expressions in the target model version and this resource will need to be ignored on the target host.")
    public String attributesDontSupportExpressions();

    @Message(id=293, value="Attributes are not understood in the target model version and this resource will need to be ignored on the target host.")
    public String attributesAreNotUnderstoodAndMustBeIgnored();

    @Message(id=294, value="Transforming resource %s to core model version '%s' -- %s %s")
    public String transformerLoggerCoreModelResourceTransformerAttributes(PathAddress var1, ModelVersion var2, String var3, String var4);

    @Message(id=295, value="Transforming operation %s at resource %s to core model version '%s' -- %s %s")
    public String transformerLoggerCoreModelOperationTransformerAttributes(ModelNode var1, PathAddress var2, ModelVersion var3, String var4, String var5);

    @Message(id=296, value="Transforming resource %s to subsystem '%s' model version '%s' -- %s %s")
    public String transformerLoggerSubsystemModelResourceTransformerAttributes(PathAddress var1, String var2, ModelVersion var3, String var4, String var5);

    @Message(id=297, value="Transforming operation %s at resource %s to subsystem '%s' model version '%s' -- %s %s")
    public String transformerLoggerSubsystemModelOperationTransformerAttributes(ModelNode var1, PathAddress var2, String var3, ModelVersion var4, String var5, String var6);

    @Message(id=298, value="Node contains an unresolved expression %s -- a resolved model is required")
    public OperationFailedException illegalUnresolvedModel(String var1);

    @Message(id=299, value="Transforming resource %s for host controller '%s' to core model version '%s' -- there were problems with some of the attributes and this resource will need to be ignored on that host. Details of the problems: %s")
    public OperationFailedException rejectAttributesCoreModelResourceTransformer(PathAddress var1, String var2, ModelVersion var3, List<String> var4);

    @Message(id=300, value="Transforming resource %s for host controller '%s' to subsystem '%s' model version '%s' --there were problems with some of the attributes and this resource will need to be ignored on that host. Details of problems: %s")
    public OperationFailedException rejectAttributesSubsystemModelResourceTransformer(PathAddress var1, String var2, String var3, ModelVersion var4, List<String> var5);

    @Message(id=301, value="The following attributes do not support expressions: %s")
    public String attributesDoNotSupportExpressions(Set<String> var1);

    @Message(id=0, value="attributes %s")
    public String attributeNames(Set<String> var1);

    @Message(id=302, value="The following attributes are not understood in the target model version and this resource will need to be ignored on the target host: %s")
    public String attributesAreNotUnderstoodAndMustBeIgnored(Set<String> var1);

    @Message(id=303, value="Resource %s is rejected on the target host, and will need to be ignored on the host")
    public String rejectedResourceResourceTransformation(PathAddress var1);

    @Message(id=304, value="Resource %s is rejected on the target host and will need to be ignored on the host: %s")
    public String rejectResourceOperationTransformation(PathAddress var1, ModelNode var2);

    @Message(id=305, value="Unless the Host Controller is started with command line option %s and the %s attribute is not set to %s, %s must be declared or the %s and the %s need to be provided.")
    public XMLStreamException discoveryOptionsMustBeDeclared(String var1, String var2, String var3, String var4, String var5, String var6, @Param Location var7);

    @Message(id=306, value="read only context")
    public IllegalStateException readOnlyContext();

    @Message(id=307, value="We are trying to read data from the master host controller, which is currently busy executing another set of operations. This is a temporary situation, please retry")
    public String cannotGetControllerLock();

    @Message(id=308, value="Cannot configure an interface to use 'any-ipv6-address' when system property java.net.preferIPv4Stack is true")
    public StartException invalidAnyIPv6();

    @Message(id=309, value="Legacy extension '%s' is not supported on servers running this version. The extension is only supported for use by hosts running a previous release in a mixed-version managed domain")
    public String unsupportedLegacyExtension(String var1);

    @Message(id=310, value="Extension module %s not found")
    public OperationFailedRuntimeException extensionModuleNotFound(@Cause ModuleNotFoundException var1, String var2);

    @Message(id=311, value="Failed to load Extension module %s")
    public RuntimeException extensionModuleLoadingFailure(@Cause ModuleLoadException var1, String var2);

    @Message(id=312, value="no context to delegate with id: %s")
    public IllegalStateException noContextToDelegateTo(int var1);

    @Message(id=313, value="Unauthorized to execute operation '%s' for resource '%s' -- %s")
    public UnauthorizedException unauthorized(String var1, PathAddress var2, ModelNode var3);

    @Message(id=314, value="Users with multiple roles are not allowed")
    public SecurityException illegalMultipleRoles();

    @Message(id=315, value="An unexpected number of AccountPrincipals %d have been found in the current Subject.")
    public IllegalStateException unexpectedAccountPrincipalCount(int var1);

    @Message(id=316, value="Different realms '%s' '%s' found in single Subject")
    public IllegalStateException differentRealmsInSubject(String var1, String var2);

    @Message(id=317, value="There is no handler called '%s'")
    public IllegalStateException noHandlerCalled(String var1);

    @Message(id=318, value="The operation context is not an AbstractOperationContext")
    public OperationFailedException operationContextIsNotAbstractOperationContext();

    @Message(id=319, value="The handler is referenced by %s and so cannot be removed")
    public IllegalStateException handlerIsReferencedBy(Set<PathAddress> var1);

    @Message(id=320, value="The resolved file %s either does not exist or is a directory")
    public IllegalStateException resolvedFileDoesNotExistOrIsDirectory(File var1);

    @Message(id=321, value="Could not back up '%s' to '%s'")
    public IllegalStateException couldNotBackUp(@Cause IOException var1, String var2, String var3);

    @Message(id=322, value="Attempt was made to both remove and add a handler from a composite operation - update the handler instead")
    public IllegalStateException attemptToBothRemoveAndAddHandlerUpdateInstead();

    @Message(id=323, value="Attempt was made to both add and remove a handler from a composite operation")
    public IllegalStateException attemptToBothAddAndRemoveAndHandlerFromCompositeOperation();

    @Message(id=324, value="Attempt was made to both update and remove a handler from a composite operation")
    public IllegalStateException attemptToBothUpdateAndRemoveHandlerFromCompositeOperation();

    @Message(id=325, value="Attempt was made to both remove and add a handler reference from a composite operation")
    public IllegalStateException attemptToBothRemoveAndAddHandlerReferenceFromCompositeOperation();

    @Message(id=327, value="Unknown role '%s'")
    public IllegalArgumentException unknownRole(String var1);

    @Message(id=328, value="Cannot remove standard role '%s'")
    public IllegalStateException cannotRemoveStandardRole(String var1);

    @Message(id=329, value="Unknown base role '%s'")
    public IllegalArgumentException unknownBaseRole(String var1);

    @Message(id=330, value="Role '%s' is already registered")
    public IllegalStateException roleIsAlreadyRegistered(String var1);

    @Message(id=331, value="Can only create child audit logger for main audit logger")
    public IllegalStateException canOnlyCreateChildAuditLoggerForMainAuditLogger();

    @Message(id=332, value="Permission denied")
    public String permissionDenied();

    @Message(id=333, value="Cannot add a Permission to a readonly PermissionCollection")
    public SecurityException permissionCollectionIsReadOnly();

    @Message(id=334, value="Incompatible permission type %s")
    public IllegalArgumentException incompatiblePermissionType(Class<?> var1);

    @Message(id=335, value="Management resource '%s' not found")
    public String managementResourceNotFoundMessage(PathAddress var1);

    @Message(id=336, value="The following attributes are nillable in the current model but must be defined in the target model version: %s")
    public String attributesMustBeDefined(Set<String> var1);

    @Message(id=337, value="Unsupported Principal type '%X' received.")
    public IOException unsupportedPrincipalType(byte var1);

    @Message(id=338, value="Unsupported Principal parameter '%X' received parsing principal type '%X'.")
    public IOException unsupportedPrincipalParameter(byte var1, byte var2);

    @Message(id=339, value="The following attributes must be defined as %s in the current model: %s")
    public String attributesMustBeDefinedAs(ModelNode var1, Set<String> var2);

    @Message(id=340, value="The following attributes must NOT be defined as %s in the current model: %s")
    public String attributesMustNotBeDefinedAs(ModelNode var1, Set<String> var2);

    @Message(id=341, value="A uri with bad syntax '%s' was passed for validation.")
    public OperationFailedException badUriSyntax(String var1);

    @Message(id=342, value="Illegal value %d for operation header %s; value must be greater than zero")
    public IllegalStateException invalidBlockingTimeout(long var1, String var3);

    @Message(id=343, value="The service container has been destabilized by a previous operation and further runtime updates cannot be processed. Restart is required.")
    public String timeoutAwaitingInitialStability();

    @Message(id=344, value="Operation timed out awaiting service container stability")
    public String timeoutExecutingOperation();

    @Message(id=345, value="Timeout after %d seconds waiting for existing service %s to be removed so a new instance can be installed.")
    public IllegalStateException serviceInstallTimedOut(long var1, ServiceName var3);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=346, value="Invalid value %s for property %s; must be a numeric value greater than zero. Default value of %d will be used.")
    public void invalidDefaultBlockingTimeout(String var1, String var2, long var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=347, value="Timeout after [%d] seconds waiting for initial service container stability before allowing runtime changes for operation '%s' at address '%s'. Operation will roll back; process restart is required.")
    public void timeoutAwaitingInitialStability(long var1, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=348, value="Timeout after [%d] seconds waiting for service container stability. Operation will roll back. Step that first updated the service container was '%s' at address '%s'")
    public void timeoutExecutingOperation(long var1, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=349, value="Timeout after [%d] seconds waiting for service container stability while finalizing an operation. Process must be restarted. Step that first updated the service container was '%s' at address '%s'")
    public void timeoutCompletingOperation(long var1, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=350, value="Execution of operation '%s' on remote process at address '%s' interrupted while awaiting initial response; remote process has been notified to cancel operation")
    public void interruptedAwaitingInitialResponse(String var1, PathAddress var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=351, value="Execution of operation '%s' on remote process at address '%s' interrupted while awaiting final response; remote process has been notified to terminate operation")
    public void interruptedAwaitingFinalResponse(String var1, PathAddress var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=352, value="Cancelling operation '%s' with id '%d' running on thread '%s'")
    public void cancellingOperation(String var1, int var2, String var3);

    @Message(id=353, value="No response handler for request %s")
    public IOException responseHandlerNotFound(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=354, value="Attempting reconnect to syslog handler '%s; after timeout of %d seconds")
    public void attemptingReconnectToSyslog(String var1, int var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=355, value="Reconnecting to syslog handler '%s failed")
    public void reconnectToSyslogFailed(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=356, value="Failed to emit notification %s")
    public void failedToEmitNotification(Notification var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=357, value="Notification of type %s is not described for the resource at the address %s")
    public void notificationIsNotDescribed(String var1, PathAddress var2);

    @Message(id=358, value="The resource was added at the address %s.")
    public String resourceWasAdded(PathAddress var1);

    @Message(id=359, value="The resource was removed at the address %s.")
    public String resourceWasRemoved(PathAddress var1);

    @Message(id=360, value="The attribute %s value has been changed from %s to %s.")
    public String attributeValueWritten(String var1, ModelNode var2, ModelNode var3);

    @Message(id=361, value="Capabilities cannot be queried in stage '%s'; they are not available until stage '%s'.")
    public IllegalStateException capabilitiesNotAvailable(OperationContext.Stage var1, OperationContext.Stage var2);

    @Message(id=362, value="Capabilities required by resource '%s' are not available:")
    public String requiredCapabilityMissing(String var1);

    @Message(id=363, value="Capability '%s' is already registered in context '%s.")
    public IllegalStateException capabilityAlreadyRegisteredInContext(String var1, String var2);

    @Message(id=364, value="Capability '%s' is unknown.")
    public IllegalStateException unknownCapability(String var1);

    @Message(id=365, value="Capability '%s' is unknown in context '%s'.")
    public IllegalStateException unknownCapabilityInContext(String var1, String var2);

    @Message(id=366, value="Capability '%s' does not expose a runtime API.")
    public IllegalArgumentException capabilityDoesNotExposeRuntimeAPI(String var1);

    @Message(id=367, value="Cannot remove capability '%s' as it is required by other capabilities:")
    public String cannotRemoveRequiredCapability(String var1);

    @Message(id=368, value="Cannot remove capability '%s' from context '%s' as it is required by other capabilities:")
    public String cannotRemoveRequiredCapabilityInContext(String var1, String var2);

    @Message(id=369, value="Required capabilities are not available:")
    public String requiredCapabilityMissing();

    @Message(id=0, value="capability '%s' requires it for address '%s'")
    public String requirementPointSimple(String var1, String var2);

    @Message(id=0, value="capability '%s' requires it for attribute '%s' at address '%s'")
    public String requirementPointFull(String var1, String var2, String var3);

    @Message(id=0, value="    %s")
    public String formattedCapabilityName(String var1);

    @Message(id=0, value="    %s in context '%s'")
    public String formattedCapabilityId(String var1, String var2);

    @Message(id=370, value="Incomplete expression: %s")
    public OperationFailedException incompleteExpression(String var1);

    @Message(id=371, value="The element '%s' is no longer supported, please use '%s' instead")
    public XMLStreamException unsupportedElement(QName var1, @Param Location var2, String var3);

    @Message(id=372, value="List attribute '%s' contains duplicates, which are not allowed")
    public String duplicateElementsInList(String var1);

    @Message(id=373, value="Deployment resource must be runtime only")
    public IllegalArgumentException deploymentResourceMustBeRuntimeOnly();

    @Message(id=374, value="Unable to resolve expressions at this location.")
    public OperationFailedException unableToResolveExpressions();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=375, value="Update of the management operation audit log failed on the handler '%s' due to '%s'. Please make sure that the syslog server is running and reachable")
    public void udpSyslogServerUnavailable(String var1, String var2);

    @Message(id=376, value="Unexpected attribute '%s' encountered. Valid attributes are: '%s'")
    public XMLStreamException unexpectedAttribute(QName var1, StringBuilder var2, @Param Location var3);

    @Message(id=377, value="Unexpected element '%s' encountered. Valid elements are: '%s'")
    public XMLStreamException unexpectedElement(QName var1, StringBuilder var2, @Param Location var3);

    @Message(id=378, value="Attribute '%s' is not of type '%s', it is type '%s'")
    public OperationFailedException attributeIsWrongType(String var1, ModelType var2, ModelType var3);

    @Message(id=379, value="System boot is in process; execution of remote management operations is not currently available")
    public String managementUnavailableDuringBoot();

    @Message(id=380, value="Attribute '%s' needs to be set or passed before attribute '%s' can be correctly set")
    public OperationFailedException requiredAttributeNotSet(String var1, String var2);

    @Message(id=381, value="Illegal permission name '%s'")
    public IllegalArgumentException illegalPermissionName(String var1);

    @Message(id=382, value="Illegal permission actions '%s'")
    public IllegalArgumentException illegalPermissionActions(String var1);

    @Message(id=383, value="No operation is defined %s")
    public String noOperationDefined(ModelNode var1);

    @Message(id=384, value="The call to registerHostCapable() should happen before registering models or transformers for the '%s' subsystem.")
    public IllegalStateException registerHostCapableMustHappenFirst(String var1);

    @Message(id=385, value="An attempt was made to register the non-host capable subsystem '%s' from extension module '%s' in the host model.")
    public IllegalStateException nonHostCapableSubsystemInHostModel(String var1, String var2);

    @Message(id=386, value="The host controller info can only be accessed after the model stage on boot")
    public OperationFailedException onlyAccessHostControllerInfoInRuntimeStage();

    @Message(id=387, value="Illegal path address '%s' , it is not in a correct CLI format")
    public IllegalArgumentException illegalCLIStylePathAddress(String var1);

    @Message(id=388, value="Could not create empty configuration file %s")
    public IllegalStateException cannotCreateEmptyConfig(String var1, @Cause IOException var2);

    @Message(id=389, value="Could not create an empty configuration at file %s as there is an existing non-empty configuration there")
    public IllegalStateException rejectEmptyConfig(String var1);

    @Message(id=390, value="An invalid key '%s' has been supplied for parameter '%s'")
    public OperationFailedException invalidKeyForObjectType(String var1, String var2);
}

