/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ProxyOperationAddressTranslator;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.BlockingQueueOperationListener;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.controller.remote.TransactionalProtocolHandlers;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.threads.AsyncFuture;

public class RemoteProxyController
implements ProxyController {
    private final PathAddress pathAddress;
    private final ProxyOperationAddressTranslator addressTranslator;
    private final TransactionalProtocolClient client;

    private RemoteProxyController(TransactionalProtocolClient client, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
        this.client = client;
        this.pathAddress = pathAddress;
        this.addressTranslator = addressTranslator;
    }

    public static RemoteProxyController create(TransactionalProtocolClient client, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
        return new RemoteProxyController(client, pathAddress, addressTranslator);
    }

    public static RemoteProxyController create(ManagementChannelHandler channelAssociation, PathAddress pathAddress, ProxyOperationAddressTranslator addressTranslator) {
        TransactionalProtocolClient client = TransactionalProtocolHandlers.createClient(channelAssociation);
        return RemoteProxyController.create(client, pathAddress, addressTranslator);
    }

    public TransactionalProtocolClient getTransactionalProtocolClient() {
        return this.client;
    }

    @Override
    public PathAddress getProxyNodeAddress() {
        return this.pathAddress;
    }

    @Override
    public void execute(ModelNode original, OperationMessageHandler messageHandler, final ProxyController.ProxyOperationControl control, OperationAttachments attachments) {
        final CountDownLatch completed = new CountDownLatch(1);
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(1, true);
        TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation> operationListener = new TransactionalProtocolClient.TransactionalOperationListener<TransactionalProtocolClient.Operation>(){

            @Override
            public void operationPrepared(TransactionalProtocolClient.PreparedOperation<TransactionalProtocolClient.Operation> prepared) {
                if (!queue.offer(prepared)) {
                    prepared.rollback();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationFailed(TransactionalProtocolClient.Operation operation, ModelNode result) {
                try {
                    queue.offer(new BlockingQueueOperationListener.FailedOperation<TransactionalProtocolClient.Operation>(operation, result));
                }
                finally {
                    completed.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(TransactionalProtocolClient.Operation operation, ModelNode result) {
                try {
                    control.operationCompleted(result);
                }
                finally {
                    completed.countDown();
                }
            }
        };
        AsyncFuture<ModelNode> futureResult = null;
        try {
            ModelNode translated = this.translateOperationForProxy(original);
            ControllerLogger.MGMT_OP_LOGGER.tracef("Executing %s for %s", translated.get("operation").asString(), this.getProxyNodeAddress());
            futureResult = this.client.execute(operationListener, translated, messageHandler, attachments);
            final TransactionalProtocolClient.PreparedOperation prepared = (TransactionalProtocolClient.PreparedOperation)queue.take();
            if (prepared.isFailed()) {
                control.operationFailed(prepared.getPreparedResult());
                return;
            }
            AsyncFuture<ModelNode> cancellable = futureResult;
            control.operationPrepared(new ModelController.OperationTransaction((Future)cancellable, translated){
                final /* synthetic */ Future val$cancellable;
                final /* synthetic */ ModelNode val$translated;
                {
                    this.val$cancellable = future;
                    this.val$translated = modelNode;
                }

                @Override
                public void commit() {
                    prepared.commit();
                    try {
                        completed.await();
                    }
                    catch (InterruptedException e) {
                        this.val$cancellable.cancel(true);
                        ControllerLogger.MGMT_OP_LOGGER.interruptedAwaitingFinalResponse(this.val$translated.get("operation").asString(), RemoteProxyController.this.getProxyNodeAddress());
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                @Override
                public void rollback() {
                    prepared.rollback();
                    try {
                        completed.await();
                    }
                    catch (InterruptedException e) {
                        this.val$cancellable.cancel(true);
                        ControllerLogger.MGMT_OP_LOGGER.interruptedAwaitingFinalResponse(this.val$translated.get("operation").asString(), RemoteProxyController.this.getProxyNodeAddress());
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, prepared.getPreparedResult());
        }
        catch (InterruptedException e) {
            if (futureResult != null) {
                ControllerLogger.MGMT_OP_LOGGER.interruptedAwaitingInitialResponse(original.get("operation").asString(), this.getProxyNodeAddress());
                futureResult.cancel(true);
            }
            control.operationFailed(RemoteProxyController.getCancelledResponse());
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            ModelNode result = new ModelNode();
            result.get("outcome").set("failed");
            result.get("failure-description").set(e.getLocalizedMessage());
            control.operationFailed(result);
        }
    }

    public ModelNode translateOperationForProxy(ModelNode op) {
        PathAddress translated;
        PathAddress addr = PathAddress.pathAddress(op.get("address"));
        if (addr.equals(translated = this.addressTranslator.translateAddress(addr))) {
            return op;
        }
        ModelNode proxyOp = op.clone();
        proxyOp.get("address").set(translated.toModelNode());
        return proxyOp;
    }

    private static ModelNode getCancelledResponse() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("cancelled");
        result.get("failure-description").set(ControllerLogger.ROOT_LOGGER.operationCancelled());
        return result;
    }
}

