/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.ReadAttributeHandler;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WriteAttributeHandler
implements OperationStepHandler {
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("write-attribute", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.NAME, GlobalOperationAttributes.VALUE).setRuntimeOnly().build();
    public static final OperationStepHandler INSTANCE = new WriteAttributeHandler();
    private ParametersValidator nameValidator = new ParametersValidator();

    WriteAttributeHandler() {
        this.nameValidator.registerValidator(GlobalOperationAttributes.NAME.getName(), new StringLengthValidator(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model;
        this.nameValidator.validate(operation);
        final String attributeName = operation.require(GlobalOperationAttributes.NAME.getName()).asString();
        final PathAddress address = PathAddress.pathAddress(operation.get("address"));
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        if (registry == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(PathAddress.pathAddress(operation.get("address"))));
        }
        final AttributeAccess attributeAccess = registry.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        if (attributeAccess == null) {
            throw new OperationFailedException(new ModelNode().set(ControllerLogger.ROOT_LOGGER.unknownAttribute(attributeName)));
        }
        if (attributeAccess.getAccessType() != AttributeAccess.AccessType.READ_WRITE) {
            throw new OperationFailedException(new ModelNode().set(ControllerLogger.ROOT_LOGGER.attributeNotWritable(attributeName)));
        }
        ModelNode currentValue = attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION ? ((model = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS).getModel()).has(attributeName) ? model.get(attributeName) : new ModelNode()) : new ModelNode();
        AuthorizationResult authorizationResult = context.authorize(operation, attributeName, currentValue);
        if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), address, authorizationResult.getExplanation());
        }
        if (attributeAccess.getStorageType() == AttributeAccess.Storage.CONFIGURATION && !registry.isRuntimeOnly()) {
            ModelNode oldValue = currentValue.clone();
            OperationStepHandler writeHandler = attributeAccess.getWriteHandler();
            ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(writeHandler.getClass());
            try {
                writeHandler.execute(context, operation);
                ModelNode model2 = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                ModelNode newValue = model2.has(attributeName) ? model2.get(attributeName) : new ModelNode();
                this.emitAttributeValueWrittenNotification(context, address, attributeName, oldValue, newValue);
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
            }
        } else {
            assert (attributeAccess.getStorageType() == AttributeAccess.Storage.RUNTIME);
            OperationContext.Stage currentStage = context.getCurrentStage();
            ModelNode readAttributeOperation = Util.createOperation("read-attribute", address);
            readAttributeOperation.get(GlobalOperationAttributes.NAME.getName()).set(attributeName);
            ReadAttributeHandler readAttributeHandler = new ReadAttributeHandler(null, null);
            final ModelNode oldValue = new ModelNode();
            final ModelNode newValue = new ModelNode();
            context.addStep(oldValue, readAttributeOperation, readAttributeHandler, currentStage);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    WriteAttributeHandler.this.doExecuteInternal(context, operation, attributeAccess);
                }
            }, currentStage);
            context.addStep(newValue, readAttributeOperation, readAttributeHandler, currentStage);
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    WriteAttributeHandler.this.emitAttributeValueWrittenNotification(context, address, attributeName, oldValue.get("result"), newValue.get("result"));
                    context.stepCompleted();
                }
            }, currentStage);
            context.stepCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteInternal(OperationContext context, ModelNode operation, AttributeAccess attributeAccess) throws OperationFailedException {
        OperationStepHandler writeHandler = attributeAccess.getWriteHandler();
        ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(writeHandler.getClass());
        try {
            writeHandler.execute(context, operation);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private void emitAttributeValueWrittenNotification(OperationContext context, PathAddress address, String attributeName, ModelNode oldValue, ModelNode newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        ModelNode data = new ModelNode();
        data.get(GlobalOperationAttributes.NAME.getName()).set(attributeName);
        data.get("old-value").set(oldValue);
        data.get("new-value").set(newValue);
        Notification notification = new Notification("attribute-value-written", address, ControllerLogger.ROOT_LOGGER.attributeValueWritten(attributeName, oldValue, newValue), data);
        context.emit(notification);
    }
}

