/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDescriptionProviderUtil;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DefaultOperationDescriptionProvider
implements DescriptionProvider {
    private final String operationName;
    private final ResourceDescriptionResolver descriptionResolver;
    private final ResourceDescriptionResolver attributeDescriptionResolver;
    private final ModelType replyType;
    private final ModelType replyValueType;
    private final boolean replyAllowNull;
    private final DeprecationData deprecationData;
    private final AttributeDefinition[] replyParameters;
    private final AttributeDefinition[] parameters;
    final List<AccessConstraintDefinition> accessConstraints;

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, (ModelType)null, (ModelType)null, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, DeprecationData deprecationData, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, descriptionResolver, null, null, deprecationData, null, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ModelType replyType, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, replyType, (ModelType)null, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ModelType replyType, ModelType replyValueType, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, replyType, replyValueType, (DeprecationData)null, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ModelType replyType, ModelType replyValueType, DeprecationData deprecationData, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, descriptionResolver, replyType, replyValueType, deprecationData, null, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ResourceDescriptionResolver attributeDescriptionResolver, ModelType replyType, ModelType replyValueType, DeprecationData deprecationData, AttributeDefinition[] replyParameters, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, attributeDescriptionResolver, replyType, replyValueType, false, deprecationData, replyParameters, parameters);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ResourceDescriptionResolver attributeDescriptionResolver, ModelType replyType, ModelType replyValueType, boolean replyAllowNull, DeprecationData deprecationData, AttributeDefinition[] replyParameters, AttributeDefinition ... parameters) {
        this(operationName, descriptionResolver, attributeDescriptionResolver, replyType, replyValueType, replyAllowNull, deprecationData, replyParameters, parameters, (List<AccessConstraintDefinition>)null);
    }

    public DefaultOperationDescriptionProvider(String operationName, ResourceDescriptionResolver descriptionResolver, ResourceDescriptionResolver attributeDescriptionResolver, ModelType replyType, ModelType replyValueType, boolean replyAllowNull, DeprecationData deprecationData, AttributeDefinition[] replyParameters, AttributeDefinition[] parameters, List<AccessConstraintDefinition> accessConstraints) {
        this.operationName = operationName;
        this.descriptionResolver = descriptionResolver;
        this.attributeDescriptionResolver = attributeDescriptionResolver;
        this.replyType = replyType;
        this.replyValueType = replyValueType;
        this.replyAllowNull = replyAllowNull;
        this.parameters = parameters;
        this.deprecationData = deprecationData;
        this.replyParameters = replyParameters;
        this.accessConstraints = accessConstraints != null ? accessConstraints : Collections.emptyList();
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        String replyDesc;
        ModelNode result = new ModelNode();
        ResourceBundle bundle = this.descriptionResolver.getResourceBundle(locale);
        ResourceBundle attributeBundle = this.attributeDescriptionResolver.getResourceBundle(locale);
        result.get("operation-name").set(this.operationName);
        result.get("description").set(this.descriptionResolver.getOperationDescription(this.operationName, locale, bundle));
        result.get("request-properties").setEmptyObject();
        if (this.parameters != null) {
            for (AttributeDefinition definition : this.parameters) {
                definition.addOperationParameterDescription(result, this.operationName, this.attributeDescriptionResolver, locale, attributeBundle);
            }
        }
        ModelNode reply = result.get("reply-properties").setEmptyObject();
        if (this.replyType != null && this.replyType != ModelType.UNDEFINED) {
            reply.get("type").set(this.replyType);
            if (this.replyType == ModelType.LIST || this.replyType == ModelType.OBJECT) {
                if (this.replyValueType != null && this.replyValueType != ModelType.OBJECT) {
                    reply.get("value-type").set(this.replyValueType);
                } else if (this.replyValueType != null) {
                    reply.get("value-type").set(this.getReplyValueTypeDescription(this.descriptionResolver, locale, bundle));
                }
            }
        }
        if (this.replyParameters != null && this.replyParameters.length > 0) {
            if (this.replyParameters.length == 1) {
                AttributeDefinition ad = this.replyParameters[0];
                ModelNode param = new ModelNode();
                ad.addOperationParameterDescription(param, this.operationName, this.attributeDescriptionResolver, locale, attributeBundle);
                reply.set(param.get("request-properties").get(ad.getName()));
            } else {
                reply.get("type").set(this.replyType == null ? ModelType.OBJECT : this.replyType);
                for (AttributeDefinition ad : this.replyParameters) {
                    ModelNode param = ad.addOperationParameterDescription(new ModelNode(), this.operationName, this.attributeDescriptionResolver, locale, bundle);
                    reply.get(new String[]{"value-type", ad.getName()}).set(param);
                }
            }
        }
        if (!reply.asList().isEmpty() && (replyDesc = this.descriptionResolver.getOperationReplyDescription(this.operationName, locale, bundle)) != null) {
            reply.get("description").set(replyDesc);
        }
        if (this.replyAllowNull) {
            reply.get("nillable").set(true);
        }
        if (this.deprecationData != null) {
            ModelNode deprecated = result.get("deprecated");
            deprecated.get("since").set(this.deprecationData.getSince().toString());
            deprecated.get("reason").set(this.descriptionResolver.getOperationDeprecatedDescription(this.operationName, locale, bundle));
        }
        if (this.isAddAccessConstraints()) {
            AccessConstraintDescriptionProviderUtil.addAccessConstraints(result, this.accessConstraints, locale);
        }
        return result;
    }

    protected boolean isAddAccessConstraints() {
        return true;
    }

    protected ModelNode getReplyValueTypeDescription(ResourceDescriptionResolver descriptionResolver, Locale locale, ResourceBundle bundle) {
        return new ModelNode(ModelType.OBJECT);
    }
}

