/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class PersistentResourceXMLDescription {
    protected final PersistentResourceDefinition resourceDefinition;
    protected final String xmlElementName;
    protected final String xmlWrapperElement;
    protected final LinkedHashMap<String, AttributeDefinition> attributes;
    protected final LinkedHashMap<String, LinkedHashMap<String, AttributeDefinition>> attributesByGroup;
    protected final List<PersistentResourceXMLDescription> children;
    protected final boolean useValueAsElementName;
    protected final boolean noAddOperation;
    protected final AdditionalOperationsGenerator additionalOperationsGenerator;
    private boolean flushRequired = true;
    private final Map<String, AttributeParser> attributeParsers;
    private final boolean useElementsForGroups;
    private final String namespaceURI;

    @Deprecated
    protected PersistentResourceXMLDescription(PersistentResourceDefinition resourceDefinition, String xmlElementName, String xmlWrapperElement, LinkedHashMap<String, AttributeDefinition> attributes, List<PersistentResourceXMLDescription> children, boolean useValueAsElementName, boolean noAddOperation, AdditionalOperationsGenerator additionalOperationsGenerator, Map<String, AttributeParser> attributeParsers) {
        this.resourceDefinition = resourceDefinition;
        this.xmlElementName = xmlElementName;
        this.xmlWrapperElement = xmlWrapperElement;
        this.useElementsForGroups = true;
        this.attributes = attributes;
        this.attributesByGroup = new LinkedHashMap();
        this.attributesByGroup.put(null, attributes);
        this.children = children;
        this.useValueAsElementName = useValueAsElementName;
        this.noAddOperation = noAddOperation;
        this.additionalOperationsGenerator = additionalOperationsGenerator;
        this.attributeParsers = attributeParsers;
        this.namespaceURI = null;
    }

    private PersistentResourceXMLDescription(PersistentResourceXMLBuilder builder) {
        this.resourceDefinition = builder.resourceDefinition;
        this.xmlElementName = builder.xmlElementName;
        this.xmlWrapperElement = builder.xmlWrapperElement;
        this.attributes = builder.attributes;
        this.useElementsForGroups = builder.useElementsForGroups;
        this.attributesByGroup = new LinkedHashMap();
        this.namespaceURI = builder.namespaceURI;
        if (this.useElementsForGroups) {
            this.attributesByGroup.put(null, new LinkedHashMap());
            for (Map.Entry entry : builder.attributes.entrySet()) {
                AttributeDefinition ad = (AttributeDefinition)entry.getValue();
                LinkedHashMap<String, AttributeDefinition> forGroup = this.attributesByGroup.get(ad.getAttributeGroup());
                if (forGroup == null) {
                    forGroup = new LinkedHashMap();
                    this.attributesByGroup.put(ad.getAttributeGroup(), forGroup);
                }
                forGroup.put((String)entry.getKey(), ad);
            }
        } else {
            this.attributesByGroup.put(null, builder.attributes);
        }
        this.children = new ArrayList<PersistentResourceXMLDescription>();
        for (PersistentResourceXMLBuilder persistentResourceXMLBuilder : builder.children) {
            this.children.add(persistentResourceXMLBuilder.build());
        }
        this.useValueAsElementName = builder.useValueAsElementName;
        this.noAddOperation = builder.noAddOperation;
        this.additionalOperationsGenerator = builder.additionalOperationsGenerator;
        this.attributeParsers = builder.attributeParsers;
    }

    public PathElement getPathElement() {
        return this.resourceDefinition.getPathElement();
    }

    public void parse(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        if (this.xmlWrapperElement != null) {
            if (reader.getLocalName().equals(this.xmlWrapperElement)) {
                if (reader.hasNext() && reader.nextTag() == 2) {
                    return;
                }
            } else {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
        ModelNode op = Util.createAddOperation();
        boolean wildcard = this.resourceDefinition.getPathElement().isWildcard();
        String name = this.parseAttributes(reader, op, (Map<String, AttributeDefinition>)this.attributesByGroup.get(null), wildcard);
        if (wildcard && name == null) {
            throw ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(new StringBuilder("name"), reader.getLocation());
        }
        PathElement path = wildcard ? PathElement.pathElement(this.resourceDefinition.getPathElement().getKey(), name) : this.resourceDefinition.getPathElement();
        PathAddress address = parentAddress.append(path);
        if (!this.noAddOperation) {
            op.get("address").set(address.toModelNode());
            list.add(op);
        }
        if (this.additionalOperationsGenerator != null) {
            this.additionalOperationsGenerator.additionalOperations(address, op, list);
        }
        this.parseChildren(reader, address, list, op);
        if (this.xmlWrapperElement != null) {
            ParseUtils.requireNoContent(reader);
        }
    }

    private String parseAttributes(XMLExtendedStreamReader reader, ModelNode op, Map<String, AttributeDefinition> attributes, boolean wildcard) throws XMLStreamException {
        String name = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (wildcard && "name".equals(attributeName)) {
                name = value;
                continue;
            }
            if (attributes.containsKey(attributeName)) {
                AttributeParser parser;
                AttributeDefinition def = attributes.get(attributeName);
                AttributeParser attributeParser = parser = this.attributeParsers.containsKey(attributeName) ? this.attributeParsers.get(attributeName) : def.getParser();
                assert (parser != null);
                parser.parseAndSetParameter(def, value, op, (XMLStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedAttribute(reader, i, attributes.keySet());
        }
        for (AttributeDefinition attributeDefinition : attributes.values()) {
            if (!(attributeDefinition instanceof PropertiesAttributeDefinition)) continue;
            PropertiesAttributeDefinition attribute = (PropertiesAttributeDefinition)attributeDefinition;
            attribute.parse(reader, op);
            this.flushRequired = false;
        }
        return name;
    }

    private Map<String, PersistentResourceXMLDescription> getChildrenMap() {
        HashMap<String, PersistentResourceXMLDescription> res = new HashMap<String, PersistentResourceXMLDescription>();
        for (PersistentResourceXMLDescription child : this.children) {
            if (child.xmlWrapperElement != null) {
                res.put(child.xmlWrapperElement, child);
                continue;
            }
            res.put(child.xmlElementName, child);
        }
        return res;
    }

    private void parseChildren(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list, ModelNode parentAddOp) throws XMLStreamException {
        if (!(this.children.size() != 0 || this.useElementsForGroups && this.attributesByGroup.size() != 1)) {
            if (this.flushRequired) {
                ParseUtils.requireNoContent(reader);
            }
        } else {
            Map<String, PersistentResourceXMLDescription> children = this.getChildrenMap();
            while (reader.hasNext() && reader.nextTag() != 2) {
                LinkedHashMap<String, AttributeDefinition> groupAttributes;
                PersistentResourceXMLDescription child = children.get(reader.getLocalName());
                if (child != null) {
                    child.parse(reader, parentAddress, list);
                    continue;
                }
                LinkedHashMap<String, AttributeDefinition> linkedHashMap = groupAttributes = this.useElementsForGroups ? this.attributesByGroup.get(reader.getLocalName()) : null;
                if (groupAttributes != null) {
                    this.parseAttributes(reader, parentAddOp, groupAttributes, false);
                    continue;
                }
                throw ParseUtils.unexpectedElement(reader, children.keySet());
            }
        }
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        this.persist(writer, model, this.namespaceURI);
    }

    private void writeStartElement(XMLExtendedStreamWriter writer, String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI != null) {
            writer.writeStartElement(namespaceURI, localName);
        } else {
            writer.writeStartElement(localName);
        }
    }

    public void startSubsystemElement(XMLExtendedStreamWriter writer, String namespaceURI, boolean empty) throws XMLStreamException {
        if (writer.getNamespaceContext().getPrefix(namespaceURI) == null) {
            writer.setDefaultNamespace(namespaceURI);
            if (empty) {
                writer.writeEmptyElement(Element.SUBSYSTEM.getLocalName());
            } else {
                writer.writeStartElement(Element.SUBSYSTEM.getLocalName());
            }
            writer.writeNamespace(null, namespaceURI);
        } else if (empty) {
            writer.writeEmptyElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        } else {
            writer.writeStartElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        }
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model, String namespaceURI) throws XMLStreamException {
        boolean writeWrapper;
        boolean wildcard = this.resourceDefinition.getPathElement().isWildcard();
        model = wildcard ? model.get(this.resourceDefinition.getPathElement().getKey()) : model.get(this.resourceDefinition.getPathElement().getKeyValuePair());
        boolean isSubsystem = this.resourceDefinition.getPathElement().getKey().equals("subsystem");
        if (!(isSubsystem || model.isDefined() || this.useValueAsElementName)) {
            return;
        }
        boolean bl = writeWrapper = this.xmlWrapperElement != null;
        if (writeWrapper) {
            this.writeStartElement(writer, namespaceURI, this.xmlWrapperElement);
        }
        if (wildcard) {
            for (Property p : model.asPropertyList()) {
                if (this.useValueAsElementName) {
                    this.writeStartElement(writer, namespaceURI, p.getName());
                } else {
                    this.writeStartElement(writer, namespaceURI, this.xmlElementName);
                    writer.writeAttribute("name", p.getName());
                }
                this.persistAttributes(writer, p.getValue(), false);
                this.persistChildren(writer, p.getValue());
                writer.writeEndElement();
            }
        } else {
            if (this.useValueAsElementName) {
                this.writeStartElement(writer, namespaceURI, this.resourceDefinition.getPathElement().getValue());
            } else if (isSubsystem) {
                this.startSubsystemElement(writer, namespaceURI, this.children.isEmpty());
            } else {
                this.writeStartElement(writer, namespaceURI, this.xmlElementName);
            }
            this.persistAttributes(writer, model, true);
            this.persistChildren(writer, model);
            if (!isSubsystem || !this.children.isEmpty()) {
                writer.writeEndElement();
            }
        }
        if (writeWrapper) {
            writer.writeEndElement();
        }
    }

    private void persistAttributes(XMLExtendedStreamWriter writer, ModelNode model, boolean marshalDefault) throws XMLStreamException {
        for (Map.Entry<String, AttributeDefinition> entry : this.attributesByGroup.get(null).entrySet()) {
            entry.getValue().getAttributeMarshaller().marshallAsAttribute(entry.getValue(), model, marshalDefault, (XMLStreamWriter)writer);
        }
        if (this.useElementsForGroups) {
            for (Map.Entry<String, Object> entry : this.attributesByGroup.entrySet()) {
                if (entry.getKey() == null) continue;
                boolean started = false;
                for (Map.Entry def : ((LinkedHashMap)entry.getValue()).entrySet()) {
                    AttributeDefinition ad = (AttributeDefinition)def.getValue();
                    AttributeMarshaller marshaller = ad.getAttributeMarshaller();
                    if (!marshaller.isMarshallable(ad, model, marshalDefault)) continue;
                    if (!started) {
                        writer.writeEmptyElement(entry.getKey());
                        started = true;
                    }
                    marshaller.marshallAsAttribute(ad, model, marshalDefault, (XMLStreamWriter)writer);
                }
            }
        }
    }

    public void persistChildren(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        for (PersistentResourceXMLDescription child : this.children) {
            child.persist(writer, model);
        }
    }

    public static PersistentResourceXMLBuilder builder(PersistentResourceDefinition resource) {
        return new PersistentResourceXMLBuilder(resource);
    }

    public static PersistentResourceXMLBuilder builder(PersistentResourceDefinition resource, String namespaceURI) {
        return new PersistentResourceXMLBuilder(resource, namespaceURI);
    }

    public static interface AdditionalOperationsGenerator {
        public void additionalOperations(PathAddress var1, ModelNode var2, List<ModelNode> var3);
    }

    public static class PersistentResourceXMLBuilder {
        protected final PersistentResourceDefinition resourceDefinition;
        private final String namespaceURI;
        protected String xmlElementName;
        protected String xmlWrapperElement;
        protected boolean useValueAsElementName;
        protected boolean noAddOperation;
        protected AdditionalOperationsGenerator additionalOperationsGenerator;
        protected final LinkedHashMap<String, AttributeDefinition> attributes = new LinkedHashMap();
        protected final List<PersistentResourceXMLBuilder> children = new ArrayList<PersistentResourceXMLBuilder>();
        protected final LinkedHashMap<String, AttributeParser> attributeParsers = new LinkedHashMap();
        protected boolean useElementsForGroups = true;

        protected PersistentResourceXMLBuilder(PersistentResourceDefinition resourceDefinition) {
            this.resourceDefinition = resourceDefinition;
            this.namespaceURI = null;
            this.xmlElementName = resourceDefinition.getPathElement().isWildcard() ? resourceDefinition.getPathElement().getKey() : resourceDefinition.getPathElement().getValue();
        }

        protected PersistentResourceXMLBuilder(PersistentResourceDefinition resourceDefinition, String namespaceURI) {
            this.resourceDefinition = resourceDefinition;
            this.namespaceURI = namespaceURI;
            this.xmlElementName = resourceDefinition.getPathElement().isWildcard() ? resourceDefinition.getPathElement().getKey() : resourceDefinition.getPathElement().getValue();
        }

        public PersistentResourceXMLBuilder addChild(PersistentResourceXMLBuilder builder) {
            this.children.add(builder);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute) {
            this.attributes.put(attribute.getXmlName(), attribute);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser) {
            this.attributes.put(attribute.getXmlName(), attribute);
            this.attributeParsers.put(attribute.getXmlName(), attributeParser);
            return this;
        }

        public PersistentResourceXMLBuilder addAttributes(AttributeDefinition ... attributes) {
            for (AttributeDefinition at : attributes) {
                this.attributes.put(at.getXmlName(), at);
            }
            return this;
        }

        public PersistentResourceXMLBuilder setXmlWrapperElement(String xmlWrapperElement) {
            this.xmlWrapperElement = xmlWrapperElement;
            return this;
        }

        public PersistentResourceXMLBuilder setXmlElementName(String xmlElementName) {
            this.xmlElementName = xmlElementName;
            return this;
        }

        public PersistentResourceXMLBuilder setUseValueAsElementName(boolean useValueAsElementName) {
            this.useValueAsElementName = useValueAsElementName;
            return this;
        }

        public PersistentResourceXMLBuilder setNoAddOperation(boolean noAddOperation) {
            this.noAddOperation = noAddOperation;
            return this;
        }

        public PersistentResourceXMLBuilder setAdditionalOperationsGenerator(AdditionalOperationsGenerator additionalOperationsGenerator) {
            this.additionalOperationsGenerator = additionalOperationsGenerator;
            return this;
        }

        public PersistentResourceXMLBuilder setUseElementsForGroups(boolean useElementsForGroups) {
            this.useElementsForGroups = useElementsForGroups;
            return this;
        }

        public PersistentResourceXMLDescription build() {
            return new PersistentResourceXMLDescription(this);
        }
    }
}

