/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.extension.ExtensionContextSupplement;
import org.jboss.as.controller.extension.SubsystemInformation;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.persistence.SubsystemXmlWriterRegistry;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.transform.CombinedTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLMapper;

public class ExtensionRegistry {
    private static final Set<String> legallySupplemented;
    private final ProcessType processType;
    private SubsystemXmlWriterRegistry writerRegistry;
    private volatile PathManager pathManager;
    private final ConcurrentMap<String, ExtensionInfo> extensions = new ConcurrentHashMap<String, ExtensionInfo>();
    private final ConcurrentMap<String, String> reverseMap = new ConcurrentHashMap<String, String>();
    private final RunningModeControl runningModeControl;
    private final ManagedAuditLogger auditLogger;
    private final JmxAuthorizer authorizer;
    private final ConcurrentHashMap<String, SubsystemInformation> subsystemsInfo = new ConcurrentHashMap();
    private volatile TransformerRegistry transformerRegistry = TransformerRegistry.Factory.create();
    private static final JmxAuthorizer NO_OP_AUTHORIZER;

    public ExtensionRegistry(ProcessType processType, RunningModeControl runningModeControl, ManagedAuditLogger auditLogger, JmxAuthorizer authorizer) {
        this.processType = processType;
        this.runningModeControl = runningModeControl;
        this.auditLogger = auditLogger != null ? auditLogger : AuditLogger.NO_OP_LOGGER;
        this.authorizer = authorizer != null ? authorizer : NO_OP_AUTHORIZER;
    }

    @Deprecated
    public ExtensionRegistry(ProcessType processType, RunningModeControl runningModeControl) {
        this(processType, runningModeControl, null, null);
    }

    public void setWriterRegistry(SubsystemXmlWriterRegistry writerRegistry) {
        this.writerRegistry = writerRegistry;
    }

    public void setPathManager(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    public SubsystemInformation getSubsystemInfo(String name) {
        return this.subsystemsInfo.get(name);
    }

    public Set<String> getExtensionModuleNames() {
        return Collections.unmodifiableSet(this.extensions.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SubsystemInformation> getAvailableSubsystems(String moduleName) {
        Map result = null;
        ExtensionInfo info = (ExtensionInfo)this.extensions.get(moduleName);
        if (info != null) {
            ExtensionInfo extensionInfo = info;
            synchronized (extensionInfo) {
                result = Collections.unmodifiableMap(new HashMap(info.subsystems));
            }
        }
        return result;
    }

    public ExtensionParsingContext getExtensionParsingContext(String moduleName, XMLMapper xmlMapper) {
        return new ExtensionParsingContextImpl(moduleName, xmlMapper);
    }

    public ExtensionContext getExtensionContext(String moduleName, ManagementResourceRegistration rootRegistration, boolean isMasterDomainController) {
        ManagementResourceRegistration profileRegistration = rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("profile")));
        if (profileRegistration == null) {
            profileRegistration = rootRegistration;
        }
        ManagementResourceRegistration deploymentsRegistration = this.processType.isServer() ? rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("deployment"))) : null;
        boolean allowSupplement = legallySupplemented.contains(moduleName);
        ManagedAuditLogger al = allowSupplement ? this.auditLogger : null;
        return new ExtensionContextImpl(moduleName, profileRegistration, deploymentsRegistration, this.pathManager, isMasterDomainController, al);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ProfileParsingCompletionHandler> getProfileParsingCompletionHandlers() {
        HashSet<ProfileParsingCompletionHandler> result = new HashSet<ProfileParsingCompletionHandler>();
        Iterator i$ = this.extensions.values().iterator();
        while (i$.hasNext()) {
            ExtensionInfo extensionInfo;
            ExtensionInfo extensionInfo2 = extensionInfo = (ExtensionInfo)i$.next();
            synchronized (extensionInfo2) {
                if (extensionInfo.parsingCompletionHandler != null) {
                    result.add(extensionInfo.parsingCompletionHandler);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtension(Resource rootResource, String moduleName, ManagementResourceRegistration rootRegistration) throws IllegalStateException {
        ManagementResourceRegistration profileReg = rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("profile")));
        if (profileReg == null) {
            profileReg = rootRegistration;
        }
        ManagementResourceRegistration deploymentsReg = this.processType.isServer() ? rootRegistration.getSubModel(PathAddress.pathAddress(PathElement.pathElement("deployment"))) : null;
        ExtensionInfo extension = (ExtensionInfo)this.extensions.remove(moduleName);
        if (extension != null) {
            ExtensionInfo extensionInfo = extension;
            synchronized (extensionInfo) {
                Set subsystemNames = extension.subsystems.keySet();
                for (String string : subsystemNames) {
                    if (rootResource.getChild(PathElement.pathElement("subsystem", string)) == null) continue;
                    this.extensions.put(moduleName, extension);
                    throw ControllerLogger.ROOT_LOGGER.removingExtensionWithRegisteredSubsystem(moduleName, string);
                }
                for (Map.Entry entry : extension.subsystems.entrySet()) {
                    String subsystem = (String)entry.getKey();
                    profileReg.unregisterSubModel(PathElement.pathElement("subsystem", subsystem));
                    if (deploymentsReg != null) {
                        deploymentsReg.unregisterSubModel(PathElement.pathElement("subsystem", subsystem));
                    }
                    if (extension.xmlMapper == null) continue;
                    SubsystemInformationImpl subsystemInformation = (SubsystemInformationImpl)SubsystemInformationImpl.class.cast(entry.getValue());
                    for (String namespace : subsystemInformation.getXMLNamespaces()) {
                        extension.xmlMapper.unregisterRootElement(new QName(namespace, "subsystem"));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ConcurrentMap<String, ExtensionInfo> concurrentMap = this.extensions;
        synchronized (concurrentMap) {
            this.transformerRegistry = TransformerRegistry.Factory.create();
            this.extensions.clear();
            this.reverseMap.clear();
        }
    }

    public void recordSubsystemVersions(String moduleName, ModelNode subsystems) {
        Map<String, SubsystemInformation> subsystemsInfo = this.getAvailableSubsystems(moduleName);
        if (subsystemsInfo != null && !subsystemsInfo.isEmpty()) {
            for (Map.Entry<String, SubsystemInformation> entry : subsystemsInfo.entrySet()) {
                SubsystemInformation subsystem = entry.getValue();
                subsystems.add(entry.getKey(), subsystem.getManagementInterfaceMajorVersion() + "." + subsystem.getManagementInterfaceMinorVersion() + "." + subsystem.getManagementInterfaceMicroVersion());
            }
        }
    }

    private ExtensionInfo getExtensionInfo(String extensionModuleName) {
        ExtensionInfo result = (ExtensionInfo)this.extensions.get(extensionModuleName);
        if (result == null) {
            result = new ExtensionInfo(extensionModuleName);
            ExtensionInfo existing = this.extensions.putIfAbsent(extensionModuleName, result);
            result = existing == null ? result : existing;
        }
        return result;
    }

    private void checkNewSubystem(String extensionModuleName, String subsystemName) {
        String existingModule = this.reverseMap.putIfAbsent(subsystemName, extensionModuleName);
        if (existingModule != null && !extensionModuleName.equals(existingModule)) {
            throw ControllerLogger.ROOT_LOGGER.duplicateSubsystem(subsystemName, extensionModuleName, existingModule);
        }
    }

    public TransformerRegistry getTransformerRegistry() {
        return this.transformerRegistry;
    }

    static {
        HashSet<String> set = new HashSet<String>(4);
        set.add("org.jboss.as.jmx");
        set.add("Test");
        legallySupplemented = Collections.unmodifiableSet(set);
        NO_OP_AUTHORIZER = new JmxAuthorizer(){

            @Override
            public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetResource target) {
                return AuthorizationResult.PERMITTED;
            }

            @Override
            public Authorizer.AuthorizerDescription getDescription() {
                return new Authorizer.AuthorizerDescription(){

                    @Override
                    public boolean isRoleBased() {
                        return false;
                    }

                    @Override
                    public Set<String> getStandardRoles() {
                        return Collections.emptySet();
                    }
                };
            }

            @Override
            public AuthorizationResult authorize(Caller caller, Environment callEnvironment, Action action, TargetAttribute target) {
                return AuthorizationResult.PERMITTED;
            }

            @Override
            public AuthorizationResult authorizeJmxOperation(Caller caller, Environment callEnvironment, JmxAction action) {
                return AuthorizationResult.PERMITTED;
            }

            @Override
            public Set<String> getCallerRoles(Caller caller, Environment callEnvironment, Set<String> runAsRoles) {
                return null;
            }

            @Override
            public void setNonFacadeMBeansSensitive(boolean sensitive) {
            }
        };
    }

    private static class DeploymentManagementResourceRegistration
    implements ManagementResourceRegistration {
        private final ManagementResourceRegistration deployments;
        private final ManagementResourceRegistration subdeployments;

        private DeploymentManagementResourceRegistration(ManagementResourceRegistration deployments, ManagementResourceRegistration subdeployments) {
            this.deployments = deployments;
            this.subdeployments = subdeployments;
        }

        @Override
        public PathAddress getPathAddress() {
            return this.deployments.getPathAddress();
        }

        @Override
        public boolean isRuntimeOnly() {
            return this.deployments.isRuntimeOnly();
        }

        @Override
        public void setRuntimeOnly(boolean runtimeOnly) {
            this.deployments.setRuntimeOnly(runtimeOnly);
            this.subdeployments.setRuntimeOnly(runtimeOnly);
        }

        @Override
        public boolean isRemote() {
            return this.deployments.isRemote();
        }

        @Override
        public OperationStepHandler getOperationHandler(PathAddress address, String operationName) {
            return this.deployments.getOperationHandler(address, operationName);
        }

        @Override
        public DescriptionProvider getOperationDescription(PathAddress address, String operationName) {
            return this.deployments.getOperationDescription(address, operationName);
        }

        @Override
        public Set<OperationEntry.Flag> getOperationFlags(PathAddress address, String operationName) {
            return this.deployments.getOperationFlags(address, operationName);
        }

        @Override
        public OperationEntry getOperationEntry(PathAddress address, String operationName) {
            return this.deployments.getOperationEntry(address, operationName);
        }

        @Override
        public Set<String> getAttributeNames(PathAddress address) {
            return this.deployments.getAttributeNames(address);
        }

        @Override
        public AttributeAccess getAttributeAccess(PathAddress address, String attributeName) {
            return this.deployments.getAttributeAccess(address, attributeName);
        }

        @Override
        public Map<String, NotificationEntry> getNotificationDescriptions(PathAddress address, boolean inherited) {
            return this.deployments.getNotificationDescriptions(address, inherited);
        }

        @Override
        public Set<String> getChildNames(PathAddress address) {
            return this.deployments.getChildNames(address);
        }

        @Override
        public Set<PathElement> getChildAddresses(PathAddress address) {
            return this.deployments.getChildAddresses(address);
        }

        @Override
        public DescriptionProvider getModelDescription(PathAddress address) {
            return this.deployments.getModelDescription(address);
        }

        @Override
        public Map<String, OperationEntry> getOperationDescriptions(PathAddress address, boolean inherited) {
            return this.deployments.getOperationDescriptions(address, inherited);
        }

        @Override
        public ProxyController getProxyController(PathAddress address) {
            return this.deployments.getProxyController(address);
        }

        @Override
        public Set<ProxyController> getProxyControllers(PathAddress address) {
            return this.deployments.getProxyControllers(address);
        }

        @Override
        public ManagementResourceRegistration getOverrideModel(String name) {
            return this.deployments.getOverrideModel(name);
        }

        @Override
        public ManagementResourceRegistration getSubModel(PathAddress address) {
            return this.deployments.getSubModel(address);
        }

        @Override
        public List<AccessConstraintDefinition> getAccessConstraints() {
            return this.deployments.getAccessConstraints();
        }

        @Override
        public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
            ManagementResourceRegistration depl = this.deployments.registerSubModel(address, descriptionProvider);
            ManagementResourceRegistration subdepl = this.subdeployments.registerSubModel(address, descriptionProvider);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public ManagementResourceRegistration registerSubModel(ResourceDefinition resourceDefinition) {
            ManagementResourceRegistration depl = this.deployments.registerSubModel(resourceDefinition);
            ManagementResourceRegistration subdepl = this.subdeployments.registerSubModel(resourceDefinition);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public void unregisterSubModel(PathElement address) {
            this.deployments.unregisterSubModel(address);
            this.subdeployments.unregisterSubModel(address);
        }

        @Override
        public boolean isAllowsOverride() {
            return this.deployments.isAllowsOverride();
        }

        @Override
        public ManagementResourceRegistration registerOverrideModel(String name, OverrideDescriptionProvider descriptionProvider) {
            ManagementResourceRegistration depl = this.deployments.registerOverrideModel(name, descriptionProvider);
            ManagementResourceRegistration subdepl = this.subdeployments.registerOverrideModel(name, descriptionProvider);
            return new DeploymentManagementResourceRegistration(depl, subdepl);
        }

        @Override
        public void unregisterOverrideModel(String name) {
            this.deployments.unregisterOverrideModel(name);
            this.subdeployments.unregisterOverrideModel(name);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, flags);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, entryType, flags);
        }

        @Override
        public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, EnumSet<OperationEntry.Flag> flags) {
            this.deployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, flags);
            this.subdeployments.registerOperationHandler(operationName, handler, descriptionProvider, inherited, flags);
        }

        @Override
        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler) {
            this.registerOperationHandler(definition, handler, false);
        }

        @Override
        public void registerOperationHandler(OperationDefinition definition, OperationStepHandler handler, boolean inherited) {
            this.deployments.registerOperationHandler(definition, handler, inherited);
            this.subdeployments.registerOperationHandler(definition, handler, inherited);
        }

        @Override
        public void unregisterOperationHandler(String operationName) {
            this.deployments.unregisterOperationHandler(operationName);
            this.subdeployments.unregisterOperationHandler(operationName);
        }

        @Override
        public void registerReadWriteAttribute(AttributeDefinition definition, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
            this.deployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
            this.subdeployments.registerReadWriteAttribute(definition, readHandler, writeHandler);
        }

        @Override
        public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
            this.deployments.registerReadOnlyAttribute(attributeName, readHandler, storage);
            this.subdeployments.registerReadOnlyAttribute(attributeName, readHandler, storage);
        }

        @Override
        public void registerReadOnlyAttribute(AttributeDefinition definition, OperationStepHandler readHandler) {
            this.deployments.registerReadOnlyAttribute(definition, readHandler);
            this.subdeployments.registerReadOnlyAttribute(definition, readHandler);
        }

        @Override
        public void registerMetric(AttributeDefinition definition, OperationStepHandler metricHandler) {
            this.deployments.registerMetric(definition, metricHandler);
            this.subdeployments.registerMetric(definition, metricHandler);
        }

        @Override
        public void unregisterAttribute(String attributeName) {
            this.deployments.unregisterAttribute(attributeName);
            this.subdeployments.unregisterAttribute(attributeName);
        }

        @Override
        public void registerNotification(NotificationDefinition notification, boolean inherited) {
            this.deployments.registerNotification(notification, inherited);
            this.subdeployments.registerNotification(notification, inherited);
        }

        @Override
        public void registerNotification(NotificationDefinition notification) {
            this.deployments.registerNotification(notification);
            this.subdeployments.registerNotification(notification);
        }

        @Override
        public void unregisterNotification(String notificationType) {
            this.deployments.unregisterNotification(notificationType);
            this.subdeployments.unregisterNotification(notificationType);
        }

        @Override
        public void registerProxyController(PathElement address, ProxyController proxyController) {
            this.deployments.registerProxyController(address, proxyController);
            this.subdeployments.registerProxyController(address, proxyController);
        }

        @Override
        public void unregisterProxyController(PathElement address) {
            this.deployments.unregisterProxyController(address);
            this.subdeployments.unregisterProxyController(address);
        }

        @Override
        public void registerAlias(PathElement address, AliasEntry alias) {
            this.deployments.registerAlias(address, alias);
            this.subdeployments.registerAlias(address, alias);
        }

        @Override
        public void unregisterAlias(PathElement address) {
            this.deployments.unregisterAlias(address);
            this.subdeployments.unregisterAlias(address);
        }

        @Override
        public AliasEntry getAliasEntry() {
            return this.deployments.getAliasEntry();
        }

        @Override
        public boolean isAlias() {
            return this.deployments.isAlias();
        }
    }

    private class ExtensionInfo {
        private final Map<String, SubsystemInformation> subsystems = new HashMap<String, SubsystemInformation>();
        private final String extensionModuleName;
        private XMLMapper xmlMapper;
        private ProfileParsingCompletionHandler parsingCompletionHandler;

        public ExtensionInfo(String extensionModuleName) {
            this.extensionModuleName = extensionModuleName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SubsystemInformationImpl getSubsystemInfo(String subsystemName) {
            ExtensionRegistry.this.checkNewSubystem(this.extensionModuleName, subsystemName);
            ExtensionInfo extensionInfo = this;
            synchronized (extensionInfo) {
                SubsystemInformationImpl subsystem = (SubsystemInformationImpl)SubsystemInformationImpl.class.cast(this.subsystems.get(subsystemName));
                if (subsystem == null) {
                    subsystem = new SubsystemInformationImpl();
                    this.subsystems.put(subsystemName, subsystem);
                }
                return subsystem;
            }
        }
    }

    private class SubsystemRegistrationImpl
    implements SubsystemRegistration {
        private final String name;
        private final ModelVersion version;
        private final ManagementResourceRegistration profileRegistration;
        private final ManagementResourceRegistration deploymentsRegistration;

        private SubsystemRegistrationImpl(String name, int major, int minor, int micro, ManagementResourceRegistration profileRegistration, ManagementResourceRegistration deploymentsRegistration) {
            assert (profileRegistration != null);
            this.name = name;
            this.profileRegistration = profileRegistration;
            this.deploymentsRegistration = deploymentsRegistration;
            this.version = ModelVersion.create(major, minor, micro);
        }

        @Override
        public ManagementResourceRegistration registerSubsystemModel(ResourceDefinition resourceDefinition) {
            assert (resourceDefinition != null) : "resourceDefinition is null";
            return this.profileRegistration.registerSubModel(resourceDefinition);
        }

        @Override
        public ManagementResourceRegistration registerDeploymentModel(ResourceDefinition resourceDefinition) {
            assert (resourceDefinition != null) : "resourceDefinition is null";
            ManagementResourceRegistration deploymentsReg = this.deploymentsRegistration;
            ManagementResourceRegistration base = deploymentsReg != null ? deploymentsReg : this.getDummyRegistration();
            return base.registerSubModel(resourceDefinition);
        }

        @Override
        public void registerXMLElementWriter(XMLElementWriter<SubsystemMarshallingContext> writer) {
            ExtensionRegistry.this.writerRegistry.registerSubsystemWriter(this.name, writer);
        }

        @Override
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange range, ResourceTransformer subsystemTransformer) {
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, range, subsystemTransformer);
        }

        @Override
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange version, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer, boolean placeholder) {
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, version, resourceTransformer, operationTransformer, placeholder);
        }

        @Override
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange version, ResourceTransformer resourceTransformer, OperationTransformer operationTransformer) {
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, version, resourceTransformer, operationTransformer, false);
        }

        @Override
        public TransformersSubRegistration registerModelTransformers(ModelVersionRange version, CombinedTransformer combinedTransformer) {
            return ExtensionRegistry.this.transformerRegistry.registerSubsystemTransformers(this.name, version, combinedTransformer, combinedTransformer, false);
        }

        private ManagementResourceRegistration getDummyRegistration() {
            return ManagementResourceRegistration.Factory.create(new DescriptionProvider(){

                @Override
                public ModelNode getModelDescription(Locale locale) {
                    return new ModelNode();
                }
            });
        }

        @Override
        public ModelVersion getSubsystemVersion() {
            return this.version;
        }
    }

    private class SubsystemInformationImpl
    implements SubsystemInformation {
        private Integer majorVersion;
        private Integer minorVersion;
        private Integer microVersion;
        private boolean deprecated = false;
        private final List<String> parsingNamespaces = new ArrayList<String>();

        private SubsystemInformationImpl() {
        }

        @Override
        public List<String> getXMLNamespaces() {
            return Collections.unmodifiableList(this.parsingNamespaces);
        }

        void addParsingNamespace(String namespace) {
            this.parsingNamespaces.add(namespace);
        }

        @Override
        public Integer getManagementInterfaceMajorVersion() {
            return this.majorVersion;
        }

        private void setMajorVersion(Integer majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public Integer getManagementInterfaceMinorVersion() {
            return this.minorVersion;
        }

        private void setMinorVersion(Integer minorVersion) {
            this.minorVersion = minorVersion;
        }

        @Override
        public Integer getManagementInterfaceMicroVersion() {
            return this.microVersion;
        }

        private void setMicroVersion(Integer microVersion) {
            this.microVersion = microVersion;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        private void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }
    }

    private class ExtensionContextImpl
    implements ExtensionContext,
    ExtensionContextSupplement {
        private final ExtensionInfo extension;
        private final PathManager pathManager;
        private final boolean registerTransformers;
        private final ManagedAuditLogger auditLogger;
        private final boolean allowSupplement;
        private final ManagementResourceRegistration profileRegistration;
        private final ManagementResourceRegistration deploymentsRegistration;

        private ExtensionContextImpl(String extensionName, ManagementResourceRegistration profileResourceRegistration, ManagementResourceRegistration deploymentsResourceRegistration, PathManager pathManager, boolean registerTransformers, ManagedAuditLogger auditLogger) {
            PathAddress subdepAddress;
            ManagementResourceRegistration subdeployments;
            assert (pathManager != null || !ExtensionRegistry.this.processType.isServer()) : "pathManager is null";
            this.pathManager = pathManager;
            this.extension = ExtensionRegistry.this.getExtensionInfo(extensionName);
            this.registerTransformers = registerTransformers;
            this.auditLogger = auditLogger;
            this.allowSupplement = auditLogger != null;
            this.profileRegistration = profileResourceRegistration;
            this.deploymentsRegistration = deploymentsResourceRegistration != null ? ((subdeployments = deploymentsResourceRegistration.getSubModel(subdepAddress = PathAddress.pathAddress(PathElement.pathElement("subdeployment")))) == null ? deploymentsResourceRegistration : new DeploymentManagementResourceRegistration(deploymentsResourceRegistration, subdeployments)) : null;
        }

        @Override
        public SubsystemRegistration registerSubsystem(String name, int majorVersion, int minorVersion) throws IllegalArgumentException, IllegalStateException {
            return this.registerSubsystem(name, majorVersion, minorVersion, 0);
        }

        @Override
        public SubsystemRegistration registerSubsystem(String name, int majorVersion, int minorVersion, int microVersion) {
            return this.registerSubsystem(name, majorVersion, minorVersion, microVersion, false);
        }

        @Override
        public SubsystemRegistration registerSubsystem(String name, int majorVersion, int minorVersion, int microVersion, boolean deprecated) {
            assert (name != null) : "name is null";
            ExtensionRegistry.this.checkNewSubystem(this.extension.extensionModuleName, name);
            SubsystemInformationImpl info = this.extension.getSubsystemInfo(name);
            info.setMajorVersion(majorVersion);
            info.setMinorVersion(minorVersion);
            info.setMicroVersion(microVersion);
            info.setDeprecated(deprecated);
            ExtensionRegistry.this.subsystemsInfo.put(name, info);
            if (deprecated) {
                ControllerLogger.DEPRECATED_LOGGER.extensionDeprecated(name);
            }
            return new SubsystemRegistrationImpl(name, majorVersion, minorVersion, microVersion, this.profileRegistration, this.deploymentsRegistration);
        }

        @Override
        public ProcessType getProcessType() {
            return ExtensionRegistry.this.processType;
        }

        @Override
        public RunningMode getRunningMode() {
            return ExtensionRegistry.this.runningModeControl.getRunningMode();
        }

        @Override
        public boolean isRuntimeOnlyRegistrationValid() {
            return ExtensionRegistry.this.processType.isServer() && ExtensionRegistry.this.runningModeControl.getRunningMode() != RunningMode.ADMIN_ONLY;
        }

        @Override
        public PathManager getPathManager() {
            if (!ExtensionRegistry.this.processType.isServer()) {
                throw ControllerLogger.ROOT_LOGGER.pathManagerNotAvailable(ExtensionRegistry.this.processType);
            }
            return this.pathManager;
        }

        @Override
        public boolean isRegisterTransformers() {
            return this.registerTransformers;
        }

        @Override
        public AuditLogger getAuditLogger(boolean inheritConfiguration, boolean manualCommit) {
            if (!this.allowSupplement) {
                throw new UnsupportedOperationException();
            }
            if (inheritConfiguration) {
                return this.auditLogger;
            }
            return this.auditLogger.createNewConfiguration(manualCommit);
        }

        @Override
        public JmxAuthorizer getAuthorizer() {
            if (!this.allowSupplement) {
                throw new UnsupportedOperationException();
            }
            return ExtensionRegistry.this.authorizer;
        }
    }

    private class ExtensionParsingContextImpl
    implements ExtensionParsingContext {
        private final ExtensionInfo extension;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExtensionParsingContextImpl(String extensionName, XMLMapper xmlMapper) {
            this.extension = ExtensionRegistry.this.getExtensionInfo(extensionName);
            if (xmlMapper != null) {
                ExtensionInfo extensionInfo = this.extension;
                synchronized (extensionInfo) {
                    this.extension.xmlMapper = xmlMapper;
                }
            }
        }

        @Override
        public ProcessType getProcessType() {
            return ExtensionRegistry.this.processType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSubsystemXmlMapping(String subsystemName, String namespaceUri, XMLElementReader<List<ModelNode>> reader) {
            assert (subsystemName != null) : "subsystemName is null";
            assert (namespaceUri != null) : "namespaceUri is null";
            ExtensionInfo extensionInfo = this.extension;
            synchronized (extensionInfo) {
                this.extension.getSubsystemInfo(subsystemName).addParsingNamespace(namespaceUri);
                if (this.extension.xmlMapper != null) {
                    this.extension.xmlMapper.registerRootElement(new QName(namespaceUri, "subsystem"), reader);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setProfileParsingCompletionHandler(ProfileParsingCompletionHandler handler) {
            assert (handler != null) : "handler is null";
            ExtensionInfo extensionInfo = this.extension;
            synchronized (extensionInfo) {
                this.extension.parsingCompletionHandler = handler;
            }
        }
    }
}

