/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.HostServerGroupTracker;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerLock;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReadOnlyContext;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.registry.CapabilityContext;
import org.jboss.as.controller.capability.registry.CapabilityId;
import org.jboss.as.controller.capability.registry.DelegatingRuntimeCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RegistrationPoint;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistration;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.capability.registry.RuntimeRequirementRegistration;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.extension.ParallelExtensionAddHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.NotificationSupport;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.core.security.AccessMechanism;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

class ModelControllerImpl
implements ModelController {
    private static final String INITIAL_BOOT_OPERATION = "initial-boot-operation";
    private static final String POST_EXTENSION_BOOT_OPERATION = "post-extension-boot-operation";
    static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;
    private final ModelControllerLock controllerLock = new ModelControllerLock();
    private final ContainerStateMonitor stateMonitor;
    private final AtomicReference<ManagementModelImpl> managementModel = new AtomicReference();
    private final ConfigurationPersister persister;
    private final ProcessType processType;
    private final RunningModeControl runningModeControl;
    private final AtomicBoolean bootingFlag = new AtomicBoolean(true);
    private final OperationStepHandler prepareStep;
    private final ControlledProcessState processState;
    private final ExecutorService executorService;
    private final ExpressionResolver expressionResolver;
    private final Authorizer authorizer;
    private final ConcurrentMap<Integer, OperationContextImpl> activeOperations = new ConcurrentHashMap<Integer, OperationContextImpl>();
    private final ManagedAuditLogger auditLogger;
    private final BootErrorCollector bootErrorCollector;
    private final NotificationSupport notificationSupport;
    private final HostServerGroupTracker hostServerGroupTracker;
    private final Resource.ResourceEntry modelControllerResource;

    ModelControllerImpl(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, ManagementResourceRegistration rootRegistration, ContainerStateMonitor stateMonitor, ConfigurationPersister persister, ProcessType processType, RunningModeControl runningModeControl, OperationStepHandler prepareStep, ControlledProcessState processState, ExecutorService executorService, ExpressionResolver expressionResolver, Authorizer authorizer, ManagedAuditLogger auditLogger, NotificationSupport notificationSupport, BootErrorCollector bootErrorCollector) {
        assert (serviceRegistry != null);
        this.serviceRegistry = serviceRegistry;
        assert (serviceTarget != null);
        this.serviceTarget = serviceTarget;
        assert (rootRegistration != null);
        ManagementModelImpl mmi = new ManagementModelImpl(rootRegistration, Resource.Factory.create(), new CapabilityRegistryImpl(processType.isServer()));
        mmi.publish();
        assert (stateMonitor != null);
        this.stateMonitor = stateMonitor;
        assert (persister != null);
        this.persister = persister;
        assert (processType != null);
        this.processType = processType;
        assert (runningModeControl != null);
        this.runningModeControl = runningModeControl;
        assert (notificationSupport != null);
        this.notificationSupport = notificationSupport;
        OperationStepHandler operationStepHandler = this.prepareStep = prepareStep == null ? new DefaultPrepareStepHandler() : prepareStep;
        assert (processState != null);
        this.processState = processState;
        this.serviceTarget.addListener((ServiceListener)stateMonitor);
        this.executorService = executorService;
        assert (expressionResolver != null);
        this.expressionResolver = expressionResolver;
        assert (authorizer != null);
        this.authorizer = authorizer;
        assert (auditLogger != null);
        this.auditLogger = auditLogger;
        assert (bootErrorCollector != null);
        this.bootErrorCollector = bootErrorCollector;
        this.hostServerGroupTracker = processType.isManagedDomain() ? new HostServerGroupTracker() : null;
        this.modelControllerResource = new ModelControllerResource();
        auditLogger.startBoot();
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments) {
        OperationResponse or = this.internalExecute(operation, handler, control, attachments, this.prepareStep, false);
        ModelNode result = or.getResponseNode();
        try {
            or.close();
        }
        catch (IOException e) {
            ControllerLogger.ROOT_LOGGER.debugf(e, "Caught exception closing response to %s whose associated streams, if any, were not wanted", operation);
        }
        return result;
    }

    @Override
    public OperationResponse execute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control) {
        return this.internalExecute(operation.getOperation(), handler, control, (OperationAttachments)operation, this.prepareStep, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, final ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, int operationId) {
        AbstractOperationContext delegateContext;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        if ((delegateContext = (AbstractOperationContext)this.activeOperations.get(operationId)) == null) {
            throw ControllerLogger.ROOT_LOGGER.noContextToDelegateTo(operationId);
        }
        final ModelNode response = new ModelNode();
        ModelController.OperationTransactionControl originalResultTxControl = control == null ? null : new ModelController.OperationTransactionControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                control.operationPrepared(transaction, response);
            }
        };
        ReadOnlyContext context = new ReadOnlyContext(this.processType, this.runningModeControl.getRunningMode(), originalResultTxControl, this.processState, false, delegateContext, this, operationId);
        context.addStep(response, operation, prepareStep, OperationContext.Stage.MODEL);
        CurrentOperationIdHolder.setCurrentOperationID(operationId);
        try {
            context.executeOperation();
        }
        finally {
            CurrentOperationIdHolder.setCurrentOperationID(null);
        }
        if (!response.hasDefined("response-headers") || !response.get("response-headers").hasDefined("process-state")) {
            ControlledProcessState.State state = this.processState.getState();
            switch (state) {
                case RELOAD_REQUIRED: 
                case RESTART_REQUIRED: {
                    response.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected OperationResponse internalExecute(ModelNode operation, OperationMessageHandler handler, final ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep, boolean attemptLock) {
        block27: {
            sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ModelController.ACCESS_PERMISSION);
            }
            headers = operation.has("operation-headers") != false ? operation.get("operation-headers") : null;
            rollbackOnFailure = headers == null || headers.hasDefined("rollback-on-runtime-failure") == false || headers.get("rollback-on-runtime-failure").asBoolean() != false;
            contextFlags = rollbackOnFailure != false ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
            v0 = restartResourceServices = headers != null && headers.hasDefined("allow-resource-service-restart") != false && headers.get("allow-resource-service-restart").asBoolean() != false;
            if (restartResourceServices) {
                contextFlags.add(AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
            }
            blockingTimeoutConfig = headers != null && headers.hasDefined("blocking-timeout") != false ? headers.get("blocking-timeout") : null;
            responseNode = new ModelNode();
            originalResultTxControl = control == null ? null : new ModelController.OperationTransactionControl(){

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    control.operationPrepared(transaction, responseNode);
                }
            };
            accessMechanism = null;
            accessContext = SecurityActions.currentAccessAuditContext();
            if (accessContext != null) {
                if (operation.hasDefined("operation-headers")) {
                    operationHeaders = operation.get("operation-headers");
                    if (operationHeaders.hasDefined("domain-uuid")) {
                        accessContext.setDomainUuid(operationHeaders.get("domain-uuid").asString());
                    }
                    if (operationHeaders.hasDefined("access-mechanism")) {
                        accessContext.setAccessMechanism(AccessMechanism.valueOf((String)operationHeaders.get("access-mechanism").asString()));
                    }
                }
                accessMechanism = accessContext.getAccessMechanism();
            }
            if (accessMechanism != null && this.bootingFlag.get()) {
                return ModelControllerImpl.handleExternalRequestDuringBoot();
            }
            do {
                responseStreams = null;
            } while (this.activeOperations.putIfAbsent(operationID = Integer.valueOf(new Random(new SecureRandom().nextLong()).nextInt()), context = new OperationContextImpl(operationID, operation.get("operation").asString(), operation.get("address"), this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, attachments, this.managementModel.get(), originalResultTxControl, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, blockingTimeoutConfig, accessMechanism, this.notificationSupport)) != null);
            CurrentOperationIdHolder.setCurrentOperationID(operationID);
            shouldUnlock = false;
            try {
                if (!attemptLock) ** GOTO lbl69
                if (this.controllerLock.detectDeadlockAndGetLock(operationID)) break block27;
                responseNode.get("outcome").set("failed");
                responseNode.get("failure-description").set(ControllerLogger.ROOT_LOGGER.cannotGetControllerLock());
                var21_21 = OperationResponse.Factory.createSimple((ModelNode)responseNode);
            }
            catch (Throwable var23_24) {
                if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
                    state = this.processState.getState();
                    switch (5.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                        case 1: 
                        case 2: {
                            responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                            break;
                        }
                    }
                }
                if (shouldUnlock) {
                    this.controllerLock.unlock(operationID);
                }
                this.activeOperations.remove(operationID);
                CurrentOperationIdHolder.setCurrentOperationID(null);
                throw var23_24;
            }
            if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
                state = this.processState.getState();
                switch (5.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                    case 1: 
                    case 2: {
                        responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                        break;
                    }
                }
            }
            if (shouldUnlock) {
                this.controllerLock.unlock(operationID);
            }
            this.activeOperations.remove(operationID);
            CurrentOperationIdHolder.setCurrentOperationID(null);
            return var21_21;
        }
        shouldUnlock = true;
lbl69:
        // 2 sources

        context.addStep(responseNode, operation, prepareStep, OperationContext.Stage.MODEL);
        context.executeOperation();
        responseStreams = context.getResponseStreams();
        if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
            state = this.processState.getState();
            switch (5.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                case 1: 
                case 2: {
                    responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        if (shouldUnlock) {
            this.controllerLock.unlock(operationID);
        }
        this.activeOperations.remove(operationID);
        CurrentOperationIdHolder.setCurrentOperationID(null);
        if (responseStreams == null || responseStreams.size() == 0) {
            return OperationResponse.Factory.createSimple((ModelNode)responseNode);
        }
        return new OperationResponseImpl(responseNode, responseStreams);
    }

    private static OperationResponse handleExternalRequestDuringBoot() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("failed");
        result.get("failure-description").set(ControllerLogger.MGMT_OP_LOGGER.managementUnavailableDuringBoot());
        return OperationResponse.Factory.createSimple((ModelNode)result);
    }

    boolean boot(List<ModelNode> bootList, OperationMessageHandler handler, ModelController.OperationTransactionControl control, boolean rollbackOnRuntimeFailure) {
        OperationContext.ResultAction resultAction;
        Integer operationID = new Random(new SecureRandom().nextLong()).nextInt();
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags = rollbackOnRuntimeFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
        OperationContextImpl context = new OperationContextImpl(operationID, INITIAL_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, null, this.notificationSupport);
        BootOperations bootOperations = this.organizeBootOperations(bootList, operationID);
        for (ParsedBootOp initialOp : bootOperations.initialOps) {
            context.addBootStep(initialOp);
        }
        if (bootOperations.invalid) {
            context.setRollbackOnly();
        }
        if ((resultAction = context.executeOperation()) == OperationContext.ResultAction.KEEP && bootOperations.postExtensionOps != null) {
            OperationContextImpl postExtContext = new OperationContextImpl(operationID, POST_EXTENSION_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, null, this.notificationSupport);
            for (ParsedBootOp parsedOp : bootOperations.postExtensionOps) {
                if (parsedOp.handler == null) {
                    parsedOp = new ParsedBootOp(parsedOp, this.managementModel.get().getRootResourceRegistration().getOperationHandler(parsedOp.address, parsedOp.operationName));
                }
                if (parsedOp.handler == null) {
                    this.logNoHandler(parsedOp);
                    postExtContext.setRollbackOnly();
                    break;
                }
                postExtContext.addBootStep(parsedOp);
            }
            resultAction = postExtContext.executeOperation();
        }
        return resultAction == OperationContext.ResultAction.KEEP;
    }

    private BootOperations organizeBootOperations(List<ModelNode> bootList, int lockPermit) {
        ArrayList<ParsedBootOp> initialOps = new ArrayList<ParsedBootOp>();
        ArrayList<ParsedBootOp> postExtensionOps = null;
        boolean invalid = false;
        boolean sawExtensionAdd = false;
        ManagementResourceRegistration rootRegistration = this.managementModel.get().getRootResourceRegistration();
        ParallelExtensionAddHandler parallelExtensionAddHandler = this.executorService == null ? null : new ParallelExtensionAddHandler(this.executorService, ModelControllerImpl.getMutableRootResourceRegistrationProvider());
        ParallelBootOperationStepHandler parallelSubsystemHandler = this.executorService != null && this.processType.isServer() && this.runningModeControl.getRunningMode() == RunningMode.NORMAL ? new ParallelBootOperationStepHandler(this.executorService, rootRegistration, this.processState, this, lockPermit) : null;
        boolean registeredParallelSubsystemHandler = false;
        int subsystemIndex = 0;
        for (ModelNode bootOp : bootList) {
            OperationStepHandler stepHandler;
            ParsedBootOp parsedOp = new ParsedBootOp(bootOp);
            if (postExtensionOps != null) {
                if (parsedOp.isExtensionAdd()) {
                    stepHandler = (ExtensionAddHandler)rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
                    if (parallelExtensionAddHandler != null) {
                        parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                        continue;
                    }
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                    continue;
                }
                if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                    if (registeredParallelSubsystemHandler && (parsedOp.isInterfaceOperation() || parsedOp.isSocketOperation())) {
                        postExtensionOps.add(subsystemIndex++, parsedOp);
                        continue;
                    }
                    postExtensionOps.add(parsedOp);
                    continue;
                }
                if (registeredParallelSubsystemHandler) continue;
                postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
                subsystemIndex = postExtensionOps.size() - 1;
                registeredParallelSubsystemHandler = true;
                continue;
            }
            stepHandler = rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
            if (!sawExtensionAdd && stepHandler == null) {
                this.logNoHandler(parsedOp);
                invalid = true;
                break;
            }
            if (stepHandler instanceof ExtensionAddHandler) {
                if (parallelExtensionAddHandler != null) {
                    parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                    if (!sawExtensionAdd) {
                        initialOps.add(parallelExtensionAddHandler.getParsedBootOp());
                    }
                } else {
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                }
                sawExtensionAdd = true;
                continue;
            }
            if (!sawExtensionAdd) {
                initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                continue;
            }
            postExtensionOps = new ArrayList<ParsedBootOp>(32);
            if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                postExtensionOps.add(parsedOp);
                continue;
            }
            postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
            registeredParallelSubsystemHandler = true;
        }
        return new BootOperations(initialOps, postExtensionOps, invalid);
    }

    void finishBoot() {
        this.auditLogger.bootDone();
        this.bootingFlag.set(false);
    }

    ManagementModel getManagementModel() {
        return this.managementModel.get();
    }

    Resource.ResourceEntry getModelControllerResource() {
        return this.modelControllerResource;
    }

    @Override
    public ModelControllerClient createClient(final Executor executor) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        return new ModelControllerClient(){

            public void close() throws IOException {
            }

            public ModelNode execute(ModelNode operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(Operation operation) throws IOException {
                return this.execute(operation, null);
            }

            public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT, null);
            }

            public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation.getOperation(), messageHandler, ModelController.OperationTransactionControl.COMMIT, (OperationAttachments)operation);
            }

            public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT);
            }

            public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation, messageHandler, null, ResponseConverter.TO_MODEL_NODE);
            }

            public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation, ResponseConverter.TO_MODEL_NODE);
            }

            public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, (OperationAttachments)operation, ResponseConverter.TO_OPERATION_RESPONSE);
            }

            private <T> AsyncFuture<T> executeAsync(final ModelNode operation, final OperationMessageHandler messageHandler, final OperationAttachments attachments, ResponseConverter<T> responseConverter) {
                if (executor == null) {
                    throw ControllerLogger.ROOT_LOGGER.nullAsynchronousExecutor();
                }
                final AtomicReference opThread = new AtomicReference();
                class OpTask<T>
                extends AsyncFutureTask<T> {
                    private final ResponseConverter<T> responseConverter;

                    OpTask(ResponseConverter<T> responseConverter) {
                        super(var1_1.executor);
                        this.responseConverter = responseConverter;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void asyncCancel(boolean interruptionDesired) {
                        Thread thread = opThread.getAndSet(Thread.currentThread());
                        if (thread == null) {
                            this.setCancelled();
                        } else {
                            thread.interrupt();
                            boolean interrupted = false;
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                while (opThread.get() != null) {
                                    try {
                                        opThread.wait();
                                    }
                                    catch (InterruptedException ie) {
                                        interrupted = true;
                                    }
                                }
                            }
                            this.setCancelled();
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }

                    void handleResult(OperationResponse result) {
                        ModelNode responseNode;
                        ModelNode modelNode = responseNode = result == null ? null : result.getResponseNode();
                        if (responseNode != null && responseNode.hasDefined("outcome") && "cancelled".equals(responseNode.get("outcome").asString())) {
                            this.setCancelled();
                        } else {
                            this.setResult(this.responseConverter.fromOperationResponse(result));
                        }
                    }
                }
                final OpTask opTask = new OpTask(responseConverter);
                final AccessControlContext acc = (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
                executor.execute(new Runnable(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (opThread.compareAndSet(null, Thread.currentThread())) {
                                OperationResponse response = AccessController.doPrivileged(new PrivilegedAction<OperationResponse>(){

                                    @Override
                                    public OperationResponse run() {
                                        Operation op = attachments == null ? Operation.Factory.create((ModelNode)operation) : Operation.Factory.create((ModelNode)operation, (List)attachments.getInputStreams(), (boolean)attachments.isAutoCloseStreams());
                                        return ModelControllerImpl.this.execute(op, messageHandler, ModelController.OperationTransactionControl.COMMIT);
                                    }
                                }, acc);
                                opTask.handleResult(response);
                            }
                        }
                        finally {
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                opThread.set(null);
                                opThread.notifyAll();
                            }
                        }
                    }
                });
                return opTask;
            }
        };
    }

    ConfigurationPersister.PersistenceResource writeModel(final ManagementModelImpl model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        ControllerLogger.MGMT_OP_LOGGER.tracef("persisting %s from %s", model.rootResource, model);
        ModelNode newModel = Resource.Tools.readModel(model.rootResource);
        final ConfigurationPersister.PersistenceResource delegate = this.persister.store(newModel, affectedAddresses);
        return new ConfigurationPersister.PersistenceResource(){

            @Override
            public void commit() {
                if (ModelControllerImpl.this.hostServerGroupTracker != null) {
                    ModelControllerImpl.this.hostServerGroupTracker.invalidate();
                }
                model.publish();
                delegate.commit();
            }

            @Override
            public void rollback() {
                delegate.rollback();
            }
        };
    }

    void acquireLock(Integer permit, boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.controllerLock.lockInterruptibly(permit);
        } else {
            this.controllerLock.lock(permit);
        }
    }

    boolean acquireLock(Integer permit, boolean interruptibly, long timeout) throws InterruptedException {
        if (interruptibly) {
            return this.controllerLock.lockInterruptibly(permit, timeout, TimeUnit.SECONDS);
        }
        return this.controllerLock.lock(permit, timeout, TimeUnit.SECONDS);
    }

    void releaseLock(Integer permit) {
        this.controllerLock.unlock(permit);
    }

    void logContainerStateChangesAndReset() {
        this.stateMonitor.logContainerStateChangesAndReset();
    }

    void awaitContainerStability(long timeout, TimeUnit timeUnit, boolean interruptibly) throws InterruptedException, TimeoutException {
        if (interruptibly) {
            this.stateMonitor.awaitStability(timeout, timeUnit);
        } else {
            this.stateMonitor.awaitStabilityUninterruptibly(timeout, timeUnit);
        }
    }

    ContainerStateMonitor.ContainerStateChangeReport awaitContainerStateChangeReport(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return this.stateMonitor.awaitContainerStateChangeReport(timeout, timeUnit);
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public NotificationHandlerRegistration getNotificationRegistry() {
        return this.notificationSupport.getNotificationRegistry();
    }

    NotificationSupport getNotificationSupport() {
        return this.notificationSupport;
    }

    ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.expressionResolver.resolveExpressions(node);
    }

    Authorizer getAuthorizer() {
        return this.authorizer;
    }

    private void logNoHandler(ParsedBootOp parsedOp) {
        ManagementResourceRegistration child = this.managementModel.get().getRootResourceRegistration().getSubModel(parsedOp.address);
        if (child == null) {
            ControllerLogger.ROOT_LOGGER.error(ControllerLogger.ROOT_LOGGER.noSuchResourceType(parsedOp.address));
        } else {
            ControllerLogger.ROOT_LOGGER.error(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(parsedOp.operationName, parsedOp.address));
        }
    }

    AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    static MutableRootResourceRegistrationProvider getMutableRootResourceRegistrationProvider() {
        return MutableRootResourceRegistrationProviderImpl.INSTANCE;
    }

    void addFailureDescription(ModelNode operation, ModelNode failure) {
        if (this.bootingFlag.get()) {
            this.bootErrorCollector.addFailureDescription(operation, failure);
        }
    }

    private OperationStepHandler resolveOperationHandler(PathAddress address, String operationName) {
        PathElement pe;
        ManagementResourceRegistration rootRegistration = this.managementModel.get().getRootResourceRegistration();
        OperationStepHandler result = rootRegistration.getOperationHandler(address, operationName);
        if (result == null && address.size() > 0 && (pe = address.getLastElement()).isWildcard()) {
            String type = pe.getKey();
            PathAddress parent = address.subAddress(0, address.size() - 1);
            Set<PathElement> children = rootRegistration.getChildAddresses(parent);
            if (children != null) {
                OperationStepHandler found = null;
                for (PathElement child : children) {
                    OperationStepHandler osh;
                    if (!type.equals(child.getKey())) continue;
                    OperationEntry oe = rootRegistration.getOperationEntry(parent.append(child), operationName);
                    OperationStepHandler operationStepHandler = osh = oe == null ? null : oe.getOperationHandler();
                    if (osh == null || found != null && !found.equals(osh)) {
                        found = null;
                        break;
                    }
                    found = osh;
                }
                if (found != null) {
                    result = found;
                }
            }
        }
        return result;
    }

    static {
        EMPTY_ADDRESS.protect();
    }

    private static interface ResponseConverter<T> {
        public static final ResponseConverter<ModelNode> TO_MODEL_NODE = new ResponseConverter<ModelNode>(){

            @Override
            public ModelNode fromOperationResponse(OperationResponse or) {
                ModelNode result = or.getResponseNode();
                try {
                    or.close();
                }
                catch (IOException e) {
                    ControllerLogger.ROOT_LOGGER.debugf(e, "Caught exception closing %s whose associated streams, if any, were not wanted", or);
                }
                return result;
            }
        };
        public static final ResponseConverter<OperationResponse> TO_OPERATION_RESPONSE = new ResponseConverter<OperationResponse>(){

            @Override
            public OperationResponse fromOperationResponse(OperationResponse or) {
                return or;
            }
        };

        public T fromOperationResponse(OperationResponse var1);
    }

    private static class OperationResponseImpl
    implements OperationResponse {
        private final ModelNode simpleResponse;
        private final Map<String, OperationResponse.StreamEntry> inputStreams;

        private OperationResponseImpl(ModelNode simpleResponse, Map<String, OperationResponse.StreamEntry> inputStreams) {
            this.simpleResponse = simpleResponse;
            this.inputStreams = inputStreams;
            ModelNode header = simpleResponse.get(new String[]{"response-headers", "attached-streams"});
            header.setEmptyList();
            ArrayList streams = new ArrayList();
            for (OperationResponse.StreamEntry entry : inputStreams.values()) {
                ModelNode streamNode = new ModelNode();
                streamNode.get("uuid").set(entry.getUUID());
                streamNode.get("mime-type").set(entry.getMimeType());
                header.add(streamNode);
            }
        }

        public ModelNode getResponseNode() {
            return this.simpleResponse;
        }

        public List<OperationResponse.StreamEntry> getInputStreams() {
            return new ArrayList<OperationResponse.StreamEntry>(this.inputStreams.values());
        }

        public OperationResponse.StreamEntry getInputStream(String uuid) {
            return this.inputStreams.get(uuid);
        }

        public void close() throws IOException {
            int i = 0;
            for (OperationResponse.StreamEntry is : this.inputStreams.values()) {
                try {
                    is.getStream().close();
                }
                catch (Exception e) {
                    ControllerLogger.MGMT_OP_LOGGER.debugf(e, "Failed closing response stream at index %d", i);
                }
                ++i;
            }
        }
    }

    static class CapabilityRegistryImpl
    implements RuntimeCapabilityRegistry {
        private final Map<CapabilityId, RuntimeCapabilityRegistration> capabilities = new HashMap<CapabilityId, RuntimeCapabilityRegistration>();
        private final Map<CapabilityId, Map<String, RuntimeRequirementRegistration>> requirements = new HashMap<CapabilityId, Map<String, RuntimeRequirementRegistration>>();
        private final boolean forServer;
        private final Map<CapabilityContext, Set<CapabilityContext>> satisfiedByMap;

        CapabilityRegistryImpl(boolean forServer) {
            this.forServer = forServer;
            this.satisfiedByMap = forServer ? null : new HashMap();
        }

        @Override
        public synchronized void registerCapability(RuntimeCapabilityRegistration capabilityRegistration) {
            CapabilityContext capContext;
            CapabilityId capabilityId = capabilityRegistration.getCapabilityId();
            RegistrationPoint rp = capabilityRegistration.getOldestRegistrationPoint();
            RuntimeCapabilityRegistration currentRegistration = this.capabilities.get(capabilityId);
            if (currentRegistration != null) {
                if (!Objects.equals(capabilityRegistration.getCapability(), currentRegistration.getCapability()) || !currentRegistration.addRegistrationPoint(rp)) {
                    throw ControllerLogger.MGMT_OP_LOGGER.capabilityAlreadyRegisteredInContext(capabilityId.getName(), capabilityId.getContext().getName());
                }
            } else {
                this.capabilities.put(capabilityId, capabilityRegistration);
            }
            for (String req : ((RuntimeCapability)capabilityRegistration.getCapability()).getRequirements()) {
                this.registerRequirement(new RuntimeRequirementRegistration(req, capabilityId.getName(), capabilityId.getContext(), rp));
            }
            if (!this.forServer && !this.satisfiedByMap.containsKey(capContext = capabilityId.getContext())) {
                HashSet<CapabilityContext> satisfiesUs = new HashSet<CapabilityContext>();
                this.satisfiedByMap.put(capContext, satisfiesUs);
                for (Map.Entry<CapabilityContext, Set<CapabilityContext>> entry : this.satisfiedByMap.entrySet()) {
                    if (entry.getKey().canSatisfyRequirements(capContext)) {
                        satisfiesUs.add(entry.getKey());
                    }
                    if (!capContext.canSatisfyRequirements(entry.getKey())) continue;
                    entry.getValue().add(capContext);
                }
            }
        }

        @Override
        public synchronized void registerAdditionalCapabilityRequirement(RuntimeRequirementRegistration requirement) {
            this.registerRequirement(requirement);
        }

        private void registerRequirement(RuntimeRequirementRegistration requirement) {
            RuntimeRequirementRegistration existing;
            CapabilityId dependentId = requirement.getDependentId();
            if (!this.capabilities.containsKey(dependentId)) {
                throw ControllerLogger.MGMT_OP_LOGGER.unknownCapabilityInContext(dependentId.getName(), dependentId.getContext().getName());
            }
            Map<String, RuntimeRequirementRegistration> dependents = this.requirements.get(dependentId);
            if (dependents == null) {
                dependents = new HashMap<String, RuntimeRequirementRegistration>();
                this.requirements.put(dependentId, dependents);
            }
            if ((existing = dependents.get(requirement.getRequiredName())) == null) {
                dependents.put(requirement.getRequiredName(), requirement);
            } else {
                existing.addRegistrationPoint(requirement.getOldestRegistrationPoint());
            }
        }

        @Override
        public synchronized void removeCapabilityRequirement(RuntimeRequirementRegistration requirementRegistration) {
            this.removeRequirement(requirementRegistration);
        }

        @Override
        public synchronized RuntimeCapabilityRegistration removeCapability(String capabilityName, CapabilityContext context, PathAddress registrationPoint) {
            RegistrationPoint rp;
            CapabilityId capabilityId = new CapabilityId(capabilityName, context);
            RuntimeCapabilityRegistration removed = null;
            RuntimeCapabilityRegistration candidate = this.capabilities.get(capabilityId);
            if (candidate != null && candidate.removeRegistrationPoint(rp = new RegistrationPoint(registrationPoint, null))) {
                for (String req : ((RuntimeCapability)candidate.getCapability()).getRequirements()) {
                    this.removeRequirement(new RuntimeRequirementRegistration(req, capabilityName, context, rp));
                }
                for (String req : ((RuntimeCapability)candidate.getCapability()).getOptionalRequirements()) {
                    this.removeRequirement(new RuntimeRequirementRegistration(req, capabilityName, context, rp));
                }
                if (candidate.getRegistrationPointCount() == 0) {
                    removed = this.capabilities.remove(capabilityId);
                }
            }
            return removed;
        }

        private synchronized void removeRequirement(RuntimeRequirementRegistration requirementRegistration) {
            RuntimeRequirementRegistration rrr;
            Map<String, RuntimeRequirementRegistration> dependents = this.requirements.get(requirementRegistration.getDependentId());
            if (dependents != null && (rrr = dependents.get(requirementRegistration.getRequiredName())) != null) {
                rrr.removeRegistrationPoint(requirementRegistration.getOldestRegistrationPoint());
                if (rrr.getRegistrationPointCount() == 0) {
                    dependents.remove(requirementRegistration.getRequiredName());
                }
                if (dependents.size() == 0) {
                    this.requirements.remove(requirementRegistration.getDependentId());
                }
            }
        }

        @Override
        public synchronized boolean hasCapability(String capabilityName, CapabilityContext capabilityContext) {
            return this.findSatisfactoryCapability(capabilityName, capabilityContext) != null;
        }

        @Override
        public synchronized <T> T getCapabilityRuntimeAPI(String capabilityName, CapabilityContext capabilityContext, Class<T> apiType) {
            CapabilityId capabilityId = this.findSatisfactoryCapability(capabilityName, capabilityContext);
            if (capabilityId == null) {
                if (this.forServer) {
                    throw ControllerLogger.MGMT_OP_LOGGER.unknownCapability(capabilityName);
                }
                throw ControllerLogger.MGMT_OP_LOGGER.unknownCapabilityInContext(capabilityName, capabilityContext.getName());
            }
            RuntimeCapabilityRegistration reg = this.capabilities.get(capabilityId);
            Object api = ((RuntimeCapability)reg.getCapability()).getRuntimeAPI();
            if (api == null) {
                throw ControllerLogger.MGMT_OP_LOGGER.capabilityDoesNotExposeRuntimeAPI(capabilityName);
            }
            return apiType.cast(api);
        }

        synchronized CapabilityRegistryImpl copy() {
            CapabilityRegistryImpl result = new CapabilityRegistryImpl(this.forServer);
            result.capabilities.putAll(this.capabilities);
            for (Map.Entry<CapabilityId, Map<String, RuntimeRequirementRegistration>> entry : this.requirements.entrySet()) {
                HashMap<String, RuntimeRequirementRegistration> mapCopy = new HashMap<String, RuntimeRequirementRegistration>();
                for (Map.Entry<String, RuntimeRequirementRegistration> innerEntry : entry.getValue().entrySet()) {
                    mapCopy.put(innerEntry.getKey(), new RuntimeRequirementRegistration(innerEntry.getValue()));
                }
                result.requirements.put(entry.getKey(), mapCopy);
            }
            if (!this.forServer) {
                result.satisfiedByMap.putAll(this.satisfiedByMap);
            }
            return result;
        }

        synchronized Map<CapabilityId, Set<RuntimeRequirementRegistration>> getMissingRequirements() {
            HashMap<CapabilityId, Set<RuntimeRequirementRegistration>> result = new HashMap<CapabilityId, Set<RuntimeRequirementRegistration>>();
            for (Map.Entry<CapabilityId, Map<String, RuntimeRequirementRegistration>> entry : this.requirements.entrySet()) {
                CapabilityContext dependentContext = entry.getKey().getContext();
                for (RuntimeRequirementRegistration req : entry.getValue().values()) {
                    CapabilityId satisfiesId = this.findSatisfactoryCapability(req.getRequiredName(), dependentContext);
                    if (satisfiesId != null) continue;
                    CapabilityId basicId = new CapabilityId(req.getRequiredName(), dependentContext);
                    HashSet<RuntimeRequirementRegistration> set = (HashSet<RuntimeRequirementRegistration>)result.get(basicId);
                    if (set == null) {
                        set = new HashSet<RuntimeRequirementRegistration>();
                        result.put(basicId, set);
                    }
                    set.add(req);
                }
            }
            return result;
        }

        private CapabilityId findSatisfactoryCapability(String capabilityName, CapabilityContext capabilityContext) {
            CapabilityId requestedId = new CapabilityId(capabilityName, capabilityContext);
            if (this.capabilities.containsKey(requestedId)) {
                return requestedId;
            }
            if (!this.forServer) {
                for (CapabilityContext satisfies : this.satisfiedByMap.get(capabilityContext)) {
                    CapabilityId satisfiesId = new CapabilityId(capabilityName, satisfies);
                    if (!this.capabilities.containsKey(satisfiesId)) continue;
                    return satisfiesId;
                }
            }
            return null;
        }
    }

    final class ManagementModelImpl
    implements ManagementModel {
        private final ManagementResourceRegistration resourceRegistration;
        private final Resource rootResource;
        private final ManagementResourceRegistration delegatingResourceRegistration;
        private final Resource delegatingResource;
        private final CapabilityRegistryImpl capabilityRegistry;
        private final RuntimeCapabilityRegistry delegatingCapabilityRegistry;
        private volatile boolean published;

        ManagementModelImpl(ManagementResourceRegistration resourceRegistration, final Resource rootResource, final CapabilityRegistryImpl capabilityRegistry) {
            this.resourceRegistration = resourceRegistration;
            this.rootResource = rootResource;
            this.capabilityRegistry = capabilityRegistry;
            this.delegatingResourceRegistration = resourceRegistration;
            this.delegatingResource = new DelegatingResource(new DelegatingResource.ResourceDelegateProvider(){

                @Override
                public Resource getDelegateResource() {
                    Resource result = ManagementModelImpl.this.published ? ((ManagementModelImpl)ModelControllerImpl.this.managementModel.get()).rootResource : rootResource;
                    return result;
                }
            });
            this.delegatingCapabilityRegistry = new DelegatingRuntimeCapabilityRegistry(new DelegatingRuntimeCapabilityRegistry.CapabilityRegistryDelegateProvider(){

                @Override
                public RuntimeCapabilityRegistry getDelegateCapabilityRegistry() {
                    CapabilityRegistryImpl result = ManagementModelImpl.this.published ? ((ManagementModelImpl)ModelControllerImpl.this.managementModel.get()).capabilityRegistry : capabilityRegistry;
                    return result;
                }
            });
        }

        @Override
        public ManagementResourceRegistration getRootResourceRegistration() {
            return this.delegatingResourceRegistration;
        }

        @Override
        public Resource getRootResource() {
            return this.delegatingResource;
        }

        @Override
        public RuntimeCapabilityRegistry getCapabilityRegistry() {
            return this.delegatingCapabilityRegistry;
        }

        ManagementModelImpl cloneRootResource() {
            CapabilityRegistryImpl currentCaps;
            Resource currentResource;
            ManagementResourceRegistration mrr;
            if (this.published) {
                ManagementModelImpl currentPublished = (ManagementModelImpl)ModelControllerImpl.this.managementModel.get();
                mrr = currentPublished.resourceRegistration;
                currentResource = currentPublished.rootResource;
                currentCaps = currentPublished.capabilityRegistry;
            } else {
                mrr = this.resourceRegistration;
                currentResource = this.rootResource;
                currentCaps = this.capabilityRegistry;
            }
            Resource clone = currentResource.clone();
            ManagementModelImpl result = new ManagementModelImpl(mrr, clone, currentCaps);
            ControllerLogger.MGMT_OP_LOGGER.tracef("cloned to %s to create %s and %s", currentResource, clone, result);
            return result;
        }

        ManagementModelImpl cloneCapabilityRegistry() {
            CapabilityRegistryImpl currentCaps;
            Resource currentResource;
            ManagementResourceRegistration mrr;
            if (this.published) {
                ManagementModelImpl currentPublished = (ManagementModelImpl)ModelControllerImpl.this.managementModel.get();
                mrr = currentPublished.resourceRegistration;
                currentResource = currentPublished.rootResource;
                currentCaps = currentPublished.capabilityRegistry;
            } else {
                mrr = this.resourceRegistration;
                currentResource = this.rootResource;
                currentCaps = this.capabilityRegistry;
            }
            CapabilityRegistryImpl clone = currentCaps.copy();
            ManagementModelImpl result = new ManagementModelImpl(mrr, currentResource, clone);
            ControllerLogger.MGMT_OP_LOGGER.tracef("cloned to %s to create %s and %s", currentCaps, clone, result);
            return result;
        }

        Map<CapabilityId, Set<RuntimeRequirementRegistration>> validateCapabilityRegistry() {
            if (!this.published) {
                return this.capabilityRegistry.getMissingRequirements();
            }
            return Collections.emptyMap();
        }

        private void publish() {
            ModelControllerImpl.this.managementModel.set(this);
            ControllerLogger.MGMT_OP_LOGGER.tracef("published %s", this);
            this.published = true;
        }
    }

    private static class MutableRootResourceRegistrationProviderImpl
    implements MutableRootResourceRegistrationProvider {
        private static final MutableRootResourceRegistrationProvider INSTANCE = new MutableRootResourceRegistrationProviderImpl();

        private MutableRootResourceRegistrationProviderImpl() {
        }

        @Override
        public ManagementResourceRegistration getRootResourceRegistrationForUpdate(OperationContext context) {
            assert (context instanceof AbstractOperationContext);
            return ((AbstractOperationContext)context).getRootResourceRegistrationForUpdate();
        }
    }

    private final class ModelControllerResource
    extends PlaceholderResource.PlaceholderResourceEntry {
        private ModelControllerResource() {
            super("service", "management-operations");
        }

        @Override
        public boolean hasChild(PathElement element) {
            try {
                return "active-operation".equals(element.getKey()) && ModelControllerImpl.this.activeOperations.containsKey(Integer.valueOf(element.getValue()));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Resource getChild(PathElement element) {
            Resource.ResourceEntry result = null;
            if ("active-operation".equals(element.getKey())) {
                try {
                    OperationContextImpl context = (OperationContextImpl)ModelControllerImpl.this.activeOperations.get(Integer.valueOf(element.getValue()));
                    if (context != null) {
                        result = context.getActiveOperationResource();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public Resource requireChild(PathElement element) {
            Resource resource = this.getChild(element);
            if (resource == null) {
                throw new Resource.NoSuchResourceException(element);
            }
            return resource;
        }

        @Override
        public boolean hasChildren(String childType) {
            return "active-operation".equals(childType) && ModelControllerImpl.this.activeOperations.size() > 0;
        }

        @Override
        public Set<String> getChildTypes() {
            return Collections.singleton("active-operation");
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            HashSet<String> result = new HashSet<String>(ModelControllerImpl.this.activeOperations.size());
            for (Integer id : ModelControllerImpl.this.activeOperations.keySet()) {
                result.add(id.toString());
            }
            return result;
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>(ModelControllerImpl.this.activeOperations.size());
            for (OperationContextImpl context : ModelControllerImpl.this.activeOperations.values()) {
                result.add(context.getActiveOperationResource());
            }
            return result;
        }
    }

    private static final class BootOperations {
        private final List<ParsedBootOp> initialOps;
        private final List<ParsedBootOp> postExtensionOps;
        private final boolean invalid;

        private BootOperations(List<ParsedBootOp> initialOps, List<ParsedBootOp> postExtensionOps, boolean invalid) {
            this.initialOps = initialOps;
            this.postExtensionOps = postExtensionOps;
            this.invalid = invalid;
        }
    }

    private class DefaultPrepareStepHandler
    implements OperationStepHandler {
        private DefaultPrepareStepHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String operationName;
            PathAddress address;
            OperationStepHandler stepHandler;
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.tracef("Executing %s %s", operation.get("operation"), operation.get("address"));
            }
            if ((stepHandler = ModelControllerImpl.this.resolveOperationHandler(address = context.getCurrentAddress(), operationName = operation.require("operation").asString())) != null) {
                context.addStep(stepHandler, OperationContext.Stage.MODEL);
            } else {
                ManagementResourceRegistration child = ((ManagementModelImpl)ModelControllerImpl.this.managementModel.get()).getRootResourceRegistration().getSubModel(address);
                if (child == null) {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noSuchResourceType(address));
                } else {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, address));
                }
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

