/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationAttributes;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.global.ReadResourceHandler;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadChildrenResourcesHandler
implements OperationStepHandler {
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-children-resources", ControllerResolver.getResolver("global")).setParameters(GlobalOperationAttributes.CHILD_TYPE, GlobalOperationAttributes.RECURSIVE, GlobalOperationAttributes.RECURSIVE_DEPTH, GlobalOperationAttributes.PROXIES, GlobalOperationAttributes.INCLUDE_RUNTIME, GlobalOperationAttributes.INCLUDE_DEFAULTS).setReadOnly().setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).build();
    static final OperationStepHandler INSTANCE = new ReadChildrenResourcesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String childType = GlobalOperationAttributes.CHILD_TYPE.resolveModelAttribute(context, operation).asString();
        ModelNode readOp = new ModelNode();
        readOp.get("operation").set("read-resource");
        GlobalOperationAttributes.INCLUDE_RUNTIME.validateAndSet(operation, readOp);
        GlobalOperationAttributes.RECURSIVE.validateAndSet(operation, readOp);
        GlobalOperationAttributes.RECURSIVE_DEPTH.validateAndSet(operation, readOp);
        GlobalOperationAttributes.PROXIES.validateAndSet(operation, readOp);
        GlobalOperationAttributes.INCLUDE_DEFAULTS.validateAndSet(operation, readOp);
        HashMap<PathElement, ModelNode> resources = new HashMap<PathElement, ModelNode>();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS, false);
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        Map<String, Set<String>> childAddresses = GlobalOperationHandlers.getChildAddresses(context, address, registry, resource, childType);
        Set<String> childNames = childAddresses.get(childType);
        if (childNames == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.unknownChildType(childType));
        }
        FilteredData filteredData = new FilteredData(address);
        ReadChildrenResourcesAssemblyHandler assemblyHandler = new ReadChildrenResourcesAssemblyHandler(resources, filteredData, address, childType);
        context.addStep(assemblyHandler, OperationContext.Stage.MODEL, true);
        for (String key : childNames) {
            PathElement childPath = PathElement.pathElement(childType, key);
            PathAddress childAddress = PathAddress.EMPTY_ADDRESS.append(PathElement.pathElement(childType, key));
            ModelNode readResOp = readOp.clone();
            readResOp.get("address").set(PathAddress.pathAddress(address, childPath).toModelNode());
            OperationStepHandler overrideHandler = context.getResourceRegistration().getOperationHandler(childAddress, "read-resource");
            if (overrideHandler == null) {
                throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noOperationHandler());
            }
            if (overrideHandler.getClass() == ReadResourceHandler.class) {
                overrideHandler = null;
            }
            ReadResourceHandler rrHandler = new ReadResourceHandler(filteredData, overrideHandler, false);
            ModelNode rrRsp = new ModelNode();
            resources.put(childPath, rrRsp);
            context.addStep(rrRsp, readResOp, rrHandler, OperationContext.Stage.MODEL, true);
        }
        context.stepCompleted();
    }

    private static class ReadChildrenResourcesAssemblyHandler
    implements OperationStepHandler {
        private final Map<PathElement, ModelNode> resources;
        private final FilteredData filteredData;
        private final PathAddress address;
        private final String childType;

        private ReadChildrenResourcesAssemblyHandler(Map<PathElement, ModelNode> resources, FilteredData filteredData, PathAddress address, String childType) {
            this.resources = resources;
            this.filteredData = filteredData;
            this.address = address;
            this.childType = childType;
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    TreeMap<String, ModelNode> sortedChildren = new TreeMap<String, ModelNode>();
                    boolean failed = false;
                    for (Map.Entry entry : ReadChildrenResourcesAssemblyHandler.this.resources.entrySet()) {
                        PathElement path = (PathElement)entry.getKey();
                        ModelNode value = (ModelNode)entry.getValue();
                        if (!value.has("failure-description")) {
                            sortedChildren.put(path.getValue(), value.get("result"));
                            continue;
                        }
                        if (failed || !value.hasDefined("failure-description")) continue;
                        context.getFailureDescription().set(value.get("failure-description"));
                        failed = true;
                    }
                    if (!failed) {
                        boolean hasFilteredData = ReadChildrenResourcesAssemblyHandler.this.filteredData.hasFilteredData();
                        ModelNode result = context.getResult();
                        result.setEmptyObject();
                        for (Map.Entry entry : sortedChildren.entrySet()) {
                            if (hasFilteredData && ReadChildrenResourcesAssemblyHandler.this.filteredData.isAddressFiltered(ReadChildrenResourcesAssemblyHandler.this.address, PathElement.pathElement(ReadChildrenResourcesAssemblyHandler.this.childType, (String)entry.getKey()))) continue;
                            result.get((String)entry.getKey()).set((ModelNode)entry.getValue());
                        }
                        if (hasFilteredData) {
                            context.getResponseHeaders().get("access-control").set(ReadChildrenResourcesAssemblyHandler.this.filteredData.toModelNode());
                        }
                    }
                    context.stepCompleted();
                }
            }, OperationContext.Stage.VERIFY);
            context.stepCompleted();
        }
    }
}

