/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationClientException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.ServiceVerificationHelper;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.client.MessageSeverity;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.Notification;
import org.jboss.as.controller.notification.NotificationSupport;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.security.InetAddressPrincipal;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.manager.WildFlySecurityManager;

abstract class AbstractOperationContext
implements OperationContext {
    private static final Set<String> NON_COPIED_HEADERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("allow-resource-service-restart", "rollback-on-runtime-failure", "rollout-plan")));
    static final ThreadLocal<Thread> controllingThread = new ThreadLocal();
    final Thread initiatingThread;
    private final EnumMap<OperationContext.Stage, Deque<Step>> steps;
    private final ModelController.OperationTransactionControl transactionControl;
    final ControlledProcessState processState;
    private final NotificationSupport notificationSupport;
    private final boolean booting;
    private final ProcessType processType;
    private final RunningMode runningMode;
    private final Environment callEnvironment;
    boolean respectInterruption = true;
    private final Queue<Notification> notifications;
    OperationContext.Stage currentStage = OperationContext.Stage.MODEL;
    OperationContext.ResultAction resultAction;
    boolean cancelled;
    Step activeStep;
    Caller caller;
    private boolean executing;
    private final List<ModelNode> controllerOperations = new ArrayList<ModelNode>(2);
    private boolean auditLogged;
    private final AuditLogger auditLogger;
    private final ModelControllerImpl controller;
    private Map<String, OperationResponse.StreamEntry> responseStreams;

    AbstractOperationContext(ProcessType processType, RunningMode runningMode, ModelController.OperationTransactionControl transactionControl, ControlledProcessState processState, boolean booting, AuditLogger auditLogger, NotificationSupport notificationSupport, ModelControllerImpl controller) {
        this.processType = processType;
        this.runningMode = runningMode;
        this.transactionControl = transactionControl;
        this.processState = processState;
        this.booting = booting;
        this.auditLogger = auditLogger;
        this.notificationSupport = notificationSupport;
        this.notifications = new ConcurrentLinkedQueue<Notification>();
        this.controller = controller;
        this.steps = new EnumMap(OperationContext.Stage.class);
        for (OperationContext.Stage stage : OperationContext.Stage.values()) {
            if (booting && stage == OperationContext.Stage.VERIFY) {
                this.steps.put(stage, new LinkedBlockingDeque());
                continue;
            }
            this.steps.put(stage, new ArrayDeque());
        }
        this.initiatingThread = Thread.currentThread();
        this.callEnvironment = new Environment(processState, processType);
    }

    @Override
    public boolean isBooting() {
        return this.booting;
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(step, stage, false);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, operation, null, step, stage, addFirst);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, null, step, stage);
    }

    @Override
    public void addStep(OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        ModelNode response = this.activeStep == null ? new ModelNode().setEmptyObject() : this.activeStep.response;
        this.addStep(response, this.activeStep.operation, this.activeStep.address, step, stage, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationStepHandler step, OperationContext.Stage stage) throws IllegalArgumentException {
        this.addStep(response, operation, address, step, stage, false);
    }

    @Override
    public void addStep(ModelNode response, ModelNode operation, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        this.addStep(response, operation, null, step, stage, addFirst);
    }

    void addStep(ModelNode response, ModelNode operation, PathAddress address, OperationStepHandler step, OperationContext.Stage stage, boolean addFirst) throws IllegalArgumentException {
        assert (this.isControllingThread());
        if (response == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("response");
        }
        if (operation == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("operation");
        }
        if (step == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("step");
        }
        if (stage == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("stage");
        }
        if (this.currentStage == OperationContext.Stage.DONE) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        if (stage.compareTo(this.currentStage) < 0) {
            throw ControllerLogger.ROOT_LOGGER.stageAlreadyComplete(stage);
        }
        if (stage == OperationContext.Stage.DOMAIN && this.processType != ProcessType.HOST_CONTROLLER) {
            throw ControllerLogger.ROOT_LOGGER.invalidStage(stage, this.processType);
        }
        if (stage == OperationContext.Stage.DONE) {
            throw ControllerLogger.ROOT_LOGGER.invalidStepStage();
        }
        if (!this.booting && this.activeStep != null && this.activeStep.operation.hasDefined("operation-headers")) {
            ModelNode activeHeaders = this.activeStep.operation.get("operation-headers");
            for (Property property : activeHeaders.asPropertyList()) {
                String key = property.getName();
                if (NON_COPIED_HEADERS.contains(key)) continue;
                operation.get(new String[]{"operation-headers", key}).set(property.getValue());
            }
        }
        Deque<Step> deque = this.steps.get((Object)stage);
        if (addFirst) {
            deque.addFirst(new Step(step, response, operation, address));
        } else {
            deque.addLast(new Step(step, response, operation, address));
        }
        if (!this.executing && stage == OperationContext.Stage.MODEL) {
            this.recordControllerOperation(operation);
        }
    }

    void addBootStep(ParsedBootOp parsedBootOp) {
        this.addStep(parsedBootOp.response, parsedBootOp.operation, parsedBootOp.handler, OperationContext.Stage.MODEL);
        for (ModelNode childOp : parsedBootOp.getChildOperations()) {
            this.recordControllerOperation(childOp);
        }
    }

    @Override
    public final ModelNode getFailureDescription() {
        return this.activeStep.response.get("failure-description");
    }

    @Override
    public final boolean hasFailureDescription() {
        return this.activeStep.response.has("failure-description");
    }

    @Override
    public final ModelNode getResponseHeaders() {
        return this.activeStep.response.get("response-headers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationContext.ResultAction executeOperation() {
        try {
            OperationContext.ResultAction resultAction = this.completeStepInternal();
            return resultAction;
        }
        finally {
            if (this.resultAction != OperationContext.ResultAction.KEEP && !this.isBooting()) {
                AbstractOperationContext abstractOperationContext = this;
                synchronized (abstractOperationContext) {
                    if (this.responseStreams != null) {
                        int i = 0;
                        for (OperationResponse.StreamEntry is : this.responseStreams.values()) {
                            try {
                                is.getStream().close();
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.debugf(e, "Failed closing stream at index %d", i);
                            }
                            ++i;
                        }
                        this.responseStreams.clear();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationContext.ResultAction completeStepInternal() {
        try {
            this.doCompleteStep();
            if (this.resultAction == OperationContext.ResultAction.KEEP) {
                this.report(MessageSeverity.INFO, ControllerLogger.ROOT_LOGGER.operationSucceeded());
            } else {
                this.report(MessageSeverity.INFO, ControllerLogger.ROOT_LOGGER.operationRollingBack());
            }
            OperationContext.ResultAction resultAction = this.resultAction;
            return resultAction;
        }
        finally {
            this.respectInterruption = false;
        }
    }

    @Override
    public final void completeStep(OperationContext.RollbackHandler rollbackHandler) {
        if (rollbackHandler == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("rollbackHandler");
        }
        if (rollbackHandler == OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER) {
            this.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        } else {
            this.completeStep(new RollbackDelegatingResultHandler(rollbackHandler));
        }
    }

    @Override
    public final void completeStep(OperationContext.ResultHandler resultHandler) {
        if (resultHandler == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("resultHandler");
        }
        this.activeStep.resultHandler = resultHandler;
    }

    @Override
    public final void stepCompleted() {
        this.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
    }

    boolean stageCompleted(OperationContext.Stage stage) {
        return true;
    }

    abstract void awaitServiceContainerStability() throws InterruptedException, TimeoutException;

    abstract ConfigurationPersister.PersistenceResource createPersistenceResource() throws ConfigurationPersistenceException;

    abstract void releaseStepLocks(Step var1);

    abstract void waitForRemovals() throws InterruptedException, TimeoutException;

    abstract boolean isReadOnly();

    abstract ManagementResourceRegistration getRootResourceRegistrationForUpdate();

    boolean isControllingThread() {
        return Thread.currentThread() == this.initiatingThread || controllingThread.get() == this.initiatingThread;
    }

    void logAuditRecord() {
        if (!this.auditLogged) {
            try {
                AccessAuditContext accessContext = SecurityActions.currentAccessAuditContext();
                Caller caller = this.getCaller();
                Subject subject = SecurityActions.getSubject(caller);
                this.auditLogger.log(this.isReadOnly(), this.resultAction, caller == null ? null : caller.getName(), accessContext == null ? null : accessContext.getDomainUuid(), accessContext == null ? null : accessContext.getAccessMechanism(), this.getSubjectInetAddress(subject), this.getModel(), this.controllerOperations);
                this.auditLogged = true;
            }
            catch (Exception e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToUpdateAuditLog(e);
            }
        }
    }

    private InetAddress getSubjectInetAddress(Subject subject) {
        InetAddressPrincipal principal = this.getPrincipal(subject, InetAddressPrincipal.class);
        return principal != null ? principal.getInetAddress() : null;
    }

    private <T extends Principal> T getPrincipal(Subject subject, Class<T> clazz) {
        if (subject == null) {
            return null;
        }
        Set<T> principals = subject.getPrincipals(clazz);
        assert (principals.size() <= 1);
        if (principals.size() == 0) {
            return null;
        }
        return (T)((Principal)principals.iterator().next());
    }

    private void recordControllerOperation(ModelNode operation) {
        this.controllerOperations.add(operation.clone());
    }

    abstract Resource getModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompleteStep() {
        ModelNode response;
        assert (this.isControllingThread());
        if (this.currentStage == null) {
            throw ControllerLogger.ROOT_LOGGER.operationAlreadyComplete();
        }
        this.executing = true;
        if (!this.canContinueProcessing()) {
            this.respectInterruption = false;
            this.logAuditRecord();
            return;
        }
        ModelNode modelNode = response = this.activeStep == null ? null : this.activeStep.response;
        do {
            Step step;
            if ((step = this.steps.get((Object)this.currentStage).pollFirst()) == null) {
                if (!this.stageCompleted(this.currentStage)) {
                    this.resultAction = OperationContext.ResultAction.ROLLBACK;
                    if (this.activeStep != null) {
                        this.activeStep.finalizeStep(null);
                    }
                    return;
                }
                if (!this.currentStage.hasNext()) continue;
                this.currentStage = this.currentStage.next();
                if (this.currentStage != OperationContext.Stage.VERIFY) continue;
                try {
                    this.awaitServiceContainerStability();
                }
                catch (InterruptedException e) {
                    this.cancelled = true;
                    this.handleContainerStabilityFailure(response, e);
                    return;
                }
                catch (TimeoutException te) {
                    this.handleContainerStabilityFailure(response, te);
                    return;
                }
            }
            Throwable toThrow = null;
            boolean exit = false;
            try {
                this.executeStep(step);
            }
            catch (RuntimeException re) {
                toThrow = re;
            }
            catch (Error e) {
                toThrow = e;
            }
            finally {
                if (step.resultHandler == null) {
                    AbstractOperationContext.throwThrowable(toThrow);
                    exit = true;
                } else if (!this.canContinueProcessing()) {
                    this.respectInterruption = false;
                    this.logAuditRecord();
                    step.finalizeStep(toThrow);
                    exit = true;
                } else {
                    AbstractOperationContext.throwThrowable(toThrow);
                    response = this.activeStep.response;
                }
            }
            if (!exit) continue;
            return;
        } while (this.currentStage != OperationContext.Stage.DONE);
        ConfigurationPersister.PersistenceResource persistenceResource = null;
        if (this.isModelAffected() && this.resultAction != OperationContext.ResultAction.ROLLBACK) {
            try {
                persistenceResource = this.createPersistenceResource();
            }
            catch (ConfigurationPersistenceException e) {
                ControllerLogger.MGMT_OP_LOGGER.failedToPersistConfigurationChange(e);
                if (response != null) {
                    response.get("outcome").set("failed");
                    response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.failedToPersistConfigurationChange(e.getLocalizedMessage()));
                }
                this.resultAction = OperationContext.ResultAction.ROLLBACK;
                this.logAuditRecord();
                return;
            }
        }
        final AtomicReference<OperationContext.ResultAction> ref = new AtomicReference<OperationContext.ResultAction>(this.transactionControl == null ? OperationContext.ResultAction.KEEP : OperationContext.ResultAction.ROLLBACK);
        if (this.transactionControl != null) {
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.trace("Prepared response is " + response);
            }
            this.transactionControl.operationPrepared(new ModelController.OperationTransaction(){

                @Override
                public void commit() {
                    ref.set(OperationContext.ResultAction.KEEP);
                }

                @Override
                public void rollback() {
                    ref.set(OperationContext.ResultAction.ROLLBACK);
                }
            }, response);
        }
        this.resultAction = ref.get();
        if (persistenceResource != null) {
            if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                persistenceResource.rollback();
            } else {
                persistenceResource.commit();
            }
        }
        this.logAuditRecord();
        this.emitNotifications();
    }

    @Override
    public void emit(Notification notification) {
        this.notifications.add(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emitNotifications() {
        if (this.resultAction != OperationContext.ResultAction.ROLLBACK) {
            Queue<Notification> queue = this.notifications;
            synchronized (queue) {
                if (this.notifications.isEmpty()) {
                    return;
                }
                this.checkUndefinedNotifications(this.notifications);
                this.notificationSupport.emit(this.notifications.toArray(new Notification[this.notifications.size()]));
                this.notifications.clear();
            }
        }
    }

    private void checkUndefinedNotifications(Collection<Notification> notifications) {
        for (Notification notification : notifications) {
            String type = notification.getType();
            PathAddress source = notification.getSource();
            Map<String, NotificationEntry> descriptions = this.getRootResourceRegistration().getNotificationDescriptions(source, true);
            if (descriptions.keySet().contains(type)) continue;
            ControllerLogger.ROOT_LOGGER.notificationIsNotDescribed(type, source);
        }
    }

    private void addBootFailureDescription() {
        if (this.isBooting() && this.activeStep != null && this.activeStep.response.hasDefined("failure-description")) {
            this.controller.addFailureDescription(this.activeStep.operation, this.activeStep.response.get("failure-description").clone());
        }
    }

    private boolean canContinueProcessing() {
        if (Thread.currentThread().isInterrupted()) {
            this.cancelled = true;
        }
        if (this.cancelled) {
            if (this.activeStep != null) {
                this.activeStep.response.get("outcome").set("cancelled");
                this.activeStep.response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.operationCancelled());
                this.activeStep.response.get("rolled-back").set(true);
            }
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        } else if (this.activeStep != null && this.activeStep.hasFailed() && (this.isRollbackOnRuntimeFailure() || this.currentStage == OperationContext.Stage.MODEL)) {
            this.activeStep.response.get("outcome").set("failed");
            this.activeStep.response.get("rolled-back").set(true);
            this.resultAction = OperationContext.ResultAction.ROLLBACK;
        }
        return this.resultAction != OperationContext.ResultAction.ROLLBACK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStep(Step step) {
        block23: {
            step.predecessor = this.activeStep;
            this.activeStep = step;
            try {
                try {
                    ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(step.handler.getClass());
                    try {
                        step.handler.execute(this, step.operation);
                        if (this.isErrorLoggingNecessary() && step.hasFailed()) {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailed(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        }
                        if (step.serviceVerificationHelper != null) {
                            this.addStep(step.serviceVerificationHelper, OperationContext.Stage.VERIFY);
                        }
                    }
                    finally {
                        step.executed = true;
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof OperationClientException)) {
                        this.logAuditRecord();
                        throw t;
                    }
                    if (this.currentStage != OperationContext.Stage.DONE) {
                        ModelNode failDesc = ((OperationClientException)OperationClientException.class.cast(t)).getFailureDescription();
                        step.response.get("failure-description").set(failDesc);
                        if (this.isErrorLoggingNecessary()) {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailed(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        } else {
                            ControllerLogger.MGMT_OP_LOGGER.operationFailedOnClientError(step.operation.get("operation"), step.operation.get("address"), step.response.get("failure-description"));
                        }
                        this.stepCompleted();
                        break block23;
                    }
                    throw t;
                }
            }
            catch (Throwable t) {
                if (t instanceof StackOverflowError) {
                    ControllerLogger.MGMT_OP_LOGGER.operationFailedInsufficientStackSpace(t, step.operation.get("operation"), step.operation.get("address"), "jboss.boot.thread.stack.size", 0x200000);
                } else {
                    ControllerLogger.MGMT_OP_LOGGER.operationFailed(t, step.operation.get("operation"), step.operation.get("address"));
                }
                if (this.currentStage != OperationContext.Stage.DONE) {
                    if (!step.hasFailed()) {
                        String cause;
                        String string = cause = t instanceof OperationClientException ? t.getLocalizedMessage() : t.toString();
                        if (cause == null) {
                            cause = t.toString();
                        }
                        step.response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.operationHandlerFailed(cause));
                    }
                    step.response.get("outcome").set("failed");
                    this.resultAction = this.getFailedResultAction(t);
                    if (this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                        step.response.get("rolled-back").set(true);
                    }
                } else {
                    this.report(MessageSeverity.WARN, ControllerLogger.ROOT_LOGGER.stepHandlerFailed(step.handler));
                }
            }
            finally {
                this.addBootFailureDescription();
                this.finishStep(step);
            }
        }
    }

    private boolean isErrorLoggingNecessary() {
        return this.isBooting() || this.currentStage == OperationContext.Stage.RUNTIME || this.currentStage == OperationContext.Stage.VERIFY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishStep(Step step) {
        boolean finalize = true;
        Throwable toThrow = null;
        try {
            if (step.resultHandler != null) {
                if (!this.hasMoreSteps()) {
                    this.completeStepInternal();
                } else {
                    finalize = false;
                }
            }
        }
        catch (RuntimeException re) {
            toThrow = re;
        }
        catch (Error e) {
            toThrow = e;
        }
        finally {
            if (finalize) {
                step.finalizeStep(toThrow);
            } else {
                AbstractOperationContext.throwThrowable(toThrow);
            }
        }
    }

    private void handleContainerStabilityFailure(ModelNode response, Exception cause) {
        boolean interrupted = cause instanceof InterruptedException;
        assert (interrupted || cause instanceof TimeoutException);
        if (response != null) {
            response.get("outcome").set("cancelled");
            response.get("failure-description").set(interrupted ? ControllerLogger.ROOT_LOGGER.operationCancelled() : ControllerLogger.ROOT_LOGGER.timeoutExecutingOperation());
            response.get("rolled-back").set(true);
        }
        this.resultAction = OperationContext.ResultAction.ROLLBACK;
        this.respectInterruption = false;
        this.logAuditRecord();
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (this.activeStep != null && this.activeStep.resultHandler != null) {
            this.activeStep.finalizeStep(null);
        }
    }

    private static void throwThrowable(Throwable toThrow) {
        if (toThrow != null) {
            if (toThrow instanceof RuntimeException) {
                throw (RuntimeException)toThrow;
            }
            throw (Error)toThrow;
        }
    }

    private OperationContext.ResultAction getFailedResultAction(Throwable cause) {
        if (this.currentStage == OperationContext.Stage.MODEL || this.cancelled || this.isRollbackOnRuntimeFailure() || this.isRollbackOnly() || cause != null && !(cause instanceof OperationFailedException)) {
            return OperationContext.ResultAction.ROLLBACK;
        }
        return OperationContext.ResultAction.KEEP;
    }

    @Override
    public final ProcessType getProcessType() {
        return this.processType;
    }

    @Override
    public final RunningMode getRunningMode() {
        return this.runningMode;
    }

    @Override
    public final boolean isNormalServer() {
        return this.processType.isServer() && this.runningMode == RunningMode.NORMAL;
    }

    @Override
    public final boolean isRollbackOnly() {
        return this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void setRollbackOnly() {
        this.resultAction = OperationContext.ResultAction.ROLLBACK;
    }

    final boolean isRollingBack() {
        return this.currentStage == OperationContext.Stage.DONE && this.resultAction == OperationContext.ResultAction.ROLLBACK;
    }

    @Override
    public final void reloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.activeStep.restartStamp = this.processState.setReloadRequired();
            this.activeStep.response.get(new String[]{"response-headers", "operation-requires-reload"}).set(true);
        } else {
            this.restartRequired();
        }
    }

    @Override
    public final void restartRequired() {
        this.activeStep.restartStamp = this.processState.setRestartRequired();
        this.activeStep.response.get(new String[]{"response-headers", "operation-requires-restart"}).set(true);
    }

    @Override
    public final void revertReloadRequired() {
        if (this.processState.isReloadSupported()) {
            this.processState.revertReloadRequired(this.activeStep.restartStamp);
            if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-reload")) {
                this.activeStep.response.get("response-headers").remove("operation-requires-reload");
                if (this.activeStep.response.get("response-headers").asInt() == 0) {
                    this.activeStep.response.remove("response-headers");
                }
            }
        } else {
            this.revertRestartRequired();
        }
    }

    @Override
    public final void revertRestartRequired() {
        this.processState.revertRestartRequired(this.activeStep.restartStamp);
        if (this.activeStep.response.get("response-headers").hasDefined("operation-requires-restart")) {
            this.activeStep.response.get("response-headers").remove("operation-requires-restart");
            if (this.activeStep.response.get("response-headers").asInt() == 0) {
                this.activeStep.response.remove("response-headers");
            }
        }
    }

    @Override
    public final void runtimeUpdateSkipped() {
        this.activeStep.response.get(new String[]{"response-headers", "runtime-update-skipped"}).set(true);
    }

    @Override
    public final ModelNode getResult() {
        return this.activeStep.response.get("result");
    }

    @Override
    public final boolean hasResult() {
        return this.activeStep.response.has("result");
    }

    @Override
    public String attachResultStream(String mimeType, InputStream stream) {
        String domainUUID = UUID.randomUUID().toString();
        this.attachResultStream(domainUUID, mimeType, stream);
        return domainUUID;
    }

    @Override
    public synchronized void attachResultStream(String uuid, String mimeType, InputStream stream) {
        if (this.responseStreams == null) {
            this.responseStreams = new LinkedHashMap<String, OperationResponse.StreamEntry>();
        }
        this.responseStreams.put(uuid, new OperationStreamEntry(uuid, mimeType, stream));
    }

    Map<String, OperationResponse.StreamEntry> getResponseStreams() {
        return this.responseStreams;
    }

    @Override
    public final ModelNode getServerResults() {
        if (this.processType != ProcessType.HOST_CONTROLLER) {
            throw ControllerLogger.ROOT_LOGGER.serverResultsAccessNotAllowed(ProcessType.HOST_CONTROLLER, this.processType);
        }
        return this.activeStep.response.get("server-groups");
    }

    private boolean hasMoreSteps() {
        boolean more;
        OperationContext.Stage stage = this.currentStage;
        boolean bl = more = !this.steps.get((Object)stage).isEmpty();
        while (!more && stage.hasNext()) {
            more = !this.steps.get((Object)(stage = stage.next())).isEmpty();
        }
        return more;
    }

    @Override
    public Caller getCaller() {
        Caller response;
        this.caller = response = SecurityActions.getCaller(this.caller);
        return response;
    }

    @Override
    public Environment getCallEnvironment() {
        return this.callEnvironment;
    }

    private static class OperationStreamEntry
    implements OperationResponse.StreamEntry {
        private final InputStream stream;
        private final String mimeType;
        private final String uuid;

        private OperationStreamEntry(String uuid, String mimeType, InputStream stream) {
            this.uuid = uuid;
            this.mimeType = mimeType;
            this.stream = stream;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public InputStream getStream() {
            return this.stream;
        }

        public void close() throws IOException {
            StreamUtils.safeClose((Closeable)this.stream);
        }
    }

    static class OperationId {
        final PathAddress address;
        final String name;

        OperationId(ModelNode operation) {
            this(PathAddress.pathAddress(operation.get("address")), operation.hasDefined("operation") ? operation.get("operation").asString() : null);
        }

        private OperationId(PathAddress address, String name) {
            this.address = address;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperationId that = (OperationId)o;
            return this.address.equals(that.address) && !(this.name == null ? that.name != null : !this.name.equals(that.name));
        }

        public int hashCode() {
            int result = this.address.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    private static class RollbackDelegatingResultHandler
    implements OperationContext.ResultHandler {
        private final OperationContext.RollbackHandler delegate;

        private RollbackDelegatingResultHandler(OperationContext.RollbackHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                this.delegate.handleRollback(context, operation);
            }
        }
    }

    class Step {
        private final Step parent;
        private final OperationStepHandler handler;
        final ModelNode response;
        final ModelNode operation;
        final PathAddress address;
        final OperationId operationId;
        private Object restartStamp;
        private OperationContext.ResultHandler resultHandler;
        ServiceTarget serviceTarget;
        private ServiceVerificationHelper serviceVerificationHelper;
        private Set<ServiceName> addedServices;
        Step predecessor;
        boolean hasRemovals;
        boolean executed;

        private Step(OperationStepHandler handler, ModelNode response, ModelNode operation, PathAddress address) {
            this.parent = AbstractOperationContext.this.activeStep;
            this.handler = handler;
            this.response = response;
            this.operation = operation;
            this.address = address == null ? PathAddress.pathAddress(operation.get("address")) : address;
            String opName = operation.hasDefined("operation") ? operation.require("operation").asString() : null;
            this.operationId = new OperationId(this.address, opName);
            response.get("outcome");
        }

        ServiceTarget getScopedServiceTarget(ServiceTarget parent) {
            if (this.serviceTarget == null) {
                this.serviceTarget = parent.subTarget();
                this.serviceTarget.addMonitor(this.getServiceVerificationHelper().getMonitor());
            }
            return this.serviceTarget;
        }

        void serviceAdded(ServiceController<?> controller) {
            if (!this.executed) {
                this.getAddedServices().add(controller.getName());
            }
        }

        void serviceModeChanged(ServiceController<?> service) {
            assert (service.getMode() != ServiceController.Mode.REMOVE);
            if (!(this.executed || this.addedServices != null && this.addedServices.contains(service.getName()))) {
                service.addListener((ServiceListener)this.getServiceVerificationHelper());
            }
        }

        private List<Step> findPathToRootStep() {
            ArrayList<Step> result = new ArrayList<Step>();
            Step current = this;
            while (current.parent != null) {
                current = current.parent;
                result.add(0, current);
            }
            result.add(this);
            return result;
        }

        private ServiceVerificationHelper getServiceVerificationHelper() {
            if (this.serviceVerificationHelper == null) {
                this.serviceVerificationHelper = new ServiceVerificationHelper();
            }
            return this.serviceVerificationHelper;
        }

        private Set<ServiceName> getAddedServices() {
            if (this.addedServices == null) {
                this.addedServices = new HashSet<ServiceName>();
            }
            return this.addedServices;
        }

        private boolean hasFailed() {
            return this.response.hasDefined("failure-description");
        }

        private void finalizeStep(Throwable toThrow) {
            block10: {
                try {
                    this.finalizeInternal();
                }
                catch (RuntimeException t) {
                    if (toThrow == null) {
                        toThrow = t;
                    }
                }
                catch (Error t) {
                    if (toThrow != null) break block10;
                    toThrow = t;
                }
            }
            Step step = this.predecessor;
            while (step != null) {
                if (step.resultHandler != null) {
                    block11: {
                        try {
                            step.finalizeInternal();
                        }
                        catch (RuntimeException t) {
                            if (toThrow == null) {
                                toThrow = t;
                            }
                        }
                        catch (Error t) {
                            if (toThrow != null) break block11;
                            toThrow = t;
                        }
                    }
                    step = step.predecessor;
                    continue;
                }
                AbstractOperationContext.this.activeStep = step;
                break;
            }
            AbstractOperationContext.throwThrowable(toThrow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finalizeInternal() {
            AbstractOperationContext.this.activeStep = this;
            try {
                this.handleResult();
                if (AbstractOperationContext.this.currentStage != null && AbstractOperationContext.this.currentStage != OperationContext.Stage.DONE) {
                    AbstractOperationContext.this.currentStage = OperationContext.Stage.DONE;
                    if (!this.hasFailed()) {
                        this.response.get("failure-description").set(ControllerLogger.ROOT_LOGGER.operationHandlerFailedToComplete());
                    }
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                    AbstractOperationContext.this.resultAction = AbstractOperationContext.this.getFailedResultAction(null);
                } else if (AbstractOperationContext.this.resultAction == OperationContext.ResultAction.ROLLBACK) {
                    this.response.get("outcome").set(AbstractOperationContext.this.cancelled ? "cancelled" : "failed");
                    this.response.get("rolled-back").set(true);
                } else {
                    this.response.get("outcome").set(this.hasFailed() ? "failed" : "success");
                }
            }
            finally {
                AbstractOperationContext.this.releaseStepLocks(this);
                if (this.predecessor == null) {
                    AbstractOperationContext.this.currentStage = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResult() {
            this.hasRemovals = false;
            try {
                try {
                    this.rollbackAddedServices();
                }
                finally {
                    try {
                        this.invokeResultHandler();
                    }
                    finally {
                        if (this.hasRemovals) {
                            AbstractOperationContext.this.waitForRemovals();
                        }
                    }
                }
            }
            catch (Exception e) {
                AbstractOperationContext.this.report(MessageSeverity.ERROR, ControllerLogger.ROOT_LOGGER.stepHandlerFailedRollback(this.handler, this.operation.asString(), this.address, e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeResultHandler() {
            if (this.resultHandler != null) {
                try {
                    ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(this.handler.getClass());
                    try {
                        this.resultHandler.handleResult(AbstractOperationContext.this.resultAction, AbstractOperationContext.this, this.operation);
                    }
                    finally {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                    }
                }
                finally {
                    this.resultHandler = null;
                }
            }
        }

        private void rollbackAddedServices() {
            if (AbstractOperationContext.this.resultAction == OperationContext.ResultAction.ROLLBACK && this.addedServices != null) {
                for (ServiceName serviceName : this.addedServices) {
                    AbstractOperationContext.this.removeService(serviceName);
                }
            }
        }
    }

    static enum ContextFlag {
        ROLLBACK_ON_FAIL,
        ALLOW_RESOURCE_SERVICE_RESTART;

    }
}

