/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;

public class ClientConfigurationImpl
implements ModelControllerClientConfiguration {
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private final String address;
    private final int port;
    private final CallbackHandler handler;
    private final Map<String, String> saslOptions;
    private final SSLContext sslContext;
    private final ExecutorService executorService;
    private final String protocol;
    private final boolean shutdownExecutor;
    private final int connectionTimeout;

    public ClientConfigurationImpl(String address, int port, CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext, ExecutorService executorService, boolean shutdownExecutor, int connectionTimeout, String protocol) {
        this.address = address;
        this.port = port;
        this.handler = handler;
        this.saslOptions = saslOptions;
        this.sslContext = sslContext;
        this.executorService = executorService;
        this.shutdownExecutor = shutdownExecutor;
        this.protocol = protocol;
        this.connectionTimeout = connectionTimeout > 0 ? connectionTimeout : 5000;
    }

    @Override
    public String getHost() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    @Override
    public Map<String, String> getSaslOptions() {
        return this.saslOptions;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executorService;
    }

    @Override
    public void close() {
        if (this.shutdownExecutor && this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

