/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.CommandSubstitutionException;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.UnresolvedExpressionException;
import org.jboss.as.cli.parsing.UnresolvedVariableException;
import org.jboss.as.cli.util.CLIExpressionResolver;

public class StateParser {
    private final DefaultParsingState initialState = new DefaultParsingState("INITIAL");

    public void addState(char ch, ParsingState state) {
        this.initialState.enterState(ch, state);
    }

    public String parse(String str, ParsingStateCallbackHandler callbackHandler) throws CommandFormatException {
        return StateParser.parse(str, callbackHandler, this.initialState);
    }

    public static String parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState) throws CommandFormatException {
        return StateParser.parseLine(str, callbackHandler, initialState).getSubstitued();
    }

    public static SubstitutedLine parseLine(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState) throws CommandFormatException {
        return StateParser.parseLine(str, callbackHandler, initialState, true);
    }

    public static String parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        return StateParser.parseLine(str, callbackHandler, initialState, strict).getSubstitued();
    }

    public static SubstitutedLine parseLine(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict) throws CommandFormatException {
        return StateParser.parseLine(str, callbackHandler, initialState, strict, null);
    }

    public static SubstitutedLine parseLine(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, CommandContext ctx) throws CommandFormatException {
        return StateParser.parseLine(str, callbackHandler, initialState, true, ctx);
    }

    public static String parse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict, CommandContext ctx) throws CommandFormatException {
        return StateParser.parseLine(str, callbackHandler, initialState, strict, ctx).getSubstitued();
    }

    public static SubstitutedLine parseLine(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict, CommandContext ctx) throws CommandFormatException {
        return StateParser.parseLine(str, callbackHandler, initialState, strict, false, ctx);
    }

    public static SubstitutedLine parseLine(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict, boolean disableResolutionException, CommandContext ctx) throws CommandFormatException {
        try {
            return StateParser.doParse(str, callbackHandler, initialState, strict, disableResolutionException, ctx);
        }
        catch (CommandFormatException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CommandFormatException("Failed to parse '" + str + "'", t);
        }
    }

    protected static SubstitutedLine doParse(String str, ParsingStateCallbackHandler callbackHandler, ParsingState initialState, boolean strict, boolean disableResolutionException, CommandContext cmdCtx) throws CommandFormatException {
        if (str == null || str.isEmpty()) {
            return new SubstitutedLine(str);
        }
        ParsingContextImpl ctx = new ParsingContextImpl();
        ctx.initialState = initialState;
        ctx.callbackHandler = callbackHandler;
        ctx.input = str;
        ctx.strict = strict;
        ctx.cmdCtx = cmdCtx;
        ctx.disableResolutionException = disableResolutionException;
        ctx.substitued.substitued = ctx.parse();
        return ctx.substitued;
    }

    static class ParsingContextImpl
    implements ParsingContext {
        private final Deque<ParsingState> stack = new ArrayDeque<ParsingState>();
        String input;
        String originalInput;
        int location;
        char ch;
        ParsingStateCallbackHandler callbackHandler;
        ParsingState initialState;
        boolean strict;
        boolean disableResolutionException;
        CommandFormatException error;
        CommandContext cmdCtx;
        private final SubstitutedLine substitued = new SubstitutedLine();
        private final Deque<Character> lookFor = new ArrayDeque<Character>();
        int lastMetLookForIndex = -1;
        private char deactivated;

        ParsingContextImpl() {
        }

        String parse() throws CommandFormatException {
            this.ch = this.input.charAt(0);
            this.originalInput = this.input;
            this.location = 0;
            this.initialState.getEnterHandler().handle(this);
            while (this.location < this.input.length()) {
                this.ch = this.input.charAt(this.location);
                CharacterHandler handler = this.getState().getHandler(this.ch);
                handler.handle(this);
                ++this.location;
            }
            ParsingState state = this.getState();
            while (state != this.initialState) {
                state.getEndContentHandler().handle(this);
                this.leaveState();
                state = this.getState();
            }
            this.initialState.getEndContentHandler().handle(this);
            this.initialState.getLeaveHandler().handle(this);
            return this.input;
        }

        @Override
        public void resolveExpression(boolean systemProperty, boolean exceptionIfNotResolved) throws UnresolvedExpressionException {
            int inputLength = this.input.length();
            if (inputLength - this.location < 2) {
                return;
            }
            char firstChar = this.input.charAt(this.location);
            if (firstChar == '$') {
                if (this.input.charAt(this.location + 1) == '{') {
                    if (systemProperty) {
                        this.input = CLIExpressionResolver.resolveProperty(this.input, this.location, exceptionIfNotResolved);
                        this.ch = this.input.charAt(this.location);
                    }
                } else {
                    this.substituteVariable(exceptionIfNotResolved);
                }
            } else if (firstChar == '`') {
                this.substituteCommand(exceptionIfNotResolved);
            }
        }

        private void substituteCommand(boolean exceptionIfNotResolved) throws CommandSubstitutionException {
            if (this.location + 1 == this.input.length()) {
                throw new CommandSubstitutionException("", "Command is missing after `");
            }
            int endQuote = this.firstNotEscaped('`', this.location + 1);
            if (endQuote - this.location <= 1) {
                throw new CommandSubstitutionException(this.input.substring(this.location + 1), "Closing ` is missing for " + this.input.substring(this.location, Math.min(this.location + 5, this.input.length())) + "...");
            }
            String cmd = this.input.substring(this.location + 1, endQuote);
            String resolved = Util.getResult(this.cmdCtx, cmd);
            StringBuilder buf = new StringBuilder(this.input.length() - cmd.length() - 2 + resolved.length());
            buf.append(this.input.substring(0, this.location)).append(resolved);
            if (endQuote < this.input.length() - 1) {
                buf.append(this.input.substring(endQuote + 1));
            }
            this.input = buf.toString();
            this.ch = this.input.charAt(this.location);
        }

        private int firstNotEscaped(char ch, int start) {
            int index = this.input.indexOf(ch, start);
            if (index < 0) {
                return index;
            }
            if (this.input.charAt(index - 1) == '\\') {
                int i = index - 2;
                boolean escaped = true;
                while (i - start >= 0 && this.input.charAt(i) == '\\') {
                    --i;
                    escaped = !escaped;
                }
                if (escaped) {
                    if (index + 1 < this.input.length() - 1) {
                        return this.firstNotEscaped(ch, index + 1);
                    }
                    return -1;
                }
            }
            return index;
        }

        private void substituteVariable(boolean exceptionIfNotResolved) throws UnresolvedVariableException {
            String value;
            int endIndex = this.location + 1;
            char c = this.input.charAt(endIndex);
            if (endIndex >= this.input.length() || !Character.isJavaIdentifierStart(c) || c == '$') {
                return;
            }
            while (++endIndex < this.input.length() && Character.isJavaIdentifierPart(c = this.input.charAt(endIndex)) && c != '$') {
            }
            String name = this.input.substring(this.location + 1, endIndex);
            String string = value = this.cmdCtx == null ? null : this.cmdCtx.getVariable(name);
            if (value == null) {
                if (exceptionIfNotResolved && !this.disableResolutionException) {
                    throw new UnresolvedVariableException(name, "Unrecognized variable " + name);
                }
            } else {
                this.substitued.add("$" + name, value, this.location);
                StringBuilder buf = new StringBuilder(this.input.length() - name.length() + value.length());
                buf.append(this.input.substring(0, this.location)).append(value);
                if (endIndex < this.input.length()) {
                    buf.append(this.input.substring(endIndex));
                }
                this.input = buf.toString();
                this.ch = this.input.charAt(this.location);
            }
        }

        @Override
        public boolean replaceSpecialChars() {
            if (this.location == 0) {
                return false;
            }
            if (this.input.charAt(this.location - 1) != '\\') {
                return false;
            }
            switch (this.ch) {
                case 'n': {
                    this.ch = (char)10;
                    break;
                }
                case 't': {
                    this.ch = (char)9;
                    break;
                }
                case 'b': {
                    this.ch = (char)8;
                    break;
                }
                case 'r': {
                    this.ch = (char)13;
                    break;
                }
                case 'f': {
                    this.ch = (char)12;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isStrict() {
            return this.strict;
        }

        @Override
        public ParsingState getState() {
            return this.stack.isEmpty() ? this.initialState : this.stack.peek();
        }

        @Override
        public void enterState(ParsingState state) throws CommandFormatException {
            this.stack.push(state);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public ParsingState leaveState() throws CommandFormatException {
            this.stack.peek().getLeaveHandler().handle(this);
            this.callbackHandler.leavingState(this);
            ParsingState pop = this.stack.pop();
            if (!this.stack.isEmpty()) {
                this.stack.peek().getReturnHandler().handle(this);
            } else {
                this.initialState.getReturnHandler().handle(this);
            }
            return pop;
        }

        @Override
        public ParsingStateCallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        @Override
        public char getCharacter() {
            return this.ch;
        }

        @Override
        public int getLocation() {
            return this.location;
        }

        @Override
        public void reenterState() throws CommandFormatException {
            this.callbackHandler.leavingState(this);
            ParsingState state = this.stack.peek();
            state.getLeaveHandler().handle(this);
            this.callbackHandler.enteredState(this);
            state.getEnterHandler().handle(this);
        }

        @Override
        public boolean isEndOfContent() {
            return this.location >= this.input.length();
        }

        @Override
        public String getInput() {
            return this.input;
        }

        @Override
        public void advanceLocation(int offset) throws IndexOutOfBoundsException {
            if (this.isEndOfContent()) {
                throw new IndexOutOfBoundsException("Location=" + this.location + ", offset=" + offset + ", length=" + this.input.length());
            }
            this.location += offset;
            if (this.location < this.input.length()) {
                this.ch = this.input.charAt(this.location);
            }
        }

        @Override
        public CommandFormatException getError() {
            return this.error;
        }

        @Override
        public void setError(CommandFormatException e) {
            if (this.error == null) {
                this.error = e;
            }
        }

        @Override
        public void lookFor(char ch) {
            this.lookFor.push(Character.valueOf(ch));
        }

        @Override
        public boolean meetIfLookedFor(char ch) {
            if (this.lastMetLookForIndex == this.location || this.lookFor.isEmpty() || this.lookFor.peek().charValue() != ch) {
                return false;
            }
            this.lookFor.pop();
            this.lastMetLookForIndex = this.location;
            return true;
        }

        @Override
        public boolean isLookingFor(char c) {
            return !this.lookFor.isEmpty() && this.lookFor.peek().charValue() == c;
        }

        @Override
        public void deactivateControl(char c) {
            if (this.deactivated != '\u0000') {
                throw new IllegalStateException("Current implementation supports only one deactivated character at a time.");
            }
            this.deactivated = c;
        }

        @Override
        public void activateControl(char c) {
            if (this.deactivated == c) {
                this.deactivated = '\u0000';
            }
        }

        @Override
        public boolean isDeactivated(char c) {
            return this.deactivated == c;
        }
    }

    public static class Substitution {
        private final String original;
        private final String substitution;
        private final int substitutionIndex;
        private final int originalIndex;

        private Substitution(String original, String substitution, int substitutionIndex, int originalIndex) {
            this.original = original;
            this.substitution = substitution;
            this.substitutionIndex = substitutionIndex;
            this.originalIndex = originalIndex;
        }
    }

    public static class SubstitutedLine {
        private final List<Substitution> substitutions = new ArrayList<Substitution>();
        private String substitued;
        private int currentOriginalIndex;

        SubstitutedLine() {
        }

        SubstitutedLine(String str) {
            this.substitued = str;
        }

        public String getSubstitued() {
            return this.substitued;
        }

        public List<Substitution> getSubstitions() {
            return Collections.unmodifiableList(this.substitutions);
        }

        public int getOriginalOffset(int substituedOffset) {
            if (this.substitutions.isEmpty()) {
                return substituedOffset;
            }
            int delta = 0;
            for (Substitution sub : this.getSubstitions()) {
                if (sub.substitutionIndex >= substituedOffset) break;
                delta += sub.original.length() - sub.substitution.length();
            }
            return substituedOffset + delta;
        }

        private void add(String original, String substitution, int location) {
            int orig = location - this.currentOriginalIndex;
            this.currentOriginalIndex += substitution.length() - original.length();
            this.substitutions.add(new Substitution(original, substitution, location, orig));
        }
    }
}

