/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import org.aesh.command.CommandException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ElytronUtil;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStore;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.dmr.ModelNode;

public class KeyStorePathSecurityBuilder
extends SSLSecurityBuilder {
    private final File path;
    private final String password;
    private String relativeTo;
    private String type;
    private String name;

    public KeyStorePathSecurityBuilder(File path, String password) throws CommandException {
        if (path == null || password == null) {
            throw new CommandException("key-store path and password can't be null");
        }
        this.path = path;
        this.password = password;
    }

    public KeyStorePathSecurityBuilder setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
        return this;
    }

    public KeyStorePathSecurityBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public KeyStorePathSecurityBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    protected KeyStore buildKeyStore(CommandContext ctx, boolean buildRequest) throws Exception {
        boolean lookupExisting = false;
        this.validateOptions(ctx);
        if (this.name == null) {
            this.name = DefaultResourceNames.buildDefaultKeyStoreName(this.path, ctx);
            lookupExisting = true;
        }
        if (this.type == null) {
            this.type = DefaultResourceNames.buildDefaultKeyStoreType(this.type, ctx);
        }
        String kName = null;
        if (lookupExisting) {
            kName = ElytronUtil.findMatchingKeyStore(ctx, this.path, this.relativeTo, this.password, this.type, null, null);
        }
        boolean existing = false;
        if (kName == null) {
            ModelNode request = ElytronUtil.addKeyStore(ctx, this.name, this.path, this.relativeTo, this.password, this.type, null, null);
            this.addStep(request, new SSLSecurityBuilder.FailureDescProvider(){

                @Override
                public String stepFailedDescription() {
                    return "Adding key-store using file " + String.valueOf(KeyStorePathSecurityBuilder.this.path);
                }
            });
        } else {
            existing = true;
            this.name = kName;
        }
        return new KeyStore(this.name, this.password, existing);
    }

    private void validateOptions(CommandContext ctx) throws Exception {
        if (this.relativeTo == null && !this.path.exists()) {
            throw new CommandException("key-store path doesn't exist");
        }
        if (this.name != null && ElytronUtil.keyStoreExists(ctx, this.name)) {
            throw new CommandException("key-store " + this.name + " already exists");
        }
    }

    @Override
    protected void doFailureOccured(CommandContext ctx) {
    }
}

