/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.AwaiterModelControllerClient;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.xnio.http.RedirectException;

public class ShutdownHandler
extends BaseOperationCommand {
    private final ArgumentWithValue restart;
    private final ArgumentWithValue host;
    @Deprecated
    private final ArgumentWithValue timeout;
    private final ArgumentWithValue suspendTimeout;
    private final AtomicReference<EmbeddedProcessLaunch> embeddedServerRef;
    private PerNodeOperationAccess hostShutdownPermission;
    private final ArgumentWithValue performInstallation;

    public ShutdownHandler(CommandContext ctx, AtomicReference<EmbeddedProcessLaunch> embeddedServerRef) {
        super(ctx, "shutdown", true, false);
        this.embeddedServerRef = embeddedServerRef;
        this.restart = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--restart"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ShutdownHandler.this.performInstallation.isPresent(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.timeout = new ArgumentWithValue(this, "--timeout"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode()) {
                    return false;
                }
                if (ShutdownHandler.this.suspendTimeout.isPresent(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.suspendTimeout = new ArgumentWithValue(this, "--suspend-timeout"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ShutdownHandler.this.timeout.isPresent(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.host = new ArgumentWithValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                return ShutdownHandler.this.hostShutdownPermission.getAllowedOn(ctx);
            }
        }, "--host"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.performInstallation = new ArgumentWithValue(this, SimpleTabCompleter.BOOLEAN, "--perform-installation"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ShutdownHandler.this.restart.isPresent(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.hostShutdownPermission = new PerNodeOperationAccess(ctx, "host", null, "shutdown");
        return AccessRequirementBuilder.Factory.create(ctx).any().operation("shutdown").requirement(this.hostShutdownPermission).build();
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return super.isAvailable(ctx) && (this.embeddedServerRef == null || this.embeddedServerRef.get() == null);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        boolean requestRestart;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandLineException("Connection is not available.");
        }
        if (this.embeddedServerRef != null && this.embeddedServerRef.get() != null) {
            this.embeddedServerRef.get().stop();
            return;
        }
        if (!(client instanceof AwaiterModelControllerClient)) {
            throw new CommandLineException("Unsupported ModelControllerClient implementation " + client.getClass().getName());
        }
        AwaiterModelControllerClient cliClient = (AwaiterModelControllerClient)client;
        ModelNode op = this.buildRequestWithoutHeaders(ctx);
        boolean isPerformInstallation = "true".equalsIgnoreCase(this.performInstallation.getValue(ctx.getParsedCommandLine()));
        boolean disconnect = true;
        boolean bl = requestRestart = "true".equalsIgnoreCase(this.restart.getValue(ctx.getParsedCommandLine())) || isPerformInstallation;
        if (requestRestart || ctx.isDomainMode() && !this.isLocalHost(ctx.getModelControllerClient(), this.host.getValue(ctx.getParsedCommandLine()))) {
            disconnect = false;
        }
        ModelNode clientMarker = ShutdownHandler.executeOperation(client, cliClient, op, true);
        if ("true".equalsIgnoreCase(this.performInstallation.getValue(ctx.getParsedCommandLine()))) {
            boolean isLocalClient = true;
            if (clientMarker != null) {
                String clientMarkerData = WildFlySecurityManager.getPropertyPrivileged((String)"cli-marker-value", null);
                if (clientMarkerData != null && !clientMarker.asString().equals(clientMarkerData)) {
                    isLocalClient = false;
                }
            } else {
                isLocalClient = false;
            }
            if (isLocalClient) {
                ctx.printLine("The JBoss CLI session will be closed automatically to allow the server be updated. Once the server has been restarted, you can relaunch the JBoss CLI session.", false);
                ctx.terminateSession();
                return;
            }
        }
        if (disconnect) {
            ctx.disconnectController();
        } else {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new CommandLineException("Interrupted while pausing before reconnecting.", e);
            }
            try {
                long configuredTimeout = (long)ctx.getConfig().getConnectionTimeout() + 1000L;
                configuredTimeout = isPerformInstallation ? configuredTimeout + 60000L : configuredTimeout;
                cliClient.ensureConnected(configuredTimeout);
            }
            catch (CommandLineException e) {
                ctx.disconnectController();
                throw e;
            }
            catch (IOException ex) {
                if (ex instanceof RedirectException) {
                    if (!Util.reconnectContext((RedirectException)((Object)ex), ctx)) {
                        throw new CommandLineException("Can't reconnect context.", ex);
                    }
                }
                throw new CommandLineException(ex);
            }
        }
    }

    private static ModelNode executeOperation(ModelControllerClient client, AwaiterModelControllerClient cliClient, ModelNode op, boolean awaitClose) throws CommandLineException {
        block4: {
            try {
                ModelNode response = cliClient.execute(op, awaitClose);
                if (!Util.isSuccess(response)) {
                    throw new CommandLineException(Util.getFailureDescription(response));
                }
                if (response.hasDefined(new String[]{"result", "cli-marker-value"})) {
                    return response.get(new String[]{"result", "cli-marker-value"});
                }
            }
            catch (IOException e) {
                if (!cliClient.isConnected()) break block4;
                StreamUtils.safeClose((Closeable)client);
                throw new CommandLineException("Failed to execute :shutdown", e);
            }
        }
        return null;
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ModelNode op = new ModelNode();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (ctx.isDomainMode()) {
            String hostName = this.host.getValue(args);
            if (hostName == null) {
                throw new CommandFormatException("Missing required argument " + this.host.getFullName());
            }
            op.get("address").add("host", hostName);
            if (this.timeout.isPresent(args)) {
                throw new CommandFormatException(this.timeout.getFullName() + " is not allowed in the domain mode.");
            }
        } else {
            if (this.host.isPresent(args)) {
                throw new CommandFormatException(this.host.getFullName() + " is not allowed in the standalone mode.");
            }
            if (this.timeout.isPresent(args) && this.suspendTimeout.isPresent(args)) {
                throw new CommandFormatException(this.timeout.getFullName() + " cannot be used in conjunction with suspend-timeout.");
            }
            op.get("address").setEmptyList();
        }
        if (this.restart.isPresent(args) && this.performInstallation.isPresent(args)) {
            throw new CommandFormatException(this.performInstallation.getFullName() + " cannot be used in conjunction with restart.");
        }
        op.get("operation").set("shutdown");
        this.setBooleanArgument(args, op, this.restart, "restart");
        this.setBooleanArgument(args, op, this.performInstallation, "perform-installation");
        this.setIntArgument(args, op, this.timeout, "timeout");
        this.setIntArgument(args, op, this.suspendTimeout, "suspend-timeout");
        return op;
    }

    protected boolean isLocalHost(ModelControllerClient client, String host) throws CommandLineException {
        ModelNode response;
        ModelNode request = new ModelNode();
        request.get("address").setEmptyList();
        request.get("operation").set("read-attribute");
        request.get("name").set("local-host-name");
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to read attribute local-host-name", e);
        }
        if (!Util.isSuccess(response)) {
            throw new CommandLineException("Failed to read attribute local-host-name: " + Util.getFailureDescription(response));
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("The result is not defined for attribute local-host-name: " + String.valueOf(result));
        }
        return result.asString().equals(host);
    }

    protected void setBooleanArgument(ParsedCommandLine args, ModelNode op, ArgumentWithValue arg, String paramName) throws CommandFormatException {
        if (!arg.isPresent(args)) {
            return;
        }
        String value = arg.getValue(args);
        if (value == null) {
            throw new CommandFormatException(arg.getFullName() + " is missing value.");
        }
        if (value.equalsIgnoreCase("true")) {
            op.get(paramName).set(true);
        } else if (value.equalsIgnoreCase("false")) {
            op.get(paramName).set(false);
        } else {
            throw new CommandFormatException("Invalid value for " + arg.getFullName() + ": '" + value + "'");
        }
    }

    private void setIntArgument(ParsedCommandLine args, ModelNode op, ArgumentWithValue arg, String paramName) throws CommandFormatException {
        if (!arg.isPresent(args)) {
            return;
        }
        String value = arg.getValue(args);
        if (value == null) {
            throw new CommandFormatException(arg.getFullName() + " is missing value.");
        }
        try {
            Integer i = Integer.parseInt(value);
            op.get(paramName).set(i.intValue());
        }
        catch (NumberFormatException nfe) {
            throw new CommandFormatException("Invalid value for " + arg.getFullName() + ": '" + value + "'");
        }
    }
}

