/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslException;
import org.jboss.aesh.console.AeshConsoleCallback;
import org.jboss.aesh.console.ConsoleCallback;
import org.jboss.aesh.console.ConsoleOperation;
import org.jboss.aesh.console.Process;
import org.jboss.aesh.console.helper.InterruptHook;
import org.jboss.aesh.console.settings.FileAccessPermission;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandCompleter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHandlerProvider;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandLineRedirection;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.ConnectionInfo;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.ControllerAddressResolver;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.RequestWithAttachments;
import org.jboss.as.cli.SSLConfig;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.batch.impl.DefaultBatchManager;
import org.jboss.as.cli.batch.impl.DefaultBatchedCommand;
import org.jboss.as.cli.embedded.EmbeddedControllerHandlerRegistrar;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.handlers.ArchiveHandler;
import org.jboss.as.cli.handlers.AttachmentHandler;
import org.jboss.as.cli.handlers.ClearScreenHandler;
import org.jboss.as.cli.handlers.CommandCommandHandler;
import org.jboss.as.cli.handlers.CommandTimeoutHandler;
import org.jboss.as.cli.handlers.ConnectHandler;
import org.jboss.as.cli.handlers.ConnectionInfoHandler;
import org.jboss.as.cli.handlers.DeployHandler;
import org.jboss.as.cli.handlers.DeploymentInfoHandler;
import org.jboss.as.cli.handlers.DeploymentOverlayHandler;
import org.jboss.as.cli.handlers.EchoDMRHandler;
import org.jboss.as.cli.handlers.EchoVariableHandler;
import org.jboss.as.cli.handlers.GenericTypeOperationHandler;
import org.jboss.as.cli.handlers.HelpHandler;
import org.jboss.as.cli.handlers.HistoryHandler;
import org.jboss.as.cli.handlers.LsHandler;
import org.jboss.as.cli.handlers.OperationRequestHandler;
import org.jboss.as.cli.handlers.PrefixHandler;
import org.jboss.as.cli.handlers.PrintWorkingNodeHandler;
import org.jboss.as.cli.handlers.QuitHandler;
import org.jboss.as.cli.handlers.ReadAttributeHandler;
import org.jboss.as.cli.handlers.ReadOperationHandler;
import org.jboss.as.cli.handlers.ReloadHandler;
import org.jboss.as.cli.handlers.SetVariableHandler;
import org.jboss.as.cli.handlers.ShutdownHandler;
import org.jboss.as.cli.handlers.UndeployHandler;
import org.jboss.as.cli.handlers.UnsetVariableHandler;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.handlers.batch.BatchClearHandler;
import org.jboss.as.cli.handlers.batch.BatchDiscardHandler;
import org.jboss.as.cli.handlers.batch.BatchEditLineHandler;
import org.jboss.as.cli.handlers.batch.BatchHandler;
import org.jboss.as.cli.handlers.batch.BatchHoldbackHandler;
import org.jboss.as.cli.handlers.batch.BatchListHandler;
import org.jboss.as.cli.handlers.batch.BatchMoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRemoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRunHandler;
import org.jboss.as.cli.handlers.ifelse.ElseHandler;
import org.jboss.as.cli.handlers.ifelse.EndIfHandler;
import org.jboss.as.cli.handlers.ifelse.IfHandler;
import org.jboss.as.cli.handlers.jca.DataSourceAddCompositeHandler;
import org.jboss.as.cli.handlers.jca.JDBCDriverInfoHandler;
import org.jboss.as.cli.handlers.jca.JDBCDriverNameProvider;
import org.jboss.as.cli.handlers.jca.XADataSourceAddCompositeHandler;
import org.jboss.as.cli.handlers.module.ASModuleHandler;
import org.jboss.as.cli.handlers.trycatch.CatchHandler;
import org.jboss.as.cli.handlers.trycatch.EndTryHandler;
import org.jboss.as.cli.handlers.trycatch.FinallyHandler;
import org.jboss.as.cli.handlers.trycatch.TryHandler;
import org.jboss.as.cli.impl.CLIPrintStream;
import org.jboss.as.cli.impl.CliConfigImpl;
import org.jboss.as.cli.impl.CliLauncher;
import org.jboss.as.cli.impl.CliShutdownHook;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.jboss.as.cli.impl.CommandExecutor;
import org.jboss.as.cli.impl.ConnectionInfoBean;
import org.jboss.as.cli.impl.Console;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.impl.ExtensionsLoader;
import org.jboss.as.cli.impl.HeadersArgumentValueConverter;
import org.jboss.as.cli.impl.ModelControllerClientFactory;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.NodePathFormatter;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;
import org.jboss.as.cli.operation.impl.RolloutPlanCompleter;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.as.cli.util.FingerprintGenerator;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.protocol.GeneralTimeoutHandler;
import org.jboss.as.protocol.ProtocolTimeoutHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.stdio.StdioContext;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.OptionalNameCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.client.MatchRule;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.util.CodePointIterator;
import org.xnio.http.RedirectException;

class CommandContextImpl
implements CommandContext,
ModelControllerClientFactory.ConnectionCloseHandler {
    private static final Logger log = Logger.getLogger(CommandContext.class);
    private static final byte RUNNING = 0;
    private static final byte TERMINATING = 1;
    private static final byte TERMINATED = 2;
    private boolean INTERACT = false;
    private boolean SILENT = false;
    private boolean ERROR_ON_INTERACT = false;
    private final CliConfig config;
    private final ControllerAddressResolver addressResolver;
    private final CommandRegistry cmdRegistry = new CommandRegistry();
    private ExtensionsLoader extLoader;
    private Console console;
    private byte terminate;
    private String cmdLine;
    private DefaultCallbackHandler parsedCmd = new DefaultCallbackHandler(true);
    private boolean domainMode;
    private ModelControllerClient client;
    private ControllerAddress currentAddress;
    private final String username;
    private final char[] password;
    private final boolean disableLocalAuth;
    private boolean defaultSslContext;
    private SSLContext sslContext;
    private LazyDelagatingTrustManager trustManager;
    private Map<CommandContext.Scope, Map<String, Object>> map = new HashMap<CommandContext.Scope, Map<String, Object>>();
    private final OperationRequestAddress prefix = new DefaultOperationRequestAddress();
    private final NodePathFormatter prefixFormatter = DefaultPrefixFormatter.INSTANCE;
    private final OperationCandidatesProvider operationCandidatesProvider;
    private final OperationRequestHandler operationHandler;
    private BatchManager batchManager = new DefaultBatchManager();
    private final CommandCompleter cmdCompleter;
    private final GeneralTimeoutHandler timeoutHandler = new GeneralTimeoutHandler();
    private final String clientBindAddress;
    private BufferedWriter outputTarget;
    private List<CliEventListener> listeners = new ArrayList<CliEventListener>();
    private int exitCode;
    private File currentDir = new File("");
    private boolean resolveParameterValues;
    private Map<String, String> variables;
    private CliShutdownHook.Handler shutdownHook;
    private CommandLineRedirectionRegistration redirection;
    private ConnectionInfoBean connInfoBean;
    private final CLIPrintStream cliPrintStream;
    private boolean uninstallIO;
    private static JaasConfigurationWrapper jaasConfigurationWrapper;
    private final boolean echoCommand;
    private static final short DEFAULT_TIMEOUT = 0;
    private int timeout = 0;
    private int configTimeout;
    private ControllerAddress connectionAddress;
    private StringBuilder lineBuffer;
    private StringBuilder origLineBuffer;
    private CommandExecutor executor = new CommandExecutor(this);
    String promptConnectPart;

    CommandContextImpl() throws CliInitializationException {
        this.console = null;
        this.operationCandidatesProvider = null;
        this.cmdCompleter = null;
        this.operationHandler = new OperationRequestHandler();
        this.initStdIO();
        try {
            this.initCommands();
        }
        catch (CommandLineException e) {
            throw new CliInitializationException("Failed to initialize commands", e);
        }
        this.config = CliConfigImpl.load(this);
        this.addressResolver = ControllerAddressResolver.newInstance(this.config, null);
        this.resolveParameterValues = this.config.isResolveParameterValues();
        this.SILENT = this.config.isSilent();
        this.ERROR_ON_INTERACT = this.config.isErrorOnInteract();
        this.echoCommand = this.config.isEchoCommand();
        this.configTimeout = this.config.getCommandTimeout() == null ? 0 : this.config.getCommandTimeout();
        this.setCommandTimeout(this.configTimeout);
        this.username = null;
        this.password = null;
        this.disableLocalAuth = false;
        this.clientBindAddress = null;
        this.cliPrintStream = new CLIPrintStream();
        this.initSSLContext();
        this.initJaasConfig();
        this.addShutdownHook();
        CliLauncher.runcom(this);
    }

    CommandContextImpl(CommandContextConfiguration configuration) throws CliInitializationException {
        this.config = CliConfigImpl.load(this, configuration);
        this.addressResolver = ControllerAddressResolver.newInstance(this.config, configuration.getController());
        this.operationHandler = new OperationRequestHandler();
        this.username = configuration.getUsername();
        this.password = configuration.getPassword();
        this.disableLocalAuth = configuration.isDisableLocalAuth();
        this.clientBindAddress = configuration.getClientBindAddress();
        this.SILENT = this.config.isSilent();
        this.ERROR_ON_INTERACT = this.config.isErrorOnInteract();
        this.echoCommand = this.config.isEchoCommand();
        this.configTimeout = this.config.getCommandTimeout() == null ? 0 : this.config.getCommandTimeout();
        this.setCommandTimeout(this.configTimeout);
        this.resolveParameterValues = this.config.isResolveParameterValues();
        this.cliPrintStream = configuration.getConsoleOutput() == null ? new CLIPrintStream() : new CLIPrintStream(configuration.getConsoleOutput());
        this.initStdIO();
        try {
            this.initCommands();
        }
        catch (CommandLineException e) {
            throw new CliInitializationException("Failed to initialize commands", e);
        }
        this.initSSLContext();
        this.initJaasConfig();
        if (configuration.isInitConsole() || configuration.getConsoleInput() != null) {
            this.cmdCompleter = new CommandCompleter(this.cmdRegistry);
            this.initBasicConsole(configuration.getConsoleInput(), false);
            this.console.addCompleter(this.cmdCompleter);
            this.operationCandidatesProvider = new DefaultOperationCandidatesProvider();
        } else {
            this.cmdCompleter = null;
            this.operationCandidatesProvider = null;
        }
        this.addShutdownHook();
        CliLauncher.runcom(this);
    }

    protected void addShutdownHook() {
        this.shutdownHook = new CliShutdownHook.Handler(){

            @Override
            public void shutdown() {
                if (CommandContextImpl.this.console != null) {
                    CommandContextImpl.this.console.interrupt();
                }
                CommandContextImpl.this.terminateSession();
            }
        };
        CliShutdownHook.add(this.shutdownHook);
    }

    protected void initBasicConsole(InputStream consoleInput) throws CliInitializationException {
        this.initBasicConsole(consoleInput, true);
    }

    protected void initBasicConsole(InputStream consoleInput, boolean start) throws CliInitializationException {
        assert (this.console == null) : "the console has already been initialized";
        Settings settings = this.createSettings(consoleInput);
        this.console = Console.Factory.getConsole(this, settings);
        this.console.setCallback(this.initCallback());
        if (start) {
            this.console.start();
        }
    }

    private ConsoleCallback initCallback() {
        return new CLIAeshConsoleCallback(){

            public int execute(ConsoleOperation output) throws InterruptedException {
                this.setActiveProcess(true);
                try {
                    if (CommandContextImpl.this.cmdCompleter == null) {
                        throw new IllegalStateException("The console hasn't been initialized at construction time.");
                    }
                    if (output.getBuffer() == null) {
                        CommandContextImpl.this.terminateSession();
                    } else {
                        CommandContextImpl.this.handleSafe(output.getBuffer().trim());
                        if (CommandContextImpl.this.INTERACT && CommandContextImpl.this.terminate == 0) {
                            CommandContextImpl.this.console.setPrompt(CommandContextImpl.this.getPrompt());
                        }
                    }
                    int n = 0;
                    return n;
                }
                finally {
                    this.setActiveProcess(false);
                }
            }
        };
    }

    private Settings createSettings(InputStream consoleInput) {
        SettingsBuilder settings = new SettingsBuilder();
        if (consoleInput != null) {
            settings.inputStream(consoleInput);
        }
        settings.outputStream((PrintStream)this.cliPrintStream);
        settings.enableExport(false);
        settings.disableHistory(!this.config.isHistoryEnabled());
        settings.historyFile(new File(this.config.getHistoryFileDir(), this.config.getHistoryFileName()));
        settings.historySize(this.config.getHistoryMaxSize());
        FileAccessPermission permissions = new FileAccessPermission();
        permissions.setReadableOwnerOnly(true);
        permissions.setWritableOwnerOnly(true);
        settings.historyFilePermission(permissions);
        settings.parseOperators(false);
        settings.interruptHook(new InterruptHook(){

            public void handleInterrupt(org.jboss.aesh.console.Console console, Action action) {
                if (CommandContextImpl.this.shutdownHook != null) {
                    CommandContextImpl.this.shutdownHook.shutdown();
                } else {
                    CommandContextImpl.this.terminateSession();
                }
                Thread.currentThread().interrupt();
            }
        });
        return settings.create();
    }

    private void initStdIO() {
        try {
            StdioContext.install();
            this.uninstallIO = true;
        }
        catch (IllegalStateException e) {
            this.uninstallIO = false;
        }
    }

    private void restoreStdIO() {
        if (this.uninstallIO) {
            try {
                StdioContext.uninstall();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void initCommands() throws CommandLineException {
        this.cmdRegistry.registerHandler((CommandHandler)new AttachmentHandler(this), "attachment");
        this.cmdRegistry.registerHandler((CommandHandler)new PrefixHandler(), "cd", "cn");
        this.cmdRegistry.registerHandler((CommandHandler)new ClearScreenHandler(), "clear", "cls");
        this.cmdRegistry.registerHandler((CommandHandler)new CommandCommandHandler(this.cmdRegistry), "command");
        this.cmdRegistry.registerHandler((CommandHandler)new ConnectHandler(), "connect");
        this.cmdRegistry.registerHandler((CommandHandler)new EchoDMRHandler(), "echo-dmr");
        this.cmdRegistry.registerHandler((CommandHandler)new HelpHandler(this.cmdRegistry), "help", "h");
        this.cmdRegistry.registerHandler((CommandHandler)new HistoryHandler(), "history");
        this.cmdRegistry.registerHandler((CommandHandler)new LsHandler(this), "ls");
        this.cmdRegistry.registerHandler((CommandHandler)new ASModuleHandler(this), "module");
        this.cmdRegistry.registerHandler((CommandHandler)new PrintWorkingNodeHandler(), "pwd", "pwn");
        this.cmdRegistry.registerHandler((CommandHandler)new QuitHandler(), "quit", "q", "exit");
        this.cmdRegistry.registerHandler((CommandHandler)new ReadAttributeHandler(this), "read-attribute");
        this.cmdRegistry.registerHandler((CommandHandler)new ReadOperationHandler(this), "read-operation");
        this.cmdRegistry.registerHandler((CommandHandler)new VersionHandler(), "version");
        this.cmdRegistry.registerHandler((CommandHandler)new ConnectionInfoHandler(), "connection-info");
        this.cmdRegistry.registerHandler((CommandHandler)new CommandTimeoutHandler(), "command-timeout");
        this.cmdRegistry.registerHandler((CommandHandler)new SetVariableHandler(), "set");
        this.cmdRegistry.registerHandler((CommandHandler)new EchoVariableHandler(), "echo");
        this.cmdRegistry.registerHandler((CommandHandler)new UnsetVariableHandler(), "unset");
        this.cmdRegistry.registerHandler((CommandHandler)new DeployHandler(this), "deploy");
        this.cmdRegistry.registerHandler((CommandHandler)new UndeployHandler(this), "undeploy");
        this.cmdRegistry.registerHandler((CommandHandler)new DeploymentInfoHandler(this), "deployment-info");
        this.cmdRegistry.registerHandler((CommandHandler)new DeploymentOverlayHandler(this), "deployment-overlay");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchHandler(this), "batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchDiscardHandler(), "discard-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchListHandler(), "list-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchHoldbackHandler(), "holdback-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchRunHandler(this), "run-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchClearHandler(), "clear-batch");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchRemoveLineHandler(), "remove-batch-line");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchMoveLineHandler(), "move-batch-line");
        this.cmdRegistry.registerHandler((CommandHandler)new BatchEditLineHandler(), "edit-batch-line");
        this.cmdRegistry.registerHandler((CommandHandler)new TryHandler(), "try");
        this.cmdRegistry.registerHandler((CommandHandler)new CatchHandler(), "catch");
        this.cmdRegistry.registerHandler((CommandHandler)new FinallyHandler(), "finally");
        this.cmdRegistry.registerHandler((CommandHandler)new EndTryHandler(), "end-try");
        this.cmdRegistry.registerHandler((CommandHandler)new IfHandler(), "if");
        this.cmdRegistry.registerHandler((CommandHandler)new ElseHandler(), "else");
        this.cmdRegistry.registerHandler((CommandHandler)new EndIfHandler(), "end-if");
        DefaultCompleter driverNameCompleter = new DefaultCompleter(JDBCDriverNameProvider.INSTANCE);
        GenericTypeOperationHandler dsHandler = new GenericTypeOperationHandler((CommandContext)this, "/subsystem=datasources/data-source", null);
        dsHandler.addValueCompleter("driver-name", driverNameCompleter);
        DataSourceAddCompositeHandler dsAddHandler = new DataSourceAddCompositeHandler(this, "/subsystem=datasources/data-source");
        dsAddHandler.addValueCompleter("driver-name", driverNameCompleter);
        dsHandler.addHandler("add", dsAddHandler);
        this.cmdRegistry.registerHandler((CommandHandler)dsHandler, dsHandler.getCommandName());
        GenericTypeOperationHandler xaDsHandler = new GenericTypeOperationHandler((CommandContext)this, "/subsystem=datasources/xa-data-source", null);
        xaDsHandler.addValueCompleter("driver-name", driverNameCompleter);
        XADataSourceAddCompositeHandler xaDsAddHandler = new XADataSourceAddCompositeHandler(this, "/subsystem=datasources/xa-data-source");
        xaDsAddHandler.addValueCompleter("driver-name", driverNameCompleter);
        xaDsHandler.addHandler("add", xaDsAddHandler);
        this.cmdRegistry.registerHandler((CommandHandler)xaDsHandler, xaDsHandler.getCommandName());
        this.cmdRegistry.registerHandler((CommandHandler)new JDBCDriverInfoHandler(this), "jdbc-driver-info");
        GenericTypeOperationHandler rolloutPlan = new GenericTypeOperationHandler((CommandContext)this, "/management-client-content=rollout-plans/rollout-plan", null);
        rolloutPlan.addValueConverter("content", HeadersArgumentValueConverter.INSTANCE);
        rolloutPlan.addValueCompleter("content", RolloutPlanCompleter.INSTANCE);
        this.cmdRegistry.registerHandler((CommandHandler)rolloutPlan, rolloutPlan.getCommandName());
        this.cmdRegistry.registerHandler((CommandHandler)new ArchiveHandler(this), false, "archive");
        AtomicReference<EmbeddedProcessLaunch> embeddedServerLaunch = EmbeddedControllerHandlerRegistrar.registerEmbeddedCommands(this.cmdRegistry, this);
        this.cmdRegistry.registerHandler((CommandHandler)new ReloadHandler(this, embeddedServerLaunch), "reload");
        this.cmdRegistry.registerHandler((CommandHandler)new ShutdownHandler(this, embeddedServerLaunch), "shutdown");
        this.registerExtraHandlers();
        this.extLoader = new ExtensionsLoader(this.cmdRegistry, this);
    }

    private void registerExtraHandlers() throws CommandLineException {
        ServiceLoader<CommandHandlerProvider> loader = ServiceLoader.load(CommandHandlerProvider.class);
        for (CommandHandlerProvider provider : loader) {
            this.cmdRegistry.registerHandler(provider.createCommandHandler(this), provider.isTabComplete(), provider.getNames());
        }
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initSSLContext() throws CliInitializationException {
        if (WildFlySecurityManager.getPropertyPrivileged((String)"javax.net.ssl.keyStore", null) != null) return;
        if (WildFlySecurityManager.getPropertyPrivileged((String)"javax.net.ssl.trustStore", null) != null) {
            return;
        }
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        String trustStore = null;
        String trustStorePassword = null;
        boolean modifyTrustStore = true;
        SSLConfig sslConfig = this.config.getSslConfig();
        if (sslConfig != null) {
            String keyStoreLoc = sslConfig.getKeyStore();
            if (keyStoreLoc != null) {
                char[] keyStorePassword = sslConfig.getKeyStorePassword().toCharArray();
                String tmpKeyPassword = sslConfig.getKeyPassword();
                char[] keyPassword = tmpKeyPassword != null ? tmpKeyPassword.toCharArray() : keyStorePassword;
                File keyStoreFile = new File(keyStoreLoc);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(keyStoreFile);
                    KeyStore theKeyStore = KeyStore.getInstance("JKS");
                    theKeyStore.load(fis, keyStorePassword);
                    String alias = sslConfig.getAlias();
                    if (alias != null) {
                        KeyStore replacement = KeyStore.getInstance("JKS");
                        replacement.load(null);
                        KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(keyPassword);
                        replacement.setEntry(alias, theKeyStore.getEntry(alias, protection), protection);
                        theKeyStore = replacement;
                    }
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    keyManagerFactory.init(theKeyStore, keyPassword);
                    keyManagers = keyManagerFactory.getKeyManagers();
                }
                catch (IOException e) {
                    try {
                        throw new CliInitializationException(e);
                        catch (GeneralSecurityException e2) {
                            throw new CliInitializationException(e2);
                        }
                    }
                    catch (Throwable throwable) {
                        StreamUtils.safeClose(fis);
                        throw throwable;
                    }
                }
                StreamUtils.safeClose((Closeable)fis);
            }
            trustStore = sslConfig.getTrustStore();
            trustStorePassword = sslConfig.getTrustStorePassword();
            modifyTrustStore = sslConfig.isModifyTrustStore();
        }
        if (trustStore == null) {
            String userHome = WildFlySecurityManager.getPropertyPrivileged((String)"user.home", null);
            File trustStoreFile = new File(userHome, ".jboss-cli.truststore");
            trustStore = trustStoreFile.getAbsolutePath();
            trustStorePassword = "cli_truststore";
        }
        this.trustManager = new LazyDelagatingTrustManager(trustStore, trustStorePassword, modifyTrustStore);
        trustManagers = new TrustManager[]{this.trustManager};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            this.defaultSslContext = sslConfig == null;
            this.sslContext = sslContext;
            return;
        }
        catch (GeneralSecurityException e) {
            throw new CliInitializationException(e);
        }
    }

    private void initJaasConfig() {
        if (jaasConfigurationWrapper == null) {
            Configuration coreConfig = null;
            try {
                coreConfig = SecurityActions.getGlobalJaasConfiguration();
            }
            catch (SecurityException e) {
                log.debug((Object)"Unable to obtain default configuration", (Throwable)e);
            }
            jaasConfigurationWrapper = new JaasConfigurationWrapper(coreConfig);
            SecurityActions.setGlobalJaasConfiguration(jaasConfigurationWrapper);
        }
    }

    @Override
    public boolean isTerminated() {
        return this.terminate == 2;
    }

    @Override
    public void handle(String line) throws CommandLineException {
        block22: {
            if (line.isEmpty() || line.charAt(0) == '#') {
                return;
            }
            int i = line.length() - 1;
            while (i > 0 && line.charAt(i) <= ' ' && line.charAt(--i) != '\\') {
            }
            String echoLine = line;
            if (line.charAt(i) == '\\') {
                if (this.lineBuffer == null) {
                    this.lineBuffer = new StringBuilder();
                    this.origLineBuffer = new StringBuilder();
                }
                this.lineBuffer.append(line, 0, i);
                this.lineBuffer.append(' ');
                this.origLineBuffer.append(line, 0, i);
                this.origLineBuffer.append('\n');
                return;
            }
            if (this.lineBuffer != null) {
                this.lineBuffer.append(line);
                this.origLineBuffer.append(line);
                echoLine = this.origLineBuffer.toString();
                line = this.lineBuffer.toString();
                this.lineBuffer = null;
            }
            if (this.echoCommand && !this.INTERACT && this.redirection == null) {
                this.printLine(this.getPrompt() + echoLine);
            }
            this.resetArgs(line);
            try {
                if (this.redirection != null) {
                    this.redirection.target.handle(this);
                    break block22;
                }
                if (this.parsedCmd.getFormat() == OperationFormat.INSTANCE) {
                    if (this.isBatchMode()) {
                        Batch batch = this.getBatchManager().getActiveBatch();
                        ModelNode request = Util.toOperationRequest(this, this.parsedCmd, batch.getAttachments());
                        StringBuilder op = new StringBuilder();
                        op.append(this.getNodePathFormatter().format(this.parsedCmd.getAddress()));
                        op.append(line.substring(line.indexOf(58)));
                        DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(this, op.toString(), request, null);
                        batch.add(batchedCmd);
                    } else {
                        Attachments attachments = new Attachments();
                        ModelNode op = Util.toOperationRequest(this, this.parsedCmd, attachments);
                        RequestWithAttachments req = new RequestWithAttachments(op, attachments);
                        this.set(CommandContext.Scope.REQUEST, "OP_REQ", req);
                        this.operationHandler.handle(this);
                    }
                    break block22;
                }
                String cmdName = this.parsedCmd.getOperationName();
                CommandHandler handler = this.cmdRegistry.getCommandHandler(cmdName.toLowerCase());
                if (handler != null) {
                    if (this.isBatchMode() && handler.isBatchMode(this)) {
                        if (!(handler instanceof OperationCommand)) {
                            throw new CommandLineException("The command is not allowed in a batch.");
                        }
                        try {
                            Batch batch = this.getBatchManager().getActiveBatch();
                            OperationCommand.HandledRequest request = ((OperationCommand)handler).buildHandledRequest(this, batch.getAttachments());
                            DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(this, line, request.getRequest(), request.getResponseHandler());
                            batch.add(batchedCmd);
                            break block22;
                        }
                        catch (CommandFormatException e) {
                            throw new CommandFormatException("Failed to add to batch '" + line + "'", e);
                        }
                    }
                    this.execute(() -> {
                        this.executor.execute(handler, this.timeout, TimeUnit.SECONDS);
                        return null;
                    }, line);
                    break block22;
                }
                throw new CommandLineException("Unexpected command '" + line + "'. Type 'help --commands' for the list of supported commands.");
            }
            catch (CommandLineException e) {
                throw e;
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Failed to handle '" + line + "'"), t);
                }
                throw new CommandLineException("Failed to handle '" + line + "'", t);
            }
            finally {
                this.cmdLine = null;
                this.clear(CommandContext.Scope.REQUEST);
            }
        }
    }

    @Override
    public ModelNode execute(Operation mn, String description) throws CommandLineException, IOException {
        if (this.client == null) {
            throw new CommandLineException("The connection to the controller has not been established.");
        }
        try {
            return this.execute(() -> this.executor.execute(mn, this.timeout, TimeUnit.SECONDS), description);
        }
        catch (CommandLineException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw ex;
        }
    }

    @Override
    public ModelNode execute(ModelNode mn, String description) throws CommandLineException, IOException {
        OperationBuilder opBuilder = new OperationBuilder(mn, true);
        return this.execute(opBuilder.build(), description);
    }

    private <T> T execute(Callable<T> c, String msg) throws CommandLineException {
        try {
            return c.call();
        }
        catch (IOException ex) {
            throw new CommandLineException("IO exception for " + msg, ex);
        }
        catch (TimeoutException ex) {
            throw new CommandLineException("Timeout exception for " + msg, ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new CommandLineException("Interrupt exception for " + msg, ex);
        }
        catch (ExecutionException ex) {
            Throwable cause;
            Throwable throwable = cause = ex.getCause() == null ? ex : ex.getCause();
            if (cause instanceof CommandLineException) {
                throw (CommandLineException)cause;
            }
            throw new CommandLineException("Execution exception for " + msg + ": " + cause.getMessage(), cause);
        }
        catch (CommandLineException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandLineException("Exception for " + msg, ex);
        }
    }

    @Override
    public void handleSafe(String line) {
        this.exitCode = 0;
        try {
            this.handle(line);
        }
        catch (Throwable t) {
            this.error(Util.getMessagesFromThrowable(t));
        }
    }

    @Override
    public String getArgumentsString() {
        if (this.lineBuffer != null) {
            return this.lineBuffer.toString();
        }
        if (this.cmdLine != null && this.parsedCmd.getOperationName() != null) {
            int cmdNameLength = this.parsedCmd.getOperationName().length();
            if (this.cmdLine.length() == cmdNameLength) {
                return null;
            }
            return this.cmdLine.substring(cmdNameLength + 1);
        }
        return null;
    }

    @Override
    public void terminateSession() {
        if (this.terminate == 0) {
            this.clear(CommandContext.Scope.CONTEXT);
            this.clear(CommandContext.Scope.REQUEST);
            this.terminate = 1;
            this.disconnectController();
            this.restoreStdIO();
            if (this.console != null) {
                this.console.stop();
            }
            if (this.shutdownHook != null) {
                CliShutdownHook.remove(this.shutdownHook);
            }
            this.executor.cancel();
            this.terminate = (byte)2;
        }
    }

    @Override
    public void printLine(String message) {
        Logger.Level logLevel = this.exitCode != 0 ? Logger.Level.ERROR : Logger.Level.INFO;
        if (log.isEnabled(logLevel)) {
            log.log(logLevel, (Object)message);
        }
        if (this.outputTarget != null) {
            try {
                this.outputTarget.append(message);
                this.outputTarget.newLine();
                this.outputTarget.flush();
            }
            catch (IOException e) {
                System.err.println("Failed to print '" + message + "' to the output target: " + e.getLocalizedMessage());
            }
            return;
        }
        if (!this.SILENT) {
            if (this.console != null) {
                this.console.print(message);
                this.console.printNewLine();
            } else {
                this.cliPrintStream.println(message);
            }
        }
    }

    protected void error(String message) {
        this.exitCode = 1;
        this.printLine(message);
    }

    private String readLine(String prompt, boolean password) throws CommandLineException {
        if (!this.INTERACT && this.ERROR_ON_INTERACT) {
            this.interactionDisabled();
        }
        if (this.console == null) {
            this.initBasicConsole(null);
        } else if (!this.console.running()) {
            this.console.start();
        }
        if (password) {
            return this.console.readLine(prompt, Character.valueOf('\u0000'));
        }
        return this.console.readLine(prompt);
    }

    protected void interactionDisabled() throws CommandLineException {
        throw new CommandLineException("Invalid Usage. Prompt attempted in non-interactive mode. Please check commands or change CLI mode.");
    }

    @Override
    public void printColumns(Collection<String> col) {
        if (log.isInfoEnabled()) {
            log.info(col);
        }
        if (this.outputTarget != null) {
            try {
                for (String item : col) {
                    this.outputTarget.append(item);
                    this.outputTarget.newLine();
                }
            }
            catch (IOException e) {
                System.err.println("Failed to print columns '" + col + "' to the console: " + e.getLocalizedMessage());
            }
            return;
        }
        if (!this.SILENT) {
            if (this.console != null) {
                this.console.printColumns(col);
            } else {
                for (String item : col) {
                    this.cliPrintStream.println(item);
                }
            }
        }
    }

    @Override
    public void set(CommandContext.Scope scope, String key, Object value) {
        Objects.requireNonNull(scope);
        Objects.requireNonNull(key);
        Map<String, Object> store = this.map.get((Object)scope);
        if (store == null) {
            store = new HashMap<String, Object>();
            this.map.put(scope, store);
        }
        store.put(key, value);
    }

    @Override
    public Object get(CommandContext.Scope scope, String key) {
        Objects.requireNonNull(scope);
        Objects.requireNonNull(key);
        Map<String, Object> store = this.map.get((Object)scope);
        Object value = null;
        if (store != null) {
            value = store.get(key);
        }
        return value;
    }

    @Override
    public void clear(CommandContext.Scope scope) {
        Objects.requireNonNull(scope);
        Map<String, Object> store = this.map.remove((Object)scope);
        if (store != null) {
            store.clear();
        }
    }

    @Override
    public Object remove(CommandContext.Scope scope, String key) {
        Objects.requireNonNull(scope);
        Map<String, Object> store = this.map.get((Object)scope);
        Object value = null;
        if (store != null) {
            value = store.remove(key);
        }
        return value;
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return this.client;
    }

    @Override
    public CommandLineParser getCommandLineParser() {
        return DefaultOperationRequestParser.INSTANCE;
    }

    @Override
    public OperationRequestAddress getCurrentNodePath() {
        return this.prefix;
    }

    @Override
    public NodePathFormatter getNodePathFormatter() {
        return this.prefixFormatter;
    }

    @Override
    public OperationCandidatesProvider getOperationCandidatesProvider() {
        return this.operationCandidatesProvider;
    }

    @Override
    public void connectController() throws CommandLineException {
        this.connectController(null);
    }

    @Override
    public void connectController(String controller) throws CommandLineException {
        this.connectionAddress = this.addressResolver.resolveAddress(controller);
        HashSet<ControllerAddress> visited = new HashSet<ControllerAddress>();
        visited.add(this.connectionAddress);
        boolean retry = false;
        do {
            try {
                AuthenticationCallbackHandler cbh = new AuthenticationCallbackHandler(this.username, this.password);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("connecting to " + this.connectionAddress.getHost() + ':' + this.connectionAddress.getPort() + " as " + this.username));
                }
                ModelControllerClient tempClient = ModelControllerClientFactory.CUSTOM.getClient(this.connectionAddress, cbh, this.disableLocalAuth, this.sslContext, this.defaultSslContext, this.config.getConnectionTimeout(), this, (ProtocolTimeoutHandler)this.timeoutHandler, this.clientBindAddress);
                retry = false;
                this.connInfoBean = new ConnectionInfoBean();
                this.tryConnection(tempClient, this.connectionAddress);
                this.initNewClient(tempClient, this.connectionAddress, this.connInfoBean);
                this.connInfoBean.setDisableLocalAuth(this.disableLocalAuth);
                this.connInfoBean.setLoggedSince(new Date());
            }
            catch (RedirectException re) {
                try {
                    URI location = new URI(re.getLocation());
                    if (Util.isHttpsRedirect(re, this.connectionAddress.getProtocol())) {
                        int port = location.getPort();
                        if (port < 0) {
                            port = 443;
                        }
                        this.connectionAddress = this.addressResolver.resolveAddress(new URI("remote+https", null, location.getHost(), port, null, null, null).toString());
                        if (!visited.add(this.connectionAddress)) {
                            throw new CommandLineException("Redirect to address already tried encountered Address=" + this.connectionAddress.toString());
                        }
                    } else {
                        if (this.connectionAddress.getHost().equals(location.getHost()) && this.connectionAddress.getPort() == location.getPort() && location.getPath() != null && location.getPath().length() > 1) {
                            throw new CommandLineException("Server at " + this.connectionAddress.getHost() + ":" + this.connectionAddress.getPort() + " does not support " + this.connectionAddress.getProtocol());
                        }
                        throw new CommandLineException("Unsupported redirect received.", re);
                    }
                    retry = true;
                }
                catch (URISyntaxException e) {
                    throw new CommandLineException("Bad redirect location '" + re.getLocation() + "' received.", e);
                }
            }
            catch (IOException e) {
                throw new CommandLineException("Failed to resolve host '" + this.connectionAddress.getHost() + "'", e);
            }
        } while (retry);
    }

    @Override
    @Deprecated
    public void connectController(String host, int port) throws CommandLineException {
        try {
            this.connectController(new URI(null, null, host, port, null, null, null).toString().substring(2));
        }
        catch (URISyntaxException e) {
            throw new CommandLineException("Unable to construct URI for connection.", e);
        }
    }

    @Override
    public void bindClient(ModelControllerClient newClient) {
        ConnectionInfoBean conInfo = new ConnectionInfoBean();
        conInfo.setLoggedSince(new Date());
        this.initNewClient(newClient, null, conInfo);
    }

    private void initNewClient(ModelControllerClient newClient, ControllerAddress address, ConnectionInfoBean conInfo) {
        if (newClient != null) {
            if (this.client != null) {
                this.disconnectController();
            }
            this.client = newClient;
            this.currentAddress = address;
            this.connInfoBean = conInfo;
            if (this.connInfoBean != null) {
                this.connInfoBean.setControllerAddress(address);
            }
            List<String> nodeTypes = Util.getNodeTypes(newClient, new DefaultOperationRequestAddress());
            this.domainMode = nodeTypes.contains("server-group");
            try {
                this.extLoader.loadHandlers(this.currentAddress);
            }
            catch (CommandLineException e) {
                this.printLine(Util.getMessagesFromThrowable(e));
            }
        }
    }

    @Override
    public File getCurrentDir() {
        return this.currentDir;
    }

    @Override
    public void setCurrentDir(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("dir is null");
        }
        this.currentDir = dir;
    }

    @Override
    public void registerRedirection(CommandLineRedirection redirection) throws CommandLineException {
        if (this.redirection != null) {
            throw new CommandLineException("Another redirection is currently active.");
        }
        this.redirection = new CommandLineRedirectionRegistration(redirection);
        redirection.set(this.redirection);
    }

    private void handleSSLFailure(Certificate[] lastChain) throws CommandLineException {
        String response;
        this.printLine("Unable to connect due to unrecognised server certificate");
        for (Certificate current : lastChain) {
            if (!(current instanceof X509Certificate)) continue;
            X509Certificate x509Current = (X509Certificate)current;
            Map<String, String> fingerprints = FingerprintGenerator.generateFingerprints(x509Current);
            this.printLine("Subject    - " + x509Current.getSubjectX500Principal().getName());
            this.printLine("Issuer     - " + x509Current.getIssuerDN().getName());
            this.printLine("Valid From - " + x509Current.getNotBefore());
            this.printLine("Valid To   - " + x509Current.getNotAfter());
            for (String alg : fingerprints.keySet()) {
                this.printLine(alg + " : " + fingerprints.get(alg));
            }
            this.printLine("");
        }
        while ((response = this.trustManager.isModifyTrustStore() ? this.readLine("Accept certificate? [N]o, [T]emporarily, [P]ermanently : ", false) : this.readLine("Accept certificate? [N]o, [T]emporarily : ", false)) != null) {
            if (response.length() != 1) continue;
            switch (response.toLowerCase(Locale.ENGLISH).charAt(0)) {
                case 'n': {
                    return;
                }
                case 't': {
                    this.trustManager.storeChainTemporarily(lastChain);
                    return;
                }
                case 'p': {
                    if (!this.trustManager.isModifyTrustStore()) break;
                    this.trustManager.storeChainPermenantly(lastChain);
                    return;
                }
            }
        }
    }

    private void tryConnection(ModelControllerClient client, ControllerAddress address) throws CommandLineException, RedirectException {
        try {
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            builder.setOperationName("read-attribute");
            builder.addProperty("name", "name");
            long start = System.currentTimeMillis();
            long timeoutMillis = this.config.getConnectionTimeout() + 1000;
            boolean tryConnection = true;
            while (tryConnection) {
                ModelNode response = client.execute(builder.buildRequest());
                if (!Util.isSuccess(response)) {
                    String failure = Util.getFailureDescription(response);
                    if (failure.contains("WFLYCTL0332")) {
                        StreamUtils.safeClose((Closeable)client);
                        throw new CommandLineException("Connection refused based on the insufficient user permissions. Please, make sure the security-realm attribute is specified for the relevant management interface (standalone.xml/host.xml) and review the access-control configuration (standalone.xml/domain.xml).");
                    }
                    if (failure.contains("WFLYCTL0379")) {
                        if (System.currentTimeMillis() - start > timeoutMillis) {
                            throw new CommandLineException("Timeout waiting for the system to boot.");
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            this.disconnectController();
                            throw new CommandLineException("Interrupted while pausing before trying connection.", e);
                        }
                    }
                    this.printLine("Warning! The connection check resulted in failure: " + Util.getFailureDescription(response));
                    tryConnection = false;
                    continue;
                }
                tryConnection = false;
            }
        }
        catch (Exception e) {
            try {
                for (Throwable current = e; current != null; current = current.getCause()) {
                    if (current instanceof SaslException) {
                        throw new CommandLineException("Unable to authenticate against controller at " + address.getHost() + ":" + address.getPort(), current);
                    }
                    if (current instanceof SSLException) {
                        throw new CommandLineException("Unable to negotiate SSL connection with controller at " + address.getHost() + ":" + address.getPort());
                    }
                    if (current instanceof RedirectException) {
                        throw (RedirectException)current;
                    }
                    if (!(current instanceof CommandLineException)) continue;
                    throw (CommandLineException)current;
                }
                throw new CommandLineException("The controller is not available at " + address.getHost() + ":" + address.getPort(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose((Closeable)client);
                throw throwable;
            }
        }
    }

    @Override
    public void disconnectController() {
        if (this.client != null) {
            StreamUtils.safeClose((Closeable)this.client);
            this.client = null;
            this.currentAddress = null;
            this.domainMode = false;
            this.notifyListeners(CliEvent.DISCONNECTED);
            this.connInfoBean = null;
            this.extLoader.resetHandlers();
        }
        this.promptConnectPart = null;
        if (this.console != null && this.terminate == 0) {
            this.console.setPrompt(this.getPrompt());
        }
    }

    @Override
    @Deprecated
    public String getDefaultControllerHost() {
        return this.config.getDefaultControllerHost();
    }

    @Override
    @Deprecated
    public int getDefaultControllerPort() {
        return this.config.getDefaultControllerPort();
    }

    @Override
    public ControllerAddress getDefaultControllerAddress() {
        return this.config.getDefaultControllerAddress();
    }

    @Override
    public String getControllerHost() {
        return this.currentAddress != null ? this.currentAddress.getHost() : null;
    }

    @Override
    public int getControllerPort() {
        return this.currentAddress != null ? this.currentAddress.getPort() : -1;
    }

    @Override
    public void clearScreen() {
        if (this.console != null) {
            this.console.clearScreen();
        }
    }

    String getPrompt() {
        if (this.lineBuffer != null) {
            return "> ";
        }
        StringBuilder buffer = new StringBuilder();
        if (this.promptConnectPart == null) {
            buffer.append('[');
            String controllerHost = this.getControllerHost();
            if (this.client != null) {
                if (this.domainMode) {
                    buffer.append("domain@");
                } else {
                    buffer.append("standalone@");
                }
                if (controllerHost != null) {
                    buffer.append(controllerHost).append(':').append(this.getControllerPort()).append(' ');
                } else {
                    buffer.append("embedded ");
                }
                this.promptConnectPart = buffer.toString();
            } else {
                buffer.append("disconnected ");
            }
        } else {
            buffer.append(this.promptConnectPart);
        }
        if (this.prefix.isEmpty()) {
            buffer.append('/');
        } else {
            buffer.append(this.prefix.getNodeType());
            String nodeName = this.prefix.getNodeName();
            if (nodeName != null) {
                buffer.append('=').append(nodeName);
            }
        }
        if (this.isBatchMode()) {
            buffer.append(" #");
        }
        buffer.append("] ");
        return buffer.toString();
    }

    @Override
    public CommandHistory getHistory() {
        if (this.console == null) {
            try {
                this.initBasicConsole(null, this.INTERACT);
            }
            catch (CliInitializationException e) {
                throw new IllegalStateException("Failed to initialize console.", e);
            }
        }
        return this.console.getHistory();
    }

    private void resetArgs(String cmdLine) throws CommandFormatException {
        if (cmdLine != null) {
            this.parsedCmd.parse(this.prefix, cmdLine, this);
            this.setOutputTarget(this.parsedCmd.getOutputTarget());
        }
        this.cmdLine = cmdLine;
    }

    @Override
    public boolean isBatchMode() {
        return this.batchManager.isBatchActive();
    }

    @Override
    public boolean isWorkflowMode() {
        return this.redirection != null;
    }

    @Override
    public BatchManager getBatchManager() {
        return this.batchManager;
    }

    @Override
    public BatchedCommand toBatchedCommand(String line) throws CommandFormatException {
        OperationCommand.HandledRequest req = this.buildRequest(line, true);
        return new DefaultBatchedCommand(this, line, req.getRequest(), req.getResponseHandler());
    }

    @Override
    public ModelNode buildRequest(String line) throws CommandFormatException {
        return this.buildRequest(line, false).getRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OperationCommand.HandledRequest buildRequest(String line, boolean batchMode) throws CommandFormatException {
        if (line == null || line.isEmpty()) {
            throw new OperationFormatException("The line is null or empty.");
        }
        DefaultCallbackHandler originalParsedArguments = this.parsedCmd;
        String originalCmdLine = this.cmdLine;
        try {
            this.parsedCmd = new DefaultCallbackHandler();
            this.resetArgs(line);
            if (this.parsedCmd.getFormat() == OperationFormat.INSTANCE) {
                ModelNode request = this.parsedCmd.toOperationRequest(this);
                StringBuilder op = new StringBuilder();
                op.append(this.prefixFormatter.format(this.parsedCmd.getAddress()));
                op.append(line.substring(line.indexOf(58)));
                OperationCommand.HandledRequest handledRequest = new OperationCommand.HandledRequest(request, null);
                return handledRequest;
            }
            CommandHandler handler = this.cmdRegistry.getCommandHandler(this.parsedCmd.getOperationName());
            if (handler == null) {
                throw new OperationFormatException("No command handler for '" + this.parsedCmd.getOperationName() + "'.");
            }
            if (batchMode) {
                if (!handler.isBatchMode(this)) {
                    throw new OperationFormatException("The command is not allowed in a batch.");
                }
                Batch batch = this.getBatchManager().getActiveBatch();
                OperationCommand.HandledRequest handledRequest = ((OperationCommand)handler).buildHandledRequest(this, batch.getAttachments());
                return handledRequest;
            }
            if (!(handler instanceof OperationCommand)) {
                throw new OperationFormatException("The command does not translate to an operation request.");
            }
            OperationCommand.HandledRequest handledRequest = new OperationCommand.HandledRequest(((OperationCommand)handler).buildRequest(this), null);
            return handledRequest;
        }
        finally {
            this.clear(CommandContext.Scope.REQUEST);
            this.parsedCmd = originalParsedArguments;
            this.cmdLine = originalCmdLine;
        }
    }

    @Override
    public CommandLineCompleter getDefaultCommandCompleter() {
        return this.cmdCompleter;
    }

    @Override
    public ParsedCommandLine getParsedCommandLine() {
        return this.parsedCmd;
    }

    @Override
    public boolean isDomainMode() {
        return this.domainMode;
    }

    @Override
    public void addEventListener(CliEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null.");
        }
        this.listeners.add(listener);
    }

    @Override
    public CliConfig getConfig() {
        return this.config;
    }

    protected void setOutputTarget(String filePath) {
        if (filePath == null) {
            this.outputTarget = null;
            return;
        }
        try {
            this.outputTarget = Files.newBufferedWriter(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            this.error(e.getLocalizedMessage());
        }
    }

    protected void notifyListeners(CliEvent event) {
        for (CliEventListener listener : this.listeners) {
            listener.cliEvent(event, this);
        }
    }

    @Override
    public void interact() {
        this.INTERACT = true;
        if (this.cmdCompleter == null) {
            throw new IllegalStateException("The console hasn't been initialized at construction time.");
        }
        if (this.client == null) {
            this.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
        }
        this.console.setPrompt(this.getPrompt());
        if (!this.console.running()) {
            this.console.start();
        } else {
            this.console.redrawPrompt();
        }
        if (this.console.isControlled()) {
            this.console.continuous();
        }
        while (this.console.running()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.INTERACT = false;
    }

    @Override
    public boolean isResolveParameterValues() {
        return this.resolveParameterValues;
    }

    @Override
    public void setResolveParameterValues(boolean resolve) {
        this.resolveParameterValues = resolve;
    }

    @Override
    public void handleClose() {
        if (this.parsedCmd.getFormat() != null && !"reload".equals(this.parsedCmd.getOperationName()) && "shutdown".equals(this.parsedCmd.getOperationName()) && !CommandFormat.INSTANCE.equals(this.parsedCmd.getFormat()) && !"true".equals(this.parsedCmd.getPropertyValue("restart"))) {
            this.printLine("");
            this.printLine("The controller has closed the connection.");
            this.disconnectController();
        }
    }

    @Override
    public boolean isSilent() {
        return this.SILENT;
    }

    @Override
    public void setSilent(boolean silent) {
        this.SILENT = silent;
    }

    @Override
    public int getTerminalWidth() {
        if (!this.INTERACT) {
            return 0;
        }
        if (this.console == null) {
            try {
                this.initBasicConsole(null);
            }
            catch (CliInitializationException e) {
                this.error("Failed to initialize the console: " + e.getLocalizedMessage());
                return 80;
            }
        }
        return this.console.getTerminalWidth();
    }

    @Override
    public int getTerminalHeight() {
        if (!this.INTERACT) {
            return 0;
        }
        if (this.console == null) {
            try {
                this.initBasicConsole(null);
            }
            catch (CliInitializationException e) {
                this.error("Failed to initialize the console: " + e.getLocalizedMessage());
                return 24;
            }
        }
        return this.console.getTerminalHeight();
    }

    @Override
    public void setVariable(String name, String value) throws CommandLineException {
        if (name == null || name.isEmpty()) {
            throw new CommandLineException("Variable name can't be null or an empty string");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new CommandLineException("Variable name must be a valid Java identifier (and not contain '$'): '" + name + "'");
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '$') continue;
            throw new CommandLineException("Variable name must be a valid Java identifier (and not contain '$'): '" + name + "'");
        }
        if (value == null) {
            if (this.variables == null) {
                return;
            }
            this.variables.remove(name);
        } else {
            if (this.variables == null) {
                this.variables = new HashMap<String, String>();
            }
            this.variables.put(name, value);
        }
    }

    @Override
    public String getVariable(String name) {
        return this.variables == null ? null : this.variables.get(name);
    }

    @Override
    public Collection<String> getVariables() {
        return this.variables == null ? Collections.emptySet() : this.variables.keySet();
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connInfoBean;
    }

    @Override
    public void captureOutput(PrintStream captor) {
        assert (captor != null);
        this.cliPrintStream.captureOutput(captor);
    }

    @Override
    public void releaseOutput() {
        this.cliPrintStream.releaseOutput();
    }

    @Override
    public final void setCommandTimeout(int numSeconds) {
        if (numSeconds < 0) {
            throw new IllegalArgumentException("The command-timeout must be a valid positive integer:" + numSeconds);
        }
        this.timeout = numSeconds;
    }

    @Override
    public final int getCommandTimeout() {
        return this.timeout;
    }

    @Override
    public final void resetTimeout(CommandContext.TIMEOUT_RESET_VALUE value) {
        switch (value) {
            case CONFIG: {
                this.timeout = this.configTimeout;
                break;
            }
            case DEFAULT: {
                this.timeout = 0;
            }
        }
    }

    class CommandLineRedirectionRegistration
    implements CommandLineRedirection.Registration {
        CommandLineRedirection target;

        CommandLineRedirectionRegistration(CommandLineRedirection redirection) {
            if (redirection == null) {
                throw new IllegalArgumentException("Redirection is null");
            }
            this.target = redirection;
        }

        @Override
        public void unregister() throws CommandLineException {
            this.ensureActive();
            CommandContextImpl.this.redirection = null;
        }

        @Override
        public boolean isActive() {
            return CommandContextImpl.this.redirection == this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(ParsedCommandLine parsedLine) throws CommandLineException {
            block11: {
                this.ensureActive();
                String line = parsedLine.getSubstitutedLine();
                try {
                    if (parsedLine.getFormat() == OperationFormat.INSTANCE) {
                        if (CommandContextImpl.this.isBatchMode()) {
                            Batch batch = CommandContextImpl.this.getBatchManager().getActiveBatch();
                            ModelNode request = Util.toOperationRequest(CommandContextImpl.this, CommandContextImpl.this.parsedCmd, batch.getAttachments());
                            StringBuilder op = new StringBuilder();
                            op.append(CommandContextImpl.this.getNodePathFormatter().format(CommandContextImpl.this.parsedCmd.getAddress()));
                            op.append(line.substring(line.indexOf(58)));
                            DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(CommandContextImpl.this, op.toString(), request, null);
                            batch.add(batchedCmd);
                        } else {
                            Attachments attachments = new Attachments();
                            ModelNode op = Util.toOperationRequest(CommandContextImpl.this, CommandContextImpl.this.parsedCmd, attachments);
                            RequestWithAttachments req = new RequestWithAttachments(op, attachments);
                            CommandContextImpl.this.set(CommandContext.Scope.REQUEST, "OP_REQ", req);
                            CommandContextImpl.this.operationHandler.handle(CommandContextImpl.this);
                        }
                        break block11;
                    }
                    String cmdName = CommandContextImpl.this.parsedCmd.getOperationName();
                    CommandHandler handler = CommandContextImpl.this.cmdRegistry.getCommandHandler(cmdName.toLowerCase());
                    if (handler != null) {
                        if (CommandContextImpl.this.isBatchMode() && handler.isBatchMode(CommandContextImpl.this)) {
                            if (!(handler instanceof OperationCommand)) {
                                throw new CommandLineException("The command is not allowed in a batch.");
                            }
                            try {
                                Batch batch = CommandContextImpl.this.getBatchManager().getActiveBatch();
                                OperationCommand.HandledRequest request = ((OperationCommand)handler).buildHandledRequest(CommandContextImpl.this, batch.getAttachments());
                                DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(CommandContextImpl.this, line, request.getRequest(), request.getResponseHandler());
                                batch.add(batchedCmd);
                                break block11;
                            }
                            catch (CommandFormatException e) {
                                throw new CommandFormatException("Failed to add to batch '" + line + "'", e);
                            }
                        }
                        handler.handle(CommandContextImpl.this);
                        break block11;
                    }
                    throw new CommandLineException("Unexpected command '" + line + "'. Type 'help --commands' for the list of supported commands.");
                }
                finally {
                    CommandContextImpl.this.clear(CommandContext.Scope.REQUEST);
                }
            }
        }

        private void ensureActive() throws CommandLineException {
            if (!this.isActive()) {
                throw new CommandLineException("The redirection is not registered any more.");
            }
        }
    }

    private class JaasConfigurationWrapper
    extends Configuration {
        private final Configuration wrapped;

        private JaasConfigurationWrapper(Configuration toWrap) {
            this.wrapped = toWrap;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            AppConfigurationEntry[] response;
            AppConfigurationEntry[] appConfigurationEntryArray = response = this.wrapped != null ? this.wrapped.getAppConfigurationEntry(name) : null;
            if (response == null && "com.sun.security.jgss.initiate".equals(name)) {
                HashMap<String, String> options = new HashMap<String, String>(2);
                options.put("useTicketCache", "true");
                options.put("doNotPrompt", "true");
                response = new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
            return response;
        }
    }

    private class LazyDelagatingTrustManager
    implements X509TrustManager {
        private final String trustStore;
        private final String trustStorePassword;
        private final boolean modifyTrustStore;
        private Set<X509Certificate> temporarilyTrusted = new HashSet<X509Certificate>();
        private X509TrustManager delegate;

        LazyDelagatingTrustManager(String trustStore, String trustStorePassword, boolean modifyTrustStore) {
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.modifyTrustStore = modifyTrustStore;
        }

        boolean isModifyTrustStore() {
            return this.modifyTrustStore;
        }

        synchronized void storeChainTemporarily(Certificate[] chain) {
            for (Certificate current : chain) {
                if (!(current instanceof X509Certificate)) continue;
                this.temporarilyTrusted.add((X509Certificate)current);
            }
            this.delegate = null;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized void storeChainPermenantly(Certificate[] chain) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                KeyStore theTrustStore = KeyStore.getInstance("JKS");
                File trustStoreFile = new File(this.trustStore);
                if (trustStoreFile.exists()) {
                    fis = new FileInputStream(trustStoreFile);
                    theTrustStore.load(fis, this.trustStorePassword.toCharArray());
                    StreamUtils.safeClose((Closeable)fis);
                    fis = null;
                } else {
                    theTrustStore.load(null);
                }
                for (Certificate current : chain) {
                    if (!(current instanceof X509Certificate)) continue;
                    X509Certificate x509Current = (X509Certificate)current;
                    theTrustStore.setCertificateEntry(x509Current.getSubjectX500Principal().getName(), x509Current);
                }
                fos = new FileOutputStream(trustStoreFile);
                theTrustStore.store(fos, this.trustStorePassword.toCharArray());
            }
            catch (GeneralSecurityException e) {
                try {
                    throw new IllegalStateException("Unable to operate on trust store.", e);
                    catch (IOException e2) {
                        throw new IllegalStateException("Unable to operate on trust store.", e2);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(fis);
                    StreamUtils.safeClose(fos);
                    throw throwable;
                }
            }
            StreamUtils.safeClose((Closeable)fis);
            StreamUtils.safeClose((Closeable)fos);
            this.delegate = null;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private synchronized X509TrustManager getDelegate() {
            if (this.delegate == null) {
                FileInputStream fis = null;
                try {
                    TrustManager[] trustManagers;
                    KeyStore theTrustStore = KeyStore.getInstance("JKS");
                    File trustStoreFile = new File(this.trustStore);
                    if (trustStoreFile.exists()) {
                        fis = new FileInputStream(trustStoreFile);
                        theTrustStore.load(fis, this.trustStorePassword.toCharArray());
                    } else {
                        theTrustStore.load(null);
                    }
                    for (X509Certificate current : this.temporarilyTrusted) {
                        theTrustStore.setCertificateEntry(current.getSubjectX500Principal().getName(), current);
                    }
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(theTrustStore);
                    for (TrustManager current : trustManagers = trustManagerFactory.getTrustManagers()) {
                        if (!(current instanceof X509TrustManager)) continue;
                        this.delegate = (X509TrustManager)current;
                        break;
                    }
                }
                catch (GeneralSecurityException e) {
                    try {
                        throw new IllegalStateException("Unable to operate on trust store.", e);
                        catch (IOException e2) {
                            throw new IllegalStateException("Unable to operate on trust store.", e2);
                        }
                    }
                    catch (Throwable throwable) {
                        StreamUtils.safeClose(fis);
                        throw throwable;
                    }
                }
                StreamUtils.safeClose((Closeable)fis);
            }
            if (this.delegate == null) {
                throw new IllegalStateException("Unable to create delegate trust manager.");
            }
            return this.delegate;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(final X509Certificate[] chain, String authType) throws CertificateException {
            boolean retry;
            do {
                retry = false;
                try {
                    this.getDelegate().checkServerTrusted(chain, authType);
                    CommandContextImpl.this.connInfoBean.setServerCertificates(chain);
                }
                catch (CertificateException ce) {
                    if (!retry) {
                        CommandContextImpl.this.timeoutHandler.suspendAndExecute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CommandContextImpl.this.handleSSLFailure(chain);
                                }
                                catch (CommandLineException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        });
                        if (this.delegate == null) {
                            retry = true;
                            continue;
                        }
                        throw ce;
                    }
                    throw ce;
                }
            } while (retry);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.getDelegate().getAcceptedIssuers();
        }
    }

    private class AuthenticationCallbackHandler
    implements CallbackHandler {
        private String realm = null;
        private boolean realmShown = false;
        private String username;
        private char[] password;
        private String digest;

        private AuthenticationCallbackHandler(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        private AuthenticationCallbackHandler(String username, String digest) {
            this.username = username;
            this.digest = digest;
        }

        @Override
        public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                CommandContextImpl.this.timeoutHandler.suspendAndExecute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!(AuthenticationCallbackHandler.this.username != null && AuthenticationCallbackHandler.this.password != null || CommandContextImpl.this.INTERACT)) {
                                if (CommandContextImpl.this.console == null) {
                                    CommandContextImpl.this.initBasicConsole(null, false);
                                }
                                CommandContextImpl.this.console.controlled();
                                if (!CommandContextImpl.this.console.running()) {
                                    CommandContextImpl.this.console.start();
                                }
                            }
                            AuthenticationCallbackHandler.this.dohandle(callbacks);
                        }
                        catch (IOException | UnsupportedCallbackException | CliInitializationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof UnsupportedCallbackException) {
                    throw (UnsupportedCallbackException)e.getCause();
                }
                throw e;
            }
        }

        private void dohandle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                return;
            }
            for (Callback current : callbacks) {
                String defaultName;
                NameCallback ncb;
                if (current instanceof RealmCallback) {
                    String defaultText;
                    RealmCallback rcb = (RealmCallback)current;
                    this.realm = defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    RealmChoiceCallback rcc = (RealmChoiceCallback)current;
                    int defaultChoice = rcc.getDefaultChoice();
                    rcc.setSelectedIndex(defaultChoice);
                    this.realm = rcc.getChoices()[defaultChoice];
                    continue;
                }
                if (current instanceof OptionalNameCallback) {
                    ncb = (NameCallback)current;
                    if (this.username != null) {
                        ncb.setName(this.username);
                        CommandContextImpl.this.connInfoBean.setUsername(this.username);
                        continue;
                    }
                    defaultName = ncb.getDefaultName();
                    if (defaultName == null) continue;
                    ncb.setName(defaultName);
                    CommandContextImpl.this.connInfoBean.setUsername(defaultName);
                    continue;
                }
                if (current instanceof NameCallback) {
                    ncb = (NameCallback)current;
                    defaultName = ncb.getDefaultName();
                    if (this.username != null) {
                        ncb.setName(this.username);
                        CommandContextImpl.this.connInfoBean.setUsername(this.username);
                        continue;
                    }
                    if (defaultName != null) {
                        ncb.setName(defaultName);
                        CommandContextImpl.this.connInfoBean.setUsername(defaultName);
                        continue;
                    }
                    this.showRealm();
                    try {
                        if (CommandContextImpl.this.console == null) {
                            if (CommandContextImpl.this.ERROR_ON_INTERACT) {
                                CommandContextImpl.this.interactionDisabled();
                            }
                            CommandContextImpl.this.initBasicConsole(null);
                        }
                        CommandContextImpl.this.console.setCompletion(false);
                        CommandContextImpl.this.console.getHistory().setUseHistory(false);
                        this.username = CommandContextImpl.this.readLine("Username: ", false);
                        CommandContextImpl.this.console.getHistory().setUseHistory(true);
                        CommandContextImpl.this.console.setCompletion(true);
                    }
                    catch (CommandLineException e) {
                        throw new IOException("Failed to read username: " + e.getLocalizedMessage());
                    }
                    if (this.username == null || this.username.length() == 0) {
                        throw new SaslException("No username supplied.");
                    }
                    ncb.setName(this.username);
                    CommandContextImpl.this.connInfoBean.setUsername(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback && this.digest == null) {
                    if (this.password == null) {
                        String temp;
                        this.showRealm();
                        try {
                            if (CommandContextImpl.this.console == null) {
                                if (CommandContextImpl.this.ERROR_ON_INTERACT) {
                                    CommandContextImpl.this.interactionDisabled();
                                }
                                CommandContextImpl.this.initBasicConsole(null);
                            }
                            CommandContextImpl.this.console.setCompletion(false);
                            CommandContextImpl.this.console.getHistory().setUseHistory(false);
                            temp = CommandContextImpl.this.readLine("Password: ", true);
                            CommandContextImpl.this.console.getHistory().setUseHistory(true);
                            CommandContextImpl.this.console.setCompletion(true);
                        }
                        catch (CommandLineException e) {
                            throw new IOException("Failed to read password: " + e.getLocalizedMessage());
                        }
                        if (temp != null) {
                            this.password = temp.toCharArray();
                        }
                    }
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                if (current instanceof CredentialCallback) {
                    CredentialCallback cc = (CredentialCallback)current;
                    if (this.digest == null && cc.isCredentialTypeSupported(PasswordCredential.class, "clear")) {
                        if (this.password == null) {
                            String temp;
                            this.showRealm();
                            try {
                                if (CommandContextImpl.this.console == null) {
                                    if (CommandContextImpl.this.ERROR_ON_INTERACT) {
                                        CommandContextImpl.this.interactionDisabled();
                                    }
                                    CommandContextImpl.this.initBasicConsole(null);
                                }
                                CommandContextImpl.this.console.setCompletion(false);
                                CommandContextImpl.this.console.getHistory().setUseHistory(false);
                                temp = CommandContextImpl.this.readLine("Password: ", true);
                                CommandContextImpl.this.console.getHistory().setUseHistory(true);
                                CommandContextImpl.this.console.setCompletion(true);
                            }
                            catch (CommandLineException e) {
                                throw new IOException("Failed to read password: " + e.getLocalizedMessage());
                            }
                            if (temp != null) {
                                this.password = temp.toCharArray();
                            }
                        }
                        cc.setCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])this.password)));
                        continue;
                    }
                    if (this.digest != null && cc.isCredentialTypeSupported(PasswordCredential.class, "digest-md5")) {
                        byte[] bytes = CodePointIterator.ofString((String)this.digest).hexDecode().drain();
                        cc.setCredential((Credential)new PasswordCredential((Password)DigestPassword.createRaw((String)"digest-md5", (String)this.username, (String)this.realm, (byte[])bytes)));
                        continue;
                    }
                    if (cc.isCredentialTypeSupported(BearerTokenCredential.class)) {
                        AuthenticationContext context = AuthenticationContext.captureCurrent();
                        AuthenticationContextConfigurationClient client = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
                        AuthenticationConfiguration configuration = client.getAuthenticationConfiguration(URI.create(CommandContextImpl.this.connectionAddress.toString()), context);
                        CallbackHandler callbackHandler = client.getCallbackHandler(configuration);
                        context.with(MatchRule.ALL, configuration.useCallbackHandler((CallbackHandler)this)).run(() -> {
                            try {
                                callbackHandler.handle(callbacks);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return null;
                        });
                        continue;
                    }
                    CallbackUtil.unsupported((Callback)current);
                    continue;
                }
                CallbackUtil.unsupported((Callback)current);
            }
        }

        private void showRealm() {
            if (!this.realmShown && this.realm != null) {
                this.realmShown = true;
                CommandContextImpl.this.printLine("Authenticating against security realm: " + this.realm);
            }
        }
    }

    abstract class CLIAeshConsoleCallback
    extends AeshConsoleCallback {
        private Process process;
        private boolean activeProcess = false;

        CLIAeshConsoleCallback() {
        }

        public boolean hasActiveProcess() {
            return this.activeProcess;
        }

        public void setActiveProcess(boolean activeProcess) {
            this.activeProcess = activeProcess;
        }

        public void setProcess(Process process) {
            this.process = process;
        }

        public int getProcessPID() {
            return this.process.getPID();
        }
    }
}

