/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CommandExecutor {
    private final CliGuiContext cliGuiCtx;
    private final ModelControllerClient client;
    private final CommandContext cmdCtx;

    public CommandExecutor(CliGuiContext cliGuiCtx) {
        this.cliGuiCtx = cliGuiCtx;
        this.cmdCtx = cliGuiCtx.getCommmandContext();
        this.client = this.cmdCtx.getModelControllerClient();
        Runtime.getRuntime().addShutdownHook(new Thread(new ClientCloserShutdownHook()));
    }

    public synchronized ModelNode doCommand(String command) throws CommandFormatException, IOException {
        ModelNode request = this.cmdCtx.buildRequest(command);
        return this.execute(request, this.isSlowCommand(command)).getResponseNode();
    }

    public synchronized Response doCommandFullResponse(String command) throws CommandFormatException, IOException {
        ModelNode request = this.cmdCtx.buildRequest(command);
        boolean replacedBytes = this.replaceFilePathsWithBytes(request);
        OperationResponse response = this.execute(request, this.isSlowCommand(command) || replacedBytes);
        return new Response(command, request, response);
    }

    private boolean replaceFilePathsWithBytes(ModelNode request) throws CommandFormatException, IOException {
        boolean didReplacement = false;
        ModelNode opDesc = new ModelNode();
        opDesc.get("address").set(request.get("address"));
        opDesc.get("operation").set("read-operation-description");
        String opName = request.get("operation").asString();
        opDesc.get("name").set(opName);
        ModelNode response = this.execute(opDesc, false).getResponseNode();
        if (response.hasDefined(new String[]{"result", "request-properties"})) {
            ModelNode requestProps = response.get(new String[]{"result", "request-properties"});
            for (Property prop : requestProps.asPropertyList()) {
                String filePath;
                File localFile;
                ModelNode typeDesc = prop.getValue().get("type");
                if (typeDesc.getType() != ModelType.TYPE || typeDesc.asType() != ModelType.BYTES || !request.hasDefined(prop.getName()) || !(localFile = new File(filePath = request.get(prop.getName()).asString())).exists()) continue;
                try {
                    request.get(prop.getName()).set(Util.readBytes(localFile));
                    didReplacement = true;
                }
                catch (OperationFormatException e) {
                    throw new CommandFormatException(e);
                }
            }
        }
        return didReplacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse execute(ModelNode request, boolean useWaitCursor) throws IOException {
        if (request.get("operation").asString().equals("composite") && (!request.get("steps").isDefined() || request.get("steps").asList().isEmpty())) {
            return OperationResponse.Factory.createSimple((ModelNode)new ModelNode("WARN: no request was sent as there were no server-side operations to execute"));
        }
        try {
            if (useWaitCursor) {
                this.cliGuiCtx.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
            OperationResponse operationResponse = this.client.executeOperation(OperationBuilder.create((ModelNode)request).build(), OperationMessageHandler.DISCARD);
            return operationResponse;
        }
        finally {
            if (useWaitCursor) {
                this.cliGuiCtx.getMainWindow().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private boolean isSlowCommand(String command) {
        return command.startsWith("deploy") || command.contains(":read-log-file");
    }

    public static class Response {
        private final OperationResponse response;
        private final String command;
        private final ModelNode dmrRequest;

        Response(String command, ModelNode dmrRequest, OperationResponse response) {
            this.command = command;
            this.dmrRequest = dmrRequest.clone();
            this.response = response;
        }

        public String getCommand() {
            return this.command;
        }

        public ModelNode getDmrRequest() {
            return this.dmrRequest;
        }

        public ModelNode getDmrResponse() {
            return this.response.getResponseNode();
        }

        public OperationResponse getOperationResponse() {
            return this.response;
        }
    }

    private class ClientCloserShutdownHook
    implements Runnable {
        private ClientCloserShutdownHook() {
        }

        @Override
        public void run() {
            try {
                CommandExecutor.this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

