/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.impl.CommandCandidatesProvider;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.CommandSubstitutionException;
import org.jboss.as.cli.parsing.UnresolvedVariableException;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.cli.parsing.operation.OperationFormat;

public class CommandCompleter
implements CommandLineCompleter {
    private final CommandRegistry cmdRegistry;
    private final CommandCandidatesProvider cmdProvider;

    public CommandCompleter(CommandRegistry cmdRegistry) {
        if (cmdRegistry == null) {
            throw new IllegalArgumentException("Command registry can't be null.");
        }
        this.cmdRegistry = cmdRegistry;
        this.cmdProvider = new CommandCandidatesProvider(cmdRegistry);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int result;
        int offset = 0;
        if (ctx.getArgumentsString() != null) {
            offset = ctx.getArgumentsString().length();
            buffer = ctx.getArgumentsString() + buffer;
        }
        if ((result = this.doComplete(ctx, buffer, cursor, candidates)) < 0) {
            return result;
        }
        return result - offset;
    }

    protected int doComplete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        List candidateVariables;
        String variable;
        int index;
        int notIndex;
        boolean unresolvedVariableException;
        DefaultCallbackHandler parsedCmd;
        block17: {
            if (buffer.isEmpty()) {
                for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
                    CommandHandler handler = this.cmdRegistry.getCommandHandler(cmd);
                    if (!handler.isAvailable(ctx)) continue;
                    candidates.add(cmd);
                }
                Collections.sort(candidates);
                candidates.add(OperationFormat.INSTANCE.getAddressOperationSeparator());
                return 0;
            }
            parsedCmd = (DefaultCallbackHandler)ctx.getParsedCommandLine();
            unresolvedVariableException = false;
            try {
                if (ctx.getArgumentsString() == null && buffer.length() > cursor) {
                    parsedCmd.parse(ctx.getCurrentNodePath(), buffer.substring(0, cursor), false, ctx);
                } else if (ctx.getArgumentsString() != null && buffer.length() - ctx.getArgumentsString().length() > cursor) {
                    parsedCmd.parse(ctx.getCurrentNodePath(), buffer.substring(0, ctx.getArgumentsString().length() + cursor), false, ctx);
                } else {
                    parsedCmd.parse(ctx.getCurrentNodePath(), buffer, false, ctx);
                }
            }
            catch (UnresolvedVariableException e2) {
                unresolvedVariableException = true;
                String variable2 = e2.getExpression();
                if (buffer.endsWith(variable2)) {
                    for (String var : ctx.getVariables()) {
                        if (!var.startsWith(variable2)) continue;
                        candidates.add(var);
                    }
                    Collections.sort(candidates);
                    return buffer.length() - variable2.length();
                }
                return -1;
            }
            catch (CommandSubstitutionException e3) {
                String cmd = e3.getExpression();
                if (buffer.endsWith(cmd)) {
                    int i = this.doComplete(ctx, cmd, cmd.length(), candidates);
                    if (i < 0) {
                        return -1;
                    }
                    return buffer.length() - cmd.length() + i;
                }
                return -1;
            }
            catch (CommandFormatException e4) {
                if (parsedCmd.endsOnAddressOperationNameSeparator() && parsedCmd.endsOnSeparator()) break block17;
                return -1;
            }
        }
        OperationCandidatesProvider candidatesProvider = buffer.isEmpty() || parsedCmd.getFormat() == CommandFormat.INSTANCE ? this.cmdProvider : ctx.getOperationCandidatesProvider();
        int result = OperationRequestCompleter.INSTANCE.complete(ctx, candidatesProvider, buffer, cursor, candidates);
        if (parsedCmd.getFormat() != OperationFormat.INSTANCE && (notIndex = candidates.indexOf("!")) >= 0) {
            candidates.remove(notIndex);
        }
        if (!unresolvedVariableException && (index = buffer.lastIndexOf(36)) != -1 && buffer.length() != index + 1 && buffer.endsWith(variable = buffer.substring(index + 1)) && !(candidateVariables = ctx.getVariables().stream().filter(e -> e.startsWith(variable) && !e.equals(variable)).collect(Collectors.toList())).isEmpty()) {
            candidates.addAll(candidateVariables);
            Collections.sort(candidates);
        }
        if (candidates.isEmpty() && buffer.charAt(buffer.length() - 1) == '$' && !ctx.getVariables().isEmpty()) {
            candidates.addAll(ctx.getVariables());
            Collections.sort(candidates);
            return buffer.length();
        }
        return result;
    }
}

