/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.parsing.CommandSubstitutionException;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.security.manager.WildFlySecurityManager;

public class Util {
    public static final String LINE_SEPARATOR = WildFlySecurityManager.getPropertyPrivileged((String)"line.separator", null);
    public static final String ACCESS_CONTROL = "access-control";
    public static final String ACCESS_TYPE = "access-type";
    public static final String ADD = "add";
    public static final String ADDRESS = "address";
    public static final String ALLOWED = "allowed";
    public static final String ALLOW_RESOURCE_SERVICE_RESTART = "allow-resource-service-restart";
    public static final String ARCHIVE = "archive";
    public static final String ATTACHED_STREAMS = "attached-streams";
    public static final String ATTRIBUTES = "attributes";
    public static final String BLOCKING_TIMEOUT = "blocking-timeout";
    public static final String BROWSE_CONTENT = "browse-content";
    public static final String BYTES = "bytes";
    public static final String CHILDREN = "children";
    public static final String CHILD_TYPE = "child-type";
    public static final String COMBINED_DESCRIPTIONS = "combined-descriptions";
    public static final String COMPOSITE = "composite";
    public static final String CONCURRENT_GROUPS = "concurrent-groups";
    public static final String CONTENT = "content";
    public static final String CORE_SERVICE = "core-service";
    public static final String DATASOURCES = "datasources";
    public static final String DEFAULT = "default";
    public static final String DEPLOY = "deploy";
    public static final String DEPLOYMENT = "deployment";
    public static final String DEPLOYMENT_NAME = "deployment-name";
    public static final String DEPLOYMENT_OVERLAY = "deployment-overlay";
    public static final String DEPTH = "depth";
    public static final String DESCRIPTION = "description";
    public static final String DOMAIN_FAILURE_DESCRIPTION = "domain-failure-description";
    public static final String DOMAIN_RESULTS = "domain-results";
    public static final String DRIVER_MODULE_NAME = "driver-module-name";
    public static final String DRIVER_NAME = "driver-name";
    public static final String ENABLED = "enabled";
    public static final String EXECUTE = "execute";
    public static final String EXPRESSIONS_ALLOWED = "expressions-allowed";
    public static final String EXTENSION = "extension";
    public static final String FAILURE_DESCRIPTION = "failure-description";
    public static final String FILESYSTEM_PATH = "filesystem-path";
    public static final String FULL_REPLACE_DEPLOYMENT = "full-replace-deployment";
    public static final String FALSE = "false";
    public static final String HEAD_COMMENT_ALLOWED = "head-comment-allowed";
    public static final String HOST = "host";
    public static final String ID = "id";
    public static final String IN_SERIES = "in-series";
    public static final String INCLUDE_DEFAULTS = "include-defaults";
    public static final String INCLUDE_RUNTIME = "include-runtime";
    public static final String INCLUDE_SINGLETONS = "include-singletons";
    public static final String INPUT_STREAM_INDEX = "input-stream-index";
    public static final String INSTALLED_DRIVERS_LIST = "installed-drivers-list";
    public static final String LOCAL_HOST_NAME = "local-host-name";
    public static final String MANAGEMENT_CLIENT_CONTENT = "management-client-content";
    public static final String MASTER = "master";
    public static final String MAX_FAILED_SERVERS = "max-failed-servers";
    public static final String MAX_FAILURE_PERCENTAGE = "max-failure-percentage";
    public static final String MAX_OCCURS = "max-occurs";
    public static final String MIN_OCCURS = "min-occurs";
    public static final String MODULE = "module";
    public static final String MODULE_SLOT = "module-slot";
    public static final String NAME = "name";
    public static final String NILLABLE = "nillable";
    public static final String OPERATION = "operation";
    public static final String OPERATIONS = "operations";
    public static final String OPERATION_HEADERS = "operation-headers";
    public static final String OUTCOME = "outcome";
    public static final String PATH = "path";
    public static final String PERSISTENT = "persistent";
    public static final String PROBLEM = "problem";
    public static final String PRODUCT_NAME = "product-name";
    public static final String PRODUCT_VERSION = "product-version";
    public static final String PROFILE = "profile";
    public static final String READ = "read";
    public static final String READ_ATTRIBUTE = "read-attribute";
    public static final String READ_CHILDREN_NAMES = "read-children-names";
    public static final String READ_CHILDREN_RESOURCES = "read-children-resources";
    public static final String READ_CHILDREN_TYPES = "read-children-types";
    public static final String READ_ONLY = "read-only";
    public static final String READ_OPERATION_DESCRIPTION = "read-operation-description";
    public static final String READ_OPERATION_NAMES = "read-operation-names";
    public static final String READ_WRITE = "read-write";
    public static final String READ_RESOURCE = "read-resource";
    public static final String READ_RESOURCE_DESCRIPTION = "read-resource-description";
    public static final String REDEPLOY = "redeploy";
    public static final String RELATIVE_TO = "relative-to";
    public static final String RELEASE_CODENAME = "release-codename";
    public static final String RELEASE_VERSION = "release-version";
    public static final String RELOAD = "reload";
    public static final String REMOVE = "remove";
    public static final String REPLY_PROPERTIES = "reply-properties";
    public static final String REQUEST_PROPERTIES = "request-properties";
    public static final String REQUIRED = "required";
    public static final String RESOLVE_EXPRESSIONS = "resolve-expressions";
    public static final String RESPONSE_HEADERS = "response-headers";
    public static final String RESTART = "restart";
    public static final String RESTART_REQUIRED = "restart-required";
    public static final String RESULT = "result";
    public static final String ROLLED_BACK = "rolled-back";
    public static final String ROLLBACK_ACROSS_GROUPS = "rollback-across-groups";
    public static final String ROLLBACK_FAILURE_DESCRIPTION = "rollback-failure-description";
    public static final String ROLLBACK_ON_RUNTIME_FAILURE = "rollback-on-runtime-failure";
    public static final String ROLLING_TO_SERVERS = "rolling-to-servers";
    public static final String ROLLOUT_PLAN = "rollout-plan";
    public static final String ROLLOUT_PLANS = "rollout-plans";
    public static final String RUNTIME_NAME = "runtime-name";
    public static final String SERVER = "server";
    public static final String SERVER_GROUP = "server-group";
    public static final String SHUTDOWN = "shutdown";
    public static final String STATUS = "status";
    public static final String STEP_1 = "step-1";
    public static final String STEP_2 = "step-2";
    public static final String STEP_3 = "step-3";
    public static final String STEPS = "steps";
    public static final String STORAGE = "storage";
    public static final String SUBDEPLOYMENT = "subdeployment";
    public static final String SUBSYSTEM = "subsystem";
    public static final String SUCCESS = "success";
    public static final String TAIL_COMMENT_ALLOWED = "tail-comment-allowed";
    public static final String TIMEOUT = "timeout";
    public static final String TRIM_DESCRIPTIONS = "trim-descriptions";
    public static final String TRUE = "true";
    public static final String TYPE = "type";
    public static final String UNDEFINE_ATTRIBUTE = "undefine-attribute";
    public static final String UNDEPLOY = "undeploy";
    public static final String UPLOAD_DEPLOYMENT_STREAM = "upload-deployment-stream";
    public static final String URL = "url";
    public static final String VALID = "valid";
    public static final String VALIDATE_ADDRESS = "validate-address";
    public static final String VALUE = "value";
    public static final String VALUE_TYPE = "value-type";
    public static final String WRITE = "write";
    public static final String WRITE_ATTRIBUTE = "write-attribute";
    public static final String DESCRIPTION_RESPONSE = "DESCRIPTION_RESPONSE";
    public static final String NOT_OPERATOR = "!";
    private static final Map<Character, Character> wrappingPairs = new HashMap<Character, Character>();

    public static boolean isWindows() {
        return WildFlySecurityManager.getPropertyPrivileged((String)"os.name", null).toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    }

    public static boolean isSuccess(ModelNode operationResponse) {
        if (operationResponse != null) {
            return operationResponse.hasDefined(OUTCOME) && operationResponse.get(OUTCOME).asString().equals(SUCCESS);
        }
        return false;
    }

    public static String getFailureDescription(ModelNode operationResponse) {
        if (operationResponse == null) {
            return null;
        }
        ModelNode descr = operationResponse.get(FAILURE_DESCRIPTION);
        if (descr == null) {
            return null;
        }
        if (descr.hasDefined(DOMAIN_FAILURE_DESCRIPTION)) {
            descr = descr.get(DOMAIN_FAILURE_DESCRIPTION);
        }
        if (descr.hasDefined(ROLLED_BACK)) {
            StringBuilder buf = new StringBuilder();
            buf.append(descr.asString());
            if (descr.get(ROLLED_BACK).asBoolean()) {
                buf.append("(The operation was rolled back)");
            } else if (descr.hasDefined(ROLLBACK_FAILURE_DESCRIPTION)) {
                buf.append(descr.get(ROLLBACK_FAILURE_DESCRIPTION).toString());
            } else {
                buf.append("(The operation also failed to rollback, failure description is not available.)");
            }
        } else {
            return descr.asString();
        }
        return descr.asString();
    }

    public static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined(RESULT)) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get(RESULT).asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    public static List<String> getList(ModelNode operationResult, String wildcardExpr) {
        if (!operationResult.hasDefined(RESULT)) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get(RESULT).asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        Pattern pattern = Pattern.compile(Util.wildcardToJavaRegex(wildcardExpr));
        for (ModelNode node : nodeList) {
            String candidate = node.asString();
            if (!pattern.matcher(candidate).matches()) continue;
            list.add(candidate);
        }
        return list;
    }

    public static String wildcardToJavaRegex(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        String regex = expr.replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }

    public static boolean listContains(ModelNode operationResult, String item) {
        if (!operationResult.hasDefined(RESULT)) {
            return false;
        }
        List nodeList = operationResult.get(RESULT).asList();
        if (nodeList.isEmpty()) {
            return false;
        }
        for (ModelNode node : nodeList) {
            if (!node.asString().equals(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeploymentInRepository(String name, ModelControllerClient client) {
        return Util.getDeployments(client).contains(name);
    }

    public static boolean isDeployedAndEnabledInStandalone(String name, ModelControllerClient client) {
        ModelNode outcome;
        ModelNode request;
        DefaultOperationRequestBuilder builder;
        block12: {
            builder = new DefaultOperationRequestBuilder();
            try {
                builder.setOperationName(READ_CHILDREN_NAMES);
                builder.addProperty(CHILD_TYPE, DEPLOYMENT);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (Util.isSuccess(outcome)) {
                    if (!Util.listContains(outcome, name)) {
                        return false;
                    }
                    break block12;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        builder = new DefaultOperationRequestBuilder();
        builder.addNode(DEPLOYMENT, name);
        builder.setOperationName(READ_ATTRIBUTE);
        builder.addProperty(NAME, ENABLED);
        try {
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                if (!outcome.hasDefined(RESULT)) {
                    return false;
                }
                return outcome.get(RESULT).asBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isEnabledDeployment(String name, ModelControllerClient client, String serverGroup) throws OperationFormatException, IOException, CommandFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        if (serverGroup != null) {
            builder.addNode(SERVER_GROUP, serverGroup);
        }
        builder.addNode(DEPLOYMENT, name);
        builder.setOperationName(READ_ATTRIBUTE);
        builder.addProperty(NAME, ENABLED);
        ModelNode request = builder.buildRequest();
        ModelNode outcome = client.execute(request);
        if (Util.isSuccess(outcome)) {
            if (!outcome.hasDefined(RESULT)) {
                throw new CommandFormatException("No result for " + name);
            }
            return outcome.get(RESULT).asBoolean();
        }
        return false;
    }

    public static List<String> getAllEnabledServerGroups(String deploymentName, ModelControllerClient client) {
        List<String> serverGroups = Util.getServerGroups(client);
        if (serverGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String serverGroup : serverGroups) {
            ModelNode outcome;
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                builder.setOperationName(READ_CHILDREN_NAMES);
                builder.addNode(SERVER_GROUP, serverGroup);
                builder.addProperty(CHILD_TYPE, DEPLOYMENT);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (!Util.isSuccess(outcome)) continue;
                if (!Util.listContains(outcome, deploymentName)) {
                }
            }
            catch (Exception e) {}
            continue;
            builder = new DefaultOperationRequestBuilder();
            builder.addNode(SERVER_GROUP, serverGroup);
            builder.addNode(DEPLOYMENT, deploymentName);
            builder.setOperationName(READ_ATTRIBUTE);
            builder.addProperty(NAME, ENABLED);
            try {
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                outcome = client.execute(request);
                if (!Util.isSuccess(outcome) || !outcome.hasDefined(RESULT) || !outcome.get(RESULT).asBoolean()) continue;
                result.add(serverGroup);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static List<String> getServerGroupsReferencingDeployment(String deploymentName, ModelControllerClient client) throws CommandLineException {
        List<String> serverGroups = Util.getServerGroups(client);
        if (serverGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        for (String serverGroup : serverGroups) {
            ModelNode response;
            ModelNode request = new ModelNode();
            request.get(OPERATION).set(VALIDATE_ADDRESS);
            request.get(ADDRESS).setEmptyList();
            ModelNode addr = request.get(VALUE);
            addr.add(SERVER_GROUP, serverGroup);
            addr.add(DEPLOYMENT, deploymentName);
            try {
                response = client.execute(request);
            }
            catch (Exception e) {
                throw new CommandLineException("Failed to execute validate-address for " + request.get(ADDRESS), e);
            }
            if (response.has(RESULT)) {
                ModelNode result = response.get(RESULT);
                if (result.has(VALID)) {
                    if (!result.get(VALID).asBoolean()) continue;
                    groupNames.add(serverGroup);
                    continue;
                }
                throw new CommandLineException("Failed to validate address " + request.get(ADDRESS) + ": " + response);
            }
            throw new CommandLineException(Util.getFailureDescription(response));
        }
        return groupNames;
    }

    public static List<String> getServerGroupsReferencingOverlay(String overlayName, ModelControllerClient client) throws CommandLineException {
        List<String> serverGroups = Util.getServerGroups(client);
        if (serverGroups.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> groupNames = new ArrayList<String>();
        for (String serverGroup : serverGroups) {
            ModelNode response;
            ModelNode request = new ModelNode();
            request.get(OPERATION).set(VALIDATE_ADDRESS);
            request.get(ADDRESS).setEmptyList();
            ModelNode addr = request.get(VALUE);
            addr.add(SERVER_GROUP, serverGroup);
            addr.add(DEPLOYMENT_OVERLAY, overlayName);
            try {
                response = client.execute(request);
            }
            catch (Exception e) {
                throw new CommandLineException("Failed to execute validate-address for " + request.get(ADDRESS), e);
            }
            if (response.has(RESULT)) {
                ModelNode result = response.get(RESULT);
                if (result.has(VALID)) {
                    if (!result.get(VALID).asBoolean()) continue;
                    groupNames.add(serverGroup);
                    continue;
                }
                throw new CommandLineException("Failed to validate address " + request.get(ADDRESS) + ": " + response);
            }
            throw new CommandLineException(Util.getFailureDescription(response));
        }
        return groupNames;
    }

    public static List<String> getDeployments(ModelControllerClient client) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, DEPLOYMENT);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getDeployments(ModelControllerClient client, String serverGroup) {
        ModelNode request = new ModelNode();
        ModelNode address = request.get(ADDRESS);
        if (serverGroup != null) {
            address.add(SERVER_GROUP, serverGroup);
        }
        request.get(OPERATION).set(READ_CHILDREN_NAMES);
        request.get(CHILD_TYPE).set(DEPLOYMENT);
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getMatchingDeployments(ModelControllerClient client, String wildcardExpr, String serverGroup) {
        return Util.getMatchingDeployments(client, wildcardExpr, serverGroup, false);
    }

    public static List<String> getMatchingDeployments(ModelControllerClient client, String wildcardExpr, String serverGroup, boolean matchSubdeployments) {
        block13: {
            ModelNode request;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            try {
                if (serverGroup != null) {
                    builder.addNode(SERVER_GROUP, serverGroup);
                }
                builder.setOperationName(READ_CHILDREN_NAMES);
                builder.addProperty(CHILD_TYPE, DEPLOYMENT);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
            try {
                ModelNode outcome = client.execute(request);
                if (!Util.isSuccess(outcome)) break block13;
                if (!outcome.hasDefined(RESULT)) {
                    return Collections.emptyList();
                }
                List nodeList = outcome.get(RESULT).asList();
                if (nodeList.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<String> list = new ArrayList<String>(nodeList.size());
                Pattern pattern = Pattern.compile(Util.wildcardToJavaRegex(wildcardExpr));
                block6: for (ModelNode node : nodeList) {
                    List subdList;
                    String candidate = node.asString();
                    if (pattern.matcher(candidate).matches()) {
                        list.add(candidate);
                        continue;
                    }
                    if (!matchSubdeployments) continue;
                    builder = new DefaultOperationRequestBuilder();
                    try {
                        if (serverGroup != null) {
                            builder.addNode(SERVER_GROUP, serverGroup);
                        }
                        builder.addNode(DEPLOYMENT, candidate);
                        builder.setOperationName(READ_CHILDREN_NAMES);
                        builder.addProperty(CHILD_TYPE, SUBDEPLOYMENT);
                        request = builder.buildRequest();
                    }
                    catch (OperationFormatException e) {
                        throw new IllegalStateException("Failed to build operation", e);
                    }
                    outcome = client.execute(request);
                    if (!Util.isSuccess(outcome) || !outcome.hasDefined(RESULT) || (subdList = outcome.get(RESULT).asList()).isEmpty()) continue;
                    for (ModelNode subd : subdList) {
                        String subdName = subd.asString();
                        if (!pattern.matcher(subdName).matches()) continue;
                        list.add(candidate);
                        continue block6;
                    }
                }
                return list;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public static List<String> getServerGroups(ModelControllerClient client) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, SERVER_GROUP);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getNodeTypes(ModelControllerClient client, OperationRequestAddress address) {
        List<String> result;
        ModelNode request;
        if (client == null) {
            return Collections.emptyList();
        }
        if (address.endsOnType()) {
            throw new IllegalArgumentException("The prefix isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(address);
        try {
            builder.setOperationName(READ_CHILDREN_TYPES);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<String> getNodeNames(ModelControllerClient client, OperationRequestAddress address, String type) {
        List<String> result;
        ModelNode request;
        if (client == null) {
            return Collections.emptyList();
        }
        if (address != null && address.endsOnType()) {
            throw new IllegalArgumentException("The address isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = address == null ? new DefaultOperationRequestBuilder() : new DefaultOperationRequestBuilder(address);
        try {
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<String> getOperationNames(CommandContext ctx, OperationRequestAddress prefix) {
        List<String> result;
        ModelNode request;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        if (prefix.endsOnType()) {
            throw new IllegalArgumentException("The prefix isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(prefix);
        try {
            builder.setOperationName(READ_OPERATION_NAMES);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        if (ctx.getConfig().isAccessControl()) {
            request.get(ACCESS_CONTROL).set(true);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static List<String> getJmsResources(ModelControllerClient client, String profile, String type) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (profile != null) {
                builder.addNode(PROFILE, profile);
            }
            builder.addNode(SUBSYSTEM, "messaging");
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static List<String> getDatasources(ModelControllerClient client, String profile, String dsType) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            if (profile != null) {
                builder.addNode(PROFILE, profile);
            }
            builder.addNode(SUBSYSTEM, DATASOURCES);
            builder.setOperationName(READ_CHILDREN_NAMES);
            builder.addProperty(CHILD_TYPE, dsType);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public static boolean isTopic(ModelControllerClient client, String name) {
        List<String> topics = Util.getJmsResources(client, null, "jms-topic");
        return topics.contains(name);
    }

    public static boolean isQueue(ModelControllerClient client, String name) {
        List<String> queues = Util.getJmsResources(client, null, "jms-queue");
        return queues.contains(name);
    }

    public static boolean isConnectionFactory(ModelControllerClient client, String name) {
        List<String> cf = Util.getJmsResources(client, null, "connection-factory");
        return cf.contains(name);
    }

    public static ModelNode configureDeploymentOperation(String operationName, String uniqueName, String serverGroup) {
        ModelNode op = new ModelNode();
        op.get(OPERATION).set(operationName);
        if (serverGroup != null) {
            op.get(ADDRESS).add(SERVER_GROUP, serverGroup);
        }
        op.get(ADDRESS).add(DEPLOYMENT, uniqueName);
        return op;
    }

    public static boolean isValidPath(ModelControllerClient client, String ... node) throws CommandLineException {
        ModelNode response;
        if (node == null) {
            return false;
        }
        if (node.length % 2 != 0) {
            return false;
        }
        ModelNode op = new ModelNode();
        op.get(ADDRESS).setEmptyList();
        op.get(OPERATION).set(VALIDATE_ADDRESS);
        ModelNode addressValue = op.get(VALUE);
        for (int i = 0; i < node.length; i += 2) {
            addressValue.add(node[i], node[i + 1]);
        }
        try {
            response = client.execute(op);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to execute validate-address", e);
        }
        ModelNode result = response.get(RESULT);
        if (!result.isDefined()) {
            return false;
        }
        ModelNode valid = result.get(VALID);
        if (!valid.isDefined()) {
            return false;
        }
        return valid.asBoolean();
    }

    public static String getCommonStart(List<String> list) {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return list.get(0);
        }
        String first = list.get(0);
        String last = list.get(size - 1);
        int minSize = Math.min(first.length(), last.length());
        for (int i = 0; i < minSize; ++i) {
            if (first.charAt(i) == last.charAt(i)) continue;
            if (i == 0) {
                return null;
            }
            return first.substring(0, i);
        }
        return first.substring(0, minSize);
    }

    public static String escapeString(String name, EscapeSelector selector) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!selector.isEscape(ch)) continue;
            StringBuilder builder = new StringBuilder();
            builder.append(name, 0, i);
            builder.append('\\').append(ch);
            for (int j = i + 1; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (selector.isEscape(ch)) {
                    builder.append('\\');
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return name;
    }

    public static void sortAndEscape(List<String> candidates, EscapeSelector selector) {
        Collections.sort(candidates);
        String common = Util.getCommonStart(candidates);
        if (common != null) {
            String escapedCommon = Util.escapeString(common, selector);
            if (common.length() != escapedCommon.length()) {
                for (int i = 0; i < candidates.size(); ++i) {
                    candidates.set(i, escapedCommon + candidates.get(i).substring(common.length()));
                }
            }
        }
    }

    public static void setRequestProperty(ModelNode request, String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument name is not specified: '" + name + "'");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument value is not specified: '" + value + "'");
        }
        ModelNode toSet = null;
        try {
            toSet = ModelNode.fromString((String)value);
        }
        catch (Exception e) {
            toSet = new ModelNode().set(value);
        }
        request.get(name).set(toSet);
    }

    public static ModelNode buildRequest(CommandContext ctx, OperationRequestAddress address, String operation) throws CommandFormatException {
        ModelNode request = new ModelNode();
        request.get(OPERATION).set(operation);
        ModelNode addressNode = request.get(ADDRESS);
        if (address.isEmpty()) {
            addressNode.setEmptyList();
        } else {
            if (address.endsOnType()) {
                throw new CommandFormatException("The address ends on a type: " + address.getNodeType());
            }
            for (OperationRequestAddress.Node node : address) {
                addressNode.add(node.getType(), node.getName());
            }
        }
        return request;
    }

    public static ModelNode getRolloutPlan(ModelControllerClient client, String name) throws CommandFormatException {
        ModelNode response;
        ModelNode request = new ModelNode();
        request.get(OPERATION).set(READ_ATTRIBUTE);
        ModelNode addr = request.get(ADDRESS);
        addr.add(MANAGEMENT_CLIENT_CONTENT, ROLLOUT_PLANS);
        addr.add(ROLLOUT_PLAN, name);
        request.get(NAME).set(CONTENT);
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute request: " + e.getMessage(), e);
        }
        if (!response.hasDefined(OUTCOME)) {
            throw new CommandFormatException("Operation response if missing outcome: " + response);
        }
        if (!response.get(OUTCOME).asString().equals(SUCCESS)) {
            throw new CommandFormatException("Failed to load rollout plan: " + response);
        }
        if (!response.hasDefined(RESULT)) {
            throw new CommandFormatException("Operation response is missing result.");
        }
        return response.get(RESULT);
    }

    public static List<String> splitCommands(String line) {
        int i;
        List<String> commands = null;
        int nextOpIndex = 0;
        Character expectedClosing = null;
        ArrayDeque<Character> expectedClosingStack = null;
        for (i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (expectedClosing != null && expectedClosing.charValue() == ch) {
                if (expectedClosingStack != null && !expectedClosingStack.isEmpty()) {
                    expectedClosing = (Character)expectedClosingStack.pop();
                    continue;
                }
                expectedClosing = null;
                continue;
            }
            Character matchingClosing = wrappingPairs.get(Character.valueOf(ch));
            if (matchingClosing != null) {
                if (expectedClosing == null) {
                    expectedClosing = matchingClosing;
                    continue;
                }
                if (expectedClosingStack == null) {
                    expectedClosingStack = new ArrayDeque<Character>();
                }
                expectedClosingStack.push(expectedClosing);
                expectedClosing = matchingClosing;
                continue;
            }
            if (expectedClosing != null || ch != ',') continue;
            if (commands == null) {
                commands = new ArrayList<String>();
            }
            commands.add(line.substring(nextOpIndex, i));
            nextOpIndex = i + 1;
        }
        if (commands == null) {
            commands = Collections.singletonList(line);
        } else {
            commands.add(line.substring(nextOpIndex, i));
        }
        return commands;
    }

    public static byte[] readBytes(File f) throws OperationFormatException {
        byte[] bytes;
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            bytes = new byte[(int)f.length()];
            int read = is.read(bytes);
            if (read != bytes.length) {
                throw new OperationFormatException("Failed to read bytes from " + f.getAbsolutePath() + ": " + read + " from " + f.length());
            }
        }
        catch (Exception e) {
            try {
                throw new OperationFormatException("Failed to read file " + f.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)is);
        return bytes;
    }

    public static String getResult(CommandContext cmdCtx, String cmd) throws CommandSubstitutionException {
        ModelNode response;
        ModelNode request;
        try {
            request = cmdCtx.buildRequest(cmd);
        }
        catch (CommandFormatException e) {
            throw new CommandSubstitutionException(cmd, "Failed to substitute " + cmd, e);
        }
        ModelControllerClient client = cmdCtx.getModelControllerClient();
        if (client == null) {
            throw new CommandSubstitutionException(cmd, "Substitution of " + cmd + " requires connection to the controller.");
        }
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            throw new CommandSubstitutionException(cmd, "Failed to substitute " + cmd, e);
        }
        if (!Util.isSuccess(response)) {
            throw new CommandSubstitutionException(cmd, "Failed to substitute " + cmd + ": " + Util.getFailureDescription(response));
        }
        return response.get(RESULT).asString();
    }

    public static ModelNode toOperationRequest(CommandContext ctx, ParsedCommandLine parsedLine, Attachments attachments) throws CommandFormatException {
        return Util.toOperationRequest(ctx, parsedLine, attachments, true);
    }

    public static ModelNode toOperationRequest(CommandContext ctx, ParsedCommandLine parsedLine) throws CommandFormatException {
        return Util.toOperationRequest(ctx, parsedLine, new Attachments(), false);
    }

    private static ModelNode toOperationRequest(CommandContext ctx, ParsedCommandLine parsedLine, Attachments attachments, boolean description) throws CommandFormatException {
        if (parsedLine.getFormat() != OperationFormat.INSTANCE) {
            throw new OperationFormatException("The line does not follow the operation request format");
        }
        ModelNode request = new ModelNode();
        ModelNode addressNode = request.get(ADDRESS);
        if (parsedLine.getAddress().isEmpty()) {
            addressNode.setEmptyList();
        } else {
            Iterator iterator = parsedLine.getAddress().iterator();
            while (iterator.hasNext()) {
                OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    addressNode.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("The node name is not specified for type '" + node.getType() + "'");
            }
        }
        String operationName = parsedLine.getOperationName();
        if (operationName == null || operationName.isEmpty()) {
            throw new OperationFormatException("The operation name is missing or the format of the operation request is wrong.");
        }
        request.get(OPERATION).set(operationName);
        ModelNode outcome = null;
        if (description) {
            outcome = (ModelNode)ctx.get(CommandContext.Scope.REQUEST, DESCRIPTION_RESPONSE);
            if (outcome == null && (outcome = Util.retrieveDescription(ctx, request, false)) != null) {
                ctx.set(CommandContext.Scope.REQUEST, DESCRIPTION_RESPONSE, outcome);
            }
            if (outcome != null) {
                if (!outcome.has(RESULT)) {
                    throw new CommandFormatException("Failed to perform read-operation-description to validate the request: result is not available.");
                }
                outcome = outcome.get(RESULT).get(REQUEST_PROPERTIES);
            }
        }
        for (String propName : parsedLine.getPropertyNames()) {
            String value = parsedLine.getPropertyValue(propName);
            if (propName == null || propName.trim().isEmpty()) {
                throw new OperationFormatException("The argument name is not specified: '" + propName + "'");
            }
            if (value == null || value.trim().isEmpty()) {
                throw new OperationFormatException("The argument value is not specified for " + propName + ": '" + value + "'");
            }
            ModelNode toSet = ArgumentValueConverter.DEFAULT.fromString(ctx, value);
            if (outcome != null) {
                Util.applyReplacements(propName, toSet, outcome.get(propName), outcome.get(propName).get(TYPE).asType(), attachments);
            }
            request.get(propName).set(toSet);
        }
        if (parsedLine.getLastHeaderName() != null) {
            throw new OperationFormatException("Header '" + parsedLine.getLastHeaderName() + "' is not complete.");
        }
        Collection<ParsedOperationRequestHeader> headers = parsedLine.getHeaders();
        if (headers != null && !headers.isEmpty()) {
            ModelNode headersNode = request.get(OPERATION_HEADERS);
            for (ParsedOperationRequestHeader header : headers) {
                header.addTo(ctx, headersNode);
            }
        }
        return request;
    }

    public static String getMessagesFromThrowable(Throwable t) {
        StringBuilder buf = new StringBuilder();
        if (t.getLocalizedMessage() != null) {
            buf.append(t.getLocalizedMessage());
        } else {
            buf.append(t.getClass().getName());
        }
        for (Throwable t1 = t.getCause(); t1 != null; t1 = t1.getCause()) {
            if (t1.getLocalizedMessage() != null) {
                buf.append(": ").append(t1.getLocalizedMessage());
                continue;
            }
            buf.append(": ").append(t1.getClass().getName());
        }
        return buf.toString();
    }

    private static ModelNode retrieveDescription(CommandContext ctx, ModelNode request, boolean strict) throws CommandFormatException {
        ModelNode outcome;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            throw new CommandFormatException("No connection to the controller.");
        }
        Set keys = request.keys();
        if (!keys.contains(OPERATION)) {
            throw new CommandFormatException("Request is missing the operation name.");
        }
        String operationName = request.get(OPERATION).asString();
        if (!keys.contains(ADDRESS)) {
            throw new CommandFormatException("Request is missing the address part.");
        }
        ModelNode address = request.get(ADDRESS);
        ModelNode opDescrReq = new ModelNode();
        opDescrReq.get(ADDRESS).set(address);
        opDescrReq.get(OPERATION).set(READ_OPERATION_DESCRIPTION);
        opDescrReq.get(NAME).set(operationName);
        try {
            outcome = client.execute(opDescrReq);
        }
        catch (Exception e) {
            throw new CommandFormatException("Failed to perform read-operation-description", e);
        }
        if (!Util.isSuccess(outcome)) {
            if (strict) {
                throw new CommandFormatException("Failed to get the list of the operation properties: \"" + Util.getFailureDescription(outcome) + '\"');
            }
            return null;
        }
        return outcome;
    }

    public static ModelNode validateRequest(CommandContext ctx, ModelNode request) throws CommandFormatException {
        Set definedProps;
        Set keys = request.keys();
        if (keys.size() == 2) {
            return null;
        }
        ModelNode outcome = (ModelNode)ctx.get(CommandContext.Scope.REQUEST, DESCRIPTION_RESPONSE);
        if (outcome == null) {
            outcome = Util.retrieveDescription(ctx, request, true);
            if (outcome == null) {
                return null;
            }
            ctx.set(CommandContext.Scope.REQUEST, DESCRIPTION_RESPONSE, outcome);
        }
        if (!outcome.has(RESULT)) {
            throw new CommandFormatException("Failed to perform read-operation-description to validate the request: result is not available.");
        }
        String operationName = request.get(OPERATION).asString();
        ModelNode result = outcome.get(RESULT);
        Set set = definedProps = result.hasDefined(REQUEST_PROPERTIES) ? result.get(REQUEST_PROPERTIES).keys() : Collections.emptySet();
        if (definedProps.isEmpty()) {
            if (keys.size() != 3 || !keys.contains(OPERATION_HEADERS)) {
                throw new CommandFormatException("Operation '" + operationName + "' does not expect any property.");
            }
        } else {
            int skipped = 0;
            for (String prop : keys) {
                if (skipped < 2 && (prop.equals(ADDRESS) || prop.equals(OPERATION))) {
                    ++skipped;
                    continue;
                }
                if (definedProps.contains(prop) || OPERATION_HEADERS.equals(prop)) continue;
                throw new CommandFormatException("'" + prop + "' is not found among the supported properties: " + definedProps);
            }
        }
        return outcome;
    }

    public static void replaceFilePathsWithBytes(ModelNode request, ModelNode opDescOutcome) throws CommandFormatException {
        ModelNode requestProps = opDescOutcome.get(new String[]{RESULT, REQUEST_PROPERTIES});
        for (Property prop : requestProps.asPropertyList()) {
            String filePath;
            File localFile;
            ModelNode typeDesc = prop.getValue().get(TYPE);
            if (typeDesc.getType() != ModelType.TYPE || typeDesc.asType() != ModelType.BYTES || !request.hasDefined(prop.getName()) || !(localFile = new File(filePath = request.get(prop.getName()).asString())).exists()) continue;
            try {
                request.get(prop.getName()).set(Util.readBytes(localFile));
            }
            catch (OperationFormatException e) {
                throw new CommandFormatException(e);
            }
        }
    }

    static void applyReplacements(String name, ModelNode value, ModelNode description, ModelType mt, Attachments attachments) {
        if (value == null || !value.isDefined()) {
            return;
        }
        switch (mt) {
            case INT: {
                if (!value.getType().equals((Object)ModelType.STRING) || !Util.isFileAttachment(description)) break;
                value.set(attachments.addFileAttachment(value.asString()));
                break;
            }
            case LIST: {
                ModelNode valueType;
                if (!mt.equals((Object)value.getType()) || !(valueType = description.get(VALUE_TYPE)).isDefined()) break;
                ModelType valueTypeType = valueType.getType();
                if (ModelType.OBJECT.equals((Object)valueTypeType)) {
                    for (int i = 0; i < value.asInt(); ++i) {
                        Util.applyReplacements(VALUE_TYPE, value.get(i), valueType, ModelType.OBJECT, attachments);
                    }
                } else {
                    if (!ModelType.INT.equals((Object)valueType.asType()) || !Util.isFileAttachment(description)) break;
                    for (int i = 0; i < value.asInt(); ++i) {
                        value.get(i).set(attachments.addFileAttachment(value.get(i).asString()));
                    }
                }
                break;
            }
            case OBJECT: {
                if (!mt.equals((Object)value.getType())) break;
                ModelNode valueType = description.get(VALUE_TYPE);
                if (!valueType.isDefined()) {
                    valueType = description;
                }
                for (String k : value.keys()) {
                    if (!value.get(k).isDefined()) continue;
                    Util.applyReplacements(k, value.get(k), valueType.get(k), valueType.get(k).get(TYPE).asType(), attachments);
                }
                break;
            }
        }
    }

    private static boolean isFileAttachment(ModelNode mn) {
        return mn.has(FILESYSTEM_PATH) && mn.get(FILESYSTEM_PATH).asBoolean() && mn.has(ATTACHED_STREAMS) && mn.get(ATTACHED_STREAMS).asBoolean();
    }

    static {
        wrappingPairs.put(Character.valueOf('('), Character.valueOf(')'));
        wrappingPairs.put(Character.valueOf('{'), Character.valueOf('}'));
        wrappingPairs.put(Character.valueOf('['), Character.valueOf(']'));
        wrappingPairs.put(Character.valueOf('\"'), Character.valueOf('\"'));
    }
}

