/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.AttributeNamePathCompleter;
import org.jboss.as.cli.impl.BytesCompleter;
import org.jboss.as.cli.impl.DeploymentItemCompleter;
import org.jboss.as.cli.impl.ValueTypeCompleter;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestHeader;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.CapabilityReferenceCompleter;
import org.jboss.as.cli.operation.impl.ChildTypeCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.operation.impl.OperationNameCompleter;
import org.jboss.as.cli.operation.impl.RolloutPlanRequestHeader;
import org.jboss.as.cli.parsing.ParserUtil;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class DefaultOperationCandidatesProvider
implements OperationCandidatesProvider {
    private static final SimpleTabCompleter NO_CANDIDATES_COMPLETER = new SimpleTabCompleter(new String[0]);
    private static final CommandLineCompleter BOOLEAN_HEADER_COMPLETER = new CommandLineCompleter(){
        private final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            try {
                ParserUtil.parseHeaders(buffer, this.parsedOp);
            }
            catch (CommandFormatException e) {
                return -1;
            }
            if (this.parsedOp.endsOnSeparator()) {
                candidates.add("false");
                candidates.add("true");
                return buffer.length();
            }
            if (this.parsedOp.getLastHeader() == null) {
                candidates.add("=");
                return buffer.length();
            }
            int result = SimpleTabCompleter.BOOLEAN.complete(ctx, buffer.substring(this.parsedOp.getLastChunkIndex()), cursor, candidates);
            if (candidates.size() == 1 && candidates.get(0).equals(buffer.substring(this.parsedOp.getLastChunkIndex()))) {
                candidates.clear();
                candidates.add(buffer.substring(this.parsedOp.getLastChunkIndex()) + ";");
            }
            if (result < 0) {
                return result;
            }
            return this.parsedOp.getLastChunkIndex() + result;
        }
    };
    private static final CommandLineCompleter INT_HEADER_COMPLETER = new CommandLineCompleter(){
        private final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            try {
                ParserUtil.parseHeaders(buffer, this.parsedOp);
            }
            catch (CommandFormatException e) {
                return -1;
            }
            if (this.parsedOp.endsOnSeparator()) {
                return buffer.length();
            }
            if (this.parsedOp.getLastHeader() == null) {
                candidates.add("=");
                return buffer.length();
            }
            return buffer.length();
        }
    };
    private static final Map<String, OperationRequestHeader> HEADERS = new HashMap<String, OperationRequestHeader>();
    private static final Map<String, Map<String, CommandLineCompleterFactory>> globalOpPropCompleters;

    private static void addBooleanHeader(final String name) {
        OperationRequestHeader header = new OperationRequestHeader(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public CommandLineCompleter getCompleter() {
                return BOOLEAN_HEADER_COMPLETER;
            }
        };
        HEADERS.put(header.getName(), header);
    }

    private static void addIntHeader(final String name) {
        OperationRequestHeader header = new OperationRequestHeader(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public CommandLineCompleter getCompleter() {
                return INT_HEADER_COMPLETER;
            }
        };
        HEADERS.put(header.getName(), header);
    }

    public List<String> getNodeNames(CommandContext ctx, OperationRequestAddress prefix) {
        List<String> result;
        ModelNode request;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("The prefix must end on a type but it's empty.");
        }
        if (!prefix.endsOnType()) {
            throw new IllegalArgumentException("The prefix doesn't end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(prefix);
        try {
            builder.setOperationName("read-children-names");
            builder.addProperty("child-type", prefix.getNodeType());
            builder.addProperty("include-singletons", "true");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<String> getNodeTypes(CommandContext ctx, OperationRequestAddress prefix) {
        return Util.getNodeTypes(ctx.getModelControllerClient(), prefix);
    }

    public List<String> getOperationNames(CommandContext ctx, OperationRequestAddress prefix) {
        return Util.getOperationNames(ctx, prefix);
    }

    public List<CommandArgument> getProperties(CommandContext ctx, String operationName, OperationRequestAddress address) {
        List<CommandArgument> result;
        ModelNode request;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(address);
        try {
            builder.setOperationName("read-operation-description");
            builder.addProperty("name", operationName);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        Map<String, CommandLineCompleterFactory> globalOpProps = globalOpPropCompleters.get(operationName);
        try {
            ModelNode outcome = client.execute(request);
            if (!Util.isSuccess(outcome)) {
                result = Collections.emptyList();
            } else {
                ModelNode resultNode = outcome.get("result");
                if (!resultNode.isDefined()) {
                    return Collections.emptyList();
                }
                ModelNode reqProps = resultNode.get("request-properties");
                if (!reqProps.isDefined()) {
                    return Collections.emptyList();
                }
                List propList = reqProps.asPropertyList();
                result = new ArrayList<CommandArgument>(propList.size());
                for (final Property prop : propList) {
                    final CommandLineCompleter completer = this.getCompleter(globalOpProps, prop, ctx, operationName, address);
                    result.add(new CommandArgument(){
                        final String argName;
                        {
                            this.argName = prop.getName();
                        }

                        @Override
                        public String getFullName() {
                            return this.argName;
                        }

                        @Override
                        public String getShortName() {
                            return null;
                        }

                        @Override
                        public int getIndex() {
                            return -1;
                        }

                        @Override
                        public boolean isPresent(ParsedCommandLine args) throws CommandFormatException {
                            return args.hasProperty(this.argName);
                        }

                        @Override
                        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                            return !this.isPresent(ctx.getParsedCommandLine());
                        }

                        @Override
                        public String getValue(ParsedCommandLine args) throws CommandFormatException {
                            return args.getPropertyValue(this.argName);
                        }

                        @Override
                        public String getValue(ParsedCommandLine args, boolean required) throws CommandFormatException {
                            if (!this.isPresent(args)) {
                                throw new CommandFormatException("Property '" + this.argName + "' is missing required value.");
                            }
                            return args.getPropertyValue(this.argName);
                        }

                        @Override
                        public boolean isValueComplete(ParsedCommandLine args) throws CommandFormatException {
                            if (!this.isPresent(args)) {
                                return false;
                            }
                            return !this.argName.equals(args.getLastParsedPropertyName());
                        }

                        @Override
                        public boolean isValueRequired() {
                            boolean required = true;
                            ModelNode mn = prop.getValue().get("type");
                            if (mn != null) {
                                required = mn.asType() != ModelType.BOOLEAN;
                            }
                            return required;
                        }

                        @Override
                        public CommandLineCompleter getValueCompleter() {
                            return completer;
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    private CommandLineCompleter getCompleter(Map<String, CommandLineCompleterFactory> globalOpProps, Property prop, CommandContext ctx, String operationName, OperationRequestAddress address) throws IllegalArgumentException {
        CommandLineCompleterFactory factory;
        CommandLineCompleter propCompleter = null;
        CommandLineCompleterFactory commandLineCompleterFactory = factory = globalOpProps == null ? null : globalOpProps.get(prop.getName());
        if (factory != null) {
            propCompleter = factory.createCompleter(ctx, address);
        }
        if (propCompleter == null) {
            propCompleter = DefaultOperationCandidatesProvider.getCompleter(prop, ctx, address);
        }
        return propCompleter;
    }

    static CommandLineCompleter getCompleter(Property prop, CommandContext ctx, OperationRequestAddress address) {
        ModelNode attrDescr = prop.getValue();
        ModelNode typeNode = attrDescr.get("type");
        if (typeNode.isDefined() && ModelType.BOOLEAN.equals((Object)typeNode.asType())) {
            return SimpleTabCompleter.BOOLEAN;
        }
        if (typeNode.isDefined() && ModelType.BYTES.equals((Object)typeNode.asType())) {
            return BytesCompleter.INSTANCE;
        }
        if (attrDescr.has("value-type")) {
            ModelNode valueTypeNode = attrDescr.get("value-type");
            if (typeNode.isDefined() && ModelType.LIST.equals((Object)typeNode.asType())) {
                return new ValueTypeCompleter(attrDescr, address);
            }
            try {
                valueTypeNode.asType();
                if (attrDescr.has("allowed")) {
                    return DefaultOperationCandidatesProvider.getAllowedCompleter(prop);
                }
                if (typeNode.isDefined() && ModelType.OBJECT.equals((Object)typeNode.asType())) {
                    return new ValueTypeCompleter(attrDescr, address);
                }
            }
            catch (IllegalArgumentException e) {
                return new ValueTypeCompleter(attrDescr, address);
            }
        }
        if (attrDescr.has("filesystem-path") && attrDescr.get("filesystem-path").asBoolean()) {
            return FilenameTabCompleter.newCompleter(ctx);
        }
        if (attrDescr.has("relative-to") && attrDescr.get("relative-to").asBoolean()) {
            return new DeploymentItemCompleter(address);
        }
        if (attrDescr.has("allowed")) {
            return DefaultOperationCandidatesProvider.getAllowedCompleter(prop);
        }
        if (attrDescr.has("capability-reference")) {
            return new CapabilityReferenceCompleter(address, attrDescr.get("capability-reference").asString());
        }
        return null;
    }

    private static CommandLineCompleter getAllowedCompleter(Property prop) {
        ModelNode allowedNode = prop.getValue().get("allowed");
        if (allowedNode.isDefined()) {
            List nodeList = allowedNode.asList();
            String[] values = new String[nodeList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((ModelNode)nodeList.get(i)).asString();
            }
            return new SimpleTabCompleter(values);
        }
        return null;
    }

    @Override
    public Map<String, OperationRequestHeader> getHeaders(CommandContext ctx) {
        return HEADERS;
    }

    static void addGlobalOpPropCompleter(String op, String prop, CommandLineCompleterFactory factory) {
        Map<String, CommandLineCompleterFactory> propMap = globalOpPropCompleters.get(op);
        if (propMap == null) {
            propMap = new HashMap<String, CommandLineCompleterFactory>();
            globalOpPropCompleters.put(op, propMap);
        }
        propMap.put(prop, factory);
    }

    static CommandLineCompleterFactory getGlobalOpPropCompleter(String op, String prop) {
        Map<String, CommandLineCompleterFactory> propMap = globalOpPropCompleters.get(op);
        return propMap == null ? null : propMap.get(prop);
    }

    static {
        HEADERS.put(RolloutPlanRequestHeader.INSTANCE.getName(), RolloutPlanRequestHeader.INSTANCE);
        DefaultOperationCandidatesProvider.addBooleanHeader("allow-resource-service-restart");
        DefaultOperationCandidatesProvider.addBooleanHeader("rollback-on-runtime-failure");
        DefaultOperationCandidatesProvider.addIntHeader("blocking-timeout");
        globalOpPropCompleters = new HashMap<String, Map<String, CommandLineCompleterFactory>>();
        CommandLineCompleterFactory attrNameCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address);
            }
        };
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("undefine-attribute", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-attribute", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("write-attribute", "name", new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address, true);
            }
        });
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("write-attribute", "value", new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                ModelNode response;
                String propName = ctx.getParsedCommandLine().getPropertyValue("name");
                if (propName == null) {
                    return NO_CANDIDATES_COMPLETER;
                }
                ModelNode req = new ModelNode();
                ModelNode addrNode = req.get("address");
                for (OperationRequestAddress.Node node : address) {
                    addrNode.add(node.getType(), node.getName());
                }
                req.get("operation").set("read-resource-description");
                try {
                    response = ctx.getModelControllerClient().execute(req);
                }
                catch (Exception e) {
                    return NO_CANDIDATES_COMPLETER;
                }
                ModelNode result = response.get("result");
                if (!result.isDefined()) {
                    return NO_CANDIDATES_COMPLETER;
                }
                ModelNode attrs = result.get("attributes");
                if (!attrs.isDefined()) {
                    return NO_CANDIDATES_COMPLETER;
                }
                ModelNode attrDescr = attrs.get(propName);
                if (!attrDescr.isDefined()) {
                    return NO_CANDIDATES_COMPLETER;
                }
                Property prop = new Property(propName, attrDescr);
                return DefaultOperationCandidatesProvider.getCompleter(prop, ctx, address);
            }
        });
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-operation-description", "name", new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new OperationNameCompleter(address);
            }
        });
        CommandLineCompleterFactory childTypeCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new ChildTypeCompleter(address);
            }
        };
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-children-names", "child-type", childTypeCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-children-resources", "child-type", childTypeCompleter);
        CommandLineCompleterFactory mapAttrNameCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address, false, AttributeNamePathCompleter.MAP_FILTER);
            }
        };
        CommandLineCompleterFactory mapOnlyWritableAttrNameCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address, true, AttributeNamePathCompleter.MAP_FILTER);
            }
        };
        CommandLineCompleterFactory listAttrNameCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address, AttributeNamePathCompleter.LIST_FILTER);
            }
        };
        CommandLineCompleterFactory listOnlyWritableAttrNameCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(CommandContext ctx, OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address, true, AttributeNamePathCompleter.LIST_FILTER);
            }
        };
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-put", "name", mapOnlyWritableAttrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-remove", "name", mapOnlyWritableAttrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-get", "name", mapAttrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-clear", "name", mapOnlyWritableAttrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-add", "name", listOnlyWritableAttrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-remove", "name", listOnlyWritableAttrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-get", "name", listAttrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-clear", "name", listOnlyWritableAttrNameCompleter);
    }

    static interface CommandLineCompleterFactory {
        public CommandLineCompleter createCompleter(CommandContext var1, OperationRequestAddress var2);
    }
}

