/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.BaseParsingState;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.CharacterHandlerMap;
import org.jboss.as.cli.parsing.DefaultCharacterHandlerMap;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;

public class DefaultParsingState
extends BaseParsingState {
    protected final CharacterHandlerMap enterStateHandlers;
    private final CharacterHandlerMap handlers;
    private boolean ignoreWhitespaces;
    private boolean leaveOnWhitespace;
    private CharacterHandler wsHandler;
    private CharacterHandler defaultHandler = GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER;

    public DefaultParsingState(String id) {
        this(id, false);
    }

    public DefaultParsingState(String id, boolean enterLeaveContent) {
        this(id, enterLeaveContent, new DefaultCharacterHandlerMap());
    }

    public DefaultParsingState(String id, boolean enterLeaveContent, CharacterHandlerMap enterStateHandlers) {
        super(id);
        if (enterLeaveContent) {
            this.setEnterHandler(GlobalCharacterHandlers.CONTENT_CHARACTER_HANDLER);
            this.setLeaveHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (!ctx.isEndOfContent()) {
                        ctx.getCallbackHandler().character(ctx);
                    }
                }
            });
        }
        this.handlers = new DefaultCharacterHandlerMap();
        this.enterStateHandlers = enterStateHandlers;
    }

    public void setIgnoreWhitespaces(boolean ignoreWhitespaces) {
        this.ignoreWhitespaces = ignoreWhitespaces;
    }

    public boolean isIgnoreWhitespaces() {
        return this.ignoreWhitespaces;
    }

    public void setLeaveOnWhitespace(boolean leaveOnWhitespace) {
        this.leaveOnWhitespace = leaveOnWhitespace;
    }

    public boolean isLeaveOnWhitespace() {
        return this.leaveOnWhitespace;
    }

    public void setDefaultHandler(CharacterHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Default handler can't be null.");
        }
        this.defaultHandler = handler;
    }

    public CharacterHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void putHandler(char ch, CharacterHandler handler) {
        this.handlers.putHandler(ch, handler);
    }

    public void enterState(char ch, ParsingState state) {
        this.enterStateHandlers.putHandler(ch, new EnterStateCharacterHandler(state));
    }

    public void leaveState(char ch) {
        this.enterStateHandlers.putHandler(ch, GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
    }

    public void setHandleEntrance(boolean handleEntrance) {
        if (handleEntrance) {
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    DefaultParsingState.this.getHandler(ctx.getCharacter()).handle(ctx);
                }
            });
        } else {
            this.setEnterHandler(GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER);
        }
    }

    public void setWhitespaceHandler(CharacterHandler handler) {
        this.wsHandler = handler;
    }

    public CharacterHandler getWhitespaceHandler() {
        return this.wsHandler;
    }

    @Override
    public CharacterHandler getHandler(char ch) {
        if (this.wsHandler != null && Character.isWhitespace(ch)) {
            return this.wsHandler;
        }
        if (this.ignoreWhitespaces && Character.isWhitespace(ch)) {
            return GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER;
        }
        if (this.leaveOnWhitespace && Character.isWhitespace(ch)) {
            return GlobalCharacterHandlers.LEAVE_STATE_HANDLER;
        }
        CharacterHandler handler = this.enterStateHandlers.getHandler(ch);
        if (handler != null) {
            return handler;
        }
        handler = this.handlers.getHandler(ch);
        if (handler != null) {
            return handler;
        }
        return this.defaultHandler;
    }
}

