/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.jboss.as.cli.AwaiterModelControllerClient;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.CliShutdownHook;
import org.jboss.as.cli.impl.ModelControllerClientFactory;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolTimeoutHandler;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.threads.JBossThreadFactory;
import org.xnio.OptionMap;

public class CLIModelControllerClient
extends AbstractModelControllerClient
implements AwaiterModelControllerClient {
    private static final OptionMap DEFAULT_OPTIONS = OptionMap.EMPTY;
    private static final ThreadPoolExecutor executorService;
    private static final Endpoint endpoint;
    private static final byte CLOSED = 0;
    private static final byte CONNECTING = 1;
    private static final byte CONNECTED = 2;
    private static final byte LOST_CONNECTION = 3;
    private static final byte MUST_CLOSE = 4;
    private final Object lock = new Object();
    private final CallbackHandler handler;
    private final Map<String, String> saslOptions;
    private final SSLContext sslContext;
    private final ModelControllerClientFactory.ConnectionCloseHandler closeHandler;
    private final ManagementChannelHandler channelAssociation;
    private ManagementClientChannelStrategy strategy;
    private final ProtocolConnectionConfiguration channelConfig;
    private final AtomicInteger state = new AtomicInteger(0);

    CLIModelControllerClient(ControllerAddress address, CallbackHandler handler, int connectionTimeout, ModelControllerClientFactory.ConnectionCloseHandler closeHandler, Map<String, String> saslOptions, SSLContext sslContext, ProtocolTimeoutHandler timeoutHandler, String clientBindAddress) throws IOException {
        URI connURI;
        this.handler = handler;
        this.sslContext = sslContext;
        this.closeHandler = closeHandler;
        this.channelAssociation = new ManagementChannelHandler(new ManagementClientChannelStrategy(){

            public Channel getChannel() throws IOException {
                return CLIModelControllerClient.this.getOrCreateChannel();
            }

            public void close() throws IOException {
            }
        }, (ExecutorService)executorService, new ManagementRequestHandlerFactory[]{this});
        try {
            connURI = new URI(address.getProtocol(), null, address.getHost(), address.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to create URI", e);
        }
        this.channelConfig = ProtocolConnectionConfiguration.create((Endpoint)endpoint, (URI)connURI, (OptionMap)DEFAULT_OPTIONS);
        this.channelConfig.setClientBindAddress(clientBindAddress);
        this.saslOptions = saslOptions;
        this.channelConfig.setSaslOptions(saslOptions);
        if (connectionTimeout > 0) {
            this.channelConfig.setConnectionTimeout((long)connectionTimeout);
        }
        this.channelConfig.setTimeoutHandler(timeoutHandler);
    }

    protected ManagementChannelAssociation getChannelAssociation() throws IOException {
        return this.channelAssociation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel getOrCreateChannel() throws IOException {
        ManagementClientChannelStrategy localStrategy;
        Channel ch = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.strategy == null) {
                ChannelCloseHandler channelCloseHandler = new ChannelCloseHandler();
                localStrategy = ManagementClientChannelStrategy.create((ProtocolConnectionConfiguration)this.channelConfig, (ManagementMessageHandler)this.channelAssociation, (CallbackHandler)this.handler, this.saslOptions, (SSLContext)this.sslContext, (CloseHandler)channelCloseHandler);
                channelCloseHandler.setOriginalStrategy(localStrategy);
            } else {
                localStrategy = this.strategy;
            }
            this.state.set(1);
        }
        ch = localStrategy.getChannel();
        object = this.lock;
        synchronized (object) {
            this.strategy = localStrategy;
            if (this.state.get() == 4) {
                this.close();
                this.lock.notifyAll();
                throw new IOException("Connection closed");
            }
            if (this.state.get() == 3) {
                this.close();
            } else {
                this.state.set(2);
            }
            this.lock.notifyAll();
        }
        return ch;
    }

    @Override
    public boolean isConnected() {
        return this.strategy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.state.get() == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.state.get() == 0) {
                return;
            }
            if (this.state.get() == 1) {
                this.state.set(4);
                return;
            }
            this.state.set(0);
            this.channelAssociation.shutdown();
            if (this.strategy != null) {
                StreamUtils.safeClose((Closeable)this.strategy);
                this.strategy = null;
            }
            this.channelAssociation.shutdownNow();
            try {
                this.channelAssociation.awaitCompletion(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            this.lock.notifyAll();
        }
    }

    @Override
    public ModelNode execute(ModelNode operation, boolean awaitClose) throws IOException {
        ModelNode response = super.execute(operation);
        if (!Util.isSuccess(response)) {
            return response;
        }
        this.awaitClose(awaitClose);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitClose(boolean awaitClose) throws IOException {
        if (awaitClose) {
            Object object = this.lock;
            synchronized (object) {
                if (this.strategy != null) {
                    try {
                        this.lock.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    StreamUtils.safeClose((Closeable)this.strategy);
                    this.strategy = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureConnected(long timeoutMillis) throws CommandLineException {
        boolean doTry = true;
        long start = System.currentTimeMillis();
        IOException ioe = null;
        while (doTry) {
            try {
                this.getOrCreateChannel().getConnection();
                doTry = false;
            }
            catch (IOException e) {
                ioe = e;
                Object object = this.lock;
                synchronized (object) {
                    if (this.strategy != null) {
                        StreamUtils.safeClose((Closeable)this.strategy);
                        this.strategy = null;
                    }
                    this.lock.notifyAll();
                }
            }
            if (ioe == null) continue;
            if (ioe.getCause() != null && ioe.getCause() instanceof SaslException) {
                throw new CommandLineException("Failed to establish connection", ioe);
            }
            if (System.currentTimeMillis() - start > timeoutMillis) {
                throw new CommandLineException("Failed to establish connection in " + (System.currentTimeMillis() - start) + "ms", ioe);
            }
            ioe = null;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new CommandLineException("Interrupted while pausing before reconnecting.", e);
            }
        }
    }

    static {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        ThreadFactory threadFactory = (ThreadFactory)AccessController.doPrivileged(new PrivilegedAction<JBossThreadFactory>(){

            @Override
            public JBossThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup("cli-remoting"), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
        executorService = new ThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, workQueue, threadFactory);
        executorService.allowCoreThreadTimeOut(true);
        try {
            endpoint = Endpoint.builder().setEndpointName("cli-client").build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create remoting endpoint");
        }
        CliShutdownHook.add(new CliShutdownHook.Handler(){

            @Override
            public void shutdown() {
                executorService.shutdown();
                try {
                    executorService.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    endpoint.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private final class ChannelCloseHandler
    implements CloseHandler<Channel> {
        private ManagementClientChannelStrategy originalStrategy;

        private ChannelCloseHandler() {
        }

        void setOriginalStrategy(ManagementClientChannelStrategy strategy) {
            if (this.originalStrategy != null) {
                throw new IllegalArgumentException("The strategy has already been initialized.");
            }
            this.originalStrategy = strategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClose(Channel closed, IOException exception) {
            if (CLIModelControllerClient.this.state.get() == 0) {
                return;
            }
            if (CLIModelControllerClient.this.state.compareAndSet(1, 3)) {
                return;
            }
            Object object = CLIModelControllerClient.this.lock;
            synchronized (object) {
                if (CLIModelControllerClient.this.strategy != null) {
                    if (CLIModelControllerClient.this.strategy != this.originalStrategy) {
                        new Exception("Channel close handler " + CLIModelControllerClient.this.strategy + " " + this.originalStrategy).printStackTrace();
                    }
                    CLIModelControllerClient.this.strategy = null;
                    CLIModelControllerClient.this.closeHandler.handleClose();
                }
                CLIModelControllerClient.this.channelAssociation.handleChannelClosed(closed, exception);
                CLIModelControllerClient.this.lock.notifyAll();
            }
            closed.getConnection().addCloseHandler((CloseHandler)new CloseHandler<Connection>(){

                public void handleClose(Connection closed, IOException exception) {
                    StreamUtils.safeClose((Closeable)ChannelCloseHandler.this.originalStrategy);
                }
            });
        }
    }
}

