/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineFormat;
import org.jboss.as.cli.EscapeSelector;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestHeader;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.ParsedOperationRequestHeader;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.SegmentParsingInitialState;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.logging.Logger;

public class OperationRequestCompleter
implements CommandLineCompleter {
    public static final OperationRequestCompleter INSTANCE = new OperationRequestCompleter();
    public static final CommandLineCompleter ARG_VALUE_COMPLETER = new CommandLineCompleter(){
        final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            try {
                this.parsedOp.parseOperation(ctx.getCurrentNodePath(), buffer);
            }
            catch (CommandFormatException e) {
                return -1;
            }
            return INSTANCE.complete(ctx, this.parsedOp, buffer, cursor, candidates);
        }
    };
    public static final EscapeSelector ESCAPE_SELECTOR = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == ':' || ch == '/' || ch == '=' || ch == ' ' || ch == '\"' || ch == '\\' || ch == '\'';
        }
    };
    public static final EscapeSelector ESCAPE_SELECTOR_INSIDE_QUOTES = new EscapeSelector(){

        @Override
        public boolean isEscape(char ch) {
            return ch == '\"' || ch == '\\';
        }
    };
    private static final Logger LOGGER = Logger.getLogger(OperationRequestCompleter.class);

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, ctx.getParsedCommandLine(), buffer, cursor, candidates);
    }

    public int complete(CommandContext ctx, OperationCandidatesProvider candidatesProvider, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, ctx.getParsedCommandLine(), candidatesProvider, buffer, cursor, candidates);
    }

    public int complete(CommandContext ctx, ParsedCommandLine parsedCmd, String buffer, int cursor, List<String> candidates) {
        return this.complete(ctx, parsedCmd, ctx.getOperationCandidatesProvider(), buffer, cursor, candidates);
    }

    protected int complete(CommandContext ctx, ParsedCommandLine parsedCmd, OperationCandidatesProvider candidatesProvider, String buffer, int cursor, List<String> candidates) {
        int offset;
        String chunk;
        if (parsedCmd.isRequestComplete()) {
            return -1;
        }
        if (parsedCmd.endsOnHeaderListStart() || parsedCmd.hasHeaders()) {
            Map<String, OperationRequestHeader> headers = candidatesProvider.getHeaders(ctx);
            if (headers.isEmpty()) {
                return -1;
            }
            int result = buffer.length();
            if (parsedCmd.getLastHeaderName() != null) {
                if (buffer.endsWith(parsedCmd.getLastHeaderName())) {
                    result = parsedCmd.getLastChunkIndex();
                    for (String name : headers.keySet()) {
                        if (name.equals(parsedCmd.getLastHeaderName())) {
                            result = this.completeHeader(headers, ctx, parsedCmd, buffer, cursor, candidates);
                            break;
                        }
                        if (parsedCmd.hasHeader(name) || !name.startsWith(parsedCmd.getLastHeaderName())) continue;
                        candidates.add(name);
                    }
                } else {
                    result = this.completeHeader(headers, ctx, parsedCmd, buffer, cursor, candidates);
                }
            } else if (!parsedCmd.hasHeaders()) {
                candidates.addAll(headers.keySet());
            } else if (parsedCmd.endsOnHeaderSeparator()) {
                candidates.addAll(headers.keySet());
                for (ParsedOperationRequestHeader parsed : parsedCmd.getHeaders()) {
                    candidates.remove(parsed.getName());
                }
            } else {
                ParsedOperationRequestHeader lastParsedHeader = parsedCmd.getLastHeader();
                OperationRequestHeader lastHeader = headers.get(lastParsedHeader.getName());
                if (lastHeader == null) {
                    return -1;
                }
                CommandLineCompleter headerCompleter = lastHeader.getCompleter();
                if (headerCompleter == null) {
                    return -1;
                }
                result = headerCompleter.complete(ctx, buffer, cursor, candidates);
            }
            Collections.sort(candidates);
            return result;
        }
        if (parsedCmd.endsOnPropertyListEnd()) {
            return buffer.length();
        }
        if (parsedCmd.hasProperties() || parsedCmd.endsOnPropertyListStart() || parsedCmd.endsOnNotOperator()) {
            boolean bl;
            if (!parsedCmd.hasOperationName()) {
                return -1;
            }
            Collection<CommandArgument> allArgs = candidatesProvider.getProperties(ctx, parsedCmd.getOperationName(), parsedCmd.getAddress());
            if (allArgs.isEmpty()) {
                CommandLineFormat format2 = parsedCmd.getFormat();
                if (!parsedCmd.hasProperties() && format2 != null && format2.getPropertyListEnd() != null && format2.getPropertyListEnd().length() > 0) {
                    candidates.add(format2.getPropertyListEnd());
                }
                return buffer.length();
            }
            try {
                if (parsedCmd.endsOnNotOperator()) {
                    for (CommandArgument arg : allArgs) {
                        if (!arg.canAppearNext(ctx) || arg.isValueRequired()) continue;
                        candidates.add(arg.getFullName());
                    }
                    Collections.sort(candidates);
                    return buffer.length();
                }
                if (!parsedCmd.hasProperties()) {
                    boolean needNeg = false;
                    for (CommandArgument arg : allArgs) {
                        if (!arg.canAppearNext(ctx)) continue;
                        if (arg.getIndex() >= 0) {
                            CommandLineCompleter valCompl = arg.getValueCompleter();
                            if (valCompl == null) continue;
                            valCompl.complete(ctx, "", 0, candidates);
                            continue;
                        }
                        String argName = arg.getFullName();
                        candidates.add(argName);
                        if (arg.isValueRequired()) continue;
                        needNeg = true;
                    }
                    if (needNeg) {
                        candidates.add("!");
                    }
                    Collections.sort(candidates);
                    return buffer.length();
                }
            }
            catch (CommandFormatException e) {
                return -1;
            }
            int result = buffer.length();
            Object chunk2 = null;
            CommandLineCompleter valueCompleter = null;
            if (!parsedCmd.endsOnPropertySeparator()) {
                String argName = parsedCmd.getLastParsedPropertyName();
                String argValue = parsedCmd.getLastParsedPropertyValue();
                if (argValue != null || parsedCmd.endsOnPropertyValueSeparator()) {
                    result = parsedCmd.getLastChunkIndex();
                    if (parsedCmd.endsOnPropertyValueSeparator()) {
                        ++result;
                    }
                    chunk2 = argValue;
                    valueCompleter = argName != null ? this.getValueCompleter(ctx, allArgs, argName) : this.getValueCompleter(ctx, allArgs, parsedCmd.getOtherProperties().size() - 1);
                    if (valueCompleter == null) {
                        CommandLineFormat commandLineFormat;
                        if (parsedCmd.endsOnSeparator()) {
                            return -1;
                        }
                        for (CommandArgument commandArgument : allArgs) {
                            try {
                                if (!commandArgument.canAppearNext(ctx) || commandArgument.getFullName().equals(argName)) continue;
                                return -1;
                            }
                            catch (CommandFormatException e) {
                                break;
                            }
                        }
                        if ((commandLineFormat = parsedCmd.getFormat()) != null && commandLineFormat.getPropertyListEnd() != null && commandLineFormat.getPropertyListEnd().length() > 0) {
                            candidates.add(commandLineFormat.getPropertyListEnd());
                        }
                        return buffer.length();
                    }
                } else {
                    chunk2 = argName;
                    result = parsedCmd.getLastChunkIndex();
                }
            } else {
                chunk2 = null;
            }
            if (valueCompleter != null) {
                CommandLineFormat format4;
                int valueResult;
                if (chunk2 == null) {
                    String parsedName = parsedCmd.getLastParsedPropertyName();
                    for (CommandArgument commandArgument : allArgs) {
                        String string = commandArgument.getFullName();
                        if (!string.equals(parsedName) || commandArgument.isValueRequired()) continue;
                        candidates.add("false");
                        return result;
                    }
                }
                if ((valueResult = valueCompleter.complete(ctx, (String)(chunk2 == null ? "" : chunk2), chunk2 == null ? 0 : ((String)chunk2).length(), candidates)) < 0) {
                    return valueResult;
                }
                if (this.suggestionEqualsUserEntry(candidates, (String)chunk2, valueResult) && (format4 = parsedCmd.getFormat()) != null) {
                    for (CommandArgument commandArgument : allArgs) {
                        try {
                            if (!commandArgument.canAppearNext(ctx)) continue;
                            candidates.set(0, "" + format4.getPropertySeparator());
                            return buffer.length();
                        }
                        catch (CommandFormatException e) {
                            e.printStackTrace();
                            return result + valueResult;
                        }
                    }
                    candidates.set(0, format4.getPropertyListEnd());
                    return buffer.length();
                }
                return result + valueResult;
            }
            CommandArgument lastArg = null;
            boolean allPropertiesPresent = true;
            for (CommandArgument commandArgument : allArgs) {
                try {
                    if (commandArgument.canAppearNext(ctx)) {
                        allPropertiesPresent = false;
                        continue;
                    }
                    String argFullName = commandArgument.getFullName();
                    if (!argFullName.equals(chunk2)) continue;
                    lastArg = commandArgument;
                }
                catch (CommandFormatException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            boolean bl2 = false;
            for (CommandArgument arg : allArgs) {
                try {
                    if (!arg.canAppearNext(ctx)) continue;
                    if (arg.getIndex() >= 0) {
                        CommandLineCompleter valCompl = arg.getValueCompleter();
                        if (valCompl == null) continue;
                        Object value = chunk2 == null ? "" : chunk2;
                        valCompl.complete(ctx, (String)value, ((String)value).length(), candidates);
                        continue;
                    }
                    String argFullName = arg.getFullName();
                    if (chunk2 == null || argFullName.startsWith((String)chunk2)) {
                        if (!parsedCmd.isLastPropertyNegated()) {
                            candidates.add(argFullName);
                        } else if (!arg.isValueRequired()) {
                            candidates.add(argFullName);
                        }
                    }
                    if (arg.isValueRequired() || parsedCmd.isLastPropertyNegated()) continue;
                    bl = true;
                }
                catch (CommandFormatException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            if (bl && parsedCmd.endsOnPropertySeparator()) {
                candidates.add("!");
            }
            if (lastArg != null) {
                if (lastArg.isValueRequired()) {
                    candidates.add(lastArg.getFullName() + "=");
                } else if (lastArg instanceof ArgumentWithoutValue) {
                    CommandLineFormat format5;
                    ArgumentWithoutValue argumentWithoutValue = (ArgumentWithoutValue)lastArg;
                    if (!argumentWithoutValue.isExclusive() && !allPropertiesPresent && (format5 = parsedCmd.getFormat()) != null && format5.getPropertySeparator() != null) {
                        candidates.add(lastArg.getFullName() + format5.getPropertySeparator());
                    }
                } else {
                    CommandLineFormat commandLineFormat = parsedCmd.getFormat();
                    if (!parsedCmd.isLastPropertyNegated()) {
                        candidates.add("=false");
                    }
                    if (commandLineFormat != null && commandLineFormat.getPropertyListEnd() != null && commandLineFormat.getPropertyListEnd().length() > 0) {
                        candidates.add(commandLineFormat.getPropertyListEnd());
                        if (!allPropertiesPresent) {
                            candidates.add(commandLineFormat.getPropertySeparator());
                        }
                    }
                }
            }
            if (candidates.isEmpty()) {
                CommandLineFormat commandLineFormat;
                if (chunk2 == null && !parsedCmd.endsOnSeparator() && (commandLineFormat = parsedCmd.getFormat()) != null && commandLineFormat.getPropertyListEnd() != null && commandLineFormat.getPropertyListEnd().length() > 0) {
                    candidates.add(commandLineFormat.getPropertyListEnd());
                }
            } else {
                Collections.sort(candidates);
            }
            return result;
        }
        if (parsedCmd.hasOperationName() || parsedCmd.endsOnAddressOperationNameSeparator()) {
            if (parsedCmd.getAddress().endsOnType()) {
                return -1;
            }
            Collection<String> names = candidatesProvider.getOperationNames(ctx, parsedCmd.getAddress());
            if (names.isEmpty()) {
                return -1;
            }
            String chunk3 = parsedCmd.getOperationName();
            if (chunk3 == null) {
                candidates.addAll(names);
            } else {
                for (String name : names) {
                    if (!name.startsWith(chunk3)) continue;
                    candidates.add(name);
                }
            }
            Collections.sort(candidates);
            if (parsedCmd.endsOnSeparator()) {
                return buffer.length();
            }
            if (chunk3 != null && candidates.size() == 1 && chunk3.equals(candidates.get(0)) && parsedCmd.getFormat().getPropertyListStart().length() > 0) {
                candidates.set(0, chunk3 + parsedCmd.getFormat().getPropertyListStart());
            }
            return parsedCmd.getLastChunkIndex();
        }
        OperationRequestAddress address = parsedCmd.getAddress();
        if (buffer.endsWith("..")) {
            return -1;
        }
        if (address.isEmpty() || parsedCmd.endsOnNodeSeparator() || parsedCmd.endsOnNodeTypeNameSeparator() || address.equals(ctx.getCurrentNodePath())) {
            chunk = null;
        } else if (address.endsOnType()) {
            chunk = address.getNodeType();
            address.toParentNode();
        } else {
            chunk = address.toNodeType();
        }
        Collection<String> names = address.endsOnType() ? candidatesProvider.getNodeNames(ctx, address) : candidatesProvider.getNodeTypes(ctx, address);
        if (names.isEmpty()) {
            return -1;
        }
        if (chunk == null) {
            candidates.addAll(names);
        } else {
            for (String name : names) {
                if (!name.startsWith(chunk)) continue;
                candidates.add(name);
            }
        }
        String lastSegment = "";
        if (parsedCmd.getSubstitutedLine().length() >= parsedCmd.getLastSeparatorIndex()) {
            lastSegment = parsedCmd.getSubstitutedLine().substring(parsedCmd.getLastSeparatorIndex() + 1);
        }
        SegmentParsingInitialState.SegmentParsingCallbackHandler parsedSegment = this.parseLastSegment(lastSegment);
        if (candidates.size() == 1) {
            String string = candidates.get(0);
            if (address.endsOnType()) {
                if (chunk != null && chunk.equals(string)) {
                    if (parsedSegment.isOpenQuotes()) {
                        candidates.set(0, "\"");
                    } else {
                        candidates.set(0, parsedCmd.getFormat().getAddressOperationSeparator());
                        candidates.add(parsedCmd.getFormat().getNodeSeparator());
                    }
                    return buffer.length();
                }
                if (parsedSegment.isOpenQuotes()) {
                    String string2 = Util.escapeString(string, ESCAPE_SELECTOR_INSIDE_QUOTES);
                    offset = parsedSegment.getOffset() - 1;
                    candidates.set(0, "\"" + string2 + "\"");
                } else {
                    String string3 = Util.escapeString(string, ESCAPE_SELECTOR);
                    offset = parsedSegment.getOffset();
                    candidates.set(0, string3);
                }
            } else {
                if (chunk != null && chunk.equals(string)) {
                    if (parsedSegment.isOpenQuotes()) {
                        candidates.set(0, "\"");
                    } else {
                        candidates.set(0, "=");
                    }
                    return buffer.length();
                }
                if (parsedSegment.isOpenQuotes()) {
                    String string4 = Util.escapeString(string, ESCAPE_SELECTOR_INSIDE_QUOTES);
                    offset = parsedSegment.getOffset() - 1;
                    candidates.set(0, "\"" + string4 + "\"=");
                } else {
                    String string5 = Util.escapeString(string, ESCAPE_SELECTOR);
                    offset = parsedSegment.getOffset();
                    candidates.set(0, string5 + "=");
                }
            }
        } else {
            if (parsedSegment.isOpenQuotes()) {
                Util.sortAndEscape(candidates, ESCAPE_SELECTOR_INSIDE_QUOTES);
            } else {
                Util.sortAndEscape(candidates, ESCAPE_SELECTOR);
            }
            offset = parsedSegment.getOffset();
        }
        return parsedCmd.getLastSeparatorIndex() + 1 + offset;
    }

    private SegmentParsingInitialState.SegmentParsingCallbackHandler parseLastSegment(String chunk) {
        SegmentParsingInitialState.SegmentParsingCallbackHandler handler = new SegmentParsingInitialState.SegmentParsingCallbackHandler();
        try {
            StateParser.parse(chunk, handler, SegmentParsingInitialState.INSTANCE, false);
        }
        catch (CommandFormatException e) {
            LOGGER.debug((Object)"Error when parsing last chunk of operation request", (Throwable)e);
        }
        return handler;
    }

    private boolean suggestionEqualsUserEntry(List<String> candidates, String chunk, int suggestionOffset) {
        if (chunk == null || candidates.size() != 1) {
            return false;
        }
        if (suggestionOffset > 0) {
            return chunk.substring(suggestionOffset).equals(candidates.get(0));
        }
        return chunk.equals(candidates.get(0));
    }

    protected CommandLineCompleter getValueCompleter(CommandContext ctx, Iterable<CommandArgument> allArgs, String argName) {
        CommandLineCompleter result = null;
        for (CommandArgument arg : allArgs) {
            if (arg.getFullName().equals(argName)) {
                return arg.getValueCompleter();
            }
            if (arg.getIndex() != Integer.MAX_VALUE) continue;
            result = arg.getValueCompleter();
        }
        return result;
    }

    protected CommandLineCompleter getValueCompleter(CommandContext ctx, Iterable<CommandArgument> allArgs, int index) {
        CommandLineCompleter maxIndex = null;
        for (CommandArgument arg : allArgs) {
            if (arg.getIndex() == index) {
                return arg.getValueCompleter();
            }
            if (arg.getIndex() != Integer.MAX_VALUE) continue;
            maxIndex = arg.getValueCompleter();
        }
        return maxIndex;
    }

    private int completeHeader(Map<String, OperationRequestHeader> headers, CommandContext ctx, ParsedCommandLine parsedCmd, String buffer, int cursor, List<String> candidates) {
        OperationRequestHeader header = headers.get(parsedCmd.getLastHeaderName());
        if (header == null) {
            return -1;
        }
        CommandLineCompleter headerCompleter = header.getCompleter();
        if (headerCompleter == null) {
            return -1;
        }
        int valueResult = headerCompleter.complete(ctx, buffer.substring(parsedCmd.getLastChunkIndex()), cursor, candidates);
        if (valueResult < 0) {
            return -1;
        }
        return parsedCmd.getLastChunkIndex() + valueResult;
    }
}

