/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.scriptsupport;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.dmr.ModelNode;

public class CLI {
    private CommandContext ctx;
    private final DefaultCallbackHandler handler = new DefaultCallbackHandler(true);

    private CLI() {
        this.initOfflineContext();
    }

    public static CLI newInstance() {
        return new CLI();
    }

    public CommandContext getCommandContext() {
        return this.ctx;
    }

    public void connect() {
        this.doConnect(() -> CommandContextFactory.getInstance().newCommandContext());
    }

    public void connect(String username, char[] password) {
        this.doConnect(() -> CommandContextFactory.getInstance().newCommandContext(username, password));
    }

    public void connect(String controller, String username, char[] password) {
        this.connect(controller, username, password, null);
    }

    public void connect(String controller, String username, char[] password, String clientBindAddress) {
        this.doConnect(() -> CommandContextFactory.getInstance().newCommandContext(new CommandContextConfiguration.Builder().setController(controller).setUsername(username).setPassword(password).setClientBindAddress(clientBindAddress).build()));
    }

    public void connect(String controllerHost, int controllerPort, String username, char[] password) {
        this.connect("remote+http", controllerHost, controllerPort, username, password, null);
    }

    public void connect(String controllerHost, int controllerPort, String username, char[] password, String clientBindAddress) {
        this.connect("remote+http", controllerHost, controllerPort, username, password, clientBindAddress);
    }

    public void connect(String protocol, String controllerHost, int controllerPort, String username, char[] password) {
        this.connect(protocol, controllerHost, controllerPort, username, password, null);
    }

    public void connect(String protocol, String controllerHost, int controllerPort, String username, char[] password, String clientBindAddress) {
        this.doConnect(() -> CommandContextFactory.getInstance().newCommandContext(new CommandContextConfiguration.Builder().setController(this.constructUri(protocol, controllerHost, controllerPort)).setUsername(username).setPassword(password).setClientBindAddress(clientBindAddress).build()));
    }

    public void disconnect() {
        try {
            if (!this.isConnected()) {
                throw new IllegalStateException("Not connected to server.");
            }
            this.ctx.terminateSession();
        }
        finally {
            this.initOfflineContext();
        }
    }

    public Result cmd(String cliCommand) {
        try {
            if (this.ctx.isWorkflowMode() || this.ctx.isBatchMode()) {
                this.ctx.handle(cliCommand);
                return new Result(cliCommand, this.ctx.getExitCode());
            }
            this.handler.parse(this.ctx.getCurrentNodePath(), cliCommand, this.ctx);
            if (this.handler.getFormat() == OperationFormat.INSTANCE) {
                ModelNode request = this.ctx.buildRequest(cliCommand);
                ModelNode response = this.ctx.execute(request, cliCommand);
                return new Result(cliCommand, request, response);
            }
            this.ctx.handle(cliCommand);
            return new Result(cliCommand, this.ctx.getExitCode());
        }
        catch (CommandLineException cfe) {
            throw new IllegalArgumentException("Error handling command: " + cliCommand, cfe);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable to send command " + cliCommand + " to server.", ioe);
        }
    }

    private String constructUri(String protocol, String host, int port) {
        try {
            URI uri = new URI(protocol, null, host, port, null, null, null);
            return protocol == null ? uri.toString().substring(2) : uri.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to construct URI.", e);
        }
    }

    private void initOfflineContext() {
        try {
            this.ctx = CommandContextFactory.getInstance().newCommandContext();
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Unable to initialize command context.", e);
        }
    }

    private boolean isConnected() {
        return this.ctx.getConnectionInfo() != null;
    }

    private void doConnect(Callable<CommandContext> callable) {
        if (this.isConnected()) {
            throw new IllegalStateException("Already connected to server.");
        }
        CommandContext newContext = null;
        try {
            newContext = callable.call();
            newContext.connectController();
        }
        catch (Exception ex) {
            if (newContext != null) {
                newContext.terminateSession();
            }
            if (ex instanceof CliInitializationException) {
                throw new IllegalStateException("Unable to initialize command context.", ex);
            }
            if (ex instanceof CommandLineException) {
                throw new IllegalStateException("Unable to connect to controller.", ex);
            }
            throw new IllegalStateException(ex);
        }
        this.ctx = newContext;
    }

    public class Result {
        private final String cliCommand;
        private ModelNode request;
        private ModelNode response;
        private boolean isSuccess = false;
        private boolean isLocalCommand = false;

        Result(String cliCommand, ModelNode request, ModelNode response) {
            this.cliCommand = cliCommand;
            this.request = request;
            this.response = response;
            this.isSuccess = response.get("outcome").asString().equals("success");
        }

        Result(String cliCommand, int exitCode) {
            this.cliCommand = cliCommand;
            this.isSuccess = exitCode == 0;
            this.isLocalCommand = true;
        }

        public String getCliCommand() {
            return this.cliCommand;
        }

        public ModelNode getRequest() {
            return this.request;
        }

        public ModelNode getResponse() {
            return this.response;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public boolean isLocalCommand() {
            return this.isLocalCommand;
        }
    }
}

