/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation.header;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.ParsedRolloutPlanHeader;
import org.jboss.as.cli.operation.impl.SingleRolloutPlanGroup;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.operation.header.RolloutPlanState;

public class RolloutPlanHeaderCallbackHandler
implements ParsingStateCallbackHandler {
    private final ParsedRolloutPlanHeader header = new ParsedRolloutPlanHeader();
    private final DefaultCallbackHandler handler;
    final StringBuilder buffer = new StringBuilder();
    private String name;
    private SingleRolloutPlanGroup group;
    private boolean concurrent;
    private int lastChunkIndex;

    public RolloutPlanHeaderCallbackHandler(DefaultCallbackHandler handler) {
        this.handler = handler;
    }

    @Override
    public void enteredState(ParsingContext ctx) throws CommandFormatException {
        String id = ctx.getState().getId();
        if ("HEADER_VALUE".equals(id)) {
            ctx.enterState(RolloutPlanState.INSTANCE);
        } else if ("SG".equals(id)) {
            this.group = new SingleRolloutPlanGroup();
        } else if ("CONCURRENT".equals(id)) {
            this.concurrent = true;
            this.header.groupConcurrentSeparator(ctx.getLocation());
        } else if ("NAME_VALUE_SEPARATOR".equals(id)) {
            String string = this.name = this.buffer.length() == 0 ? null : this.buffer.toString().trim();
            if (this.name == null || this.name.isEmpty()) {
                throw new CommandFormatException("Property is missing name at index " + ctx.getLocation());
            }
            if (this.group != null) {
                this.group.addProperty(this.name, this.lastChunkIndex);
                this.group.propertyValueSeparator(ctx.getLocation());
            } else {
                this.header.planIdValueSeparator(ctx.getLocation());
            }
        } else if ("SG_SEPARATOR".equals(id)) {
            this.header.groupSequenceSeparator(ctx.getLocation());
        } else if ("PROP_LIST".equals(id)) {
            if (this.group != null) {
                this.group.propertyListStart(ctx.getLocation());
            } else {
                this.header.propertyListStart(ctx.getLocation());
            }
        }
        this.buffer.setLength(0);
        this.lastChunkIndex = ctx.getLocation();
    }

    @Override
    public void leavingState(ParsingContext ctx) throws CommandFormatException {
        String id = ctx.getState().getId();
        if (id.equals("HEADER_VALUE")) {
            this.handler.header(this.header);
        } else if ("PROP_VALUE".equals(id)) {
            String value;
            String string = value = this.buffer.length() == 0 ? null : this.buffer.toString().trim();
            if (value == null || value.isEmpty()) {
                throw new CommandFormatException("Property '" + this.name + "' is missing value at index " + ctx.getLocation());
            }
            if (this.group == null) {
                if ("id".equals(this.name)) {
                    this.header.setPlanRef(this.lastChunkIndex, value);
                } else {
                    this.header.addProperty(this.name, value, this.lastChunkIndex);
                }
            } else {
                this.group.addProperty(this.name, value, this.lastChunkIndex);
                if (!ctx.isEndOfContent()) {
                    this.group.propertySeparator(ctx.getLocation());
                }
            }
        } else if ("PROP".equals(id)) {
            if (this.name == null && this.buffer.length() > 0) {
                if (this.group != null) {
                    this.group.addProperty(this.buffer.toString().trim(), this.lastChunkIndex);
                    if (!ctx.isEndOfContent() && ctx.getCharacter() == ',') {
                        this.group.propertySeparator(ctx.getLocation());
                    }
                } else {
                    this.header.addProperty(this.buffer.toString().trim(), this.lastChunkIndex);
                }
                this.buffer.setLength(0);
            } else {
                this.name = null;
                this.buffer.setLength(0);
            }
        } else if ("SG_NAME".equals(id)) {
            String groupName = this.buffer.toString().trim();
            if (groupName.isEmpty()) {
                throw new CommandFormatException("Empty group name at index " + ctx.getLocation());
            }
            this.group.setGroupName(groupName, this.lastChunkIndex);
        } else if ("SG".equals(id)) {
            if (this.concurrent) {
                this.header.addConcurrentGroup(this.group);
                this.concurrent = false;
            } else {
                this.header.addGroup(this.group);
            }
            this.group = null;
        } else if (!ctx.isEndOfContent() && "PROP_LIST".equals(id)) {
            if (this.group != null) {
                this.group.propertyListEnd(ctx.getLocation());
            } else {
                this.header.propertyListEnd(ctx.getLocation());
            }
        }
    }

    @Override
    public void character(ParsingContext ctx) throws CommandFormatException {
        this.buffer.append(ctx.getCharacter());
    }
}

