/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.IOException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.security.model.AuthSecurityBuilder;
import org.jboss.as.cli.impl.aesh.cmd.security.model.DefaultResourceNames;
import org.jboss.as.cli.impl.aesh.cmd.security.model.SSLSecurityBuilder;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;

public class ManagementInterfaces {
    public static void enableSSL(String managementInterface, String secureSocketBinding, CommandContext ctx, SSLSecurityBuilder builder) throws IOException, OperationFormatException {
        if (managementInterface == null) {
            managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(ctx);
        }
        if (managementInterface == null) {
            throw new OperationFormatException("No default management interface found.");
        }
        if ("http-interface".equals(managementInterface)) {
            if (secureSocketBinding == null) {
                secureSocketBinding = DefaultResourceNames.getDefaultHttpSecureSocketBindingName(managementInterface, ctx);
            }
            ManagementInterfaces.enableHTTPS(secureSocketBinding, builder);
        } else {
            if (secureSocketBinding != null) {
                throw new OperationFormatException("secure-sockect-binding not applicable to interface " + managementInterface);
            }
            ManagementInterfaces.enableNativeSSL(managementInterface, ctx, builder);
        }
    }

    public static String disableSSL(CommandContext context, String managementInterface, ModelNode steps) throws IOException, OperationFormatException {
        if (managementInterface == null) {
            managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(context);
        }
        if (managementInterface == null) {
            throw new OperationFormatException("No default management interface found.");
        }
        steps.add(ManagementInterfaces.writeInterfaceAttribute(managementInterface, "ssl-context", null));
        if ("http-interface".equals(managementInterface)) {
            steps.add(ManagementInterfaces.writeInterfaceAttribute(managementInterface, "secure-socket-binding", null));
        }
        return managementInterface;
    }

    private static void enableHTTPS(String secureSocketBinding, SSLSecurityBuilder security) throws OperationFormatException {
        security.addStep(ManagementInterfaces.writeInterfaceAttribute("http-interface", "ssl-context", security.getServerSSLContext().getName()), new SSLSecurityBuilder.FailureDescProvider(){

            @Override
            public String stepFailedDescription() {
                return "Writing ssl-context attribute of http-interface";
            }
        });
        security.addStep(ManagementInterfaces.writeInterfaceAttribute("http-interface", "secure-socket-binding", secureSocketBinding), new SSLSecurityBuilder.FailureDescProvider(){

            @Override
            public String stepFailedDescription() {
                return "Writing secure-socket-binding attribute of http-interface";
            }
        });
    }

    private static ModelNode writeInterfaceAttribute(String itf, String name, String value) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("write-attribute");
        builder.addNode("core-service", "management");
        builder.addNode("management-interface", itf);
        builder.addProperty("name", name);
        if (value != null) {
            builder.addProperty("value", value);
        }
        return builder.buildRequest();
    }

    private static void enableNativeSSL(final String managementInterface, CommandContext ctx, SSLSecurityBuilder security) throws OperationFormatException {
        security.addStep(ManagementInterfaces.writeInterfaceAttribute(managementInterface, "ssl-context", security.getServerSSLContext().getName()), new SSLSecurityBuilder.FailureDescProvider(){

            @Override
            public String stepFailedDescription() {
                return "Writing secure-socket-binding attribute of " + managementInterface;
            }
        });
    }

    public static String getManagementInterfaceSSLContextName(CommandContext ctx, String interfaceName) throws IOException, OperationFormatException {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-attribute");
            builder.addNode("core-service", "management");
            builder.addNode("management-interface", interfaceName);
            builder.addProperty("name", "ssl-context");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(outcome)) {
                ModelNode mn = outcome.get("result");
                if (mn.isDefined()) {
                    return outcome.get("result").asString();
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getManagementInterfaceSaslFactoryName(String managementInterface, CommandContext ctx) throws IOException, OperationFormatException {
        ModelNode request;
        if (managementInterface == null) {
            managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(ctx);
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-attribute");
            builder.addNode("core-service", "management");
            builder.addNode("management-interface", managementInterface);
            String attributeName = "sasl-authentication-factory";
            if ("http-interface".equals(managementInterface)) {
                attributeName = "http-upgrade.sasl-authentication-factory";
            }
            builder.addProperty("name", attributeName);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(outcome)) {
                ModelNode mn = outcome.get("result");
                if (mn.isDefined()) {
                    return outcome.get("result").asString();
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getManagementInterfaceHTTPFactoryName(CommandContext ctx) throws IOException, OperationFormatException {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-attribute");
            builder.addNode("core-service", "management");
            builder.addNode("management-interface", "http-interface");
            builder.addProperty("name", "http-authentication-factory");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(outcome)) {
                ModelNode mn = outcome.get("result");
                if (mn.isDefined()) {
                    return outcome.get("result").asString();
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void enableHTTPAuthentication(AuthSecurityBuilder http, CommandContext ctx) throws IOException, OperationFormatException {
        ModelNode request = ManagementInterfaces.writeInterfaceAttribute("http-interface", "http-authentication-factory", http.getAuthFactory().getName());
        http.getSteps().add(request);
    }

    public static void enableSASL(String managementInterface, AuthSecurityBuilder sasl, CommandContext ctx) throws IOException, OperationFormatException {
        if (managementInterface == null) {
            managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(ctx);
        }
        String attributeName = "sasl-authentication-factory";
        if ("http-interface".equals(managementInterface)) {
            attributeName = "http-upgrade.sasl-authentication-factory";
        }
        ModelNode request = ManagementInterfaces.writeInterfaceAttribute(managementInterface, attributeName, sasl.getAuthFactory().getName());
        sasl.getSteps().add(request);
    }

    public static ModelNode disableSASL(CommandContext context, String managementInterface) throws IOException, OperationFormatException {
        if (managementInterface == null) {
            managementInterface = DefaultResourceNames.getDefaultManagementInterfaceName(context);
        }
        String attributeName = "sasl-authentication-factory";
        if ("http-interface".equals(managementInterface)) {
            attributeName = "http-upgrade.sasl-authentication-factory";
        }
        return ManagementInterfaces.writeInterfaceAttribute(managementInterface, attributeName, null);
    }

    public static ModelNode disableHTTPAuth(CommandContext context) throws IOException, OperationFormatException {
        return ManagementInterfaces.writeInterfaceAttribute("http-interface", "http-authentication-factory", null);
    }
}

