/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandlerProvider;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.ControllerAddress;
import org.jboss.as.cli.Util;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class ExtensionsLoader {
    private final ModuleLoader moduleLoader;
    private final CommandContext ctx;
    private final CommandRegistry registry;
    private ControllerAddress currentAddress;
    private List<String> loadedCommands = Collections.emptyList();
    private List<String> errors = Collections.emptyList();

    ExtensionsLoader(CommandRegistry registry, CommandContext ctx) {
        assert (registry != null) : "command registry is null";
        assert (ctx != null) : "command context is null";
        this.moduleLoader = this.getClass().getClassLoader() instanceof ModuleClassLoader ? ModuleLoader.forClassLoader((ClassLoader)this.getClass().getClassLoader()) : null;
        this.ctx = ctx;
        this.registry = registry;
    }

    void resetHandlers() {
        for (String cmd : this.loadedCommands) {
            this.registry.remove(cmd);
        }
        this.currentAddress = null;
        this.errors = Collections.emptyList();
        this.loadedCommands = Collections.emptyList();
    }

    void loadHandlers(ControllerAddress address) throws CommandLineException {
        ModelNode response;
        ModelControllerClient client = this.ctx.getModelControllerClient();
        assert (client != null) : "client is null";
        if (this.moduleLoader == null) {
            return;
        }
        if (address != null && this.currentAddress != null && address.equals(this.currentAddress)) {
            return;
        }
        this.resetHandlers();
        this.currentAddress = address;
        ModelNode req = new ModelNode();
        req.get("address").setEmptyList();
        req.get("operation").set("read-children-resources");
        req.get("child-type").set("extension");
        try {
            response = client.execute(req);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to read extensions", e);
        }
        if (!Util.isSuccess(response)) {
            throw new CommandLineException("Failed to read extensions: " + Util.getFailureDescription(response));
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("Failed to read extensions: " + result.asString());
        }
        for (Property ext : result.asPropertyList()) {
            ModelNode module = ext.getValue().get("module");
            if (!module.isDefined()) {
                this.addError("Extension " + ext.getName() + " is missing module attribute");
                continue;
            }
            ModuleIdentifier moduleId = ModuleIdentifier.create((String)module.asString());
            try {
                ModuleClassLoader cl = this.moduleLoader.loadModule(moduleId).getClassLoader();
                ServiceLoader<CommandHandlerProvider> loader = ServiceLoader.load(CommandHandlerProvider.class, (ClassLoader)cl);
                for (CommandHandlerProvider provider : loader) {
                    try {
                        this.registry.registerHandler(provider.createCommandHandler(this.ctx), provider.isTabComplete(), provider.getNames());
                        this.addCommands(Arrays.asList(provider.getNames()));
                    }
                    catch (CommandRegistry.RegisterHandlerException e) {
                        this.addError(e.getLocalizedMessage());
                        ArrayList<String> addedCommands = new ArrayList<String>(Arrays.asList(provider.getNames()));
                        addedCommands.removeAll(e.getNotAddedNames());
                        this.addCommands(addedCommands);
                    }
                }
            }
            catch (ModuleLoadException e) {
                this.addError("Failed to load module " + module.asString() + " for extension " + ext.getName() + ": " + e.getLocalizedMessage());
            }
        }
        if (!this.errors.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Errors caught while loading extensions:\n");
            for (int i = 0; i < this.errors.size(); ++i) {
                String error = this.errors.get(i);
                buf.append(i + 1).append(") ").append(error).append(Util.LINE_SEPARATOR);
            }
            throw new CommandLineException(buf.toString());
        }
    }

    private void addCommands(List<String> names) {
        if (this.loadedCommands.isEmpty()) {
            this.loadedCommands = new ArrayList<String>();
        }
        this.loadedCommands.addAll(names);
    }

    private void addError(String msg) {
        switch (this.errors.size()) {
            case 0: {
                this.errors = Collections.singletonList(msg);
                break;
            }
            case 1: {
                this.errors = new ArrayList<String>(this.errors);
            }
            default: {
                this.errors.add(msg);
            }
        }
    }
}

