/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.arguments;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.LineBreakHandler;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.arguments.ArgumentValueState;
import org.jboss.as.cli.parsing.arguments.ListItemSeparatorState;

public class CompositeState
extends DefaultParsingState {
    public static final String LIST = "LIST";
    public static final String OBJECT = "OBJECT";
    public static final String ID = "OBJECT";

    public CompositeState(ArgumentValueState value) {
        this(false, value);
    }

    public CompositeState(boolean list, final ArgumentValueState value) {
        super(list ? LIST : "OBJECT");
        this.setEnterHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                char c = ctx.getCharacter();
                if (c == '{') {
                    ctx.lookFor('}');
                } else if (c == '[') {
                    ctx.lookFor(']');
                } else {
                    ctx.enterState(value);
                }
                ctx.activateControl('=');
            }
        });
        this.setDefaultHandler(new LineBreakHandler(false, false){

            @Override
            protected void doHandle(ParsingContext ctx) throws CommandFormatException {
                char c = ctx.getCharacter();
                if ((c == ']' || c == '}') && ctx.meetIfLookedFor(c)) {
                    ctx.leaveState();
                } else {
                    ctx.enterState(value);
                }
            }
        });
        this.setIgnoreWhitespaces(true);
        this.enterState(',', ListItemSeparatorState.INSTANCE);
        this.enterState('[', this);
        this.enterState('{', this);
        this.setReturnHandler(new CharacterHandler(){

            @Override
            public void handle(ParsingContext ctx) throws CommandFormatException {
                if (ctx.isEndOfContent()) {
                    return;
                }
                char c = ctx.getCharacter();
                if (c == '=' || c == '>') {
                    ctx.deactivateControl('=');
                    return;
                }
                ctx.activateControl('=');
                if (c == ',') {
                    return;
                }
                if (c == ']' || c == '}') {
                    if (ctx.meetIfLookedFor(c)) {
                        ctx.leaveState();
                        ctx.advanceLocation(1);
                    }
                    return;
                }
                CompositeState.this.getHandler(c).handle(ctx);
            }
        });
    }
}

