/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class CommandExecutor {
    private CliGuiContext cliGuiCtx;
    private ModelControllerClient client;
    private CommandContext cmdCtx;

    public CommandExecutor(CliGuiContext cliGuiCtx) {
        this.cliGuiCtx = cliGuiCtx;
        this.cmdCtx = cliGuiCtx.getCommmandContext();
        this.client = this.cmdCtx.getModelControllerClient();
        Runtime.getRuntime().addShutdownHook(new Thread(new ClientCloserShutdownHook()));
    }

    public synchronized ModelNode doCommand(String command) throws CommandFormatException, IOException {
        ModelNode request = this.cmdCtx.buildRequest(command);
        return this.execute(request, this.isSlowCommand(command));
    }

    public synchronized Response doCommandFullResponse(String command) throws CommandFormatException, IOException {
        ModelNode request = this.cmdCtx.buildRequest(command);
        boolean replacedBytes = this.replaceFilePathsWithBytes(request);
        ModelNode response = this.execute(request, this.isSlowCommand(command) || replacedBytes);
        return new Response(command, request, response);
    }

    private boolean replaceFilePathsWithBytes(ModelNode request) throws CommandFormatException, IOException {
        boolean didReplacement = false;
        ModelNode opDesc = request.clone();
        String opName = opDesc.get("operation").asString();
        opDesc.get("operation").set("read-operation-description");
        opDesc.get("name").set(opName);
        ModelNode response = this.execute(opDesc, false);
        ModelNode requestProps = response.get(new String[]{"result", "request-properties"});
        for (Property prop : requestProps.asPropertyList()) {
            ModelNode typeDesc = prop.getValue().get("type");
            if (typeDesc.getType() != ModelType.TYPE || typeDesc.asType() != ModelType.BYTES) continue;
            String filePath = request.get(prop.getName()).asString();
            File localFile = new File(filePath);
            try {
                request.get(prop.getName()).set(Util.readBytes(localFile));
                didReplacement = true;
            }
            catch (OperationFormatException e) {
                throw new CommandFormatException(e);
            }
        }
        return didReplacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelNode execute(ModelNode request, boolean useWaitCursor) throws IOException {
        try {
            if (useWaitCursor) {
                this.cliGuiCtx.getMainWindow().setCursor(Cursor.getPredefinedCursor(3));
            }
            ModelNode modelNode = this.client.execute(request);
            return modelNode;
        }
        finally {
            if (useWaitCursor) {
                this.cliGuiCtx.getMainWindow().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private boolean isSlowCommand(String command) {
        return command.startsWith("deploy") || command.startsWith("/subsystem=logging/:read-log-file");
    }

    public static class Response {
        private String command;
        private ModelNode dmrRequest;
        private ModelNode dmrResponse;

        Response(String command, ModelNode dmrRequest, ModelNode dmrResponse) {
            this.command = command;
            this.dmrRequest = dmrRequest;
            this.dmrResponse = dmrResponse;
        }

        public String getCommand() {
            return this.command;
        }

        public ModelNode getDmrRequest() {
            return this.dmrRequest;
        }

        public ModelNode getDmrResponse() {
            return this.dmrResponse;
        }
    }

    private class ClientCloserShutdownHook
    implements Runnable {
        private ClientCloserShutdownHook() {
        }

        @Override
        public void run() {
            try {
                CommandExecutor.this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

