/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.function;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionBiFunction;
import org.wildfly.common.function.ExceptionConsumer;
import org.wildfly.common.function.ExceptionFunction;
import org.wildfly.common.function.ExceptionRunnable;
import org.wildfly.common.function.ExceptionSupplier;

public final class Functions {
    private Functions() {
    }

    public static Consumer<Runnable> runnableConsumer() {
        return RunnableConsumer.INSTANCE;
    }

    public static <E extends Exception> ExceptionConsumer<ExceptionRunnable<E>, E> exceptionRunnableConsumer() {
        return ExceptionRunnableConsumer.INSTANCE;
    }

    public static <T> BiConsumer<Consumer<T>, T> consumerBiConsumer() {
        return ConsumerBiConsumer.INSTANCE;
    }

    public static <T, E extends Exception> ExceptionBiConsumer<ExceptionConsumer<T, E>, T, E> exceptionConsumerBiConsumer() {
        return ExceptionConsumerBiConsumer.INSTANCE;
    }

    public static <T> Function<Supplier<T>, T> supplierFunction() {
        return SupplierFunction.INSTANCE;
    }

    public static <T, E extends Exception> ExceptionFunction<ExceptionSupplier<T, E>, T, E> exceptionSupplierFunction() {
        return ExceptionSupplierFunction.INSTANCE;
    }

    public static <T> BiFunction<Function<Supplier<T>, T>, Supplier<T>, T> supplierFunctionBiFunction() {
        return FunctionSupplierBiFunction.INSTANCE;
    }

    public static <T, E extends Exception> ExceptionBiFunction<ExceptionFunction<ExceptionSupplier<T, E>, T, E>, ExceptionSupplier<T, E>, T, E> exceptionSupplierFunctionBiFunction() {
        return (ExceptionBiFunction)((Object)ExceptionFunctionSupplierBiFunction.INSTANCE);
    }

    public static <T> Supplier<T> constantSupplier(T value) {
        return value == null ? ConstantSupplier.NULL : new ConstantSupplier<T>(value);
    }

    public static <T, E extends Exception> ExceptionSupplier<T, E> constantExceptionSupplier(T value) {
        return value == null ? ConstantSupplier.NULL : new ConstantSupplier<T>(value);
    }

    static class ConstantSupplier<T>
    implements Supplier<T>,
    ExceptionSupplier<T, RuntimeException> {
        static final Supplier<?> NULL = new ConstantSupplier<Object>(null);
        private final T arg1;

        ConstantSupplier(T arg1) {
            this.arg1 = arg1;
        }

        @Override
        public T get() {
            return this.arg1;
        }
    }

    static class ExceptionFunctionSupplierBiFunction<E extends Exception>
    implements ExceptionBiFunction<ExceptionFunction<ExceptionSupplier<Object, E>, Object, E>, ExceptionSupplier<Object, E>, Object, E> {
        static final BiFunction<Function<Supplier<Object>, Object>, Supplier<Object>, Object> INSTANCE = new FunctionSupplierBiFunction();

        private ExceptionFunctionSupplierBiFunction() {
        }

        @Override
        public Object apply(ExceptionFunction<ExceptionSupplier<Object, E>, Object, E> function, ExceptionSupplier<Object, E> supplier) throws E {
            return function.apply(supplier);
        }
    }

    static class FunctionSupplierBiFunction
    implements BiFunction<Function<Supplier<Object>, Object>, Supplier<Object>, Object> {
        static final BiFunction<Function<Supplier<Object>, Object>, Supplier<Object>, Object> INSTANCE = new FunctionSupplierBiFunction();

        private FunctionSupplierBiFunction() {
        }

        @Override
        public Object apply(Function<Supplier<Object>, Object> function, Supplier<Object> supplier) {
            return function.apply(supplier);
        }
    }

    static class ExceptionSupplierFunction<E extends Exception>
    implements ExceptionFunction<ExceptionSupplier<Object, E>, Object, E> {
        static final ExceptionFunction<ExceptionSupplier<Object, Exception>, Object, Exception> INSTANCE = new ExceptionSupplierFunction<Exception>();

        private ExceptionSupplierFunction() {
        }

        @Override
        public Object apply(ExceptionSupplier<Object, E> supplier) throws E {
            return supplier.get();
        }
    }

    static class SupplierFunction
    implements Function<Supplier<Object>, Object> {
        static final Function<Supplier<Object>, Object> INSTANCE = new SupplierFunction();

        private SupplierFunction() {
        }

        @Override
        public Object apply(Supplier<Object> supplier) {
            return supplier.get();
        }
    }

    static class ExceptionConsumerBiConsumer<E extends Exception>
    implements ExceptionBiConsumer<ExceptionConsumer<Object, E>, Object, E> {
        static final ExceptionBiConsumer<ExceptionConsumer<Object, Exception>, Object, Exception> INSTANCE = new ExceptionConsumerBiConsumer<Exception>();

        private ExceptionConsumerBiConsumer() {
        }

        @Override
        public void accept(ExceptionConsumer<Object, E> consumer, Object o) throws E {
            consumer.accept(o);
        }
    }

    static class ConsumerBiConsumer
    implements BiConsumer<Consumer<Object>, Object> {
        static final BiConsumer<Consumer<Object>, Object> INSTANCE = new ConsumerBiConsumer();

        private ConsumerBiConsumer() {
        }

        @Override
        public void accept(Consumer<Object> consumer, Object o) {
            consumer.accept(o);
        }
    }

    static class ExceptionRunnableConsumer<E extends Exception>
    implements ExceptionConsumer<ExceptionRunnable<E>, E> {
        static final ExceptionConsumer<ExceptionRunnable<Exception>, Exception> INSTANCE = new ExceptionRunnableConsumer<Exception>();

        private ExceptionRunnableConsumer() {
        }

        @Override
        public void accept(ExceptionRunnable<E> ExceptionRunnable2) throws E {
            ExceptionRunnable2.run();
        }
    }

    static class RunnableConsumer
    implements Consumer<Runnable> {
        static final Consumer<Runnable> INSTANCE = new RunnableConsumer();

        private RunnableConsumer() {
        }

        @Override
        public void accept(Runnable runnable) {
            runnable.run();
        }
    }
}

