/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.context;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.common.context.ContextPermission;
import org.wildfly.common.context.Contextual;

public final class ContextManager<C extends Contextual<C>>
implements Supplier<C> {
    private final AtomicReference<Supplier<C>> globalDefaultSupplierRef = new AtomicReference();
    private final Class<C> type;
    private final String name;
    private final ThreadLocal<State<C>> stateRef = ThreadLocal.withInitial(State::new);
    private final ContextPermission getPermission;

    public ContextManager(Class<C> type) {
        this(type, type.getName());
    }

    public ContextManager(Class<C> type, String name) {
        Assert.checkNotNullParam("type", type);
        Assert.checkNotNullParam("name", name);
        Assert.checkNotEmptyParam("name", name);
        this.type = type;
        this.name = name;
        this.getPermission = new ContextPermission(name, "get");
    }

    public C getGlobalDefault() {
        Supplier<C> globalDefault;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getGlobalDefault"));
        }
        return (C)((globalDefault = this.globalDefaultSupplierRef.get()) == null ? null : (Contextual)globalDefault.get());
    }

    public void setGlobalDefaultSupplier(Supplier<C> supplier) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setGlobalDefaultSupplier"));
        }
        this.globalDefaultSupplierRef.set(supplier);
    }

    public boolean setGlobalDefaultSupplierIfNotSet(Supplier<Supplier<C>> supplierSupplier) {
        AtomicReference<Supplier<C>> ref;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setGlobalDefaultSupplier"));
        }
        return (ref = this.globalDefaultSupplierRef).get() == null && ref.compareAndSet(null, supplierSupplier.get());
    }

    public void setGlobalDefault(C globalDefault) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getGlobalDefault"));
        }
        this.globalDefaultSupplierRef.set(globalDefault == null ? null : () -> globalDefault);
    }

    public C getThreadDefault() {
        Supplier defaultSupplier;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getThreadDefault"));
        }
        return (C)((defaultSupplier = this.stateRef.get().defaultSupplier) == null ? null : (Contextual)defaultSupplier.get());
    }

    public void setThreadDefaultSupplier(Supplier<C> supplier) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setThreadDefaultSupplier"));
        }
        this.stateRef.get().defaultSupplier = supplier;
    }

    public void setThreadDefault(C threadDefault) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "setThreadDefault"));
        }
        this.stateRef.get().defaultSupplier = threadDefault == null ? null : () -> threadDefault;
    }

    @Override
    public C get() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.getPermission);
        }
        return this.getPrivileged();
    }

    public Supplier<C> getPrivilegedSupplier() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ContextPermission(this.name, "getPrivilegedSupplier"));
        }
        return this::getPrivileged;
    }

    private C getPrivileged() {
        State<C> state = this.stateRef.get();
        Contextual c = (Contextual)state.current;
        if (c != null) {
            return (C)c;
        }
        Supplier<Object> supplier = state.defaultSupplier;
        if (supplier != null && (c = (Contextual)supplier.get()) != null) {
            return (C)c;
        }
        supplier = this.globalDefaultSupplierRef.get();
        return (C)(supplier != null ? (Contextual)supplier.get() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C getAndSetCurrent(Contextual<C> newVal) {
        Contextual cast = (Contextual)this.type.cast(newVal);
        State<C> state = this.stateRef.get();
        try {
            Contextual contextual = (Contextual)state.current;
            return (C)contextual;
        }
        finally {
            state.current = cast;
        }
    }

    void restoreCurrent(C oldVal) {
        this.stateRef.get().current = oldVal;
    }

    static class State<T> {
        T current;
        Supplier<T> defaultSupplier;

        State() {
        }
    }
}

