/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.LinkedList;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.AnyField;
import org.wildfly.clustering.marshalling.protostream.FieldMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Scalar;
import org.wildfly.clustering.marshalling.protostream.ScalarMarshaller;

public class TypedArrayMarshaller
implements FieldMarshaller<Object> {
    private final ScalarMarshaller<Class<?>> componentType;

    TypedArrayMarshaller(ScalarMarshaller<Class<?>> componentType) {
        this.componentType = componentType;
    }

    @Override
    public Object readFrom(ProtoStreamReader reader) throws IOException {
        int index;
        Class componentType = (Class)this.componentType.readFrom(reader);
        LinkedList<Object> list = new LinkedList<Object>();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            index = WireType.getTagFieldNumber((int)tag);
            if (index == AnyField.ANY.getIndex()) {
                list.add(Scalar.ANY.readFrom(reader));
                continue;
            }
            reader.skipField(tag);
        }
        Object array = Array.newInstance(componentType == Any.class ? Object.class : componentType, list.size());
        index = 0;
        for (Object e : list) {
            Array.set(array, index++, e);
        }
        return array;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Object array) throws IOException {
        this.componentType.writeTo(writer, array.getClass().getComponentType());
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object element = Array.get(array, i);
            writer.writeTag(AnyField.ANY.getIndex(), Scalar.ANY.getWireType());
            Scalar.ANY.writeTo(writer, element);
        }
    }

    @Override
    public Class<? extends Object> getJavaClass() {
        return Object.class;
    }

    @Override
    public WireType getWireType() {
        return this.componentType.getWireType();
    }
}

