/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.build.common.model.ConfigFileOverride;
import org.wildfly.build.common.model.ConfigOverride;
import org.wildfly.build.common.model.CopyArtifactsXMLWriter10;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.common.model.FileFilterXMLWriter10;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.provisioning.model.Attribute;
import org.wildfly.build.provisioning.model.Element;
import org.wildfly.build.provisioning.model.ModuleFilter;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;
import org.wildfly.build.util.xml.TextNode;

public class ServerProvisioningDescriptionXmlWriter
implements XMLElementWriter<ServerProvisioningDescription> {
    public static ServerProvisioningDescriptionXmlWriter INSTANCE = new ServerProvisioningDescriptionXmlWriter();

    public void writeContent(XMLStreamWriter streamWriter, ServerProvisioningDescription value) throws XMLStreamException {
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.deparseDocument((XMLElementWriter)this, (Object)value, streamWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeContent(File file, ServerProvisioningDescription value) throws XMLStreamException, IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            try {
                this.writeContent(writer, value);
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter, ServerProvisioningDescription description) throws XMLStreamException {
        ElementNode rootElementNode = new ElementNode(null, Element.SERVER_PROVISIONING.getLocalName(), "urn:wildfly:server-provisioning:1.1");
        if (description.isCopyModuleArtifacts()) {
            rootElementNode.addAttribute(Attribute.COPY_MODULE_ARTIFACTS.getLocalName(), new AttributeValue(Boolean.TRUE.toString()));
        }
        if (description.isExtractSchemas()) {
            rootElementNode.addAttribute(Attribute.EXTRACT_SCHEMAS.getLocalName(), new AttributeValue(Boolean.TRUE.toString()));
            rootElementNode.addAttribute(Attribute.EXTRACT_SCHEMAS_GROUPS.getLocalName(), new AttributeValue(description.getExtractSchemasGroupsAsString()));
        }
        this.processFeaturePacks(description.getFeaturePacks(), rootElementNode);
        this.processVersionOverrides(description.getVersionOverrides(), rootElementNode);
        CopyArtifactsXMLWriter10.INSTANCE.write(description.getCopyArtifacts(), rootElementNode);
        streamWriter.writeStartDocument();
        rootElementNode.marshall((XMLStreamWriter)streamWriter);
        streamWriter.writeEndDocument();
    }

    protected void processFeaturePacks(List<ServerProvisioningDescription.FeaturePack> featurePacks, ElementNode parentElementNode) {
        if (!featurePacks.isEmpty()) {
            ElementNode featurePacksElementNode = new ElementNode(parentElementNode, Element.FEATURE_PACKS.getLocalName());
            for (ServerProvisioningDescription.FeaturePack featurePack : featurePacks) {
                this.processFeaturePack(featurePack, featurePacksElementNode);
            }
            parentElementNode.addChild(featurePacksElementNode);
        }
    }

    protected void processFeaturePack(ServerProvisioningDescription.FeaturePack featurePack, ElementNode parentElementNode) {
        ElementNode featurePackElementNode = new ElementNode(parentElementNode, Element.FEATURE_PACK.getLocalName());
        featurePackElementNode.addAttribute(Attribute.GROUP_ID.getLocalName(), new AttributeValue(featurePack.getArtifact().getGACE().getGroupId()));
        featurePackElementNode.addAttribute(Attribute.ARTIFACT_ID.getLocalName(), new AttributeValue(featurePack.getArtifact().getGACE().getArtifactId()));
        featurePackElementNode.addAttribute(Attribute.VERSION.getLocalName(), new AttributeValue(featurePack.getArtifact().getVersion()));
        if (featurePack.getArtifact().getGACE().getClassifier() != null) {
            featurePackElementNode.addAttribute(Attribute.CLASSIFIER.getLocalName(), new AttributeValue(featurePack.getArtifact().getGACE().getClassifier()));
        }
        this.processFeaturePackModuleFilters(featurePack, featurePackElementNode);
        this.processFeaturePackSubsystems(featurePack, featurePackElementNode);
        this.processFeaturePackConfigOverride(featurePack, featurePackElementNode);
        this.processFeaturePackContentFilters(featurePack, featurePackElementNode);
        parentElementNode.addChild(featurePackElementNode);
    }

    protected void processFeaturePackModuleFilters(ServerProvisioningDescription.FeaturePack featurePack, ElementNode featurePackElementNode) {
        ServerProvisioningDescription.FeaturePack.ModuleFilters moduleFilters = featurePack.getModuleFilters();
        if (moduleFilters != null) {
            ElementNode moduleFiltersElementNode = new ElementNode(featurePackElementNode, Element.MODULES.getLocalName());
            if (!moduleFilters.isInclude()) {
                moduleFiltersElementNode.addAttribute(Attribute.INCLUDE.getLocalName(), new AttributeValue(Boolean.toString(moduleFilters.isInclude())));
            }
            if (!moduleFilters.getFilters().isEmpty()) {
                for (ModuleFilter filter : moduleFilters.getFilters()) {
                    ElementNode filterElementNode = new ElementNode(moduleFiltersElementNode, Element.FILTER.getLocalName());
                    filterElementNode.addAttribute(Attribute.PATTERN.getLocalName(), new AttributeValue(filter.getPattern()));
                    filterElementNode.addAttribute(Attribute.INCLUDE.getLocalName(), new AttributeValue(Boolean.toString(filter.isInclude())));
                    if (!filter.isTransitive()) {
                        filterElementNode.addAttribute(Attribute.TRANSITIVE.getLocalName(), new AttributeValue(Boolean.toString(filter.isTransitive())));
                    }
                    moduleFiltersElementNode.addChild(filterElementNode);
                }
            }
            featurePackElementNode.addChild(moduleFiltersElementNode);
        }
    }

    protected void processFeaturePackSubsystems(ServerProvisioningDescription.FeaturePack featurePack, ElementNode featurePackElementNode) {
        List<ServerProvisioningDescription.FeaturePack.Subsystem> subsystems = featurePack.getSubsystems();
        if (subsystems != null && !subsystems.isEmpty()) {
            ElementNode subsystemsElementNode = new ElementNode(featurePackElementNode, Element.SUBSYSTEMS.getLocalName());
            for (ServerProvisioningDescription.FeaturePack.Subsystem subsystem : featurePack.getSubsystems()) {
                ElementNode subsystemElementNode = new ElementNode(subsystemsElementNode, Element.SUBSYSTEM.getLocalName());
                subsystemElementNode.addAttribute(Attribute.NAME.getLocalName(), new AttributeValue(subsystem.getName()));
                if (subsystem.isTransitive()) {
                    subsystemElementNode.addAttribute(Attribute.TRANSITIVE.getLocalName(), new AttributeValue(Boolean.toString(subsystem.isTransitive())));
                }
                subsystemsElementNode.addChild(subsystemElementNode);
            }
            featurePackElementNode.addChild(subsystemsElementNode);
        }
    }

    protected void processFeaturePackConfigOverride(ServerProvisioningDescription.FeaturePack featurePack, ElementNode featurePackElementNode) {
        ConfigOverride configOverride = featurePack.getConfigOverride();
        if (configOverride != null) {
            ElementNode configElementNode = new ElementNode(featurePackElementNode, Element.CONFIG.getLocalName());
            this.processFeaturePackConfigFileOverrides(configOverride.getStandaloneConfigFiles().values(), Element.STANDALONE, configElementNode);
            this.processFeaturePackConfigFileOverrides(configOverride.getDomainConfigFiles().values(), Element.DOMAIN, configElementNode);
            featurePackElementNode.addChild(configElementNode);
        }
    }

    protected void processFeaturePackConfigFileOverrides(Collection<ConfigFileOverride> configFiles, Element element, ElementNode parentElementNode) {
        for (ConfigFileOverride configFile : configFiles) {
            ElementNode configFileElementNode = new ElementNode(parentElementNode, element.getLocalName());
            configFileElementNode.addAttribute(Attribute.OUTPUT_FILE.getLocalName(), new AttributeValue(configFile.getOutputFile()));
            if (configFile.isUseTemplate()) {
                configFileElementNode.addAttribute(Attribute.USE_TEMPLATE.getLocalName(), new AttributeValue(Boolean.toString(configFile.isUseTemplate())));
            }
            for (Map.Entry<String, String> property : configFile.getProperties().entrySet()) {
                ElementNode propertyElementNode = new ElementNode(configFileElementNode, Element.PROPERTY.getLocalName());
                propertyElementNode.addAttribute(Attribute.NAME.getLocalName(), new AttributeValue(property.getKey()));
                propertyElementNode.addAttribute(Attribute.VALUE.getLocalName(), new AttributeValue(property.getValue()));
                configFileElementNode.addChild(propertyElementNode);
            }
            Map<String, Map<String, SubsystemConfig>> subsystems = configFile.getSubsystems();
            if (subsystems != null) {
                for (Map.Entry<String, Map<String, SubsystemConfig>> entry : subsystems.entrySet()) {
                    ElementNode subsystemsElementNode = new ElementNode(configFileElementNode, Element.SUBSYSTEMS.getLocalName());
                    if (!entry.getKey().equals("")) {
                        subsystemsElementNode.addAttribute(Attribute.NAME.getLocalName(), new AttributeValue(entry.getKey()));
                    }
                    for (SubsystemConfig subsystemConfig : entry.getValue().values()) {
                        ElementNode subsystemElementNode = new ElementNode(subsystemsElementNode, Element.SUBSYSTEM.getLocalName());
                        if (subsystemConfig.getSupplement() != null) {
                            subsystemElementNode.addAttribute("supplement", new AttributeValue(subsystemConfig.getSupplement()));
                        }
                        subsystemElementNode.addChild(new TextNode(subsystemConfig.getSubsystem()));
                        subsystemsElementNode.addChild(subsystemElementNode);
                    }
                    configFileElementNode.addChild(subsystemsElementNode);
                }
            }
            parentElementNode.addChild(configFileElementNode);
        }
    }

    protected void processFeaturePackContentFilters(ServerProvisioningDescription.FeaturePack featurePack, ElementNode featurePackElementNode) {
        ServerProvisioningDescription.FeaturePack.ContentFilters contentFilters = featurePack.getContentFilters();
        if (contentFilters != null) {
            ElementNode contentFiltersElementNode = new ElementNode(featurePackElementNode, Element.CONTENTS.getLocalName());
            if (!contentFilters.isInclude()) {
                contentFiltersElementNode.addAttribute(Attribute.INCLUDE.getLocalName(), new AttributeValue(Boolean.toString(contentFilters.isInclude())));
            }
            if (!contentFilters.getFilters().isEmpty()) {
                for (FileFilter filter : contentFilters.getFilters()) {
                    FileFilterXMLWriter10.INSTANCE.write(filter, contentFiltersElementNode);
                }
            }
            featurePackElementNode.addChild(contentFiltersElementNode);
        }
    }

    protected void processVersionOverrides(Collection<Artifact> artifacts, ElementNode parentElementNode) {
        if (!artifacts.isEmpty()) {
            ElementNode versionOverridesElementNode = new ElementNode(parentElementNode, Element.VERSION_OVERRIDES.getLocalName());
            for (Artifact artifact : artifacts) {
                ElementNode versionOverrideElementNode = new ElementNode(versionOverridesElementNode, Element.VERSION_OVERRIDE.getLocalName());
                versionOverrideElementNode.addAttribute(Attribute.GROUP_ID.getLocalName(), new AttributeValue(artifact.getGACE().getGroupId()));
                versionOverrideElementNode.addAttribute(Attribute.ARTIFACT_ID.getLocalName(), new AttributeValue(artifact.getGACE().getArtifactId()));
                versionOverrideElementNode.addAttribute(Attribute.VERSION.getLocalName(), new AttributeValue(artifact.getVersion()));
                if (artifact.getGACE().getClassifier() != null) {
                    versionOverrideElementNode.addAttribute(Attribute.CLASSIFIER.getLocalName(), new AttributeValue(artifact.getGACE().getClassifier()));
                }
                if (artifact.getGACE().getExtension() != null) {
                    versionOverrideElementNode.addAttribute(Attribute.EXTENSION.getLocalName(), new AttributeValue(artifact.getGACE().getExtension()));
                }
                versionOverridesElementNode.addChild(versionOverrideElementNode);
            }
            parentElementNode.addChild(versionOverridesElementNode);
        }
    }
}

