/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.List;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.common.model.FileFilterXMLWriter10;
import org.wildfly.build.common.model.FilePermission;
import org.wildfly.build.common.model.FilePermissionsModelParser10;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;

public class FilePermissionsXMLWriter10 {
    public static final FilePermissionsXMLWriter10 INSTANCE = new FilePermissionsXMLWriter10();

    private FilePermissionsXMLWriter10() {
    }

    public void write(List<FilePermission> filePermissions, ElementNode parentElementNode) {
        if (!filePermissions.isEmpty()) {
            ElementNode filePermissionsElementNode = new ElementNode(parentElementNode, "file-permissions");
            for (FilePermission filePermission : filePermissions) {
                this.writeFilePermission(filePermission, filePermissionsElementNode);
            }
            parentElementNode.addChild(filePermissionsElementNode);
        }
    }

    protected void writeFilePermission(FilePermission filePermission, ElementNode filePermissionsElementNode) {
        ElementNode filePermissionElementNode = new ElementNode(filePermissionsElementNode, FilePermissionsModelParser10.Element.PERMISSION.getLocalName());
        if (!filePermission.getFilters().isEmpty()) {
            for (FileFilter fileFilter : filePermission.getFilters()) {
                FileFilterXMLWriter10.INSTANCE.write(fileFilter, filePermissionElementNode);
            }
        }
        filePermissionElementNode.addAttribute(FilePermissionsModelParser10.Attribute.VALUE.getLocalName(), new AttributeValue(filePermission.getValue()));
        filePermissionsElementNode.addChild(filePermissionElementNode);
    }
}

