/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.contributor.yuiloader;

import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.wicketstuff.yui.helper.JSArray;
import org.wicketstuff.yui.helper.JSObject;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.IYuiLoaderModule;

public class YuiLoaderModule
implements IYuiLoaderModule {
    private static final long serialVersionUID = 1L;
    private String name;
    private ModuleType type;
    private String fullpath;
    private String[] requires;

    public YuiLoaderModule(String name, ModuleType type, String fullpath, String[] requires) {
        this.name = name;
        this.type = type;
        this.fullpath = fullpath;
        this.requires = requires;
    }

    public YuiLoaderModule(String name, ModuleType type, ResourceReference ref, String[] requires) {
        this(name, type, RequestCycle.get().getUrlRenderer().renderFullUrl(Url.parse((CharSequence)RequestCycle.get().urlFor(ref, null))), requires);
    }

    @Override
    public String getModuleJS() {
        JSObject js = new JSObject();
        js.add("name", this.name);
        js.add("type", this.type.toString());
        js.add("fullpath", this.fullpath);
        js.add("requires", new JSArray(this.requires));
        return js.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.name.hashCode();
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + this.fullpath.hashCode();
        return hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof YuiLoaderModule)) {
            return false;
        }
        YuiLoaderModule castOther = (YuiLoaderModule)other;
        return this.name.equals(castOther.name) && this.type.equals((Object)castOther.type) && this.fullpath.equals(castOther.fullpath);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ModuleType getType() {
        return this.type;
    }

    public void setType(ModuleType type) {
        this.type = type;
    }

    public String getFullpath() {
        return this.fullpath;
    }

    public void setFullpath(String fullpath) {
        this.fullpath = fullpath;
    }

    public String[] getRequires() {
        return this.requires;
    }

    public void setRequires(String[] requires) {
        this.requires = requires;
    }

    @Override
    public String onSuccessJS() {
        return "";
    }

    public static enum ModuleType {
        js,
        css;

    }
}

