/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.contributor.yuiloader;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.IYuiLoaderModule;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoader;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderInsert;
import org.wicketstuff.yui.markup.html.contributor.yuiloader.YuiLoaderSandbox;

public class YuiLoaderContributor
extends Behavior
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static ThreadLocalYuiLoaderContributor threadLocalLoader = new ThreadLocalYuiLoaderContributor();
    private YuiLoader yuiLoader = new YuiLoaderInsert();
    private YuiLoader yuiLoaderSandbox = new YuiLoaderSandbox();

    private YuiLoaderContributor() {
    }

    public void renderHead(Component component, IHeaderResponse response) {
        this.renderHead(response);
    }

    public void renderHead(IHeaderResponse response) {
        for (IHeaderContributor iHeaderContributor : this.getHeaderContributors()) {
            iHeaderContributor.renderHead(response);
        }
    }

    public static Behavior addModule(IYuiLoaderModule yuiLoaderModule) {
        return YuiLoaderContributor.addModule(yuiLoaderModule, false);
    }

    public static Behavior addModule(IYuiLoaderModule module, boolean useSandbox) {
        YuiLoaderContributor loader = YuiLoaderContributor.getCurrentLoader();
        if (useSandbox) {
            loader.yuiLoaderSandbox = YuiLoaderContributor.addModule(loader.yuiLoaderSandbox, module);
        } else {
            loader.yuiLoader = YuiLoaderContributor.addModule(loader.yuiLoader, module);
        }
        return loader;
    }

    private static YuiLoader addModule(YuiLoader loader, IYuiLoaderModule module) {
        if (loader.rendered) {
            loader = loader.newLoader();
        }
        loader.add(module);
        return loader;
    }

    private static YuiLoaderContributor getCurrentLoader() {
        YuiLoaderContributor loader = (YuiLoaderContributor)((Object)threadLocalLoader.get());
        return loader;
    }

    public void detach(Component component) {
        threadLocalLoader.remove();
    }

    public IHeaderContributor[] getHeaderContributors() {
        ArrayList<YuiLoader> contributors = new ArrayList<YuiLoader>();
        if (this.yuiLoader != null && !this.yuiLoader.getModules().isEmpty()) {
            contributors.add(this.yuiLoader);
        }
        if (this.yuiLoaderSandbox != null && !this.yuiLoaderSandbox.getModules().isEmpty()) {
            contributors.add(this.yuiLoaderSandbox);
        }
        return contributors.toArray(new IHeaderContributor[contributors.size()]);
    }

    private static class ThreadLocalYuiLoaderContributor
    extends ThreadLocal<YuiLoaderContributor> {
        private ThreadLocalYuiLoaderContributor() {
        }

        @Override
        protected YuiLoaderContributor initialValue() {
            return new YuiLoaderContributor();
        }
    }
}

