/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.yui.markup.html.contributor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.yui.inc.YUI;
import org.wicketstuff.yui.markup.html.contributor.YuiDependencyResolver;

public class YuiHeaderContributor
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(YuiHeaderContributor.class);
    static final String DEFAULT_YUI_BUILD = "2.7.0b";
    static final String YUI_BUILD_ROOT = "/org/wicketstuff/yui/inc";
    static final Map<String, ResourceReference> moduleCache = Collections.synchronizedMap(new HashMap());
    static final YuiDependencyResolver dependencyResolver = new YuiDependencyResolver();
    List<YuiModuleHeaderContributor> contributors = new ArrayList<YuiModuleHeaderContributor>();

    public void renderHead(IHeaderResponse response) {
        for (IHeaderContributor iHeaderContributor : this.getHeaderContributors()) {
            iHeaderContributor.renderHead(response);
        }
    }

    public IHeaderContributor[] getHeaderContributors() {
        return this.contributors.toArray(new IHeaderContributor[0]);
    }

    private void addModuleHeaderContributor(String name, String build, boolean debug) {
        this.contributors.add(new YuiModuleHeaderContributor(name, build, debug));
    }

    public static YuiHeaderContributor forModule(String module) {
        return YuiHeaderContributor.forModule(module, null);
    }

    public static YuiHeaderContributor forModule(String module, String[] optionalDependencies) {
        return YuiHeaderContributor.forModule(module, optionalDependencies, false);
    }

    public static YuiHeaderContributor forModule(String name, String[] optionalDependencies, boolean debug) {
        return YuiHeaderContributor.forModule(name, optionalDependencies, debug, DEFAULT_YUI_BUILD);
    }

    public static YuiHeaderContributor forModule(String name, String[] optionalDependencies, boolean debug, String build) {
        YuiHeaderContributor yhc = new YuiHeaderContributor();
        Set<String> dependencies = dependencyResolver.resolveDependencies(name, "/org/wicketstuff/yui/inc/" + build);
        for (String dep : dependencies) {
            yhc.addModuleHeaderContributor(dep, build, debug);
        }
        if (null != optionalDependencies && optionalDependencies.length != 0) {
            for (String opts : optionalDependencies) {
                yhc.addModuleHeaderContributor(opts, build, debug);
            }
        }
        yhc.addModuleHeaderContributor(name, build, debug);
        return yhc;
    }

    class YuiModuleHeaderContributor
    implements IHeaderContributor {
        private final String name;
        private final String build;
        private final boolean debug;

        public YuiModuleHeaderContributor(String name, String build, boolean debug) {
            this.name = name;
            this.build = build;
            this.debug = debug;
        }

        private String getRealModuleName(String path, String module) {
            String fullPath = path + "/" + module + "/";
            URL url = this.getClass().getResource(fullPath + module + "-min.js");
            if (null != url) {
                return module + "-min";
            }
            url = this.getClass().getResource(fullPath + module + ".js");
            if (null != url) {
                return module;
            }
            url = this.getClass().getResource(fullPath + module + "-beta.js");
            if (null != url) {
                return module + "-beta";
            }
            url = this.getClass().getResource(fullPath + module + "-experimental.js");
            if (null != url) {
                return module + "experimental";
            }
            return null;
        }

        public void renderHead(IHeaderResponse response) {
            String buildPath = "/org/wicketstuff/yui/inc/" + this.build;
            String realName = this.getRealModuleName(buildPath, this.name);
            if (null != realName) {
                ResourceReference moduleScript;
                String path = this.build + "/" + this.name + "/" + realName + (this.debug ? "-debug.js" : ".js");
                if (moduleCache.containsKey(path)) {
                    moduleScript = moduleCache.get(path);
                } else {
                    moduleScript = this.debug ? new JavaScriptResourceReference(YUI.class, path) : new JavaScriptResourceReference(YUI.class, path);
                    moduleCache.put(path, moduleScript);
                }
                response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)moduleScript));
                if (dependencyResolver.hasCssAsset(this.name, "/org/wicketstuff/yui/inc/" + this.build)) {
                    CssResourceReference assetRef;
                    String assetPath = this.build + "/" + this.name + "/assets/" + this.name + ".css";
                    if (moduleCache.containsKey(assetPath)) {
                        assetRef = moduleCache.get(assetPath);
                    } else {
                        assetRef = new CssResourceReference(YUI.class, assetPath);
                        moduleCache.put(assetPath, (ResourceReference)assetRef);
                    }
                    response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)assetRef, (String)"screen"));
                }
            } else {
                log.error("Unable to find realName for Yui Module " + this.name);
            }
        }
    }
}

