/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.swarm.strategies;

import java.util.Collections;
import java.util.Set;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.wicketstuff.security.authentication.LoginException;
import org.wicketstuff.security.components.ISecureComponent;
import org.wicketstuff.security.components.ISecurePage;
import org.wicketstuff.security.hive.Hive;
import org.wicketstuff.security.hive.HiveMind;
import org.wicketstuff.security.hive.authentication.LoginContainer;
import org.wicketstuff.security.hive.authentication.LoginContext;
import org.wicketstuff.security.hive.authentication.Subject;
import org.wicketstuff.security.hive.authorization.Permission;
import org.wicketstuff.security.log.IAuthorizationMessageSource;
import org.wicketstuff.security.strategies.SecurityException;
import org.wicketstuff.security.swarm.strategies.AbstractSwarmStrategy;

public class SwarmStrategy
extends AbstractSwarmStrategy {
    private static final long serialVersionUID = 1L;
    private Object hiveQueen;

    public SwarmStrategy(Object hiveQueen) {
        this(ISecurePage.class, hiveQueen);
    }

    public SwarmStrategy(Class<? extends ISecureComponent> secureClass, Object hiveQueen) {
        super(secureClass);
        this.hiveQueen = hiveQueen;
        this.loginContainer = new LoginContainer();
    }

    protected final Hive getHive() {
        Hive hive = HiveMind.getHive((Object)this.hiveQueen);
        if (hive == null) {
            throw new SecurityException("No hive registered for " + this.hiveQueen);
        }
        return hive;
    }

    @Override
    public boolean hasPermission(Permission permission, Subject subject) {
        if (permission == null) {
            throw new SecurityException("permission is not allowed to be null");
        }
        if (this.getHive().hasPermission(subject, permission)) {
            return true;
        }
        this.logPermissionDenied(permission, subject);
        return false;
    }

    protected void logPermissionDenied(Permission permission, Subject subject) {
        IAuthorizationMessageSource source = this.getMessageSource(this.logMessages());
        if (source == null) {
            return;
        }
        source.addVariable("permission", (Object)permission);
        source.addVariable("actions", (Object)permission.getActions());
        source.addVariable("subject", (Object)subject);
        Set principals = this.getHive().getPrincipals(permission);
        if (!principals.isEmpty()) {
            source.addVariable("principals", (Object)principals);
        } else {
            source.addVariable("principals", (Object)Collections.EMPTY_SET);
        }
    }

    public void login(Object context) throws LoginException {
        if (!(context instanceof LoginContext)) {
            throw new SecurityException("Unable to process login with context: " + context);
        }
        this.loginContainer.login((LoginContext)context);
    }

    public boolean logoff(Object context) {
        if (context instanceof LoginContext) {
            return this.loginContainer.logoff((LoginContext)context);
        }
        throw new SecurityException("Unable to process logoff with context: " + context);
    }

    protected final LoginContainer getLoginContainer() {
        return this.loginContainer;
    }

    public boolean isUserAuthenticated() {
        return this.getSubject() != null;
    }

    public boolean isResourceAuthorized(IResource resource, PageParameters parameters) {
        return true;
    }
}

