/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.security.swarm.strategies;

import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.wicketstuff.security.actions.WaspAction;
import org.wicketstuff.security.components.ISecureComponent;
import org.wicketstuff.security.components.SecureComponentHelper;
import org.wicketstuff.security.hive.authentication.LoginContainer;
import org.wicketstuff.security.hive.authentication.Subject;
import org.wicketstuff.security.hive.authorization.Permission;
import org.wicketstuff.security.hive.authorization.permissions.ComponentPermission;
import org.wicketstuff.security.hive.authorization.permissions.DataPermission;
import org.wicketstuff.security.log.IAuthorizationMessageSource;
import org.wicketstuff.security.models.ISecureModel;
import org.wicketstuff.security.strategies.ClassAuthorizationStrategy;
import org.wicketstuff.security.swarm.actions.SwarmAction;
import org.wicketstuff.security.swarm.models.SwarmModel;

public abstract class AbstractSwarmStrategy
extends ClassAuthorizationStrategy {
    private static final long serialVersionUID = 1L;
    protected LoginContainer loginContainer;

    public AbstractSwarmStrategy() {
    }

    public AbstractSwarmStrategy(Class<? extends ISecureComponent> secureClass) {
        super(secureClass);
    }

    public abstract boolean hasPermission(Permission var1, Subject var2);

    public Subject getSubject() {
        return this.loginContainer.getSubject();
    }

    public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission, this.getSubject());
    }

    public boolean isClassAuthenticated(Class<?> clazz) {
        return this.loginContainer.isClassAuthenticated(clazz);
    }

    public boolean isClassAuthorized(Class<?> clazz, WaspAction action) {
        if (this.hasPermission((Permission)new ComponentPermission(SecureComponentHelper.alias(clazz), action))) {
            return true;
        }
        this.logMessage(this.getMessageSource());
        return false;
    }

    public boolean isComponentAuthenticated(Component component) {
        return this.loginContainer.isComponentAuthenticated(component);
    }

    public boolean isComponentAuthorized(Component component, WaspAction action) {
        if (this.hasPermission((Permission)new ComponentPermission(component, action))) {
            return true;
        }
        IAuthorizationMessageSource message = this.getMessageSource();
        if (message != null) {
            message.setComponent(component);
            this.logMessage(message);
        }
        return false;
    }

    public boolean isModelAuthenticated(IModel<?> model, Component component) {
        return this.loginContainer.isModelAuthenticated(model, component);
    }

    public boolean isModelAuthorized(ISecureModel<?> model, Component component, WaspAction action) {
        DataPermission permission = model instanceof SwarmModel ? new DataPermission(component, (SwarmModel)model, (WaspAction)((SwarmAction)action)) : new DataPermission(String.valueOf(model), action);
        if (this.hasPermission((Permission)permission)) {
            return true;
        }
        IAuthorizationMessageSource message = this.getMessageSource();
        if (message != null) {
            message.setComponent(component);
            this.logMessage(message);
        }
        return false;
    }
}

