/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.request.UrlDecoder;
import org.apache.wicket.request.UrlEncoder;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final String DEFAULT_CHARSET_NAME = "UTF-8";

    public static final boolean appendParameter(StringBuilder sb, boolean first, String name, String value, boolean encodeURL) {
        if (!first) {
            sb.append('&');
        } else {
            first = false;
        }
        if (encodeURL) {
            sb.append(UrlEncoder.QUERY_INSTANCE.encode(name, DEFAULT_CHARSET_NAME));
            if (value != null) {
                sb.append('=').append(UrlEncoder.QUERY_INSTANCE.encode(value, DEFAULT_CHARSET_NAME));
            }
        } else {
            sb.append(name);
            if (value != null) {
                sb.append('=').append(value);
            }
        }
        return first;
    }

    public static final String buildQueryString(Map<String, String[]> parameterMap) {
        return Utils.buildQueryString(parameterMap, true);
    }

    public static final String buildQueryString(Map<String, String[]> parameterMap, boolean encodeURL) {
        if (parameterMap == null || parameterMap.isEmpty()) {
            return null;
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            if (values == null || values.length == 0) {
                first = Utils.appendParameter(sb, first, name, null, encodeURL);
                continue;
            }
            for (String value : values) {
                first = Utils.appendParameter(sb, first, name, value, encodeURL);
            }
        }
        return sb.toString();
    }

    public static final Map<String, String[]> parseQueryString(String queryString) {
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        if (queryString != null) {
            for (String queryParameter : Strings.split((String)queryString, (char)'&')) {
                String[] parts = Strings.split((String)queryParameter, (char)'=');
                if (parts.length <= 0) continue;
                for (int i = 0; i < 2 && i < parts.length; ++i) {
                    parts[i] = UrlDecoder.QUERY_INSTANCE.decode(parts[i], DEFAULT_CHARSET_NAME);
                }
                String[] values = (String[])parameterMap.get(parts[0]);
                if (values == null) {
                    parameterMap.put(parts[0], new String[]{parts.length > 1 ? parts[1] : null});
                    continue;
                }
                String[] newValues = new String[values.length + 1];
                System.arraycopy(values, 0, newValues, 0, values.length);
                newValues[values.length] = parts.length > 1 ? parts[1] : null;
                parameterMap.put(parts[0], newValues);
            }
        }
        return parameterMap;
    }
}

