/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

public class PortletServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Set<String> HIDDEN_REQUEST_ATTRIBUTES = new HashSet<String>(Arrays.asList("javax.servlet.error.request_uri", "javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path", "javax.servlet.forward.context_path", "javax.servlet.forward.query_string"));
    private String contextPath;
    private final String servletPath;
    private String pathInfo;
    private String requestURI;
    private String queryString;
    private HttpSession session;

    private static String makeServletPath(String filterPath) {
        return "/" + filterPath.substring(0, filterPath.length() - 1);
    }

    public PortletServletRequestWrapper(ServletContext context, HttpServletRequest request, HttpSession proxiedSession, String filterPath) {
        this(context, proxiedSession, request, filterPath);
        int pathInfoBegin = this.contextPath.length() + filterPath.length();
        String pathInfo = pathInfoBegin >= this.requestURI.length() ? null : this.requestURI.substring(pathInfoBegin);
        this.pathInfo = pathInfo == null || pathInfo.length() < 2 ? null : pathInfo;
    }

    public PortletServletRequestWrapper(ServletContext context, HttpServletRequest request, HttpSession proxiedSession, String filterPath, String pathInfo) {
        this(context, proxiedSession, request, filterPath);
        this.pathInfo = pathInfo;
        this.requestURI = this.contextPath + this.servletPath + (pathInfo != null ? pathInfo : "");
    }

    protected PortletServletRequestWrapper(ServletContext context, HttpSession proxiedSession, HttpServletRequest request, String filterPath) {
        super(request);
        this.session = proxiedSession;
        if (proxiedSession == null) {
            this.session = request.getSession(false);
        }
        this.servletPath = PortletServletRequestWrapper.makeServletPath(filterPath);
        this.contextPath = (String)request.getAttribute("javax.servlet.include.context_path");
        if (this.contextPath != null) {
            this.requestURI = (String)request.getAttribute("javax.servlet.include.request_uri");
            this.queryString = (String)request.getAttribute("javax.servlet.include.query_string");
        } else {
            this.contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
            if (this.contextPath != null) {
                this.requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
                this.queryString = (String)request.getAttribute("javax.servlet.include.query_string");
            } else {
                this.contextPath = request.getContextPath();
                this.requestURI = request.getRequestURI();
                this.queryString = request.getQueryString();
            }
        }
    }

    public Object getAttribute(String name) {
        if (HIDDEN_REQUEST_ATTRIBUTES.contains(name)) {
            return null;
        }
        return super.getAttribute(name);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        return this.session != null ? this.session : super.getSession(create);
    }

    public String getHeader(String name) {
        String header = super.getHeader(name);
        if (header == null) {
            Enumeration headerNames = this.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (!headerName.equalsIgnoreCase(name)) continue;
                header = super.getHeader(headerName);
                break;
            }
        }
        return header;
    }

    public Enumeration getHeaders(String name) {
        Enumeration headers = super.getHeaders(name);
        if (!headers.hasMoreElements()) {
            Enumeration headerNames = this.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (!headerName.equalsIgnoreCase(name)) continue;
                headers = super.getHeaders(headerName);
                break;
            }
        }
        return headers;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        try {
            super.setCharacterEncoding(enc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

