/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.util.Iterator;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.SystemMapper;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.portlet.ThreadPortletContext;
import org.apache.wicket.portlet.Utils;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.BookmarkablePageRequestHandler;
import org.apache.wicket.request.handler.ListenerInterfaceRequestHandler;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.AbstractComponentMapper;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.SharedResourceReference;
import org.apache.wicket.util.crypt.Base64;

public class PortletRequestMapper
extends AbstractComponentMapper {
    private SystemMapper systemMapper;

    public PortletRequestMapper(Application application) {
        this.systemMapper = new SystemMapper(application);
    }

    public IRequestHandler mapRequest(Request request) {
        return this.systemMapper.mapRequest(request);
    }

    public int getCompatibilityScore(Request request) {
        return this.systemMapper.getCompatibilityScore(request);
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.systemMapper.mapHandler(requestHandler);
        if (ThreadPortletContext.getPortletRequest() == null) {
            return url;
        }
        if (requestHandler instanceof RenderPageRequestHandler) {
            if (ThreadPortletContext.isAjax()) {
                url = this.encodeRenderUrl(url, true);
            }
        } else if (requestHandler instanceof SharedResourceReference) {
            url = this.encodeSharedResourceUrl(url);
        } else if (requestHandler instanceof ResourceReferenceRequestHandler) {
            ResourceReferenceRequestHandler resourceReferenceRequestHandler = (ResourceReferenceRequestHandler)requestHandler;
            IResource resource = resourceReferenceRequestHandler.getResource();
            url = resource instanceof PackageResource ? this.encodeSharedResourceUrl(url) : this.encodeResourceUrl(url);
        } else if (requestHandler instanceof BookmarkablePageRequestHandler) {
            url = this.encodeRenderUrl(url, true);
        } else if (requestHandler instanceof ListenerInterfaceRequestHandler) {
            ListenerInterfaceRequestHandler listenerInterfaceRequestHandler = (ListenerInterfaceRequestHandler)requestHandler;
            RequestListenerInterface listenerInterface = listenerInterfaceRequestHandler.getListenerInterface();
            Class<?> listenerClass = listenerInterface.getMethod().getDeclaringClass();
            url = IResourceListener.class.isAssignableFrom(listenerClass) || IBehaviorListener.class.isAssignableFrom(listenerClass) ? this.encodeResourceUrl(url) : (IRedirectListener.class.isAssignableFrom(listenerClass) ? (ThreadPortletContext.isAjax() ? this.encodeRenderUrl(url, true) : this.encodeRenderUrl(url, false)) : (ThreadPortletContext.isAjax() ? this.encodeActionUrl(url, true) : this.encodeActionUrl(url, false)));
        }
        return url;
    }

    private String getQualifiedPath(String path) {
        HttpServletRequest request = ThreadPortletContext.getHttpServletRequest();
        return request.getServletPath() + "/" + path;
    }

    private Url parseUrl(String urlString) {
        Url url = Url.parse((String)urlString);
        url.setProtocol(null);
        url.setHost(null);
        url.setPort(null);
        return url;
    }

    private Url encodeResourceUrl(Url url) {
        if (url != null) {
            String qualifiedPath = this.getQualifiedPath(url.toString());
            PortletResponse portletResponse = ThreadPortletContext.getPortletResponse();
            if (portletResponse != null && portletResponse instanceof MimeResponse) {
                try {
                    ResourceURL resourceUrl = ((MimeResponse)portletResponse).createResourceURL();
                    resourceUrl.setResourceID(qualifiedPath);
                    qualifiedPath = resourceUrl.toString();
                    int queryStringSeparator = qualifiedPath.indexOf(63);
                    if (queryStringSeparator > 0) {
                        Map<String, String[]> parameterMap = Utils.parseQueryString(qualifiedPath.substring(queryStringSeparator + 1));
                        boolean changed = false;
                        Iterator<Map.Entry<String, String[]>> it = parameterMap.entrySet().iterator();
                        String namespace = ThreadPortletContext.getNamespace();
                        while (it.hasNext()) {
                            if (!it.next().getKey().startsWith(namespace)) continue;
                            changed = true;
                            it.remove();
                        }
                        if (changed) {
                            qualifiedPath = qualifiedPath.substring(0, queryStringSeparator) + '?' + Utils.buildQueryString(parameterMap);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            url = this.parseUrl(qualifiedPath);
        }
        return url;
    }

    private Url encodeSharedResourceUrl(Url url) {
        if (url != null) {
            Request request = RequestCycle.get().getRequest();
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(request.getContextPath());
            urlBuilder.append(request.getFilterPath());
            urlBuilder.append("/ps:");
            urlBuilder.append(Base64.encodeBase64URLSafeString((byte[])ThreadPortletContext.getWindowID().getBytes()));
            urlBuilder.append('/');
            urlBuilder.append(url.toString());
            url = Url.parse((String)urlBuilder.toString());
        }
        return url;
    }

    private Url encodeActionUrl(Url url, boolean forceActionUrl) {
        if (!forceActionUrl && ThreadPortletContext.isResourceRequest()) {
            return this.encodeResourceUrl(url);
        }
        if (url != null) {
            String qualifiedPath = this.getQualifiedPath(url.toString());
            PortletResponse portletResponse = ThreadPortletContext.getPortletResponse();
            if (portletResponse != null && portletResponse instanceof MimeResponse) {
                try {
                    PortletURL portletUrl = ((MimeResponse)portletResponse).createActionURL();
                    portletUrl.setParameter("_wu", qualifiedPath);
                    qualifiedPath = portletUrl.toString();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            url = this.parseUrl(qualifiedPath);
        }
        return url;
    }

    private Url encodeRenderUrl(Url url, boolean forceRenderUrl) {
        if (!forceRenderUrl && ThreadPortletContext.isResourceRequest()) {
            return this.encodeResourceUrl(url);
        }
        if (url != null) {
            String qualifiedPath = this.getQualifiedPath(url.toString());
            PortletResponse portletResponse = ThreadPortletContext.getPortletResponse();
            if (portletResponse != null && portletResponse instanceof MimeResponse) {
                try {
                    PortletURL portletUrl = ((MimeResponse)portletResponse).createRenderURL();
                    portletUrl.setParameter("_wu" + ThreadPortletContext.getPortletMode().toString(), qualifiedPath);
                    qualifiedPath = portletUrl.toString();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            url = this.parseUrl(qualifiedPath);
        }
        return url;
    }
}

