/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.portlet;

import java.io.IOException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.wicket.Application;
import org.apache.wicket.portlet.MarkupIdPrepender;
import org.apache.wicket.portlet.PortletHttpSessionWrapper;
import org.apache.wicket.portlet.PortletInvalidMarkupFilter;
import org.apache.wicket.portlet.PortletRequestMapper;
import org.apache.wicket.portlet.PortletServletRequestWrapper;
import org.apache.wicket.portlet.PortletServletResponseWrapper;
import org.apache.wicket.portlet.ResponseState;
import org.apache.wicket.portlet.WicketPortlet;
import org.apache.wicket.protocol.http.IWebApplicationFactory;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.util.crypt.Base64;

public class PortletFilter
extends WicketFilter {
    public static final String SHARED_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX = "/ps:";
    private FilterConfig filterConfig;
    private WebApplication application;

    protected IWebApplicationFactory getApplicationFactory() {
        final IWebApplicationFactory applicationFactory = super.getApplicationFactory();
        return new IWebApplicationFactory(){

            public WebApplication createApplication(WicketFilter filter) {
                PortletFilter.this.application = applicationFactory.createApplication(filter);
                return PortletFilter.this.application;
            }

            public void destroy(WicketFilter filter) {
                applicationFactory.destroy(filter);
            }
        };
    }

    public void init(boolean isServlet, FilterConfig filterConfig) throws ServletException {
        super.init(isServlet, filterConfig);
        this.filterConfig = filterConfig;
        this.application.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.RenderStrategy.REDIRECT_TO_RENDER);
        this.application.getRequestCycleSettings().addResponseFilter((IResponseFilter)new PortletInvalidMarkupFilter());
        this.application.getComponentInitializationListeners().add((Object)new MarkupIdPrepender());
        this.application.setRootRequestMapper((IRequestMapper)new PortletRequestMapper((Application)this.application));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object httpServletRequest = (HttpServletRequest)servletRequest;
        Object httpServletResponse = (HttpServletResponse)servletResponse;
        String filterPath = this.getFilterPath((HttpServletRequest)httpServletRequest);
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest != null) {
            PortletConfig portletConfig = (PortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
            ResponseState responseState = (ResponseState)httpServletRequest.getAttribute(WicketPortlet.RESPONSE_STATE_ATTR);
            if (portletConfig != null) {
                if (responseState == null) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                HttpSession proxiedSession = PortletHttpSessionWrapper.createProxy(httpServletRequest, portletRequest.getWindowID());
                httpServletRequest = new PortletServletRequestWrapper(this.filterConfig.getServletContext(), (HttpServletRequest)httpServletRequest, proxiedSession, filterPath);
                httpServletResponse = new PortletServletResponseWrapper((HttpServletResponse)httpServletResponse, responseState);
            }
        } else {
            int nextSeparator;
            String pathInfo = httpServletRequest.getRequestURI().substring(httpServletRequest.getContextPath().length() + filterPath.length());
            if (pathInfo.startsWith(SHARED_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX) && (nextSeparator = pathInfo.indexOf(47, 1)) > 0) {
                String windowId = new String(Base64.decodeBase64((String)pathInfo.substring(SHARED_RESOURCE_URL_PORTLET_WINDOW_ID_PREFIX.length(), nextSeparator)));
                HttpSession proxiedSession = PortletHttpSessionWrapper.createProxy(httpServletRequest, windowId);
                pathInfo = pathInfo.substring(nextSeparator);
                httpServletRequest = new PortletServletRequestWrapper(this.filterConfig.getServletContext(), (HttpServletRequest)httpServletRequest, proxiedSession, filterPath, pathInfo);
            }
        }
        super.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, filterChain);
    }
}

