/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.fingerprint;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.MessageDigest;
import org.whispersystems.libsignal.fingerprint.FingerprintParsingException;
import org.whispersystems.libsignal.fingerprint.FingerprintProtos;
import org.whispersystems.libsignal.fingerprint.FingerprintVersionMismatchException;
import org.whispersystems.libsignal.util.ByteUtil;

public class ScannableFingerprint {
    private static final int VERSION = 1;
    private final FingerprintProtos.CombinedFingerprints fingerprints;

    ScannableFingerprint(byte[] localFingerprintData, byte[] remoteFingerprintData) {
        FingerprintProtos.LogicalFingerprint localFingerprint = FingerprintProtos.LogicalFingerprint.newBuilder().setContent(ByteString.copyFrom((byte[])ByteUtil.trim(localFingerprintData, 32))).build();
        FingerprintProtos.LogicalFingerprint remoteFingerprint = FingerprintProtos.LogicalFingerprint.newBuilder().setContent(ByteString.copyFrom((byte[])ByteUtil.trim(remoteFingerprintData, 32))).build();
        this.fingerprints = FingerprintProtos.CombinedFingerprints.newBuilder().setVersion(1).setLocalFingerprint(localFingerprint).setRemoteFingerprint(remoteFingerprint).build();
    }

    public byte[] getSerialized() {
        return this.fingerprints.toByteArray();
    }

    public boolean compareTo(byte[] scannedFingerprintData) throws FingerprintVersionMismatchException, FingerprintParsingException {
        try {
            FingerprintProtos.CombinedFingerprints scanned = FingerprintProtos.CombinedFingerprints.parseFrom(scannedFingerprintData);
            if (!(scanned.hasRemoteFingerprint() && scanned.hasLocalFingerprint() && scanned.hasVersion() && scanned.getVersion() == 1)) {
                throw new FingerprintVersionMismatchException(scanned.getVersion(), 1);
            }
            return MessageDigest.isEqual(this.fingerprints.getLocalFingerprint().getContent().toByteArray(), scanned.getRemoteFingerprint().getContent().toByteArray()) && MessageDigest.isEqual(this.fingerprints.getRemoteFingerprint().getContent().toByteArray(), scanned.getLocalFingerprint().getContent().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            throw new FingerprintParsingException((Exception)((Object)e));
        }
    }
}

