/*
 * Decompiled with CFR 0.152.
 */
package org.weex.plugin.weexlyric;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.ttpod.lyric.Lyric;
import com.ttpod.lyric.LyricParser;
import com.ttpod.lyric.LyricView;
import org.weex.plugin.weexlyric.FileUtils;

@Component(lazyload=false)
public class WXLyricView
extends WXComponent<LyricView> {
    private long mCurPlayingTime = 0L;
    private static final long MAX_DURATION_TIME = 480000L;
    private static final int FLUSH_INTERVAL = 50;
    private boolean mPlayFlag;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            LyricView lyricView = (LyricView)WXLyricView.this.getHostView();
            if (lyricView == null) {
                return;
            }
            WXLyricView.this.mCurPlayingTime = WXLyricView.this.mCurPlayingTime + 50L;
            lyricView.setPlayingTime(WXLyricView.this.mCurPlayingTime);
            if (WXLyricView.this.mCurPlayingTime < 480000L) {
                WXLyricView.this.mHandler.sendEmptyMessageDelayed(0, 50L);
            } else {
                WXLyricView.this.mPlayFlag = false;
            }
        }
    };

    public WXLyricView(WXSDKInstance instance, WXDomObject dom, WXVContainer parent) {
        super(instance, dom, parent);
    }

    protected LyricView initComponentHostView(@NonNull Context context) {
        return new LyricView(context);
    }

    protected boolean setProperty(String key, Object param) {
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="lyricFile")
    public void setLyricFile(String filePath) {
        new ParserLyricTask(filePath).execute(new String[0]);
    }

    @WXComponentProp(name="playStatus")
    public void setPlayStatus(boolean playStatus) {
        if (playStatus) {
            this.startFlushView();
        } else {
            this.stopFlushView();
        }
    }

    @WXComponentProp(name="playTime")
    public void updatePlayTime(int playingTime) {
        this.mCurPlayingTime = playingTime;
        boolean playFlag = this.mPlayFlag;
        this.stopFlushView();
        ((LyricView)this.getHostView()).setPlayingTime((long)playingTime);
        if (playFlag) {
            this.startFlushView();
        }
    }

    @WXComponentProp(name="highlightColor")
    public void setHighlightColor(String highlightColor) {
        try {
            int intColor = Color.parseColor((String)highlightColor);
            ((LyricView)this.getHostView()).setColorHighlight(intColor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @WXComponentProp(name="normalColor")
    public void setNormalColor(String normalColor) {
        try {
            int intColor = Color.parseColor((String)normalColor);
            ((LyricView)this.getHostView()).setColorNormal(intColor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @WXComponentProp(name="kalaOK")
    public void setKalaOK(boolean kalaOK) {
        ((LyricView)this.getHostView()).setKalaOK(kalaOK);
    }

    @WXComponentProp(name="textAlign")
    public void setTextAlign(Paint.Align align) {
        ((LyricView)this.getHostView()).setAlign(align);
    }

    @WXComponentProp(name="slowScroll")
    public void setSlowScroll(boolean slowScroll) {
        ((LyricView)this.getHostView()).setSlowScroll(slowScroll);
    }

    @WXComponentProp(name="displayMode")
    public void setDisplayMode(LyricView.DisplayMode playMode) {
        ((LyricView)this.getHostView()).setDisplayMode(playMode);
    }

    private void startFlushView() {
        this.mPlayFlag = true;
        this.mHandler.sendEmptyMessageDelayed(0, 50L);
    }

    private void stopFlushView() {
        this.mPlayFlag = false;
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private class ParserLyricTask
    extends AsyncTask<String, Void, Lyric> {
        private String mLyricPath;

        public ParserLyricTask(String lyricPath) {
            this.mLyricPath = lyricPath;
        }

        protected Lyric doInBackground(String ... params) {
            Lyric lyric = null;
            if (FileUtils.fileExists(this.mLyricPath)) {
                lyric = LyricParser.parse((String)this.mLyricPath);
            }
            return lyric;
        }

        protected void onPostExecute(Lyric lyric) {
            LyricView lyricView = (LyricView)WXLyricView.this.getHostView();
            if (lyricView == null) {
                return;
            }
            lyricView.setLyric(lyric);
            if (lyric == null) {
                if (FileUtils.fileExists(this.mLyricPath)) {
                    String msg = "\u89e3\u6790\u6b4c\u8bcd\u53d1\u751f\u9519\u8bef";
                } else {
                    String string = "\u6b4c\u8bcd\u6587\u4ef6\u4e0d\u5b58\u5728";
                }
            } else {
                lyricView.setPlayingTime(WXLyricView.this.mCurPlayingTime);
            }
        }
    }
}

