/*
 * Decompiled with CFR 0.152.
 */
package org.weex.plugin.weexlyric;

import android.os.AsyncTask;
import android.support.v4.util.ArrayMap;
import com.alibaba.weex.plugin.annotation.WeexModule;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.ui.component.WXComponent;
import com.ttpod.lyric.Lyric;
import com.ttpod.lyric.LyricParser;
import com.ttpod.lyric.LyricView;
import org.weex.plugin.weexlyric.FileUtils;
import org.weex.plugin.weexlyric.WXLyricView;

@WeexModule(name="lyric")
public class LyricModule
extends WXModule {
    private LyricView mLyricView;

    @JSMethod
    public String syncRet(String param) {
        return param;
    }

    @JSMethod
    public void asyncRet(String param, JSCallback callback) {
        callback.invoke((Object)param);
    }

    @JSMethod
    public void bindView(String ref) {
        WXComponent lyricComponent = this.findComponent(ref);
        if (lyricComponent instanceof WXLyricView) {
            WXLyricView wxLyricView = (WXLyricView)lyricComponent;
            this.mLyricView = (LyricView)wxLyricView.getHostView();
        }
    }

    @JSMethod
    public void setLyricPath(String lyricPath, JSCallback callback) {
        if (this.findLyricView()) {
            this.mLyricView.setState(2);
            new ParserLyricTask(lyricPath, callback).execute(new String[0]);
        } else {
            this.notifyOperateFailed(callback, "\u627e\u4e0d\u5230\u6b4c\u8bcd\u7ec4\u4ef6");
        }
    }

    public void onActivityDestroy() {
        this.mLyricView = null;
        super.onActivityDestroy();
    }

    private boolean findLyricView() {
        WXComponent lyricComponent;
        if (this.mLyricView == null && (lyricComponent = this.findComponent("lyric")) instanceof WXLyricView) {
            WXLyricView wxLyricView = (WXLyricView)lyricComponent;
            this.mLyricView = (LyricView)wxLyricView.getHostView();
        }
        return this.mLyricView != null;
    }

    private void notifyOperateFailed(JSCallback callback, String msg) {
        ArrayMap params = new ArrayMap();
        params.put("code", 0);
        params.put("msg", msg);
        callback.invoke((Object)params);
    }

    private void notifyOperateSuccess(JSCallback callback) {
        ArrayMap params = new ArrayMap();
        params.put("code", 1);
        params.put("msg", "ok");
        callback.invoke((Object)params);
    }

    private class ParserLyricTask
    extends AsyncTask<String, Void, Lyric> {
        private JSCallback mJsCallback;
        private String mLyricPath;

        public ParserLyricTask(String lyricPath, JSCallback jsCallback) {
            this.mLyricPath = lyricPath;
            this.mJsCallback = jsCallback;
        }

        protected Lyric doInBackground(String ... params) {
            Lyric lyric = null;
            if (FileUtils.fileExists(this.mLyricPath)) {
                lyric = LyricParser.parse((String)this.mLyricPath);
            }
            return lyric;
        }

        protected void onPostExecute(Lyric lyric) {
            super.onPostExecute((Object)lyric);
            if (lyric == null) {
                String msg = FileUtils.fileExists(this.mLyricPath) ? "\u89e3\u6790\u6b4c\u8bcd\u53d1\u751f\u9519\u8bef" : "\u6b4c\u8bcd\u6587\u4ef6\u4e0d\u5b58\u5728";
                LyricModule.this.notifyOperateFailed(this.mJsCallback, msg);
            } else {
                if (LyricModule.this.mLyricView != null) {
                    LyricModule.this.mLyricView.setLyric(lyric);
                    LyricModule.this.mLyricView.setPlayingTime(0L);
                }
                LyricModule.this.notifyOperateSuccess(this.mJsCallback);
            }
        }
    }
}

