/*
 * Decompiled with CFR 0.152.
 */
package org.weex.plugin.weexlyric;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class FileUtils {
    private static final int BUFFER_SIZE = 4096;

    FileUtils() {
    }

    public static boolean fileExists(String path) {
        if (FileUtils.isEmpty(path)) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    public static synchronized File createFile(String path) {
        if (FileUtils.isEmpty(path)) {
            return null;
        }
        File file = new File(path);
        if (file.isFile()) {
            return file;
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && (parentFile.isDirectory() || parentFile.mkdirs())) {
            try {
                if (file.createNewFile()) {
                    return file;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static synchronized boolean delete(String path) {
        return !FileUtils.isEmpty(path) && FileUtils.delete(new File(path));
    }

    public static synchronized boolean delete(File path) {
        File[] files;
        if (null == path) {
            return true;
        }
        if (path.isDirectory() && null != (files = path.listFiles())) {
            for (File file : files) {
                if (FileUtils.delete(file)) continue;
                return false;
            }
        }
        return !path.exists() || path.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean store(InputStream inputStream, String path) {
        if (path == null) {
            throw new NullPointerException("path should not be null.");
        }
        FileOutputStream fileOutputStream = null;
        try {
            int length;
            File file = FileUtils.createFile(path);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            byte[] buffer = new byte[4096];
            fileOutputStream = new FileOutputStream(file);
            while ((length = inputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, length);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }
}

