/*
 * Decompiled with CFR 0.152.
 */
package org.weex.plugin.imagepicker;

import android.app.Activity;
import android.content.Intent;
import android.util.Base64;
import android.util.Log;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.weex.plugin.annotation.WeexModule;
import com.luck.picture.lib.PictureSelectionModel;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import io.github.lizhangqu.coreprogress.ProgressHelper;
import io.github.lizhangqu.coreprogress.ProgressListener;
import io.github.lizhangqu.coreprogress.ProgressUIListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

@WeexModule(name="imagePicker")
public class ImagePickerModule
extends WXModule {
    private JSCallback onChooseCallBack;

    @JSMethod
    public String syncRet(String param) {
        return param;
    }

    @JSMethod
    public void asyncRet(String param, JSCallback callback) {
        callback.invoke((Object)param);
    }

    @JSMethod
    public void chooseImage(HashMap<String, Object> options, JSCallback callback) {
        this.onChooseCallBack = callback;
        PictureSelectionModel pictureSelectionModel = options.containsKey("sourceType") ? ("album".equals(options.get("sourceType")) ? PictureSelector.create((Activity)((Activity)this.mWXSDKInstance.getUIContext())).openGallery(PictureMimeType.ofImage()).isCamera(false) : PictureSelector.create((Activity)((Activity)this.mWXSDKInstance.getUIContext())).openCamera(PictureMimeType.ofImage())) : PictureSelector.create((Activity)((Activity)this.mWXSDKInstance.getUIContext())).openGallery(PictureMimeType.ofImage());
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            switch (entry.getKey()) {
                case "maxSelectCount": {
                    pictureSelectionModel.maxSelectNum(10);
                    break;
                }
                case "allowSelectGif": {
                    pictureSelectionModel.isGif(((Boolean)entry.getValue()).booleanValue());
                    break;
                }
                case "sourceType": {
                    if (!"album".equals(entry.getValue())) break;
                    pictureSelectionModel.isCamera(false);
                    break;
                }
                case "allowEditImage": {
                    pictureSelectionModel.enableCrop(((Boolean)entry.getValue()).booleanValue());
                    break;
                }
                case "clipRatio": {
                    JSONObject ratio = (JSONObject)entry.getValue();
                    Integer x = ratio.getInteger("x");
                    Integer y = ratio.getInteger("y");
                    pictureSelectionModel.withAspectRatio(x.intValue(), y.intValue());
                }
            }
        }
        pictureSelectionModel.forResult(188);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 188: {
                    List selectList = PictureSelector.obtainMultipleResult((Intent)data);
                    ArrayList list = new ArrayList();
                    for (LocalMedia media : selectList) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        byte[] path = media.getPath().getBytes();
                        map.put("path", "zcfile://tmp_" + Base64.encodeToString((byte[])path, (int)0));
                        list.add(map);
                    }
                    this.onChooseCallBack.invoke(list);
                }
            }
        }
    }

    @JSMethod
    public void previewImage(HashMap<String, Object> options) {
        JSONArray urls = (JSONArray)options.get("urls");
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        for (int i = 0; i < urls.size(); ++i) {
            String url = urls.getString(i);
            LocalMedia media = new LocalMedia(url, 0L, false, 0, 0, 1);
            media.setPictureType("image/jpeg");
            medias.add(media);
        }
        int position = urls.indexOf(options.get("current"));
        PictureSelector.create((Activity)((Activity)this.mWXSDKInstance.getContext())).externalPicturePreview(position, medias);
    }

    @JSMethod
    public void uploadFile(HashMap<String, Object> options, final JSCallback success, final JSCallback fail, final JSCallback progress) {
        OkHttpClient mOkHttpClient = new OkHttpClient();
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        String filePath = (String)options.get("filePath");
        filePath = filePath.replace("zcfile://tmp_", "");
        filePath = new String(Base64.decode((String)filePath, (int)0));
        File file = new File(filePath);
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyyMMddhhmmss", Locale.CHINESE);
        String date = sDateFormat.format(new Date());
        builder.addFormDataPart("file", date + ".png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (File)file));
        JSONObject formData = (JSONObject)options.get("formData");
        for (String key : formData.keySet()) {
            builder.addFormDataPart(key, (String)formData.get((Object)key));
        }
        MultipartBody body = builder.build();
        RequestBody requestBody = ProgressHelper.withProgress((RequestBody)body, (ProgressListener)new ProgressUIListener(){

            public void onUIProgressStart(long totalBytes) {
                super.onUIProgressStart(totalBytes);
                Log.e((String)"TAG", (String)("onUIProgressStart:" + totalBytes));
            }

            public void onUIProgressChanged(long numBytes, long totalBytes, float percent, float speed) {
                Log.e((String)"TAG", (String)"=============start===============");
                Log.e((String)"TAG", (String)("numBytes:" + numBytes));
                Log.e((String)"TAG", (String)("totalBytes:" + totalBytes));
                Log.e((String)"TAG", (String)("percent:" + percent));
                Log.e((String)"TAG", (String)("speed:" + speed));
                Log.e((String)"TAG", (String)"============= end ===============");
                progress.invokeAndKeepAlive((Object)((int)(100.0f * percent)));
            }

            public void onUIProgressFinish() {
                super.onUIProgressFinish();
                Log.e((String)"TAG", (String)"onUIProgressFinish:");
            }
        });
        Request request = new Request.Builder().url((String)options.get("url")).post(requestBody).build();
        Call call = mOkHttpClient.newCall(request);
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                fail.invoke((Object)e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                success.invoke(JSONObject.parse((String)response.body().string()));
            }
        });
    }
}

