/*
 * Decompiled with CFR 0.152.
 */
package org.weex.plugin.weexactionsheet;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WXActionSheet
extends Fragment {
    private static final String KEY_TITLE = "TITLE";
    private static final String KEY_MESSAGE = "MESSAGE";
    private static final String KEY_ITEMS = "ITEMS";
    private static final String KEY_HAS_DISMISSED = "HAS_DISMISSED";
    private static final String SEPARATOR = "@##@";
    private boolean hasDismissed = true;
    private boolean hasCancelItemAdded = false;
    private View backgroundLayer;
    private ViewGroup decor;
    private View actionSheetView;
    private LinearLayout sheetContainer;
    private ActionListener actionListener;
    private String titleText;
    private String messageText;
    private List<Pair<String, String>> actionItems;
    private static final int TRANSLATE_DURATION = 200;
    private static final int ALPHA_DURATION = 300;
    private static final int COLOR_TITLE = Color.rgb((int)143, (int)143, (int)143);
    private static final int COLOR_LINE = Color.rgb((int)219, (int)219, (int)219);
    private static final int COLOR_ITEM_NORMAL = Color.rgb((int)0, (int)122, (int)252);
    private static final int COLOR_ITEM_ALERT = Color.rgb((int)255, (int)59, (int)48);

    public void display(final FragmentManager manager, final String tag) {
        if (!this.hasDismissed || manager.isDestroyed()) {
            return;
        }
        this.hasDismissed = false;
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                FragmentTransaction transaction = manager.beginTransaction();
                transaction.add((Fragment)WXActionSheet.this, tag);
                transaction.addToBackStack(null);
                transaction.commitAllowingStateLoss();
            }
        });
    }

    public void dismiss() {
        if (this.hasDismissed) {
            return;
        }
        this.hasDismissed = true;
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                WXActionSheet.this.getFragmentManager().popBackStack();
                FragmentTransaction ft = WXActionSheet.this.getFragmentManager().beginTransaction();
                ft.remove((Fragment)WXActionSheet.this);
                ft.commitAllowingStateLoss();
            }
        });
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.hasDismissed = savedInstanceState.getBoolean(KEY_HAS_DISMISSED);
        }
        this.prepareArguments();
    }

    private void prepareArguments() {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.titleText = bundle.getString(KEY_TITLE);
            this.messageText = bundle.getString(KEY_MESSAGE);
            this.actionItems = new ArrayList<Pair<String, String>>();
            ArrayList items = bundle.getStringArrayList(KEY_ITEMS);
            if (items != null) {
                for (String item : items) {
                    String[] splited = item.split(SEPARATOR);
                    if (splited.length != 2) continue;
                    this.actionItems.add((Pair<String, String>)Pair.create((Object)splited[0], (Object)splited[1]));
                }
            }
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View focusView;
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        if (imm.isActive() && (focusView = this.getActivity().getCurrentFocus()) != null) {
            imm.hideSoftInputFromWindow(focusView.getWindowToken(), 0);
        }
        this.actionSheetView = this.createRoot();
        this.decor = (ViewGroup)this.getActivity().getWindow().getDecorView();
        this.attachItems();
        this.decor.addView(this.actionSheetView);
        this.backgroundLayer.startAnimation(this.createAlphaInAnimation());
        this.sheetContainer.startAnimation(this.createTranslationInAnimation());
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    private View createRoot() {
        FrameLayout parent = new FrameLayout((Context)this.getActivity());
        parent.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.backgroundLayer = new View((Context)this.getActivity());
        this.backgroundLayer.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.backgroundLayer.setBackgroundColor(Color.argb((int)136, (int)0, (int)0, (int)0));
        this.backgroundLayer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WXActionSheet.this.dismiss();
                if (WXActionSheet.this.actionListener != null) {
                    WXActionSheet.this.actionListener.onCancel();
                }
            }
        });
        this.sheetContainer = new LinearLayout((Context)this.getActivity());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2);
        params.gravity = 80;
        this.sheetContainer.setLayoutParams((ViewGroup.LayoutParams)params);
        this.sheetContainer.setOrientation(1);
        this.sheetContainer.setPadding(this.dp2px(8), this.dp2px(8), this.dp2px(8), this.dp2px(8));
        parent.setPadding(0, 0, 0, this.getNavBarHeight((Context)this.getActivity()));
        parent.addView(this.backgroundLayer);
        parent.addView((View)this.sheetContainer);
        return parent;
    }

    private void attachItems() {
        this.hasCancelItemAdded = false;
        this.ensureTitle();
        this.addItem();
    }

    private void ensureTitle() {
        if (!TextUtils.isEmpty((CharSequence)this.titleText) || !TextUtils.isEmpty((CharSequence)this.messageText)) {
            LinearLayout titleContainer = new LinearLayout((Context)this.getActivity());
            titleContainer.setOrientation(1);
            titleContainer.setGravity(17);
            titleContainer.setBackgroundColor(-1);
            titleContainer.setLayoutParams(new ViewGroup.LayoutParams(-1, this.dp2px(56)));
            if (!TextUtils.isEmpty((CharSequence)this.titleText)) {
                TextView title = new TextView((Context)this.getActivity());
                title.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
                title.setTextSize(1, 14.0f);
                title.setText((CharSequence)this.titleText);
                title.setGravity(1);
                title.setTextColor(COLOR_TITLE);
                title.getPaint().setFakeBoldText(true);
                titleContainer.addView((View)title);
            }
            if (!TextUtils.isEmpty((CharSequence)this.messageText)) {
                TextView message = new TextView((Context)this.getActivity());
                message.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
                message.setTextSize(1, 12.0f);
                message.setGravity(1);
                message.setText((CharSequence)this.messageText);
                message.setTextColor(COLOR_TITLE);
                titleContainer.addView((View)message);
            }
            titleContainer.setClickable(true);
            titleContainer.setFocusableInTouchMode(true);
            this.sheetContainer.addView((View)titleContainer);
            this.sheetContainer.addView(this.createLine());
        }
    }

    private void addItem() {
        Pair<String, String> item;
        int i;
        for (i = 0; i < this.actionItems.size(); ++i) {
            item = this.makeItem(this.actionItems.get(i), i);
            if (item == null) continue;
            this.sheetContainer.addView(item);
            this.sheetContainer.addView(this.createLine());
        }
        for (i = 0; i < this.actionItems.size(); ++i) {
            item = this.actionItems.get(i);
            if (!"1".equals(item.first)) continue;
            if (this.hasCancelItemAdded) {
                if (this.actionListener != null) {
                    this.actionListener.onError("Can only add most 1 item with type 1");
                }
                return;
            }
            TextView textView = this.createItemBase();
            textView.setText((CharSequence)item.second);
            textView.setTextColor(COLOR_ITEM_NORMAL);
            textView.getPaint().setFakeBoldText(true);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, this.dp2px(48));
            lp.topMargin = this.dp2px(8);
            textView.setLayoutParams((ViewGroup.LayoutParams)lp);
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (WXActionSheet.this.actionListener != null) {
                        WXActionSheet.this.actionListener.onCancel();
                        WXActionSheet.this.dismiss();
                    }
                }
            });
            this.sheetContainer.addView((View)textView);
            this.hasCancelItemAdded = true;
        }
    }

    private TextView createItemBase() {
        TextView textView = new TextView((Context)this.getActivity());
        textView.setBackgroundColor(-1);
        textView.setGravity(17);
        textView.setTextSize(0, (float)this.dp2px(18));
        return textView;
    }

    private View makeItem(final Pair<String, String> item, final int index) {
        TextView textView = this.createItemBase();
        textView.setText((CharSequence)item.second);
        if ("2".equals(item.first)) {
            textView.setTextColor(COLOR_ITEM_ALERT);
        } else if ("0".equals(item.first)) {
            textView.setTextColor(COLOR_ITEM_NORMAL);
        } else {
            return null;
        }
        textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, this.dp2px(48)));
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (WXActionSheet.this.actionListener != null) {
                    WXActionSheet.this.actionListener.onSelected(index, (String)item.second);
                    WXActionSheet.this.dismiss();
                }
            }
        });
        return textView;
    }

    private View createLine() {
        View line = new View((Context)this.getActivity());
        line.setLayoutParams(new ViewGroup.LayoutParams(-1, 1));
        line.setBackgroundColor(COLOR_LINE);
        return line;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_HAS_DISMISSED, this.hasDismissed);
    }

    public int getNavBarHeight(Context context) {
        Resources rs;
        int id;
        int navigationBarHeight = 0;
        if (Build.VERSION.SDK_INT >= 21 && (id = (rs = context.getResources()).getIdentifier("navigation_bar_height", "dimen", "android")) > 0 && this.checkDeviceHasNavigationBar(context)) {
            navigationBarHeight = rs.getDimensionPixelSize(id);
        }
        return navigationBarHeight;
    }

    private boolean checkDeviceHasNavigationBar(Context context) {
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id > 0) {
            hasNavigationBar = rs.getBoolean(id);
        }
        try {
            Class<?> systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String)m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasNavigationBar;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    private Animation createTranslationInAnimation() {
        int type = 1;
        TranslateAnimation an = new TranslateAnimation(type, 0.0f, type, 0.0f, type, 1.0f, type, 0.0f);
        an.setDuration(200L);
        return an;
    }

    private Animation createAlphaInAnimation() {
        AlphaAnimation an = new AlphaAnimation(0.0f, 1.0f);
        an.setDuration(300L);
        return an;
    }

    private Animation createTranslationOutAnimation() {
        int type = 1;
        TranslateAnimation an = new TranslateAnimation(type, 0.0f, type, 0.0f, type, 0.0f, type, 1.0f);
        an.setDuration(200L);
        an.setFillAfter(true);
        return an;
    }

    private Animation createAlphaOutAnimation() {
        AlphaAnimation an = new AlphaAnimation(1.0f, 0.0f);
        an.setDuration(300L);
        an.setFillAfter(true);
        return an;
    }

    private int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getActivity().getResources().getDisplayMetrics());
    }

    public void onDestroyView() {
        this.sheetContainer.startAnimation(this.createTranslationOutAnimation());
        this.backgroundLayer.startAnimation(this.createAlphaOutAnimation());
        this.actionSheetView.postDelayed(new Runnable(){

            @Override
            public void run() {
                WXActionSheet.this.decor.removeView(WXActionSheet.this.actionSheetView);
            }
        }, 300L);
        super.onDestroyView();
    }

    public static Builder createBuilder(FragmentActivity context) {
        return new Builder(context);
    }

    public static interface ActionListener {
        public void onSelected(int var1, String var2);

        public void onCancel();

        public void onError(String var1);
    }

    public static class Builder {
        private Activity context;
        private FragmentManager fragmentManager;
        private String title;
        private String message;
        private List<Map<String, Object>> items;
        private ActionListener listener;

        Builder(FragmentActivity context) {
            this.context = context;
            this.fragmentManager = context.getSupportFragmentManager();
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setListener(ActionListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setItems(List<Map<String, Object>> items) {
            this.items = items;
            return this;
        }

        private Bundle parseToBundle() {
            Bundle bundle = new Bundle();
            bundle.putString(WXActionSheet.KEY_TITLE, this.title);
            bundle.putString(WXActionSheet.KEY_MESSAGE, this.message);
            ArrayList<String> itemsBundle = new ArrayList<String>();
            for (Map<String, Object> map : this.items) {
                String type = String.valueOf(map.get("type"));
                String message = String.valueOf(map.get("message"));
                if (TextUtils.isEmpty((CharSequence)type)) {
                    type = "0";
                }
                if (message == null) {
                    message = "";
                }
                itemsBundle.add(type + WXActionSheet.SEPARATOR + message);
            }
            bundle.putStringArrayList(WXActionSheet.KEY_ITEMS, itemsBundle);
            return bundle;
        }

        public WXActionSheet buildAndShow() {
            WXActionSheet actionSheet = (WXActionSheet)Fragment.instantiate((Context)this.context, (String)WXActionSheet.class.getName(), (Bundle)this.parseToBundle());
            actionSheet.setActionListener(this.listener);
            actionSheet.display(this.fragmentManager, "WXActionSheet");
            return actionSheet;
        }
    }
}

