/**
 *
 *                                  Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright 2016 Alibaba Group
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package org.weex.plugin.weexactionsheet;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.util.Pair;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by moxun on 17/2/10.
 */

public class WXActionSheet extends Fragment {
    private static final String KEY_TITLE = "TITLE";
    private static final String KEY_MESSAGE = "MESSAGE";
    private static final String KEY_ITEMS = "ITEMS";
    private static final String KEY_HAS_DISMISSED = "HAS_DISMISSED";
    private static final String SEPARATOR = "@##@";
    private boolean hasDismissed = true;
    private boolean hasCancelItemAdded = false;
    private View backgroundLayer;
    private ViewGroup decor;
    private View actionSheetView;
    private LinearLayout sheetContainer;
    private ActionListener actionListener;

    private String titleText;
    private String messageText;
    private List<Pair<String, String>> actionItems;

    private static final int TRANSLATE_DURATION = 200;
    private static final int ALPHA_DURATION = 300;

    private static final int COLOR_TITLE = Color.rgb(143, 143, 143);
    private static final int COLOR_LINE = Color.rgb(219, 219, 219);
    private static final int COLOR_ITEM_NORMAL = Color.rgb(0, 122, 252);
    private static final int COLOR_ITEM_ALERT = Color.rgb(255, 59, 48);

    public void display(final FragmentManager manager, final String tag) {
        if (!hasDismissed || manager.isDestroyed()) {
            return;
        }
        hasDismissed = false;
        new Handler().post(new Runnable() {
            @Override
            public void run() {
                FragmentTransaction transaction = manager.beginTransaction();
                transaction.add(WXActionSheet.this, tag);
                transaction.addToBackStack(null);
                transaction.commitAllowingStateLoss();
            }
        });
    }

    public void dismiss() {
        if (hasDismissed) {
            return;
        }
        hasDismissed = true;
        new Handler().post(new Runnable() {
            @Override
            public void run() {
                getFragmentManager().popBackStack();
                FragmentTransaction ft = getFragmentManager().beginTransaction();
                ft.remove(WXActionSheet.this);
                ft.commitAllowingStateLoss();
            }
        });
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            hasDismissed = savedInstanceState.getBoolean(KEY_HAS_DISMISSED);
        }
        prepareArguments();
    }

    private void prepareArguments() {
        Bundle bundle = getArguments();
        if (bundle != null) {
            titleText = bundle.getString(KEY_TITLE);
            messageText = bundle.getString(KEY_MESSAGE);
            actionItems = new ArrayList<>();
            ArrayList<String> items = bundle.getStringArrayList(KEY_ITEMS);
            if (items != null) {
                for (String item : items) {
                    String[] splited = item.split(SEPARATOR);
                    if (splited.length == 2) {
                        actionItems.add(Pair.create(splited[0], splited[1]));
                    }
                }
            }
        }
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        InputMethodManager imm = (InputMethodManager) getActivity()
                .getSystemService(Context.INPUT_METHOD_SERVICE);
        if (imm.isActive()) {
            View focusView = getActivity().getCurrentFocus();
            if (focusView != null) {
                imm.hideSoftInputFromWindow(focusView.getWindowToken(), 0);
            }
        }

        actionSheetView = createRoot();
        decor = (ViewGroup) getActivity().getWindow().getDecorView();

        attachItems();

        decor.addView(actionSheetView);

        backgroundLayer.startAnimation(createAlphaInAnimation());
        sheetContainer.startAnimation(createTranslationInAnimation());
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    private View createRoot() {
        FrameLayout parent = new FrameLayout(getActivity());
        parent.setLayoutParams(new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

        backgroundLayer = new View(getActivity());
        backgroundLayer.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        backgroundLayer.setBackgroundColor(Color.argb(136, 0, 0, 0));
        backgroundLayer.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (actionListener != null) {
                    actionListener.onCancel();
                }
            }
        });

        sheetContainer = new LinearLayout(getActivity());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.gravity = Gravity.BOTTOM;
        sheetContainer.setLayoutParams(params);
        sheetContainer.setOrientation(LinearLayout.VERTICAL);
        sheetContainer.setPadding(dp2px(8), dp2px(8), dp2px(8), dp2px(8));

        parent.setPadding(0, 0, 0, getNavBarHeight(getActivity()));
        parent.addView(backgroundLayer);
        parent.addView(sheetContainer);
        return parent;
    }

    private void attachItems() {
        hasCancelItemAdded = false;
        ensureTitle();
        addItem();
    }

    private void ensureTitle() {
        if (!TextUtils.isEmpty(titleText) || !TextUtils.isEmpty(messageText)) {
            LinearLayout titleContainer = new LinearLayout(getActivity());
            titleContainer.setOrientation(LinearLayout.VERTICAL);
            titleContainer.setGravity(Gravity.CENTER);
            titleContainer.setBackgroundColor(Color.WHITE);
            titleContainer.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, dp2px(56)));

            if (!TextUtils.isEmpty(titleText)) {
                TextView title = new TextView(getActivity());
                title.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                title.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 14);
                title.setText(titleText);
                title.setGravity(Gravity.CENTER_HORIZONTAL);
                title.setTextColor(COLOR_TITLE);
                title.getPaint().setFakeBoldText(true);
                titleContainer.addView(title);
            }

            if (!TextUtils.isEmpty(messageText)) {
                TextView message = new TextView(getActivity());
                message.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                message.setTextSize(TypedValue.COMPLEX_UNIT_DIP, 12);
                message.setGravity(Gravity.CENTER_HORIZONTAL);
                message.setText(messageText);
                message.setTextColor(COLOR_TITLE);
                titleContainer.addView(message);
            }

            titleContainer.setClickable(true);
            titleContainer.setFocusableInTouchMode(true);

            sheetContainer.addView(titleContainer);
            sheetContainer.addView(createLine());
        }
    }

    private void addItem() {
        for (int i = 0; i < actionItems.size(); i++) {
            View item = makeItem(actionItems.get(i), i);
            if (item != null) {
                sheetContainer.addView(item);
                sheetContainer.addView(createLine());
            }
        }

        for (int i = 0; i < actionItems.size(); i++) {
            Pair<String, String> item = actionItems.get(i);
            if ("1".equals(item.first)) {
                if (hasCancelItemAdded) {
                    if (actionListener != null) {
                        actionListener.onError("Can only add most 1 item with type 1");
                    }
                    return;
                }
                TextView textView = createItemBase();
                textView.setText(item.second);
                textView.setTextColor(COLOR_ITEM_NORMAL);
                textView.getPaint().setFakeBoldText(true);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, dp2px(48));
                lp.topMargin = dp2px(8);
                textView.setLayoutParams(lp);
                textView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (actionListener != null) {
                            actionListener.onCancel();
                            dismiss();
                        }
                    }
                });
                sheetContainer.addView(textView);
                hasCancelItemAdded = true;
            }
        }
    }

    private TextView createItemBase() {
        TextView textView = new TextView(getActivity());
        textView.setBackgroundColor(Color.WHITE);
        textView.setGravity(Gravity.CENTER);
        textView.setTextSize(TypedValue.COMPLEX_UNIT_PX, dp2px(18));
        return textView;
    }

    private View makeItem(final Pair<String, String> item, final int index) {
        TextView textView = createItemBase();
        textView.setText(item.second);

        if ("2".equals(item.first)) {
            textView.setTextColor(COLOR_ITEM_ALERT);
        } else if ("0".equals(item.first)) {
            textView.setTextColor(COLOR_ITEM_NORMAL);
        } else {
            return null;
        }
        textView.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, dp2px(48)));
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (actionListener != null) {
                    actionListener.onSelected(index, item.second);
                    dismiss();
                }
            }
        });

        return textView;
    }

    private View createLine() {
        View line = new View(getActivity());
        line.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, 1));
        line.setBackgroundColor(COLOR_LINE);
        return line;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_HAS_DISMISSED, hasDismissed);
    }

    public int getNavBarHeight(Context context) {
        int navigationBarHeight = 0;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Resources rs = context.getResources();
            int id = rs.getIdentifier("navigation_bar_height", "dimen", "android");
            if (id > 0 && checkDeviceHasNavigationBar(context)) {
                navigationBarHeight = rs.getDimensionPixelSize(id);
            }
        }
        return navigationBarHeight;
    }

    private boolean checkDeviceHasNavigationBar(Context context) {
        boolean hasNavigationBar = false;
        Resources rs = context.getResources();
        int id = rs.getIdentifier("config_showNavigationBar", "bool", "android");
        if (id > 0) {
            hasNavigationBar = rs.getBoolean(id);
        }
        try {
            Class systemPropertiesClass = Class.forName("android.os.SystemProperties");
            Method m = systemPropertiesClass.getMethod("get", String.class);
            String navBarOverride = (String) m.invoke(systemPropertiesClass, "qemu.hw.mainkeys");
            if ("1".equals(navBarOverride)) {
                hasNavigationBar = false;
            } else if ("0".equals(navBarOverride)) {
                hasNavigationBar = true;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return hasNavigationBar;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    private Animation createTranslationInAnimation() {
        int type = TranslateAnimation.RELATIVE_TO_SELF;
        TranslateAnimation an = new TranslateAnimation(type, 0, type, 0, type,
                1, type, 0);
        an.setDuration(TRANSLATE_DURATION);
        return an;
    }

    private Animation createAlphaInAnimation() {
        AlphaAnimation an = new AlphaAnimation(0, 1);
        an.setDuration(ALPHA_DURATION);
        return an;
    }

    private Animation createTranslationOutAnimation() {
        int type = TranslateAnimation.RELATIVE_TO_SELF;
        TranslateAnimation an = new TranslateAnimation(type, 0, type, 0, type,
                0, type, 1);
        an.setDuration(TRANSLATE_DURATION);
        an.setFillAfter(true);
        return an;
    }

    private Animation createAlphaOutAnimation() {
        AlphaAnimation an = new AlphaAnimation(1, 0);
        an.setDuration(ALPHA_DURATION);
        an.setFillAfter(true);
        return an;
    }

    private int dp2px(int dp) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,
                dp, getActivity().getResources().getDisplayMetrics());
    }

    @Override
    public void onDestroyView() {
        sheetContainer.startAnimation(createTranslationOutAnimation());
        backgroundLayer.startAnimation(createAlphaOutAnimation());
        actionSheetView.postDelayed(new Runnable() {
            @Override
            public void run() {
                decor.removeView(actionSheetView);
            }
        }, ALPHA_DURATION);
        super.onDestroyView();
    }

    public static class Builder {
        private Activity context;
        private FragmentManager fragmentManager;
        private String title;
        private String message;
        private List<Map<String, Object>> items;
        private ActionListener listener;

        Builder(FragmentActivity context) {
            this.context = context;
            this.fragmentManager = context.getSupportFragmentManager();
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setListener(ActionListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setItems(List<Map<String, Object>> items) {
            this.items = items;
            return this;
        }

        private Bundle parseToBundle() {
            Bundle bundle = new Bundle();
            bundle.putString(KEY_TITLE, title);
            bundle.putString(KEY_MESSAGE, message);
            ArrayList<String> itemsBundle = new ArrayList<>();

            for (Map<String, Object> map : items) {
                String type = String.valueOf(map.get("type"));
                String message = String.valueOf(map.get("message"));

                if (TextUtils.isEmpty(type)) {
                    type = "0";
                }

                if (message == null) {
                    message = "";
                }

                itemsBundle.add(type + SEPARATOR + message);
            }

            bundle.putStringArrayList(KEY_ITEMS, itemsBundle);

            return bundle;
        }

        public WXActionSheet buildAndShow() {
            WXActionSheet actionSheet = (WXActionSheet) Fragment.instantiate(context, WXActionSheet.class.getName(), parseToBundle());
            actionSheet.setActionListener(listener);
            actionSheet.display(fragmentManager, "WXActionSheet");
            return actionSheet;
        }
    }

    public static Builder createBuilder(FragmentActivity context) {
        return new Builder(context);
    }

    public interface ActionListener {
        void onSelected(int index, String content);

        void onCancel();

        void onError(String message);
    }
}
